/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import sun.misc.ASCIICaseInsensitiveComparator;
import sun.misc.VM;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.ThreadLocalCoders;
import sun.security.action.GetPropertyAction;

public abstract class Charset
implements Comparable<Charset> {
    private static volatile String bugLevel = null;
    private static CharsetProvider standardProvider = new StandardCharsets();
    private static volatile Object[] cache1 = null;
    private static volatile Object[] cache2 = null;
    private static ThreadLocal<ThreadLocal> gate = new ThreadLocal();
    private static volatile Charset defaultCharset;
    private final String name;
    private final String[] aliases;
    private Set<String> aliasSet = null;

    static boolean atBugLevel(String bl) {
        String level = bugLevel;
        if (level == null) {
            if (!VM.isBooted()) {
                return false;
            }
            bugLevel = level = AccessController.doPrivileged(new GetPropertyAction("sun.nio.cs.bugLevel", ""));
        }
        return level.equals(bl);
    }

    private static void checkName(String s) {
        int n = s.length();
        if (!Charset.atBugLevel("1.4") && n == 0) {
            throw new IllegalCharsetNameException(s);
        }
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' && i != 0 || c == '+' && i != 0 || c == ':' && i != 0 || c == '_' && i != 0 || c == '.' && i != 0) continue;
            throw new IllegalCharsetNameException(s);
        }
    }

    private static void cache(String charsetName, Charset cs) {
        cache2 = cache1;
        cache1 = new Object[]{charsetName, cs};
    }

    private static Iterator providers() {
        return new Iterator(){
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            ServiceLoader<CharsetProvider> sl = ServiceLoader.load(CharsetProvider.class, this.cl);
            Iterator<CharsetProvider> i = this.sl.iterator();
            Object next = null;

            private boolean getNext() {
                while (this.next == null) {
                    try {
                        if (!this.i.hasNext()) {
                            return false;
                        }
                        this.next = this.i.next();
                    }
                    catch (ServiceConfigurationError sce) {
                        if (sce.getCause() instanceof SecurityException) continue;
                        throw sce;
                    }
                }
                return true;
            }

            @Override
            public boolean hasNext() {
                return this.getNext();
            }

            public Object next() {
                if (!this.getNext()) {
                    throw new NoSuchElementException();
                }
                Object n = this.next;
                this.next = null;
                return n;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Charset lookupViaProviders(final String charsetName) {
        if (!VM.isBooted()) {
            return null;
        }
        if (gate.get() != null) {
            return null;
        }
        try {
            gate.set(gate);
            Charset charset = AccessController.doPrivileged(new PrivilegedAction<Charset>(){

                @Override
                public Charset run() {
                    Iterator i = Charset.providers();
                    while (i.hasNext()) {
                        CharsetProvider cp = (CharsetProvider)i.next();
                        Charset cs = cp.charsetForName(charsetName);
                        if (cs == null) continue;
                        return cs;
                    }
                    return null;
                }
            });
            return charset;
        }
        finally {
            gate.set(null);
        }
    }

    private static Charset lookupExtendedCharset(String charsetName) {
        CharsetProvider ecp = ExtendedProviderHolder.extendedProvider;
        return ecp != null ? ecp.charsetForName(charsetName) : null;
    }

    private static Charset lookup(String charsetName) {
        if (charsetName == null) {
            throw new IllegalArgumentException("Null charset name");
        }
        Object[] a = cache1;
        if (cache1 != null && charsetName.equals(a[0])) {
            return (Charset)a[1];
        }
        return Charset.lookup2(charsetName);
    }

    private static Charset lookup2(String charsetName) {
        Object[] a = cache2;
        if (cache2 != null && charsetName.equals(a[0])) {
            cache2 = cache1;
            cache1 = a;
            return (Charset)a[1];
        }
        Charset cs = standardProvider.charsetForName(charsetName);
        if (cs != null || (cs = Charset.lookupExtendedCharset(charsetName)) != null || (cs = Charset.lookupViaProviders(charsetName)) != null) {
            Charset.cache(charsetName, cs);
            return cs;
        }
        Charset.checkName(charsetName);
        return null;
    }

    public static boolean isSupported(String charsetName) {
        return Charset.lookup(charsetName) != null;
    }

    public static Charset forName(String charsetName) {
        Charset cs = Charset.lookup(charsetName);
        if (cs != null) {
            return cs;
        }
        throw new UnsupportedCharsetException(charsetName);
    }

    private static void put(Iterator<Charset> i, Map<String, Charset> m) {
        while (i.hasNext()) {
            Charset cs = i.next();
            if (m.containsKey(cs.name())) continue;
            m.put(cs.name(), cs);
        }
    }

    public static SortedMap<String, Charset> availableCharsets() {
        return AccessController.doPrivileged(new PrivilegedAction<SortedMap<String, Charset>>(){

            @Override
            public SortedMap<String, Charset> run() {
                TreeMap m = new TreeMap(ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER);
                Charset.put(standardProvider.charsets(), m);
                CharsetProvider ecp = ExtendedProviderHolder.extendedProvider;
                if (ecp != null) {
                    Charset.put(ecp.charsets(), m);
                }
                Iterator i = Charset.providers();
                while (i.hasNext()) {
                    CharsetProvider cp = (CharsetProvider)i.next();
                    Charset.put(cp.charsets(), m);
                }
                return Collections.unmodifiableSortedMap(m);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Charset defaultCharset() {
        if (defaultCharset != null) return defaultCharset;
        Class<Charset> clazz = Charset.class;
        synchronized (Charset.class) {
            String csn = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
            Charset cs = Charset.lookup(csn);
            defaultCharset = cs != null ? cs : Charset.forName("UTF-8");
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultCharset;
        }
    }

    protected Charset(String canonicalName, String[] aliases) {
        Charset.checkName(canonicalName);
        String[] as = aliases == null ? new String[]{} : aliases;
        for (int i = 0; i < as.length; ++i) {
            Charset.checkName(as[i]);
        }
        this.name = canonicalName;
        this.aliases = as;
    }

    public final String name() {
        return this.name;
    }

    public final Set<String> aliases() {
        if (this.aliasSet != null) {
            return this.aliasSet;
        }
        int n = this.aliases.length;
        HashSet<String> hs = new HashSet<String>(n);
        for (int i = 0; i < n; ++i) {
            hs.add(this.aliases[i]);
        }
        this.aliasSet = Collections.unmodifiableSet(hs);
        return this.aliasSet;
    }

    public String displayName() {
        return this.name;
    }

    public final boolean isRegistered() {
        return !this.name.startsWith("X-") && !this.name.startsWith("x-");
    }

    public String displayName(Locale locale) {
        return this.name;
    }

    public abstract boolean contains(Charset var1);

    public abstract CharsetDecoder newDecoder();

    public abstract CharsetEncoder newEncoder();

    public boolean canEncode() {
        return true;
    }

    public final CharBuffer decode(ByteBuffer bb) {
        try {
            return ThreadLocalCoders.decoderFor(this).onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(bb);
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
    }

    public final ByteBuffer encode(CharBuffer cb) {
        try {
            return ThreadLocalCoders.encoderFor(this).onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).encode(cb);
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
    }

    public final ByteBuffer encode(String str) {
        return this.encode(CharBuffer.wrap(str));
    }

    @Override
    public final int compareTo(Charset that) {
        return this.name().compareToIgnoreCase(that.name());
    }

    public final int hashCode() {
        return this.name().hashCode();
    }

    public final boolean equals(Object ob) {
        if (!(ob instanceof Charset)) {
            return false;
        }
        if (this == ob) {
            return true;
        }
        return this.name.equals(((Charset)ob).name());
    }

    public final String toString() {
        return this.name();
    }

    private static class ExtendedProviderHolder {
        static final CharsetProvider extendedProvider = ExtendedProviderHolder.extendedProvider();

        private ExtendedProviderHolder() {
        }

        private static CharsetProvider extendedProvider() {
            return AccessController.doPrivileged(new PrivilegedAction<CharsetProvider>(){

                @Override
                public CharsetProvider run() {
                    try {
                        Class<?> epc = Class.forName("sun.nio.cs.ext.ExtendedCharsets");
                        return (CharsetProvider)epc.newInstance();
                    }
                    catch (ClassNotFoundException x) {
                    }
                    catch (IllegalAccessException | InstantiationException x) {
                        throw new Error(x);
                    }
                    return null;
                }
            });
        }
    }
}

