/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyAccess;
import sun.invoke.util.Wrapper;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;
import sun.security.util.SecurityConstants;

public class MethodHandles {
    private static final MemberName.Factory IMPL_NAMES = MemberName.getFactory();

    private MethodHandles() {
    }

    @CallerSensitive
    public static Lookup lookup() {
        return new Lookup(Reflection.getCallerClass());
    }

    public static Lookup publicLookup() {
        return Lookup.PUBLIC_LOOKUP;
    }

    public static MethodHandle arrayElementGetter(Class<?> arrayClass) throws IllegalArgumentException {
        return MethodHandleImpl.makeArrayElementAccessor(arrayClass, false);
    }

    public static MethodHandle arrayElementSetter(Class<?> arrayClass) throws IllegalArgumentException {
        return MethodHandleImpl.makeArrayElementAccessor(arrayClass, true);
    }

    public static MethodHandle spreadInvoker(MethodType type, int leadingArgCount) {
        if (leadingArgCount < 0 || leadingArgCount > type.parameterCount()) {
            throw new IllegalArgumentException("bad argument count " + leadingArgCount);
        }
        return type.invokers().spreadInvoker(leadingArgCount);
    }

    public static MethodHandle exactInvoker(MethodType type) {
        return type.invokers().exactInvoker();
    }

    public static MethodHandle invoker(MethodType type) {
        return type.invokers().generalInvoker();
    }

    static MethodHandle basicInvoker(MethodType type) {
        return type.form().basicInvoker();
    }

    public static MethodHandle explicitCastArguments(MethodHandle target, MethodType newType) {
        if (!target.type().isCastableTo(newType)) {
            throw new WrongMethodTypeException("cannot explicitly cast " + target + " to " + newType);
        }
        return MethodHandleImpl.makePairwiseConvert(target, newType, 2);
    }

    public static MethodHandle permuteArguments(MethodHandle target, MethodType newType, int ... reorder) {
        reorder = (int[])reorder.clone();
        MethodHandles.checkReorder(reorder, newType, target.type());
        return target.permuteArguments(newType, reorder);
    }

    private static void checkReorder(int[] reorder, MethodType newType, MethodType oldType) {
        if (newType.returnType() != oldType.returnType()) {
            throw MethodHandleStatics.newIllegalArgumentException("return types do not match", oldType, newType);
        }
        if (reorder.length == oldType.parameterCount()) {
            int limit = newType.parameterCount();
            boolean bad = false;
            for (int j = 0; j < reorder.length; ++j) {
                Class<?> dst;
                int i = reorder[j];
                if (i < 0 || i >= limit) {
                    bad = true;
                    break;
                }
                Class<?> src = newType.parameterType(i);
                if (src == (dst = oldType.parameterType(j))) continue;
                throw MethodHandleStatics.newIllegalArgumentException("parameter types do not match after reorder", oldType, newType);
            }
            if (!bad) {
                return;
            }
        }
        throw MethodHandleStatics.newIllegalArgumentException("bad reorder array: " + Arrays.toString(reorder));
    }

    public static MethodHandle constant(Class<?> type, Object value) {
        if (type.isPrimitive()) {
            if (type == Void.TYPE) {
                throw MethodHandleStatics.newIllegalArgumentException("void type");
            }
            Wrapper w = Wrapper.forPrimitiveType(type);
            return MethodHandles.insertArguments(MethodHandles.identity(type), 0, w.convert(value, type));
        }
        return MethodHandles.identity(type).bindTo(type.cast(value));
    }

    public static MethodHandle identity(Class<?> type) {
        if (type == Void.TYPE) {
            throw MethodHandleStatics.newIllegalArgumentException("void type");
        }
        if (type == Object.class) {
            return ValueConversions.identity();
        }
        if (type.isPrimitive()) {
            return ValueConversions.identity(Wrapper.forPrimitiveType(type));
        }
        return MethodHandleImpl.makeReferenceIdentity(type);
    }

    public static MethodHandle insertArguments(MethodHandle target, int pos, Object ... values) {
        int insCount = values.length;
        MethodType oldType = target.type();
        int outargs = oldType.parameterCount();
        int inargs = outargs - insCount;
        if (inargs < 0) {
            throw MethodHandleStatics.newIllegalArgumentException("too many values to insert");
        }
        if (pos < 0 || pos > inargs) {
            throw MethodHandleStatics.newIllegalArgumentException("no argument type to append");
        }
        MethodHandle result = target;
        for (int i = 0; i < insCount; ++i) {
            Object value = values[i];
            Class<?> ptype = oldType.parameterType(pos + i);
            if (ptype.isPrimitive()) {
                char btype = 'I';
                Wrapper w = Wrapper.forPrimitiveType(ptype);
                switch (w) {
                    case LONG: {
                        btype = 'J';
                        break;
                    }
                    case FLOAT: {
                        btype = 'F';
                        break;
                    }
                    case DOUBLE: {
                        btype = 'D';
                    }
                }
                value = w.convert(value, ptype);
                result = result.bindArgument(pos, btype, value);
                continue;
            }
            value = ptype.cast(value);
            result = pos == 0 ? result.bindReceiver(value) : result.bindArgument(pos, 'L', value);
        }
        return result;
    }

    public static MethodHandle dropArguments(MethodHandle target, int pos, List<Class<?>> valueTypes) {
        MethodType oldType = target.type();
        int dropped = valueTypes.size();
        MethodType.checkSlotCount(dropped);
        if (dropped == 0) {
            return target;
        }
        int outargs = oldType.parameterCount();
        int inargs = outargs + dropped;
        if (pos < 0 || pos >= inargs) {
            throw MethodHandleStatics.newIllegalArgumentException("no argument type to remove");
        }
        ArrayList ptypes = new ArrayList(oldType.parameterList());
        ptypes.addAll(pos, valueTypes);
        if (ptypes.size() != inargs) {
            throw MethodHandleStatics.newIllegalArgumentException("valueTypes");
        }
        MethodType newType = MethodType.methodType(oldType.returnType(), ptypes);
        return target.dropArguments(newType, pos, dropped);
    }

    public static MethodHandle dropArguments(MethodHandle target, int pos, Class<?> ... valueTypes) {
        return MethodHandles.dropArguments(target, pos, Arrays.asList(valueTypes));
    }

    public static MethodHandle filterArguments(MethodHandle target, int pos, MethodHandle ... filters) {
        MethodType targetType = target.type();
        MethodHandle adapter = target;
        MethodType adapterType = null;
        assert ((adapterType = targetType) != null);
        int maxPos = targetType.parameterCount();
        if (pos + filters.length > maxPos) {
            throw MethodHandleStatics.newIllegalArgumentException("too many filters");
        }
        int curPos = pos - 1;
        for (MethodHandle filter : filters) {
            ++curPos;
            if (filter == null) continue;
            adapter = MethodHandles.filterArgument(adapter, curPos, filter);
            assert ((adapterType = adapterType.changeParameterType(curPos, filter.type().parameterType(0))) != null);
        }
        assert (adapterType.equals((Object)adapter.type()));
        return adapter;
    }

    static MethodHandle filterArgument(MethodHandle target, int pos, MethodHandle filter) {
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        if (filterType.parameterCount() != 1 || filterType.returnType() != targetType.parameterType(pos)) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", targetType, filterType);
        }
        return MethodHandleImpl.makeCollectArguments(target, filter, pos, false);
    }

    static MethodHandle collectArguments(MethodHandle target, int pos, MethodHandle collector) {
        MethodType targetType = target.type();
        MethodType filterType = collector.type();
        if (filterType.returnType() != Void.TYPE && filterType.returnType() != targetType.parameterType(pos)) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", targetType, filterType);
        }
        return MethodHandleImpl.makeCollectArguments(target, collector, pos, false);
    }

    public static MethodHandle filterReturnValue(MethodHandle target, MethodHandle filter) {
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        Class<?> rtype = targetType.returnType();
        int filterValues = filterType.parameterCount();
        if (filterValues == 0 ? rtype != Void.TYPE : rtype != filterType.parameterType(0)) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", target, filter);
        }
        return MethodHandleImpl.makeCollectArguments(filter, target, 0, false);
    }

    public static MethodHandle foldArguments(MethodHandle target, MethodHandle combiner) {
        boolean ok;
        int pos = 0;
        MethodType targetType = target.type();
        MethodType combinerType = combiner.type();
        int foldPos = pos;
        int foldArgs = combinerType.parameterCount();
        int foldVals = combinerType.returnType() == Void.TYPE ? 0 : 1;
        int afterInsertPos = foldPos + foldVals;
        boolean bl = ok = targetType.parameterCount() >= afterInsertPos + foldArgs;
        if (ok && !combinerType.parameterList().equals(targetType.parameterList().subList(afterInsertPos, afterInsertPos + foldArgs))) {
            ok = false;
        }
        if (ok && foldVals != 0 && !combinerType.returnType().equals(targetType.parameterType(0))) {
            ok = false;
        }
        if (!ok) {
            throw MethodHandles.misMatchedTypes("target and combiner types", targetType, combinerType);
        }
        MethodType newType = targetType.dropParameterTypes(foldPos, afterInsertPos);
        return MethodHandleImpl.makeCollectArguments(target, combiner, foldPos, true);
    }

    public static MethodHandle guardWithTest(MethodHandle test, MethodHandle target, MethodHandle fallback) {
        List<Class<?>> gargs;
        MethodType ftype;
        MethodType gtype = test.type();
        MethodType ttype = target.type();
        if (!ttype.equals((Object)(ftype = fallback.type()))) {
            throw MethodHandles.misMatchedTypes("target and fallback types", ttype, ftype);
        }
        if (gtype.returnType() != Boolean.TYPE) {
            throw MethodHandleStatics.newIllegalArgumentException("guard type is not a predicate " + gtype);
        }
        List<Class<?>> targs = ttype.parameterList();
        if (!targs.equals(gargs = gtype.parameterList())) {
            int tpc;
            int gpc = gargs.size();
            if (gpc >= (tpc = targs.size()) || !targs.subList(0, gpc).equals(gargs)) {
                throw MethodHandles.misMatchedTypes("target and test types", ttype, gtype);
            }
            test = MethodHandles.dropArguments(test, gpc, targs.subList(gpc, tpc));
            gtype = test.type();
        }
        return MethodHandleImpl.makeGuardWithTest(test, target, fallback);
    }

    static RuntimeException misMatchedTypes(String what, MethodType t1, MethodType t2) {
        return MethodHandleStatics.newIllegalArgumentException(what + " must match: " + t1 + " != " + t2);
    }

    public static MethodHandle catchException(MethodHandle target, Class<? extends Throwable> exType, MethodHandle handler) {
        MethodType ttype = target.type();
        MethodType htype = handler.type();
        if (htype.parameterCount() < 1 || !htype.parameterType(0).isAssignableFrom(exType)) {
            throw MethodHandleStatics.newIllegalArgumentException("handler does not accept exception type " + exType);
        }
        if (htype.returnType() != ttype.returnType()) {
            throw MethodHandles.misMatchedTypes("target and handler return types", ttype, htype);
        }
        List<Class<?>> targs = ttype.parameterList();
        List<Class<?>> hargs = htype.parameterList();
        if (!targs.equals(hargs = hargs.subList(1, hargs.size()))) {
            int tpc;
            int hpc = hargs.size();
            if (hpc >= (tpc = targs.size()) || !targs.subList(0, hpc).equals(hargs)) {
                throw MethodHandles.misMatchedTypes("target and handler types", ttype, htype);
            }
            handler = MethodHandles.dropArguments(handler, 1 + hpc, targs.subList(hpc, tpc));
            htype = handler.type();
        }
        return MethodHandleImpl.makeGuardWithCatch(target, exType, handler);
    }

    public static MethodHandle throwException(Class<?> returnType, Class<? extends Throwable> exType) {
        if (!Throwable.class.isAssignableFrom(exType)) {
            throw new ClassCastException(exType.getName());
        }
        return MethodHandleImpl.throwException(MethodType.methodType(returnType, exType));
    }

    static {
        MethodHandleImpl.initStatics();
    }

    public static final class Lookup {
        private final Class<?> lookupClass;
        private final int allowedModes;
        public static final int PUBLIC = 1;
        public static final int PRIVATE = 2;
        public static final int PROTECTED = 4;
        public static final int PACKAGE = 8;
        private static final int ALL_MODES = 15;
        private static final int TRUSTED = -1;
        static final Lookup PUBLIC_LOOKUP;
        static final Lookup IMPL_LOOKUP;
        private static final boolean ALLOW_NESTMATE_ACCESS = false;

        private static int fixmods(int mods) {
            return (mods &= 7) != 0 ? mods : 8;
        }

        public Class<?> lookupClass() {
            return this.lookupClass;
        }

        private Class<?> lookupClassOrNull() {
            return this.allowedModes == -1 ? null : this.lookupClass;
        }

        public int lookupModes() {
            return this.allowedModes & 0xF;
        }

        Lookup(Class<?> lookupClass) {
            this(lookupClass, 15);
            Lookup.checkUnprivilegedlookupClass(lookupClass, 15);
        }

        private Lookup(Class<?> lookupClass, int allowedModes) {
            this.lookupClass = lookupClass;
            this.allowedModes = allowedModes;
        }

        public Lookup in(Class<?> requestedLookupClass) {
            requestedLookupClass.getClass();
            if (this.allowedModes == -1) {
                return new Lookup(requestedLookupClass, 15);
            }
            if (requestedLookupClass == this.lookupClass) {
                return this;
            }
            int newModes = this.allowedModes & 0xB;
            if ((newModes & 8) != 0 && !VerifyAccess.isSamePackage(this.lookupClass, requestedLookupClass)) {
                newModes &= 0xFFFFFFF5;
            }
            if ((newModes & 2) != 0 && !VerifyAccess.isSamePackageMember(this.lookupClass, requestedLookupClass)) {
                newModes &= 0xFFFFFFFD;
            }
            if ((newModes & 1) != 0 && !VerifyAccess.isClassAccessible(requestedLookupClass, this.lookupClass, this.allowedModes)) {
                newModes = 0;
            }
            Lookup.checkUnprivilegedlookupClass(requestedLookupClass, newModes);
            return new Lookup(requestedLookupClass, newModes);
        }

        private static void checkUnprivilegedlookupClass(Class<?> lookupClass, int allowedModes) {
            String name = lookupClass.getName();
            if (name.startsWith("java.lang.invoke.")) {
                throw MethodHandleStatics.newIllegalArgumentException("illegal lookupClass: " + lookupClass);
            }
            if (allowedModes == 15 && lookupClass.getClassLoader() == null && (name.startsWith("java.") || name.startsWith("sun.") && !name.startsWith("sun.invoke."))) {
                throw MethodHandleStatics.newIllegalArgumentException("illegal lookupClass: " + lookupClass);
            }
        }

        public String toString() {
            String cname = this.lookupClass.getName();
            switch (this.allowedModes) {
                case 0: {
                    return cname + "/noaccess";
                }
                case 1: {
                    return cname + "/public";
                }
                case 9: {
                    return cname + "/package";
                }
                case 11: {
                    return cname + "/private";
                }
                case 15: {
                    return cname;
                }
                case -1: {
                    return "/trusted";
                }
            }
            cname = cname + "/" + Integer.toHexString(this.allowedModes);
            assert (false) : cname;
            return cname;
        }

        public MethodHandle findStatic(Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            MemberName method = this.resolveOrFail((byte)6, refc, name, type);
            this.checkSecurityManager(refc, method);
            return this.getDirectMethod((byte)6, refc, method, this.findBoundCallerClass(method));
        }

        public MethodHandle findVirtual(Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            MethodHandle mh;
            if (refc == MethodHandle.class && (mh = this.findVirtualForMH(name, type)) != null) {
                return mh;
            }
            byte refKind = refc.isInterface() ? (byte)9 : 5;
            MemberName method = this.resolveOrFail(refKind, refc, name, type);
            this.checkSecurityManager(refc, method);
            return this.getDirectMethod(refKind, refc, method, this.findBoundCallerClass(method));
        }

        private MethodHandle findVirtualForMH(String name, MethodType type) {
            if ("invoke".equals(name)) {
                return MethodHandles.invoker(type);
            }
            if ("invokeExact".equals(name)) {
                return MethodHandles.exactInvoker(type);
            }
            return null;
        }

        public MethodHandle findConstructor(Class<?> refc, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            String name = "<init>";
            MemberName ctor = this.resolveOrFail((byte)8, refc, name, type);
            this.checkSecurityManager(refc, ctor);
            return this.getDirectConstructor(refc, ctor);
        }

        public MethodHandle findSpecial(Class<?> refc, String name, MethodType type, Class<?> specialCaller) throws NoSuchMethodException, IllegalAccessException {
            this.checkSpecialCaller(specialCaller);
            Lookup specialLookup = this.in(specialCaller);
            MemberName method = specialLookup.resolveOrFail((byte)7, refc, name, type);
            this.checkSecurityManager(refc, method);
            return specialLookup.getDirectMethod((byte)7, refc, method, this.findBoundCallerClass(method));
        }

        public MethodHandle findGetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail((byte)1, refc, name, type);
            this.checkSecurityManager(refc, field);
            return this.getDirectField((byte)1, refc, field);
        }

        public MethodHandle findSetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail((byte)3, refc, name, type);
            this.checkSecurityManager(refc, field);
            return this.getDirectField((byte)3, refc, field);
        }

        public MethodHandle findStaticGetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail((byte)2, refc, name, type);
            this.checkSecurityManager(refc, field);
            return this.getDirectField((byte)2, refc, field);
        }

        public MethodHandle findStaticSetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail((byte)4, refc, name, type);
            this.checkSecurityManager(refc, field);
            return this.getDirectField((byte)4, refc, field);
        }

        public MethodHandle bind(Object receiver, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            Class<?> refc = receiver.getClass();
            MemberName method = this.resolveOrFail((byte)7, refc, name, type);
            this.checkSecurityManager(refc, method);
            MethodHandle mh = this.getDirectMethodNoRestrict((byte)7, refc, method, this.findBoundCallerClass(method));
            return mh.bindReceiver(receiver).setVarargs(method);
        }

        public MethodHandle unreflect(Method m) throws IllegalAccessException {
            MemberName method = new MemberName(m);
            byte refKind = method.getReferenceKind();
            if (refKind == 7) {
                refKind = 5;
            }
            assert (method.isMethod());
            Lookup lookup = m.isAccessible() ? IMPL_LOOKUP : this;
            return lookup.getDirectMethod(refKind, method.getDeclaringClass(), method, this.findBoundCallerClass(method));
        }

        public MethodHandle unreflectSpecial(Method m, Class<?> specialCaller) throws IllegalAccessException {
            this.checkSpecialCaller(specialCaller);
            Lookup specialLookup = this.in(specialCaller);
            MemberName method = new MemberName(m, true);
            assert (method.isMethod());
            return specialLookup.getDirectMethod((byte)7, method.getDeclaringClass(), method, this.findBoundCallerClass(method));
        }

        public MethodHandle unreflectConstructor(Constructor c) throws IllegalAccessException {
            MemberName ctor = new MemberName(c);
            assert (ctor.isConstructor());
            Lookup lookup = c.isAccessible() ? IMPL_LOOKUP : this;
            return lookup.getDirectConstructor(ctor.getDeclaringClass(), ctor);
        }

        public MethodHandle unreflectGetter(Field f) throws IllegalAccessException {
            return this.unreflectField(f, false);
        }

        private MethodHandle unreflectField(Field f, boolean isSetter) throws IllegalAccessException {
            MemberName field = new MemberName(f, isSetter);
            assert (!isSetter ? MethodHandleNatives.refKindIsGetter(field.getReferenceKind()) : MethodHandleNatives.refKindIsSetter(field.getReferenceKind()));
            Lookup lookup = f.isAccessible() ? IMPL_LOOKUP : this;
            return lookup.getDirectField(field.getReferenceKind(), f.getDeclaringClass(), field);
        }

        public MethodHandle unreflectSetter(Field f) throws IllegalAccessException {
            return this.unreflectField(f, true);
        }

        MemberName resolveOrFail(byte refKind, Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            name.getClass();
            type.getClass();
            this.checkSymbolicClass(refc);
            return IMPL_NAMES.resolveOrFail(refKind, new MemberName(refc, name, type, refKind), this.lookupClassOrNull(), NoSuchFieldException.class);
        }

        MemberName resolveOrFail(byte refKind, Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            type.getClass();
            this.checkSymbolicClass(refc);
            this.checkMethodName(refKind, name);
            return IMPL_NAMES.resolveOrFail(refKind, new MemberName(refc, name, type, refKind), this.lookupClassOrNull(), NoSuchMethodException.class);
        }

        void checkSymbolicClass(Class<?> refc) throws IllegalAccessException {
            Class<?> caller = this.lookupClassOrNull();
            if (caller != null && !VerifyAccess.isClassAccessible(refc, caller, this.allowedModes)) {
                throw new MemberName(refc).makeAccessException("symbolic reference class is not public", this);
            }
        }

        void checkMethodName(byte refKind, String name) throws NoSuchMethodException {
            if (name.startsWith("<") && refKind != 8) {
                throw new NoSuchMethodException("illegal method name: " + name);
            }
        }

        Class<?> findBoundCallerClass(MemberName m) throws IllegalAccessException {
            Class<?> callerClass = null;
            if (MethodHandleNatives.isCallerSensitive(m)) {
                if (this.isFullPowerLookup()) {
                    callerClass = this.lookupClass;
                } else {
                    throw new IllegalAccessException("Attempt to lookup caller-sensitive method using restricted lookup object");
                }
            }
            return callerClass;
        }

        private boolean isFullPowerLookup() {
            return (this.allowedModes & 2) != 0;
        }

        private boolean isCheckMemberAccessOverridden(SecurityManager sm) {
            Class<?> cls = sm.getClass();
            if (cls == SecurityManager.class) {
                return false;
            }
            try {
                return cls.getMethod("checkMemberAccess", Class.class, Integer.TYPE).getDeclaringClass() != SecurityManager.class;
            }
            catch (NoSuchMethodException e) {
                throw new InternalError("should not reach here");
            }
        }

        void checkSecurityManager(Class<?> refc, MemberName m) {
            SecurityManager smgr = System.getSecurityManager();
            if (smgr == null) {
                return;
            }
            if (this.allowedModes == -1) {
                return;
            }
            boolean overridden = this.isCheckMemberAccessOverridden(smgr);
            boolean which = false;
            Class<?> clazz = refc;
            if (overridden) {
                smgr.checkMemberAccess(clazz, 0);
            }
            if (!this.isFullPowerLookup() || !VerifyAccess.classLoaderIsAncestor(this.lookupClass, refc)) {
                ReflectUtil.checkPackageAccess(refc);
            }
            if (m.isPublic()) {
                return;
            }
            Class<?> defc = m.getDeclaringClass();
            boolean which2 = true;
            Class<?> clazz2 = defc;
            if (!overridden) {
                if (!this.isFullPowerLookup()) {
                    smgr.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
                }
            } else {
                smgr.checkMemberAccess(clazz2, 1);
            }
            if (defc != refc) {
                ReflectUtil.checkPackageAccess(defc);
            }
        }

        void checkMethod(byte refKind, Class<?> refc, MemberName m) throws IllegalAccessException {
            String message;
            boolean wantStatic;
            boolean bl = wantStatic = refKind == 6;
            if (m.isConstructor()) {
                message = "expected a method, not a constructor";
            } else if (!m.isMethod()) {
                message = "expected a method";
            } else if (wantStatic != m.isStatic()) {
                message = wantStatic ? "expected a static method" : "expected a non-static method";
            } else {
                this.checkAccess(refKind, refc, m);
                return;
            }
            throw m.makeAccessException(message, this);
        }

        void checkField(byte refKind, Class<?> refc, MemberName m) throws IllegalAccessException {
            boolean wantStatic;
            boolean bl = wantStatic = !MethodHandleNatives.refKindHasReceiver(refKind);
            if (wantStatic == m.isStatic()) {
                this.checkAccess(refKind, refc, m);
                return;
            }
            String message = wantStatic ? "expected a static field" : "expected a non-static field";
            throw m.makeAccessException(message, this);
        }

        void checkAccess(byte refKind, Class<?> refc, MemberName m) throws IllegalAccessException {
            assert (m.referenceKindIsConsistentWith(refKind) && MethodHandleNatives.refKindIsValid(refKind) && MethodHandleNatives.refKindIsField(refKind) == m.isField());
            int allowedModes = this.allowedModes;
            if (allowedModes == -1) {
                return;
            }
            int mods = m.getModifiers();
            if (Modifier.isProtected(mods) && refKind == 8) {
                mods ^= 4;
            }
            if (Modifier.isFinal(mods) && MethodHandleNatives.refKindIsSetter(refKind)) {
                throw m.makeAccessException("unexpected set of a final field", this);
            }
            if (Modifier.isPublic(mods) && Modifier.isPublic(refc.getModifiers()) && allowedModes != 0) {
                return;
            }
            int requestedModes = Lookup.fixmods(mods);
            if ((requestedModes & allowedModes) != 0 ? VerifyAccess.isMemberAccessible(refc, m.getDeclaringClass(), mods, this.lookupClass(), allowedModes) : (requestedModes & 4) != 0 && (allowedModes & 8) != 0 && VerifyAccess.isSamePackage(m.getDeclaringClass(), this.lookupClass())) {
                return;
            }
            throw m.makeAccessException(this.accessFailedMessage(refc, m), this);
        }

        String accessFailedMessage(Class<?> refc, MemberName m) {
            boolean classOK;
            Class<?> defc = m.getDeclaringClass();
            int mods = m.getModifiers();
            boolean bl = classOK = Modifier.isPublic(defc.getModifiers()) && (defc == refc || Modifier.isPublic(refc.getModifiers()));
            if (!classOK && (this.allowedModes & 8) != 0) {
                boolean bl2 = classOK = VerifyAccess.isClassAccessible(defc, this.lookupClass(), 15) && (defc == refc || VerifyAccess.isClassAccessible(refc, this.lookupClass(), 15));
            }
            if (!classOK) {
                return "class is not public";
            }
            if (Modifier.isPublic(mods)) {
                return "access to public member failed";
            }
            if (Modifier.isPrivate(mods)) {
                return "member is private";
            }
            if (Modifier.isProtected(mods)) {
                return "member is protected";
            }
            return "member is private to package";
        }

        private void checkSpecialCaller(Class<?> specialCaller) throws IllegalAccessException {
            int allowedModes = this.allowedModes;
            if (allowedModes == -1) {
                return;
            }
            if ((allowedModes & 2) == 0 || specialCaller != this.lookupClass()) {
                throw new MemberName(specialCaller).makeAccessException("no private access for invokespecial", this);
            }
        }

        private boolean restrictProtectedReceiver(MemberName method) {
            return method.isProtected() && !method.isStatic() && this.allowedModes != -1 && method.getDeclaringClass() != this.lookupClass() && !VerifyAccess.isSamePackage(method.getDeclaringClass(), this.lookupClass());
            {
            }
        }

        private MethodHandle restrictReceiver(MemberName method, MethodHandle mh, Class<?> caller) throws IllegalAccessException {
            assert (!method.isStatic());
            if (!method.getDeclaringClass().isAssignableFrom(caller)) {
                throw method.makeAccessException("caller class must be a subclass below the method", caller);
            }
            MethodType rawType = mh.type();
            if (rawType.parameterType(0) == caller) {
                return mh;
            }
            MethodType narrowType = rawType.changeParameterType(0, caller);
            return mh.viewAsType(narrowType);
        }

        private MethodHandle getDirectMethod(byte refKind, Class<?> refc, MemberName method, Class<?> callerClass) throws IllegalAccessException {
            return this.getDirectMethodCommon(refKind, refc, method, refKind == 7 || MethodHandleNatives.refKindHasReceiver(refKind) && this.restrictProtectedReceiver(method), callerClass);
        }

        private MethodHandle getDirectMethodNoRestrict(byte refKind, Class<?> refc, MemberName method, Class<?> callerClass) throws IllegalAccessException {
            return this.getDirectMethodCommon(refKind, refc, method, false, callerClass);
        }

        private MethodHandle getDirectMethodCommon(byte refKind, Class<?> refc, MemberName method, boolean doRestrict, Class<?> callerClass) throws IllegalAccessException {
            Class<?> refcAsSuper;
            this.checkMethod(refKind, refc, method);
            if (method.isMethodHandleInvoke()) {
                return this.fakeMethodHandleInvoke(method);
            }
            if (refKind == 7 && refc != this.lookupClass() && refc != (refcAsSuper = this.lookupClass().getSuperclass()) && refc.isAssignableFrom(this.lookupClass())) {
                assert (!method.getName().equals("<init>"));
                MemberName m2 = new MemberName(refcAsSuper, method.getName(), method.getMethodType(), 7);
                m2 = IMPL_NAMES.resolveOrNull(refKind, m2, this.lookupClassOrNull());
                if (m2 == null) {
                    throw new InternalError(method.toString());
                }
                method = m2;
                refc = refcAsSuper;
                this.checkMethod(refKind, refc, method);
            }
            MethodHandle mh = DirectMethodHandle.make(refc, method);
            mh = this.maybeBindCaller(method, mh, callerClass);
            mh = mh.setVarargs(method);
            if (doRestrict) {
                mh = this.restrictReceiver(method, mh, this.lookupClass());
            }
            return mh;
        }

        private MethodHandle fakeMethodHandleInvoke(MemberName method) {
            return MethodHandles.throwException(method.getReturnType(), UnsupportedOperationException.class);
        }

        private MethodHandle maybeBindCaller(MemberName method, MethodHandle mh, Class<?> callerClass) throws IllegalAccessException {
            if (this.allowedModes == -1 || !MethodHandleNatives.isCallerSensitive(method)) {
                return mh;
            }
            Class<?> hostClass = this.lookupClass;
            if ((this.allowedModes & 2) == 0) {
                hostClass = callerClass;
            }
            MethodHandle cbmh = MethodHandleImpl.bindCaller(mh, hostClass);
            return cbmh;
        }

        private MethodHandle getDirectField(byte refKind, Class<?> refc, MemberName field) throws IllegalAccessException {
            boolean doRestrict;
            this.checkField(refKind, refc, field);
            MethodHandle mh = DirectMethodHandle.make(refc, field);
            boolean bl = doRestrict = MethodHandleNatives.refKindHasReceiver(refKind) && this.restrictProtectedReceiver(field);
            if (doRestrict) {
                mh = this.restrictReceiver(field, mh, this.lookupClass());
            }
            return mh;
        }

        private MethodHandle getDirectConstructor(Class<?> refc, MemberName ctor) throws IllegalAccessException {
            assert (ctor.isConstructor());
            this.checkAccess((byte)8, refc, ctor);
            assert (!MethodHandleNatives.isCallerSensitive(ctor));
            return DirectMethodHandle.make(ctor).setVarargs(ctor);
        }

        MethodHandle linkMethodHandleConstant(byte refKind, Class<?> defc, String name, Object type) throws ReflectiveOperationException {
            MemberName resolved = null;
            if (type instanceof MemberName) {
                resolved = (MemberName)type;
                if (!resolved.isResolved()) {
                    throw new InternalError("unresolved MemberName");
                }
                assert (name == null || name.equals(resolved.getName()));
            }
            if (MethodHandleNatives.refKindIsField(refKind)) {
                MemberName field = resolved != null ? resolved : this.resolveOrFail(refKind, defc, name, (Class)type);
                return this.getDirectField(refKind, defc, field);
            }
            if (MethodHandleNatives.refKindIsMethod(refKind)) {
                MethodHandle mh;
                if (defc == MethodHandle.class && refKind == 5 && (mh = this.findVirtualForMH(name, (MethodType)type)) != null) {
                    return mh;
                }
                MemberName method = resolved != null ? resolved : this.resolveOrFail(refKind, defc, name, (MethodType)type);
                return this.getDirectMethod(refKind, defc, method, this.lookupClass);
            }
            if (refKind == 8) {
                assert (name == null || name.equals("<init>"));
                MemberName ctor = resolved != null ? resolved : this.resolveOrFail((byte)8, defc, name, (MethodType)type);
                return this.getDirectConstructor(defc, ctor);
            }
            throw new ReflectiveOperationException("bad MethodHandle constant #" + refKind + " " + name + " : " + type);
        }

        static {
            IMPL_NAMES.getClass();
            PUBLIC_LOOKUP = new Lookup(Object.class, 1);
            IMPL_LOOKUP = new Lookup(Object.class, -1);
        }
    }
}

