/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class ExpiringCache {
    private long millisUntilExpiration;
    private Map map;
    private int queryCount;
    private int queryOverflow = 300;
    private int MAX_ENTRIES = 200;

    ExpiringCache() {
        this(30000L);
    }

    ExpiringCache(long millisUntilExpiration) {
        this.millisUntilExpiration = millisUntilExpiration;
        this.map = new LinkedHashMap(){

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > ExpiringCache.this.MAX_ENTRIES;
            }
        };
    }

    synchronized String get(String key) {
        Entry entry;
        if (++this.queryCount >= this.queryOverflow) {
            this.cleanup();
        }
        if ((entry = this.entryFor(key)) != null) {
            return entry.val();
        }
        return null;
    }

    synchronized void put(String key, String val) {
        Entry entry;
        if (++this.queryCount >= this.queryOverflow) {
            this.cleanup();
        }
        if ((entry = this.entryFor(key)) != null) {
            entry.setTimestamp(System.currentTimeMillis());
            entry.setVal(val);
        } else {
            this.map.put(key, new Entry(System.currentTimeMillis(), val));
        }
    }

    synchronized void clear() {
        this.map.clear();
    }

    private Entry entryFor(String key) {
        long delta;
        Entry entry = (Entry)this.map.get(key);
        if (entry != null && ((delta = System.currentTimeMillis() - entry.timestamp()) < 0L || delta >= this.millisUntilExpiration)) {
            this.map.remove(key);
            entry = null;
        }
        return entry;
    }

    private void cleanup() {
        Set keySet = this.map.keySet();
        String[] keys = new String[keySet.size()];
        int i = 0;
        for (String key : keySet) {
            keys[i++] = key;
        }
        for (int j = 0; j < keys.length; ++j) {
            this.entryFor(keys[j]);
        }
        this.queryCount = 0;
    }

    static class Entry {
        private long timestamp;
        private String val;

        Entry(long timestamp, String val) {
            this.timestamp = timestamp;
            this.val = val;
        }

        long timestamp() {
            return this.timestamp;
        }

        void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        String val() {
            return this.val;
        }

        void setVal(String val) {
            this.val = val;
        }
    }
}

