/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.module;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.KeyTab;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import sun.misc.HexDumpEncoder;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.krb5.Config;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbAsReqBuilder;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

public class Krb5LoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map<String, ?> options;
    private boolean debug = false;
    private boolean storeKey = false;
    private boolean doNotPrompt = false;
    private boolean useTicketCache = false;
    private boolean useKeyTab = false;
    private String ticketCacheName = null;
    private String keyTabName = null;
    private String princName = null;
    private boolean useFirstPass = false;
    private boolean tryFirstPass = false;
    private boolean storePass = false;
    private boolean clearPass = false;
    private boolean refreshKrb5Config = false;
    private boolean renewTGT = false;
    private boolean isInitiator = true;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private EncryptionKey[] encKeys = null;
    KeyTab ktab = null;
    private Credentials cred = null;
    private PrincipalName principal = null;
    private KerberosPrincipal kerbClientPrinc = null;
    private KerberosTicket kerbTicket = null;
    private KerberosKey[] kerbKeys = null;
    private StringBuffer krb5PrincName = null;
    private char[] password = null;
    private static final String NAME = "javax.security.auth.login.name";
    private static final String PWD = "javax.security.auth.login.password";
    static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.util.AuthResources");

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        this.storeKey = "true".equalsIgnoreCase((String)options.get("storeKey"));
        this.doNotPrompt = "true".equalsIgnoreCase((String)options.get("doNotPrompt"));
        this.useTicketCache = "true".equalsIgnoreCase((String)options.get("useTicketCache"));
        this.useKeyTab = "true".equalsIgnoreCase((String)options.get("useKeyTab"));
        this.ticketCacheName = (String)options.get("ticketCache");
        this.keyTabName = (String)options.get("keyTab");
        if (this.keyTabName != null) {
            this.keyTabName = sun.security.krb5.internal.ktab.KeyTab.normalize(this.keyTabName);
        }
        this.princName = (String)options.get("principal");
        this.refreshKrb5Config = "true".equalsIgnoreCase((String)options.get("refreshKrb5Config"));
        this.renewTGT = "true".equalsIgnoreCase((String)options.get("renewTGT"));
        String isInitiatorValue = (String)options.get("isInitiator");
        if (isInitiatorValue != null) {
            this.isInitiator = "true".equalsIgnoreCase(isInitiatorValue);
        }
        this.tryFirstPass = "true".equalsIgnoreCase((String)options.get("tryFirstPass"));
        this.useFirstPass = "true".equalsIgnoreCase((String)options.get("useFirstPass"));
        this.storePass = "true".equalsIgnoreCase((String)options.get("storePass"));
        this.clearPass = "true".equalsIgnoreCase((String)options.get("clearPass"));
        if (this.debug) {
            System.out.print("Debug is  " + this.debug + " storeKey " + this.storeKey + " useTicketCache " + this.useTicketCache + " useKeyTab " + this.useKeyTab + " doNotPrompt " + this.doNotPrompt + " ticketCache is " + this.ticketCacheName + " isInitiator " + this.isInitiator + " KeyTab is " + this.keyTabName + " refreshKrb5Config is " + this.refreshKrb5Config + " principal is " + this.princName + " tryFirstPass is " + this.tryFirstPass + " useFirstPass is " + this.useFirstPass + " storePass is " + this.storePass + " clearPass is " + this.clearPass + "\n");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean login() throws LoginException {
        this.validateConfiguration();
        if (this.refreshKrb5Config) {
            try {
                if (this.debug) {
                    System.out.println("Refreshing Kerberos configuration");
                }
                Config.refresh();
            }
            catch (KrbException ke) {
                le = new LoginException(ke.getMessage());
                le.initCause(ke);
                throw le;
            }
        }
        if ((principalProperty = System.getProperty("sun.security.krb5.principal")) != null) {
            this.krb5PrincName = new StringBuffer(principalProperty);
        } else if (this.princName != null) {
            this.krb5PrincName = new StringBuffer(this.princName);
        }
        if (this.tryFirstPass) {
            try {
                this.attemptAuthentication(true);
                if (this.debug) {
                    System.out.println("\t\t[Krb5LoginModule] authentication succeeded");
                }
                this.succeeded = true;
                this.cleanState();
                return true;
            }
            catch (LoginException le) {
                this.cleanState();
                if (!this.debug) ** GOTO lbl43
                System.out.println("\t\t[Krb5LoginModule] tryFirstPass failed with:" + le.getMessage());
            }
        } else if (this.useFirstPass) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                this.cleanState();
                return true;
            }
            catch (LoginException e) {
                if (this.debug) {
                    System.out.println("\t\t[Krb5LoginModule] authentication failed \n" + e.getMessage());
                }
                this.succeeded = false;
                this.cleanState();
                throw e;
            }
        }
lbl43:
        // 4 sources

        try {
            this.attemptAuthentication(false);
            this.succeeded = true;
            this.cleanState();
            return true;
        }
        catch (LoginException e) {
            if (this.debug) {
                System.out.println("\t\t[Krb5LoginModule] authentication failed \n" + e.getMessage());
            }
            this.succeeded = false;
            this.cleanState();
            throw e;
        }
    }

    private void attemptAuthentication(boolean getPasswdFromSharedState) throws LoginException {
        if (this.krb5PrincName != null) {
            try {
                this.principal = new PrincipalName(this.krb5PrincName.toString(), 1);
            }
            catch (KrbException e) {
                LoginException le = new LoginException(e.getMessage());
                le.initCause(e);
                throw le;
            }
        }
        try {
            if (this.useTicketCache) {
                if (this.debug) {
                    System.out.println("Acquire TGT from Cache");
                }
                this.cred = Credentials.acquireTGTFromCache(this.principal, this.ticketCacheName);
                if (this.cred != null && !this.isCurrent(this.cred)) {
                    if (this.renewTGT) {
                        this.cred = this.renewCredentials(this.cred);
                    } else {
                        this.cred = null;
                        if (this.debug) {
                            System.out.println("Credentials are no longer valid");
                        }
                    }
                }
                if (this.cred != null && this.principal == null) {
                    this.principal = this.cred.getClient();
                }
                if (this.debug) {
                    System.out.println("Principal is " + this.principal);
                    if (this.cred == null) {
                        System.out.println("null credentials from Ticket Cache");
                    }
                }
            }
            if (this.cred == null) {
                KrbAsReqBuilder builder;
                if (this.principal == null) {
                    this.promptForName(getPasswdFromSharedState);
                    this.principal = new PrincipalName(this.krb5PrincName.toString(), 1);
                }
                if (this.useKeyTab) {
                    KeyTab keyTab = this.ktab = this.keyTabName == null ? KeyTab.getInstance() : KeyTab.getInstance(new File(this.keyTabName));
                    if (this.isInitiator && Krb5Util.keysFromJavaxKeyTab(this.ktab, this.principal).length == 0) {
                        this.ktab = null;
                        if (this.debug) {
                            System.out.println("Key for the principal " + this.principal + " not available in " + (this.keyTabName == null ? "default key tab" : this.keyTabName));
                        }
                    }
                }
                if (this.ktab == null) {
                    this.promptForPass(getPasswdFromSharedState);
                    builder = new KrbAsReqBuilder(this.principal, this.password);
                    if (this.isInitiator) {
                        this.cred = builder.action().getCreds();
                    }
                    if (this.storeKey) {
                        this.encKeys = builder.getKeys(this.isInitiator);
                    }
                } else {
                    builder = new KrbAsReqBuilder(this.principal, this.ktab);
                    if (this.isInitiator) {
                        this.cred = builder.action().getCreds();
                    }
                }
                builder.destroy();
                if (this.debug) {
                    System.out.println("principal is " + this.principal);
                    HexDumpEncoder hd = new HexDumpEncoder();
                    if (this.ktab != null) {
                        System.out.println("Will use keytab");
                    } else if (this.storeKey) {
                        for (int i = 0; i < this.encKeys.length; ++i) {
                            System.out.println("EncryptionKey: keyType=" + this.encKeys[i].getEType() + " keyBytes (hex dump)=" + hd.encodeBuffer(this.encKeys[i].getBytes()));
                        }
                    }
                }
                if (this.isInitiator && this.cred == null) {
                    throw new LoginException("TGT Can not be obtained from the KDC ");
                }
            }
        }
        catch (KrbException e) {
            LoginException le = new LoginException(e.getMessage());
            le.initCause(e);
            throw le;
        }
        catch (IOException ioe) {
            LoginException ie = new LoginException(ioe.getMessage());
            ie.initCause(ioe);
            throw ie;
        }
    }

    private void promptForName(boolean getPasswdFromSharedState) throws LoginException {
        this.krb5PrincName = new StringBuffer("");
        if (getPasswdFromSharedState) {
            this.username = (String)this.sharedState.get(NAME);
            if (this.debug) {
                System.out.println("username from shared state is " + this.username + "\n");
            }
            if (this.username == null) {
                System.out.println("username from shared state is null\n");
                throw new LoginException("Username can not be obtained from sharedstate ");
            }
            if (this.debug) {
                System.out.println("username from shared state is " + this.username + "\n");
            }
            if (this.username != null && this.username.length() > 0) {
                this.krb5PrincName.insert(0, this.username);
                return;
            }
        }
        if (this.doNotPrompt) {
            throw new LoginException("Unable to obtain Princpal Name for authentication ");
        }
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available to garner authentication information from the user");
        }
        try {
            String defUsername = System.getProperty("user.name");
            Callback[] callbacks = new Callback[1];
            MessageFormat form = new MessageFormat(rb.getString("Kerberos.username.defUsername."));
            Object[] source = new Object[]{defUsername};
            callbacks[0] = new NameCallback(form.format(source));
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            if (this.username == null || this.username.length() == 0) {
                this.username = defUsername;
            }
            this.krb5PrincName.insert(0, this.username);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to garner " + " authentication information " + " from the user");
        }
    }

    private void promptForPass(boolean getPasswdFromSharedState) throws LoginException {
        if (getPasswdFromSharedState) {
            this.password = (char[])this.sharedState.get(PWD);
            if (this.password == null) {
                if (this.debug) {
                    System.out.println("Password from shared state is null");
                }
                throw new LoginException("Password can not be obtained from sharedstate ");
            }
            if (this.debug) {
                System.out.println("password is " + new String(this.password));
            }
            return;
        }
        if (this.doNotPrompt) {
            throw new LoginException("Unable to obtain password from user\n");
        }
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available to garner authentication information from the user");
        }
        try {
            Callback[] callbacks = new Callback[1];
            String userName = this.krb5PrincName.toString();
            MessageFormat form = new MessageFormat(rb.getString("Kerberos.password.for.username."));
            Object[] source = new Object[]{userName};
            callbacks[0] = new PasswordCallback(form.format(source), false);
            this.callbackHandler.handle(callbacks);
            char[] tmpPassword = ((PasswordCallback)callbacks[0]).getPassword();
            if (tmpPassword == null) {
                throw new LoginException("No password provided");
            }
            this.password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
            ((PasswordCallback)callbacks[0]).clearPassword();
            for (int i = 0; i < tmpPassword.length; ++i) {
                tmpPassword[i] = 32;
            }
            tmpPassword = null;
            if (this.debug) {
                System.out.println("\t\t[Krb5LoginModule] user entered username: " + this.krb5PrincName);
                System.out.println();
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to garner " + " authentication information " + "from the user");
        }
    }

    private void validateConfiguration() throws LoginException {
        if (!(!this.doNotPrompt || this.useTicketCache || this.useKeyTab || this.tryFirstPass || this.useFirstPass)) {
            throw new LoginException("Configuration Error - either doNotPrompt should be  false or at least one of useTicketCache,  useKeyTab, tryFirstPass and useFirstPass should be true");
        }
        if (this.ticketCacheName != null && !this.useTicketCache) {
            throw new LoginException("Configuration Error  - useTicketCache should be set to true to use the ticket cache" + this.ticketCacheName);
        }
        if (this.keyTabName != null & !this.useKeyTab) {
            throw new LoginException("Configuration Error - useKeyTab should be set to true to use the keytab" + this.keyTabName);
        }
        if (this.storeKey && this.doNotPrompt && !this.useKeyTab && !this.tryFirstPass && !this.useFirstPass) {
            throw new LoginException("Configuration Error - either doNotPrompt should be set to  false or at least one of tryFirstPass, useFirstPass or useKeyTab must be set to true for storeKey option");
        }
        if (this.renewTGT && !this.useTicketCache) {
            throw new LoginException("Configuration Error - either useTicketCache should be  true or renewTGT should be false");
        }
    }

    private boolean isCurrent(Credentials creds) {
        Date endTime = creds.getEndTime();
        if (endTime != null) {
            return System.currentTimeMillis() <= endTime.getTime();
        }
        return true;
    }

    private Credentials renewCredentials(Credentials creds) {
        Credentials lcreds;
        block5: {
            try {
                if (!creds.isRenewable()) {
                    throw new RefreshFailedException("This ticket is not renewable");
                }
                if (System.currentTimeMillis() > this.cred.getRenewTill().getTime()) {
                    throw new RefreshFailedException("This ticket is past its last renewal time.");
                }
                lcreds = creds.renew();
                if (this.debug) {
                    System.out.println("Renewed Kerberos Ticket");
                }
            }
            catch (Exception e) {
                lcreds = null;
                if (!this.debug) break block5;
                System.out.println("Ticket could not be renewed : " + e.getMessage());
            }
        }
        return lcreds;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean commit() throws LoginException {
        block15: {
            int i;
            Set<Object> privCredSet;
            block16: {
                if (!this.succeeded) {
                    return false;
                }
                if (this.isInitiator && this.cred == null) {
                    this.succeeded = false;
                    throw new LoginException("Null Client Credential");
                }
                if (this.subject.isReadOnly()) {
                    this.cleanKerberosCred();
                    throw new LoginException("Subject is Readonly");
                }
                privCredSet = this.subject.getPrivateCredentials();
                Set<Principal> princSet = this.subject.getPrincipals();
                this.kerbClientPrinc = new KerberosPrincipal(this.principal.getName());
                if (this.isInitiator) {
                    this.kerbTicket = Krb5Util.credsToTicket(this.cred);
                }
                if (this.storeKey && this.encKeys != null) {
                    if (this.encKeys.length == 0) {
                        this.succeeded = false;
                        throw new LoginException("Null Server Key ");
                    }
                    this.kerbKeys = new KerberosKey[this.encKeys.length];
                    for (i = 0; i < this.encKeys.length; ++i) {
                        Integer temp = this.encKeys[i].getKeyVersionNumber();
                        this.kerbKeys[i] = new KerberosKey(this.kerbClientPrinc, this.encKeys[i].getBytes(), this.encKeys[i].getEType(), temp == null ? 0 : temp);
                    }
                }
                if (!princSet.contains(this.kerbClientPrinc)) {
                    princSet.add(this.kerbClientPrinc);
                }
                if (this.kerbTicket != null && !privCredSet.contains(this.kerbTicket)) {
                    privCredSet.add(this.kerbTicket);
                }
                if (!this.storeKey) break block15;
                if (this.encKeys != null) break block16;
                if (this.ktab == null) {
                    this.succeeded = false;
                    throw new LoginException("No key to store");
                }
                if (!privCredSet.contains(this.ktab)) {
                    privCredSet.add(this.ktab);
                    for (KerberosKey key : this.ktab.getKeys(this.kerbClientPrinc)) {
                        privCredSet.add(new Krb5Util.KeysFromKeyTab(key));
                    }
                }
                break block15;
            }
            for (i = 0; i < this.kerbKeys.length; ++i) {
                if (!privCredSet.contains(this.kerbKeys[i])) {
                    privCredSet.add(this.kerbKeys[i]);
                }
                this.encKeys[i].destroy();
                this.encKeys[i] = null;
                if (!this.debug) continue;
                System.out.println("Added server's key" + this.kerbKeys[i]);
                System.out.println("\t\t[Krb5LoginModule] added Krb5Principal  " + this.kerbClientPrinc.toString() + " to Subject");
            }
        }
        this.commitSucceeded = true;
        if (this.debug) {
            System.out.println("Commit Succeeded \n");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.cleanKerberosCred();
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[Krb5LoginModule]: Entering logout");
        }
        if (this.subject.isReadOnly()) {
            this.cleanKerberosCred();
            throw new LoginException("Subject is Readonly");
        }
        this.subject.getPrincipals().remove(this.kerbClientPrinc);
        Iterator<Object> it = this.subject.getPrivateCredentials().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof KerberosTicket) && !(o instanceof KerberosKey) && !(o instanceof KeyTab)) continue;
            it.remove();
        }
        this.cleanKerberosCred();
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug) {
            System.out.println("\t\t[Krb5LoginModule]: logged out Subject");
        }
        return true;
    }

    private void cleanKerberosCred() throws LoginException {
        try {
            if (this.kerbTicket != null) {
                this.kerbTicket.destroy();
            }
            if (this.kerbKeys != null) {
                for (int i = 0; i < this.kerbKeys.length; ++i) {
                    this.kerbKeys[i].destroy();
                }
            }
        }
        catch (DestroyFailedException e) {
            throw new LoginException("Destroy Failed on Kerberos Private Credentials");
        }
        this.kerbTicket = null;
        this.kerbKeys = null;
        this.kerbClientPrinc = null;
    }

    private void cleanState() {
        if (this.succeeded) {
            if (this.storePass && !this.sharedState.containsKey(NAME) && !this.sharedState.containsKey(PWD)) {
                this.sharedState.put(NAME, this.username);
                this.sharedState.put(PWD, this.password);
            }
        } else {
            this.encKeys = null;
            this.ktab = null;
            this.principal = null;
        }
        this.username = null;
        this.password = null;
        if (this.krb5PrincName != null && this.krb5PrincName.length() != 0) {
            this.krb5PrincName.delete(0, this.krb5PrincName.length());
        }
        this.krb5PrincName = null;
        if (this.clearPass) {
            this.sharedState.remove(NAME);
            this.sharedState.remove(PWD);
        }
    }
}

