/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.JdbcRowSetResourceBundle;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetReader;
import javax.sql.rowset.CachedRowSet;

public class CachedRowSetReader
implements RowSetReader,
Serializable {
    private int writerCalls = 0;
    private boolean userCon = false;
    private int startPosition;
    private JdbcRowSetResourceBundle resBundle;
    static final long serialVersionUID = 5049738185801363801L;

    public CachedRowSetReader() {
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void readData(RowSetInternal caller) throws SQLException {
        Connection con = null;
        try {
            CachedRowSet crs = (CachedRowSet)((Object)caller);
            if (crs.getPageSize() == 0 && crs.size() > 0) {
                crs.close();
            }
            this.writerCalls = 0;
            this.userCon = false;
            con = this.connect(caller);
            if (con == null || crs.getCommand() == null) {
                throw new SQLException(this.resBundle.handleGetObject("crsreader.connecterr").toString());
            }
            try {
                con.setTransactionIsolation(crs.getTransactionIsolation());
            }
            catch (Exception ex) {
                // empty catch block
            }
            PreparedStatement pstmt = con.prepareStatement(crs.getCommand());
            this.decodeParams(caller.getParams(), pstmt);
            try {
                pstmt.setMaxRows(crs.getMaxRows());
                pstmt.setMaxFieldSize(crs.getMaxFieldSize());
                pstmt.setEscapeProcessing(crs.getEscapeProcessing());
                pstmt.setQueryTimeout(crs.getQueryTimeout());
            }
            catch (Exception ex) {
                throw new SQLException(ex.getMessage());
            }
            if (crs.getCommand().toLowerCase().indexOf("select") != -1) {
                ResultSet rs = pstmt.executeQuery();
                if (crs.getPageSize() == 0) {
                    crs.populate(rs);
                } else {
                    pstmt = con.prepareStatement(crs.getCommand(), 1004, 1008);
                    this.decodeParams(caller.getParams(), pstmt);
                    try {
                        pstmt.setMaxRows(crs.getMaxRows());
                        pstmt.setMaxFieldSize(crs.getMaxFieldSize());
                        pstmt.setEscapeProcessing(crs.getEscapeProcessing());
                        pstmt.setQueryTimeout(crs.getQueryTimeout());
                    }
                    catch (Exception ex) {
                        throw new SQLException(ex.getMessage());
                    }
                    rs = pstmt.executeQuery();
                    crs.populate(rs, this.startPosition);
                }
                rs.close();
            } else {
                pstmt.executeUpdate();
            }
            pstmt.close();
            try {
                con.commit();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            if (this.getCloseConnection()) {
                con.close();
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            block30: {
                try {
                    if (con == null || !this.getCloseConnection()) break block30;
                    try {
                        if (!con.getAutoCommit()) {
                            con.rollback();
                        }
                    }
                    catch (Exception dummy) {}
                    con.close();
                    con = null;
                }
                catch (SQLException e) {}
            }
        }
    }

    public boolean reset() throws SQLException {
        ++this.writerCalls;
        return this.writerCalls == 1;
    }

    public Connection connect(RowSetInternal caller) throws SQLException {
        if (caller.getConnection() != null) {
            this.userCon = true;
            return caller.getConnection();
        }
        if (((RowSet)((Object)caller)).getDataSourceName() != null) {
            try {
                InitialContext ctx = new InitialContext();
                DataSource ds = (DataSource)ctx.lookup(((RowSet)((Object)caller)).getDataSourceName());
                if (((RowSet)((Object)caller)).getUsername() != null) {
                    return ds.getConnection(((RowSet)((Object)caller)).getUsername(), ((RowSet)((Object)caller)).getPassword());
                }
                return ds.getConnection();
            }
            catch (NamingException ex) {
                SQLException sqlEx = new SQLException(this.resBundle.handleGetObject("crsreader.connect").toString());
                sqlEx.initCause(ex);
                throw sqlEx;
            }
        }
        if (((RowSet)((Object)caller)).getUrl() != null) {
            return DriverManager.getConnection(((RowSet)((Object)caller)).getUrl(), ((RowSet)((Object)caller)).getUsername(), ((RowSet)((Object)caller)).getPassword());
        }
        return null;
    }

    private void decodeParams(Object[] params, PreparedStatement pstmt) throws SQLException {
        Object[] param = null;
        for (int i = 0; i < params.length; ++i) {
            if (params[i] instanceof Object[]) {
                param = (Object[])params[i];
                if (param.length == 2) {
                    if (param[0] == null) {
                        pstmt.setNull(i + 1, (Integer)param[1]);
                        continue;
                    }
                    if (param[0] instanceof Date || param[0] instanceof Time || param[0] instanceof Timestamp) {
                        System.err.println(this.resBundle.handleGetObject("crsreader.datedetected").toString());
                        if (param[1] instanceof Calendar) {
                            System.err.println(this.resBundle.handleGetObject("crsreader.caldetected").toString());
                            pstmt.setDate(i + 1, (Date)param[0], (Calendar)param[1]);
                            continue;
                        }
                        throw new SQLException(this.resBundle.handleGetObject("crsreader.paramtype").toString());
                    }
                    if (param[0] instanceof Reader) {
                        pstmt.setCharacterStream(i + 1, (Reader)param[0], (Integer)param[1]);
                        continue;
                    }
                    if (!(param[1] instanceof Integer)) continue;
                    pstmt.setObject(i + 1, param[0], (Integer)param[1]);
                    continue;
                }
                if (param.length == 3) {
                    if (param[0] == null) {
                        pstmt.setNull(i + 1, (Integer)param[1], (String)param[2]);
                        continue;
                    }
                    if (param[0] instanceof InputStream) {
                        switch ((Integer)param[2]) {
                            case 0: {
                                pstmt.setUnicodeStream(i + 1, (InputStream)param[0], (Integer)param[1]);
                            }
                            case 1: {
                                pstmt.setBinaryStream(i + 1, (InputStream)param[0], (Integer)param[1]);
                            }
                            case 2: {
                                pstmt.setAsciiStream(i + 1, (InputStream)param[0], (Integer)param[1]);
                            }
                        }
                        throw new SQLException(this.resBundle.handleGetObject("crsreader.paramtype").toString());
                    }
                    if (param[1] instanceof Integer && param[2] instanceof Integer) {
                        pstmt.setObject(i + 1, param[0], (Integer)param[1], (Integer)param[2]);
                        continue;
                    }
                    throw new SQLException(this.resBundle.handleGetObject("crsreader.paramtype").toString());
                }
                pstmt.setObject(i + 1, params[i]);
                continue;
            }
            pstmt.setObject(i + 1, params[i]);
        }
    }

    protected boolean getCloseConnection() {
        return !this.userCon;
    }

    public void setStartPosition(int pos) {
        this.startPosition = pos;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

