/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.finder;

import com.sun.beans.finder.PrimitiveTypeMap;
import sun.reflect.misc.ReflectUtil;

public final class ClassFinder {
    public static Class<?> findClass(String name) throws ClassNotFoundException {
        ReflectUtil.checkPackageAccess(name);
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            if (loader != null) {
                return Class.forName(name, false, loader);
            }
        }
        catch (ClassNotFoundException exception) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return Class.forName(name);
    }

    public static Class<?> findClass(String name, ClassLoader loader) throws ClassNotFoundException {
        ReflectUtil.checkPackageAccess(name);
        if (loader != null) {
            try {
                return Class.forName(name, false, loader);
            }
            catch (ClassNotFoundException exception) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return ClassFinder.findClass(name);
    }

    public static Class<?> resolveClass(String name) throws ClassNotFoundException {
        return ClassFinder.resolveClass(name, null);
    }

    public static Class<?> resolveClass(String name, ClassLoader loader) throws ClassNotFoundException {
        Class<?> type = PrimitiveTypeMap.getType(name);
        return type == null ? ClassFinder.findClass(name, loader) : type;
    }

    private ClassFinder() {
    }
}

