/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.x86.X86SegmentRegister;
import sun.jvm.hotspot.utilities.Assert;

public class X86SegmentRegisters {
    public static final int NUM_SEGMENT_REGISTERS = 6;
    public static final X86SegmentRegister ES = new X86SegmentRegister(0, "%es");
    public static final X86SegmentRegister CS = new X86SegmentRegister(1, "%cs");
    public static final X86SegmentRegister SS = new X86SegmentRegister(2, "%ss");
    public static final X86SegmentRegister DS = new X86SegmentRegister(3, "%ds");
    public static final X86SegmentRegister FS = new X86SegmentRegister(4, "%fs");
    public static final X86SegmentRegister GS = new X86SegmentRegister(5, "%gs");
    private static X86SegmentRegister[] segmentRegisters = new X86SegmentRegister[]{ES, CS, SS, DS, FS, GS};

    public static int getNumberOfRegisters() {
        return 6;
    }

    public static X86SegmentRegister getSegmentRegister(int regNum) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(regNum > -1 && regNum < 6, "invalid segment register number!");
        }
        return segmentRegisters[regNum];
    }
}

