/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ThreadMonitor {
    private MBeanServerConnection server;
    private ThreadMXBean tmbean;
    private ObjectName objname;
    private String findDeadlocksMethodName = "findDeadlockedThreads";
    private boolean canDumpLocks = true;
    private static String INDENT = "    ";

    public ThreadMonitor(MBeanServerConnection server) throws IOException {
        this.server = server;
        this.tmbean = ManagementFactory.newPlatformMXBeanProxy(server, "java.lang:type=Threading", ThreadMXBean.class);
        try {
            this.objname = new ObjectName("java.lang:type=Threading");
        }
        catch (MalformedObjectNameException e) {
            InternalError ie = new InternalError(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        this.parseMBeanInfo();
    }

    public ThreadMonitor() {
        this.tmbean = ManagementFactory.getThreadMXBean();
    }

    public void threadDump() {
        if (this.canDumpLocks) {
            if (this.tmbean.isObjectMonitorUsageSupported() && this.tmbean.isSynchronizerUsageSupported()) {
                this.dumpThreadInfoWithLocks();
            }
        } else {
            this.dumpThreadInfo();
        }
    }

    private void dumpThreadInfo() {
        ThreadInfo[] tinfos;
        System.out.println("Full Java thread dump");
        long[] tids = this.tmbean.getAllThreadIds();
        for (ThreadInfo ti : tinfos = this.tmbean.getThreadInfo(tids, Integer.MAX_VALUE)) {
            this.printThreadInfo(ti);
        }
    }

    private void dumpThreadInfoWithLocks() {
        ThreadInfo[] tinfos;
        System.out.println("Full Java thread dump with locks info");
        for (ThreadInfo ti : tinfos = this.tmbean.dumpAllThreads(true, true)) {
            this.printThreadInfo(ti);
            LockInfo[] syncs = ti.getLockedSynchronizers();
            this.printLockInfo(syncs);
        }
        System.out.println();
    }

    private void printThreadInfo(ThreadInfo ti) {
        this.printThread(ti);
        StackTraceElement[] stacktrace = ti.getStackTrace();
        MonitorInfo[] monitors = ti.getLockedMonitors();
        for (int i = 0; i < stacktrace.length; ++i) {
            StackTraceElement ste = stacktrace[i];
            System.out.println(INDENT + "at " + ste.toString());
            for (MonitorInfo mi : monitors) {
                if (mi.getLockedStackDepth() != i) continue;
                System.out.println(INDENT + "  - locked " + mi);
            }
        }
        System.out.println();
    }

    private void printThread(ThreadInfo ti) {
        StringBuilder sb = new StringBuilder("\"" + ti.getThreadName() + "\"" + " Id=" + ti.getThreadId() + " in " + (Object)((Object)ti.getThreadState()));
        if (ti.getLockName() != null) {
            sb.append(" on lock=" + ti.getLockName());
        }
        if (ti.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (ti.isInNative()) {
            sb.append(" (running in native)");
        }
        System.out.println(sb.toString());
        if (ti.getLockOwnerName() != null) {
            System.out.println(INDENT + " owned by " + ti.getLockOwnerName() + " Id=" + ti.getLockOwnerId());
        }
    }

    private void printMonitorInfo(ThreadInfo ti) {
        MonitorInfo[] monitors = ti.getLockedMonitors();
        System.out.println(INDENT + "Locked monitors: count = " + monitors.length);
        for (MonitorInfo mi : monitors) {
            System.out.println(INDENT + "  - " + mi + " locked at ");
            System.out.println(INDENT + "      " + mi.getLockedStackDepth() + " " + mi.getLockedStackFrame());
        }
    }

    private void printLockInfo(LockInfo[] locks) {
        System.out.println(INDENT + "Locked synchronizers: count = " + locks.length);
        for (LockInfo li : locks) {
            System.out.println(INDENT + "  - " + li);
        }
        System.out.println();
    }

    public boolean findDeadlock() {
        if (this.findDeadlocksMethodName.equals("findDeadlockedThreads") && this.tmbean.isSynchronizerUsageSupported()) {
            ThreadInfo[] infos;
            long[] tids = this.tmbean.findDeadlockedThreads();
            if (tids == null) {
                return false;
            }
            System.out.println("Deadlock found :-");
            for (ThreadInfo ti : infos = this.tmbean.getThreadInfo(tids, true, true)) {
                this.printThreadInfo(ti);
                this.printMonitorInfo(ti);
                this.printLockInfo(ti.getLockedSynchronizers());
                System.out.println();
            }
        } else {
            ThreadInfo[] infos;
            long[] tids = this.tmbean.findMonitorDeadlockedThreads();
            if (tids == null) {
                return false;
            }
            for (ThreadInfo ti : infos = this.tmbean.getThreadInfo(tids, Integer.MAX_VALUE)) {
                this.printThreadInfo(ti);
            }
        }
        return true;
    }

    private void parseMBeanInfo() throws IOException {
        try {
            MBeanOperationInfo[] mopis = this.server.getMBeanInfo(this.objname).getOperations();
            boolean found = false;
            for (MBeanOperationInfo op : mopis) {
                if (!op.getName().equals(this.findDeadlocksMethodName)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.findDeadlocksMethodName = "findMonitorDeadlockedThreads";
                this.canDumpLocks = false;
            }
        }
        catch (IntrospectionException e) {
            InternalError ie = new InternalError(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        catch (InstanceNotFoundException e) {
            InternalError ie = new InternalError(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        catch (ReflectionException e) {
            InternalError ie = new InternalError(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }
}

