/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Deadlock {
    private CyclicBarrier barrier = new CyclicBarrier(6);

    public static void main(String[] argv) {
        new Deadlock();
        ThreadMonitor monitor = new ThreadMonitor();
        boolean found = false;
        while (!found) {
            found = monitor.findDeadlock();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                System.exit(1);
            }
        }
        System.out.println("\nPress <Enter> to exit this Deadlock program.\n");
        Deadlock.waitForEnterPressed();
    }

    public Deadlock() {
        DeadlockThread[] dThreads = new DeadlockThread[6];
        Monitor a = new Monitor("a");
        Monitor b = new Monitor("b");
        Monitor c = new Monitor("c");
        dThreads[0] = new DeadlockThread("MThread-1", a, b);
        dThreads[1] = new DeadlockThread("MThread-2", b, c);
        dThreads[2] = new DeadlockThread("MThread-3", c, a);
        ReentrantLock d = new ReentrantLock();
        ReentrantLock e = new ReentrantLock();
        ReentrantLock f = new ReentrantLock();
        dThreads[3] = new DeadlockThread("SThread-4", d, e);
        dThreads[4] = new DeadlockThread("SThread-5", e, f);
        dThreads[5] = new DeadlockThread("SThread-6", f, d);
        for (int i = 0; i < 6; ++i) {
            dThreads[i].setDaemon(true);
            dThreads[i].start();
        }
    }

    private static void waitForEnterPressed() {
        try {
            boolean done = false;
            while (!done) {
                char ch = (char)System.in.read();
                if (ch >= '\u0000' && ch != '\n') continue;
                done = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    class Monitor {
        String name;

        Monitor(String name) {
            this.name = name;
        }
    }

    class DeadlockThread
    extends Thread {
        private Lock lock1;
        private Lock lock2;
        private Monitor mon1;
        private Monitor mon2;
        private boolean useSync;

        DeadlockThread(String name, Lock lock1, Lock lock2) {
            super(name);
            this.lock1 = null;
            this.lock2 = null;
            this.mon1 = null;
            this.mon2 = null;
            this.lock1 = lock1;
            this.lock2 = lock2;
            this.useSync = true;
        }

        DeadlockThread(String name, Monitor mon1, Monitor mon2) {
            super(name);
            this.lock1 = null;
            this.lock2 = null;
            this.mon1 = null;
            this.mon2 = null;
            this.mon1 = mon1;
            this.mon2 = mon2;
            this.useSync = false;
        }

        @Override
        public void run() {
            if (this.useSync) {
                this.syncLock();
            } else {
                this.monitorLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void syncLock() {
            this.lock1.lock();
            try {
                try {
                    Deadlock.this.barrier.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (BrokenBarrierException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                this.goSyncDeadlock();
            }
            finally {
                this.lock1.unlock();
            }
        }

        private void goSyncDeadlock() {
            try {
                Deadlock.this.barrier.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
            catch (BrokenBarrierException e) {
                e.printStackTrace();
                System.exit(1);
            }
            this.lock2.lock();
            throw new RuntimeException("should not reach here.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void monitorLock() {
            Monitor monitor = this.mon1;
            synchronized (monitor) {
                try {
                    Deadlock.this.barrier.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (BrokenBarrierException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                this.goMonitorDeadlock();
            }
        }

        private void goMonitorDeadlock() {
            try {
                Deadlock.this.barrier.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.exit(1);
            }
            catch (BrokenBarrierException e) {
                e.printStackTrace();
                System.exit(1);
            }
            Monitor monitor = this.mon2;
            synchronized (monitor) {
                throw new RuntimeException(this.getName() + " should not reach here.");
            }
        }
    }
}

