/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CipherCore;
import com.sun.crypto.provider.DESedeCrypt;
import com.sun.crypto.provider.RC2Crypt;
import com.sun.crypto.provider.SunJCE;
import com.sun.crypto.provider.SymmetricCipher;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

final class PKCS12PBECipherCore {
    private CipherCore cipher;
    private int blockSize;
    private int keySize;
    private String algo = null;
    private byte[] salt = null;
    private int iCount = 0;
    private static final int DEFAULT_SALT_LENGTH = 20;
    private static final int DEFAULT_COUNT = 1024;
    static final int CIPHER_KEY = 1;
    static final int CIPHER_IV = 2;
    static final int MAC_KEY = 3;

    static byte[] derive(char[] chars, byte[] salt, int ic, int n, int type) {
        int length = chars.length * 2;
        if (length == 2 && chars[0] == '\u0000') {
            chars = new char[]{};
            length = 0;
        } else {
            length += 2;
        }
        byte[] passwd = new byte[length];
        int i = 0;
        int j = 0;
        while (i < chars.length) {
            passwd[j] = (byte)(chars[i] >>> 8 & 0xFF);
            passwd[j + 1] = (byte)(chars[i] & 0xFF);
            ++i;
            j += 2;
        }
        int v = 64;
        int u = 20;
        int c = PKCS12PBECipherCore.roundup(n, u) / u;
        byte[] D = new byte[v];
        int s = PKCS12PBECipherCore.roundup(salt.length, v);
        int p = PKCS12PBECipherCore.roundup(passwd.length, v);
        byte[] I = new byte[s + p];
        byte[] key = new byte[n];
        Arrays.fill(D, (byte)type);
        PKCS12PBECipherCore.concat(salt, I, 0, s);
        PKCS12PBECipherCore.concat(passwd, I, s, p);
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA1");
            byte[] B = new byte[v];
            byte[] tmp = new byte[v];
            int i2 = 0;
            while (true) {
                sha.update(D);
                sha.update(I);
                byte[] Ai = sha.digest();
                for (int r = 1; r < ic; ++r) {
                    Ai = sha.digest(Ai);
                }
                System.arraycopy(Ai, 0, key, u * i2, Math.min(n, u));
                if (i2 + 1 != c) {
                    PKCS12PBECipherCore.concat(Ai, B, 0, B.length);
                    BigInteger B1 = new BigInteger(1, B).add(BigInteger.ONE);
                    for (int j2 = 0; j2 < I.length; j2 += v) {
                        if (tmp.length != v) {
                            tmp = new byte[v];
                        }
                        System.arraycopy(I, j2, tmp, 0, v);
                        BigInteger Ij = new BigInteger(1, tmp);
                        Ij = Ij.add(B1);
                        tmp = Ij.toByteArray();
                        int trunc = tmp.length - v;
                        if (trunc >= 0) {
                            System.arraycopy(tmp, trunc, I, j2, v);
                            continue;
                        }
                        if (trunc >= 0) continue;
                        Arrays.fill(I, j2, j2 + -trunc, (byte)0);
                        System.arraycopy(tmp, 0, I, j2 + -trunc, tmp.length);
                    }
                    ++i2;
                    n -= u;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("internal error: " + e);
        }
        return key;
    }

    private static int roundup(int x, int y) {
        return (x + (y - 1)) / y * y;
    }

    private static void concat(byte[] src, byte[] dst, int start, int len) {
        if (src.length == 0) {
            return;
        }
        int loop = len / src.length;
        int i = 0;
        int off = 0;
        while (i < loop) {
            System.arraycopy(src, 0, dst, off + start, src.length);
            ++i;
            off += src.length;
        }
        System.arraycopy(src, 0, dst, off + start, len - off);
    }

    PKCS12PBECipherCore(String symmCipherAlg, int defKeySize) throws NoSuchAlgorithmException {
        this.algo = symmCipherAlg;
        SymmetricCipher symmCipher = null;
        if (this.algo.equals("DESede")) {
            symmCipher = new DESedeCrypt();
        } else if (this.algo.equals("RC2")) {
            symmCipher = new RC2Crypt();
        } else {
            throw new NoSuchAlgorithmException("No Cipher implementation for PBEWithSHA1And" + this.algo);
        }
        this.blockSize = ((SymmetricCipher)symmCipher).getBlockSize();
        this.cipher = new CipherCore(symmCipher, this.blockSize);
        this.cipher.setMode("CBC");
        try {
            this.cipher.setPadding("PKCS5Padding");
        }
        catch (NoSuchPaddingException nspe) {
            // empty catch block
        }
        this.keySize = defKeySize;
    }

    void implSetMode(String mode) throws NoSuchAlgorithmException {
        if (mode != null && !mode.equalsIgnoreCase("CBC")) {
            throw new NoSuchAlgorithmException("Invalid cipher mode: " + mode);
        }
    }

    void implSetPadding(String padding) throws NoSuchPaddingException {
        if (padding != null && !padding.equalsIgnoreCase("PKCS5Padding")) {
            throw new NoSuchPaddingException("Invalid padding scheme: " + padding);
        }
    }

    int implGetBlockSize() {
        return this.blockSize;
    }

    int implGetOutputSize(int inLen) {
        return this.cipher.getOutputSize(inLen);
    }

    byte[] implGetIV() {
        return this.cipher.getIV();
    }

    AlgorithmParameters implGetParameters() {
        AlgorithmParameters params = null;
        if (this.salt == null) {
            this.salt = new byte[20];
            SunJCE.RANDOM.nextBytes(this.salt);
            this.iCount = 1024;
        }
        PBEParameterSpec pbeSpec = new PBEParameterSpec(this.salt, this.iCount);
        try {
            params = AlgorithmParameters.getInstance("PBEWithSHA1And" + (this.algo.equalsIgnoreCase("RC2") ? "RC2_40" : this.algo), "SunJCE");
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException("SunJCE provider is not configured properly");
        }
        try {
            params.init(pbeSpec);
        }
        catch (InvalidParameterSpecException ipse) {
            throw new RuntimeException("PBEParameterSpec not supported");
        }
        return params;
    }

    void implInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        char[] passwdChars = null;
        this.salt = null;
        this.iCount = 0;
        if (key instanceof PBEKey) {
            PBEKey pbeKey = (PBEKey)key;
            passwdChars = pbeKey.getPassword();
            this.salt = pbeKey.getSalt();
            this.iCount = pbeKey.getIterationCount();
        } else if (key instanceof SecretKey) {
            byte[] passwdBytes = key.getEncoded();
            if (passwdBytes == null || !key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3)) {
                throw new InvalidKeyException("Missing password");
            }
            passwdChars = new char[passwdBytes.length];
            for (int i = 0; i < passwdChars.length; ++i) {
                passwdChars[i] = (char)(passwdBytes[i] & 0x7F);
            }
        } else {
            throw new InvalidKeyException("SecretKey of PBE type required");
        }
        if (!(opmode != 2 && opmode != 4 || params != null || this.salt != null && this.iCount != 0)) {
            throw new InvalidAlgorithmParameterException("Parameters missing");
        }
        if (params == null) {
            if (this.salt == null) {
                this.salt = new byte[20];
                if (random != null) {
                    random.nextBytes(this.salt);
                } else {
                    SunJCE.RANDOM.nextBytes(this.salt);
                }
            }
            if (this.iCount == 0) {
                this.iCount = 1024;
            }
        } else {
            if (!(params instanceof PBEParameterSpec)) {
                throw new InvalidAlgorithmParameterException("PBEParameterSpec type required");
            }
            PBEParameterSpec pbeParams = (PBEParameterSpec)params;
            if (this.salt != null) {
                if (!Arrays.equals(this.salt, pbeParams.getSalt())) {
                    throw new InvalidAlgorithmParameterException("Inconsistent value of salt between key and params");
                }
            } else {
                this.salt = pbeParams.getSalt();
            }
            if (this.iCount != 0) {
                if (this.iCount != pbeParams.getIterationCount()) {
                    throw new InvalidAlgorithmParameterException("Different iteration count between key and params");
                }
            } else {
                this.iCount = pbeParams.getIterationCount();
            }
        }
        if (this.salt.length < 8) {
            throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
        }
        if (this.iCount <= 0) {
            throw new InvalidAlgorithmParameterException("IterationCount must be a positive number");
        }
        byte[] derivedKey = PKCS12PBECipherCore.derive(passwdChars, this.salt, this.iCount, this.keySize, 1);
        SecretKeySpec cipherKey = new SecretKeySpec(derivedKey, this.algo);
        byte[] derivedIv = PKCS12PBECipherCore.derive(passwdChars, this.salt, this.iCount, 8, 2);
        IvParameterSpec ivSpec = new IvParameterSpec(derivedIv, 0, 8);
        this.cipher.init(opmode, (Key)cipherKey, ivSpec, random);
    }

    void implInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBEParameterSpec paramSpec = null;
        if (params != null) {
            try {
                paramSpec = params.getParameterSpec(PBEParameterSpec.class);
            }
            catch (InvalidParameterSpecException ipse) {
                throw new InvalidAlgorithmParameterException("requires PBE parameters");
            }
        }
        this.implInit(opmode, key, paramSpec, random);
    }

    void implInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.implInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new InvalidKeyException("requires PBE parameters");
        }
    }

    byte[] implUpdate(byte[] in, int inOff, int inLen) {
        return this.cipher.update(in, inOff, inLen);
    }

    int implUpdate(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws ShortBufferException {
        return this.cipher.update(in, inOff, inLen, out, outOff);
    }

    byte[] implDoFinal(byte[] in, int inOff, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(in, inOff, inLen);
    }

    int implDoFinal(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(in, inOff, inLen, out, outOff);
    }

    int implGetKeySize(Key key) throws InvalidKeyException {
        return this.keySize;
    }

    byte[] implWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.cipher.wrap(key);
    }

    Key implUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.cipher.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    public static final class PBEWithSHA1AndRC2_40
    extends CipherSpi {
        private final PKCS12PBECipherCore core = new PKCS12PBECipherCore("RC2", 5);

        @Override
        protected byte[] engineDoFinal(byte[] in, int inOff, int inLen) throws IllegalBlockSizeException, BadPaddingException {
            return this.core.implDoFinal(in, inOff, inLen);
        }

        @Override
        protected int engineDoFinal(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
            return this.core.implDoFinal(in, inOff, inLen, out, outOff);
        }

        @Override
        protected int engineGetBlockSize() {
            return this.core.implGetBlockSize();
        }

        @Override
        protected byte[] engineGetIV() {
            return this.core.implGetIV();
        }

        @Override
        protected int engineGetKeySize(Key key) throws InvalidKeyException {
            return this.core.implGetKeySize(key);
        }

        @Override
        protected int engineGetOutputSize(int inLen) {
            return this.core.implGetOutputSize(inLen);
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            return this.core.implGetParameters();
        }

        @Override
        protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.implInit(opmode, key, params, random);
        }

        @Override
        protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.implInit(opmode, key, params, random);
        }

        @Override
        protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
            this.core.implInit(opmode, key, random);
        }

        @Override
        protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
            this.core.implSetMode(mode);
        }

        @Override
        protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
            this.core.implSetPadding(paddingScheme);
        }

        @Override
        protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
            return this.core.implUnwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
        }

        @Override
        protected byte[] engineUpdate(byte[] in, int inOff, int inLen) {
            return this.core.implUpdate(in, inOff, inLen);
        }

        @Override
        protected int engineUpdate(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws ShortBufferException {
            return this.core.implUpdate(in, inOff, inLen, out, outOff);
        }

        @Override
        protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            return this.core.implWrap(key);
        }
    }

    public static final class PBEWithSHA1AndDESede
    extends CipherSpi {
        private final PKCS12PBECipherCore core = new PKCS12PBECipherCore("DESede", 24);

        @Override
        protected byte[] engineDoFinal(byte[] in, int inOff, int inLen) throws IllegalBlockSizeException, BadPaddingException {
            return this.core.implDoFinal(in, inOff, inLen);
        }

        @Override
        protected int engineDoFinal(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
            return this.core.implDoFinal(in, inOff, inLen, out, outOff);
        }

        @Override
        protected int engineGetBlockSize() {
            return this.core.implGetBlockSize();
        }

        @Override
        protected byte[] engineGetIV() {
            return this.core.implGetIV();
        }

        @Override
        protected int engineGetKeySize(Key key) throws InvalidKeyException {
            return this.core.implGetKeySize(key);
        }

        @Override
        protected int engineGetOutputSize(int inLen) {
            return this.core.implGetOutputSize(inLen);
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            return this.core.implGetParameters();
        }

        @Override
        protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.implInit(opmode, key, params, random);
        }

        @Override
        protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.implInit(opmode, key, params, random);
        }

        @Override
        protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
            this.core.implInit(opmode, key, random);
        }

        @Override
        protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
            this.core.implSetMode(mode);
        }

        @Override
        protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
            this.core.implSetPadding(paddingScheme);
        }

        @Override
        protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
            return this.core.implUnwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
        }

        @Override
        protected byte[] engineUpdate(byte[] in, int inOff, int inLen) {
            return this.core.implUpdate(in, inOff, inLen);
        }

        @Override
        protected int engineUpdate(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws ShortBufferException {
            return this.core.implUpdate(in, inOff, inLen, out, outOff);
        }

        @Override
        protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            return this.core.implWrap(key);
        }
    }
}

