/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class PrintGCStat {
    private RuntimeMXBean rmbean;
    private MemoryMXBean mmbean;
    private List<MemoryPoolMXBean> pools;
    private List<GarbageCollectorMXBean> gcmbeans;

    public PrintGCStat(MBeanServerConnection server) throws IOException {
        ObjectName gcName;
        ObjectName poolName;
        block6: {
            this.rmbean = ManagementFactory.newPlatformMXBeanProxy(server, "java.lang:type=Runtime", RuntimeMXBean.class);
            this.mmbean = ManagementFactory.newPlatformMXBeanProxy(server, "java.lang:type=Memory", MemoryMXBean.class);
            poolName = null;
            gcName = null;
            try {
                poolName = new ObjectName("java.lang:type=MemoryPool,*");
                gcName = new ObjectName("java.lang:type=GarbageCollector,*");
            }
            catch (MalformedObjectNameException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        Set<ObjectName> mbeans = server.queryNames(poolName, null);
        if (mbeans != null) {
            this.pools = new ArrayList<MemoryPoolMXBean>();
            for (ObjectName objName : mbeans) {
                MemoryPoolMXBean p = ManagementFactory.newPlatformMXBeanProxy(server, objName.getCanonicalName(), MemoryPoolMXBean.class);
                this.pools.add(p);
            }
        }
        if ((mbeans = server.queryNames(gcName, null)) != null) {
            this.gcmbeans = new ArrayList<GarbageCollectorMXBean>();
            for (ObjectName objName : mbeans) {
                GarbageCollectorMXBean gc = ManagementFactory.newPlatformMXBeanProxy(server, objName.getCanonicalName(), GarbageCollectorMXBean.class);
                this.gcmbeans.add(gc);
            }
        }
    }

    public PrintGCStat() {
        this.rmbean = ManagementFactory.getRuntimeMXBean();
        this.mmbean = ManagementFactory.getMemoryMXBean();
        this.pools = ManagementFactory.getMemoryPoolMXBeans();
        this.gcmbeans = ManagementFactory.getGarbageCollectorMXBeans();
    }

    public void printVerboseGc() {
        System.out.println("Uptime: " + this.formatMillis(this.rmbean.getUptime()));
        System.out.println("Heap usage: " + this.mmbean.getHeapMemoryUsage());
        System.out.println("Non-Heap memory usage: " + this.mmbean.getNonHeapMemoryUsage());
        for (GarbageCollectorMXBean gc : this.gcmbeans) {
            System.out.print(" [" + gc.getName() + ": ");
            System.out.print("Count=" + gc.getCollectionCount());
            System.out.print(" GCTime=" + this.formatMillis(gc.getCollectionTime()));
            System.out.print("]");
        }
        System.out.println();
        for (MemoryPoolMXBean p : this.pools) {
            System.out.print("  [" + p.getName() + ":");
            MemoryUsage u = p.getUsage();
            System.out.print(" Used=" + this.formatBytes(u.getUsed()));
            System.out.print(" Committed=" + this.formatBytes(u.getCommitted()));
            System.out.println("]");
        }
    }

    private String formatMillis(long ms) {
        return String.format("%.4fsec", (double)ms / 1000.0);
    }

    private String formatBytes(long bytes) {
        long kb = bytes;
        if (bytes > 0L) {
            kb = bytes / 1024L;
        }
        return kb + "K";
    }
}

