/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class Resources {
    private static Map<String, Integer> MNEMONIC_LOOKUP = Collections.synchronizedMap(new HashMap());

    private Resources() {
        throw new AssertionError();
    }

    public static String format(String pattern, Object ... arguments) {
        return MessageFormat.format(pattern, arguments);
    }

    public static int getMnemonicInt(String message) {
        Integer integer = MNEMONIC_LOOKUP.get(message);
        if (integer != null) {
            return integer;
        }
        return 0;
    }

    public static void initializeMessages(Class<?> clazz, String rbName) {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(rbName);
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        for (Field field : clazz.getFields()) {
            if (!Resources.isWritableField(field)) continue;
            String key = field.getName();
            String message = Resources.getMessage(rb, key);
            int mnemonicInt = Resources.findMnemonicInt(message);
            message = Resources.removeMnemonicAmpersand(message);
            message = Resources.replaceWithPlatformLineFeed(message);
            Resources.setFieldValue(field, message);
            MNEMONIC_LOOKUP.put(message, mnemonicInt);
        }
    }

    private static boolean isWritableField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers);
    }

    private static String getMessage(ResourceBundle rb, String key) {
        if (rb == null) {
            return "missing resource bundle";
        }
        try {
            return rb.getString(key);
        }
        catch (MissingResourceException mre) {
            return "missing message for key = \"" + key + "\" in resource bundle ";
        }
    }

    private static void setFieldValue(Field field, String value) {
        try {
            field.set(null, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new Error("Unable to access or set message for field " + field.getName());
        }
    }

    private static String replaceWithPlatformLineFeed(String text) {
        return text.replace("\n", System.getProperty("line.separator"));
    }

    private static String removeMnemonicAmpersand(String message) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < message.length(); ++i) {
            char current = message.charAt(i);
            if (current == '&' && i != message.length() - 1 && message.charAt(i + 1) != '&') continue;
            s.append(current);
        }
        return s.toString();
    }

    private static int findMnemonicInt(String s) {
        for (int i = 0; i < s.length() - 1; ++i) {
            if (s.charAt(i) != '&') continue;
            if (s.charAt(i + 1) != '&') {
                return Resources.lookupMnemonicInt(s.substring(i + 1, i + 2));
            }
            ++i;
        }
        return 0;
    }

    private static int lookupMnemonicInt(String c) {
        try {
            return KeyEvent.class.getDeclaredField("VK_" + c.toUpperCase()).getInt(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return 0;
        }
    }
}

