/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.SunWritableRaster;

public class ShortBandedRaster
extends SunWritableRaster {
    int[] dataOffsets;
    int scanlineStride;
    short[][] data;
    private int maxX;
    private int maxY;

    public ShortBandedRaster(SampleModel sampleModel, Point origin) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(origin.x, origin.y, sampleModel.getWidth(), sampleModel.getHeight()), origin, null);
    }

    public ShortBandedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point origin) {
        this(sampleModel, dataBuffer, new Rectangle(origin.x, origin.y, sampleModel.getWidth(), sampleModel.getHeight()), origin, null);
    }

    public ShortBandedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle aRegion, Point origin, ShortBandedRaster parent) {
        super(sampleModel, dataBuffer, aRegion, origin, parent);
        this.maxX = this.minX + this.width;
        this.maxY = this.minY + this.height;
        if (!(dataBuffer instanceof DataBufferUShort)) {
            throw new RasterFormatException("ShortBandedRaster must have ushort DataBuffers");
        }
        DataBufferUShort dbus = (DataBufferUShort)dataBuffer;
        if (sampleModel instanceof BandedSampleModel) {
            BandedSampleModel bsm = (BandedSampleModel)sampleModel;
            this.scanlineStride = bsm.getScanlineStride();
            int[] bankIndices = bsm.getBankIndices();
            int[] bandOffsets = bsm.getBandOffsets();
            int[] dOffsets = dbus.getOffsets();
            this.dataOffsets = new int[bankIndices.length];
            this.data = new short[bankIndices.length][];
            int xOffset = aRegion.x - origin.x;
            int yOffset = aRegion.y - origin.y;
            for (int i = 0; i < bankIndices.length; ++i) {
                this.data[i] = ShortBandedRaster.stealData(dbus, bankIndices[i]);
                this.dataOffsets[i] = dOffsets[bankIndices[i]] + xOffset + yOffset * this.scanlineStride + bandOffsets[i];
            }
        } else {
            throw new RasterFormatException("ShortBandedRasters must have BandedSampleModels");
        }
        this.verify();
    }

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public int getDataOffset(int band) {
        return this.dataOffsets[band];
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelStride() {
        return 1;
    }

    public short[][] getDataStorage() {
        return this.data;
    }

    public short[] getDataStorage(int band) {
        return this.data[band];
    }

    @Override
    public Object getDataElements(int x, int y, Object obj) {
        if (x < this.minX || y < this.minY || x >= this.maxX || y >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        short[] outData = obj == null ? new short[this.numDataElements] : (short[])obj;
        int off = (y - this.minY) * this.scanlineStride + (x - this.minX);
        for (int band = 0; band < this.numDataElements; ++band) {
            outData[band] = this.data[band][this.dataOffsets[band] + off];
        }
        return outData;
    }

    @Override
    public Object getDataElements(int x, int y, int w, int h, Object obj) {
        if (x < this.minX || y < this.minY || x + w > this.maxX || y + h > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        short[] outData = obj == null ? new short[this.numDataElements * w * h] : (short[])obj;
        int yoff = (y - this.minY) * this.scanlineStride + (x - this.minX);
        for (int c = 0; c < this.numDataElements; ++c) {
            int off = c;
            short[] bank = this.data[c];
            int dataOffset = this.dataOffsets[c];
            int yoff2 = yoff;
            int ystart = 0;
            while (ystart < h) {
                int xoff = dataOffset + yoff2;
                for (int xstart = 0; xstart < w; ++xstart) {
                    outData[off] = bank[xoff++];
                    off += this.numDataElements;
                }
                ++ystart;
                yoff2 += this.scanlineStride;
            }
        }
        return outData;
    }

    public short[] getShortData(int x, int y, int w, int h, int band, short[] outData) {
        if (x < this.minX || y < this.minY || x + w > this.maxX || y + h > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (outData == null) {
            outData = new short[this.scanlineStride * h];
        }
        int yoff = (y - this.minY) * this.scanlineStride + (x - this.minX) + this.dataOffsets[band];
        if (this.scanlineStride == w) {
            System.arraycopy(this.data[band], yoff, outData, 0, w * h);
        } else {
            int off = 0;
            int ystart = 0;
            while (ystart < h) {
                System.arraycopy(this.data[band], yoff, outData, off, w);
                off += w;
                ++ystart;
                yoff += this.scanlineStride;
            }
        }
        return outData;
    }

    public short[] getShortData(int x, int y, int w, int h, short[] outData) {
        if (x < this.minX || y < this.minY || x + w > this.maxX || y + h > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (outData == null) {
            outData = new short[this.numDataElements * this.scanlineStride * h];
        }
        int yoff = (y - this.minY) * this.scanlineStride + (x - this.minX);
        for (int c = 0; c < this.numDataElements; ++c) {
            int off = c;
            short[] bank = this.data[c];
            int dataOffset = this.dataOffsets[c];
            int yoff2 = yoff;
            int ystart = 0;
            while (ystart < h) {
                int xoff = dataOffset + yoff2;
                for (int xstart = 0; xstart < w; ++xstart) {
                    outData[off] = bank[xoff++];
                    off += this.numDataElements;
                }
                ++ystart;
                yoff2 += this.scanlineStride;
            }
        }
        return outData;
    }

    @Override
    public void setDataElements(int x, int y, Object obj) {
        if (x < this.minX || y < this.minY || x >= this.maxX || y >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        short[] inData = (short[])obj;
        int off = (y - this.minY) * this.scanlineStride + (x - this.minX);
        for (int i = 0; i < this.numDataElements; ++i) {
            this.data[i][this.dataOffsets[i] + off] = inData[i];
        }
        this.markDirty();
    }

    @Override
    public void setDataElements(int x, int y, Raster inRaster) {
        int dstOffX = x + inRaster.getMinX();
        int dstOffY = y + inRaster.getMinY();
        int width = inRaster.getWidth();
        int height = inRaster.getHeight();
        if (dstOffX < this.minX || dstOffY < this.minY || dstOffX + width > this.maxX || dstOffY + height > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(dstOffX, dstOffY, width, height, inRaster);
    }

    private void setDataElements(int dstX, int dstY, int width, int height, Raster inRaster) {
        if (width <= 0 || height <= 0) {
            return;
        }
        int srcOffX = inRaster.getMinX();
        int srcOffY = inRaster.getMinY();
        Object tdata = null;
        for (int startY = 0; startY < height; ++startY) {
            tdata = inRaster.getDataElements(srcOffX, srcOffY + startY, width, 1, tdata);
            this.setDataElements(dstX, dstY + startY, width, 1, tdata);
        }
    }

    @Override
    public void setDataElements(int x, int y, int w, int h, Object obj) {
        if (x < this.minX || y < this.minY || x + w > this.maxX || y + h > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        short[] inData = (short[])obj;
        int yoff = (y - this.minY) * this.scanlineStride + (x - this.minX);
        for (int c = 0; c < this.numDataElements; ++c) {
            int off = c;
            short[] bank = this.data[c];
            int dataOffset = this.dataOffsets[c];
            int yoff2 = yoff;
            int ystart = 0;
            while (ystart < h) {
                int xoff = dataOffset + yoff2;
                for (int xstart = 0; xstart < w; ++xstart) {
                    bank[xoff++] = inData[off];
                    off += this.numDataElements;
                }
                ++ystart;
                yoff2 += this.scanlineStride;
            }
        }
        this.markDirty();
    }

    public void putShortData(int x, int y, int w, int h, int band, short[] inData) {
        if (x < this.minX || y < this.minY || x + w > this.maxX || y + h > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int yoff = (y - this.minY) * this.scanlineStride + (x - this.minX) + this.dataOffsets[band];
        int off = 0;
        if (this.scanlineStride == w) {
            System.arraycopy(inData, 0, this.data[band], yoff, w * h);
        } else {
            int ystart = 0;
            while (ystart < h) {
                System.arraycopy(inData, off, this.data[band], yoff, w);
                off += w;
                ++ystart;
                yoff += this.scanlineStride;
            }
        }
        this.markDirty();
    }

    public void putShortData(int x, int y, int w, int h, short[] inData) {
        if (x < this.minX || y < this.minY || x + w > this.maxX || y + h > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int yoff = (y - this.minY) * this.scanlineStride + (x - this.minX);
        for (int c = 0; c < this.numDataElements; ++c) {
            int off = c;
            short[] bank = this.data[c];
            int dataOffset = this.dataOffsets[c];
            int yoff2 = yoff;
            int ystart = 0;
            while (ystart < h) {
                int xoff = dataOffset + yoff2;
                for (int xstart = 0; xstart < w; ++xstart) {
                    bank[xoff++] = inData[off];
                    off += this.numDataElements;
                }
                ++ystart;
                yoff2 += this.scanlineStride;
            }
        }
        this.markDirty();
    }

    @Override
    public WritableRaster createWritableChild(int x, int y, int width, int height, int x0, int y0, int[] bandList) {
        if (x < this.minX) {
            throw new RasterFormatException("x lies outside raster");
        }
        if (y < this.minY) {
            throw new RasterFormatException("y lies outside raster");
        }
        if (x + width < x || x + width > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside of Raster");
        }
        if (y + height < y || y + height > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside of Raster");
        }
        SampleModel sm = bandList != null ? this.sampleModel.createSubsetSampleModel(bandList) : this.sampleModel;
        int deltaX = x0 - x;
        int deltaY = y0 - y;
        return new ShortBandedRaster(sm, this.dataBuffer, new Rectangle(x0, y0, width, height), new Point(this.sampleModelTranslateX + deltaX, this.sampleModelTranslateY + deltaY), this);
    }

    @Override
    public Raster createChild(int x, int y, int width, int height, int x0, int y0, int[] bandList) {
        return this.createWritableChild(x, y, width, height, x0, y0, bandList);
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        if (w <= 0 || h <= 0) {
            throw new RasterFormatException("negative " + (w <= 0 ? "width" : "height"));
        }
        SampleModel sm = this.sampleModel.createCompatibleSampleModel(w, h);
        return new ShortBandedRaster(sm, new Point(0, 0));
    }

    @Override
    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    private void verify() {
        int i;
        int i2;
        if (this.width <= 0 || this.height <= 0 || this.height > Integer.MAX_VALUE / this.width) {
            throw new RasterFormatException("Invalid raster dimension");
        }
        if (this.scanlineStride < 0 || this.scanlineStride > Integer.MAX_VALUE / this.height) {
            throw new RasterFormatException("Incorrect scanline stride: " + this.scanlineStride);
        }
        for (i2 = 0; i2 < this.data.length; ++i2) {
            if (this.scanlineStride <= this.data[i2].length) continue;
            throw new RasterFormatException("Incorrect scanline stride: " + this.scanlineStride);
        }
        for (i2 = 0; i2 < this.dataOffsets.length; ++i2) {
            if (this.dataOffsets[i2] >= 0) continue;
            throw new RasterFormatException("Data offsets for band " + i2 + "(" + this.dataOffsets[i2] + ") must be >= 0");
        }
        int lastScanOffset = (this.height - 1) * this.scanlineStride;
        if (this.width - 1 > Integer.MAX_VALUE - lastScanOffset) {
            throw new RasterFormatException("Invalid raster dimension");
        }
        int lastPixelOffset = lastScanOffset + (this.width - 1);
        int maxIndex = 0;
        for (i = 0; i < this.numDataElements; ++i) {
            if (this.dataOffsets[i] > Integer.MAX_VALUE - lastPixelOffset) {
                throw new RasterFormatException("Invalid raster dimension");
            }
            int index = lastPixelOffset + this.dataOffsets[i];
            if (index <= maxIndex) continue;
            maxIndex = index;
        }
        for (i = 0; i < this.numDataElements; ++i) {
            if (this.data[i].length > maxIndex) continue;
            throw new RasterFormatException("Data array too small (should be > " + maxIndex + " )");
        }
    }

    public String toString() {
        return new String("ShortBandedRaster: width = " + this.width + " height = " + this.height + " #numBands " + this.numBands + " #dataElements " + this.numDataElements);
    }
}

