/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.sound.sampled.AudioPermission;
import sun.misc.Service;

final class JSSecurityManager {
    private JSSecurityManager() {
    }

    private static boolean hasSecurityManager() {
        return System.getSecurityManager() != null;
    }

    static void checkRecordPermission() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AudioPermission("record"));
        }
    }

    static String getProperty(final String propertyName) {
        String propertyValue;
        if (JSSecurityManager.hasSecurityManager()) {
            try {
                PrivilegedAction action = new PrivilegedAction(){

                    public Object run() {
                        try {
                            return System.getProperty(propertyName);
                        }
                        catch (Throwable t) {
                            return null;
                        }
                    }
                };
                propertyValue = (String)AccessController.doPrivileged(action);
            }
            catch (Exception e) {
                propertyValue = System.getProperty(propertyName);
            }
        } else {
            propertyValue = System.getProperty(propertyName);
        }
        return propertyValue;
    }

    static void loadProperties(final Properties properties, final String filename) {
        if (JSSecurityManager.hasSecurityManager()) {
            try {
                PrivilegedAction action = new PrivilegedAction(){

                    public Object run() {
                        JSSecurityManager.loadPropertiesImpl(properties, filename);
                        return null;
                    }
                };
                AccessController.doPrivileged(action);
            }
            catch (Exception e) {
                JSSecurityManager.loadPropertiesImpl(properties, filename);
            }
        } else {
            JSSecurityManager.loadPropertiesImpl(properties, filename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPropertiesImpl(Properties properties, String filename) {
        String fname = System.getProperty("java.home");
        try {
            if (fname == null) {
                throw new Error("Can't find java.home ??");
            }
            File f = new File(fname, "lib");
            f = new File(f, filename);
            fname = f.getCanonicalPath();
            FileInputStream in = new FileInputStream(fname);
            BufferedInputStream bin = new BufferedInputStream(in);
            try {
                properties.load(bin);
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static Thread createThread(Runnable runnable, String threadName, boolean isDaemon, int priority, boolean doStart) {
        Thread thread = new Thread(runnable);
        if (threadName != null) {
            thread.setName(threadName);
        }
        thread.setDaemon(isDaemon);
        if (priority >= 0) {
            thread.setPriority(priority);
        }
        if (doStart) {
            thread.start();
        }
        return thread;
    }

    static synchronized List getProviders(Class providerClass) {
        ArrayList p = new ArrayList();
        final Iterator ps = Service.providers(providerClass);
        PrivilegedAction<Boolean> hasNextAction = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return ps.hasNext();
            }
        };
        while (AccessController.doPrivileged(hasNextAction).booleanValue()) {
            try {
                Object provider = ps.next();
                if (!providerClass.isInstance(provider)) continue;
                p.add(0, provider);
            }
            catch (Throwable t) {}
        }
        return p;
    }
}

