/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import sun.awt.shell.ShellFolder;
import sun.swing.SwingUtilities2;
import sun.swing.plaf.synth.SynthFileChooserUI;

class GTKFileChooserUI
extends SynthFileChooserUI {
    private JPanel accessoryPanel = null;
    private String newFolderButtonText = null;
    private String newFolderErrorSeparator = null;
    private String newFolderErrorText = null;
    private String newFolderDialogText = null;
    private String newFolderNoDirectoryErrorTitleText = null;
    private String newFolderNoDirectoryErrorText = null;
    private String deleteFileButtonText = null;
    private String renameFileButtonText = null;
    private String newFolderButtonToolTipText = null;
    private String deleteFileButtonToolTipText = null;
    private String renameFileButtonToolTipText = null;
    private int newFolderButtonMnemonic = 0;
    private int deleteFileButtonMnemonic = 0;
    private int renameFileButtonMnemonic = 0;
    private int foldersLabelMnemonic = 0;
    private int filesLabelMnemonic = 0;
    private String renameFileDialogText = null;
    private String renameFileErrorTitle = null;
    private String renameFileErrorText = null;
    private JComboBox filterComboBox;
    private FilterComboBoxModel filterComboBoxModel;
    private JPanel rightPanel;
    private JList directoryList;
    private JList fileList;
    private JLabel pathField;
    private JTextField fileNameTextField;
    private static final Dimension hstrut3 = new Dimension(3, 1);
    private static final Dimension vstrut10 = new Dimension(1, 10);
    private static Dimension prefListSize = new Dimension(75, 150);
    private static Dimension PREF_SIZE = new Dimension(435, 360);
    private static Dimension MIN_SIZE = new Dimension(200, 300);
    private static Dimension ZERO_ACC_SIZE = new Dimension(1, 1);
    private static Dimension MAX_SIZE = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    private static final Insets buttonMargin = new Insets(3, 3, 3, 3);
    private String filesLabelText = null;
    private String foldersLabelText = null;
    private String pathLabelText = null;
    private String filterLabelText = null;
    private int pathLabelMnemonic = 0;
    private int filterLabelMnemonic = 0;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private JPanel bottomButtonPanel;
    private GTKDirectoryModel model = null;
    private Action newFolderAction;
    private boolean readOnly;
    private boolean showDirectoryIcons;
    private boolean showFileIcons;
    private GTKFileView fileView = new GTKFileView();
    private PropertyChangeListener gtkFCPropertyChangeListener;
    private Action approveSelectionAction = new GTKApproveSelectionAction();
    private GTKDirectoryListModel directoryListModel;

    public GTKFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    @Override
    protected ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("approveSelection", this.getApproveSelectionAction());
        map.put("cancelSelection", this.getCancelSelectionAction());
        map.put("Go Up", this.getChangeToParentDirectoryAction());
        map.put("fileNameCompletion", this.getFileNameCompletionAction());
        return map;
    }

    @Override
    public String getFileName() {
        String typedInName;
        JFileChooser fc = this.getFileChooser();
        String string = typedInName = this.fileNameTextField != null ? this.fileNameTextField.getText() : null;
        if (!fc.isMultiSelectionEnabled()) {
            return typedInName;
        }
        int mode = fc.getFileSelectionMode();
        JList list = mode == 1 ? this.directoryList : this.fileList;
        Object[] files = list.getSelectedValues();
        int len = files.length;
        Vector<String> result = new Vector<String>(len + 1);
        for (int i = 0; i < len; ++i) {
            File file = (File)files[i];
            result.add(file.getName());
        }
        if (typedInName != null && !result.contains(typedInName)) {
            result.add(typedInName);
        }
        StringBuffer buf = new StringBuffer();
        len = result.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            if (len > 1) {
                buf.append("\"");
            }
            buf.append((String)result.get(i));
            if (len <= 1) continue;
            buf.append("\"");
        }
        return buf.toString();
    }

    @Override
    public void setFileName(String fileName) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(fileName);
        }
    }

    @Override
    public void setDirectoryName(String dirname) {
        this.pathField.setText(dirname);
    }

    @Override
    public void ensureFileIsVisible(JFileChooser fc, File f) {
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser fc) {
        this.getModel().validateFileCache();
    }

    @Override
    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    @Override
    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    private void updateDefaultButton() {
        JFileChooser filechooser = this.getFileChooser();
        JRootPane root = SwingUtilities.getRootPane(filechooser);
        if (root == null) {
            return;
        }
        if (filechooser.getControlButtonsAreShown()) {
            if (root.getDefaultButton() == null) {
                root.setDefaultButton(this.getApproveButton(filechooser));
                this.getCancelButton(filechooser).setDefaultCapable(false);
            }
        } else if (root.getDefaultButton() == this.getApproveButton(filechooser)) {
            root.setDefaultButton(null);
        }
    }

    @Override
    protected void doSelectedFileChanged(PropertyChangeEvent e) {
        super.doSelectedFileChanged(e);
        File f = (File)e.getNewValue();
        if (f != null) {
            this.setFileName(this.getFileChooser().getName(f));
        }
    }

    @Override
    protected void doDirectoryChanged(PropertyChangeEvent e) {
        File currentDirectory;
        this.directoryList.clearSelection();
        ListSelectionModel sm = this.directoryList.getSelectionModel();
        if (sm instanceof DefaultListSelectionModel) {
            ((DefaultListSelectionModel)sm).moveLeadSelectionIndex(0);
            sm.setAnchorSelectionIndex(0);
        }
        this.fileList.clearSelection();
        sm = this.fileList.getSelectionModel();
        if (sm instanceof DefaultListSelectionModel) {
            ((DefaultListSelectionModel)sm).moveLeadSelectionIndex(0);
            sm.setAnchorSelectionIndex(0);
        }
        if ((currentDirectory = this.getFileChooser().getCurrentDirectory()) != null) {
            try {
                this.setDirectoryName(ShellFolder.getNormalizedFile((File)e.getNewValue()).getPath());
            }
            catch (IOException ioe) {
                this.setDirectoryName(((File)e.getNewValue()).getAbsolutePath());
            }
            if (this.getFileChooser().getFileSelectionMode() == 1 && !this.getFileChooser().isMultiSelectionEnabled()) {
                this.setFileName(this.pathField.getText());
            }
            this.directoryComboBoxModel.addItem(currentDirectory);
            this.directoryListModel.directoryChanged();
        }
        super.doDirectoryChanged(e);
    }

    @Override
    protected void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
                this.getAccessoryPanel().setPreferredSize(accessory.getPreferredSize());
                this.getAccessoryPanel().setMaximumSize(MAX_SIZE);
            } else {
                this.getAccessoryPanel().setPreferredSize(ZERO_ACC_SIZE);
                this.getAccessoryPanel().setMaximumSize(ZERO_ACC_SIZE);
            }
        }
    }

    @Override
    protected void doFileSelectionModeChanged(PropertyChangeEvent e) {
        this.directoryList.clearSelection();
        this.rightPanel.setVisible((Integer)e.getNewValue() != 1);
        super.doFileSelectionModeChanged(e);
    }

    @Override
    protected void doMultiSelectionChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.fileList.setSelectionMode(2);
        } else {
            this.fileList.setSelectionMode(0);
            this.fileList.clearSelection();
        }
        super.doMultiSelectionChanged(e);
    }

    @Override
    protected void doControlButtonsChanged(PropertyChangeEvent e) {
        super.doControlButtonsChanged(e);
        JFileChooser filechooser = this.getFileChooser();
        if (filechooser.getControlButtonsAreShown()) {
            filechooser.add((Component)this.bottomButtonPanel, "South");
        } else {
            filechooser.remove(this.bottomButtonPanel);
        }
        this.updateDefaultButton();
    }

    @Override
    protected void doAncestorChanged(PropertyChangeEvent e) {
        if (e.getOldValue() == null && e.getNewValue() != null) {
            this.fileNameTextField.selectAll();
            this.fileNameTextField.requestFocus();
            this.updateDefaultButton();
        }
        super.doAncestorChanged(e);
    }

    @Override
    public ListSelectionListener createListSelectionListener(JFileChooser fc) {
        return new SelectionListener();
    }

    @Override
    protected MouseListener createDoubleClickListener(JFileChooser fc, JList list) {
        return new DoubleClickListener(list);
    }

    public static ComponentUI createUI(JComponent c) {
        return new GTKFileChooserUI((JFileChooser)c);
    }

    @Override
    public void installUI(JComponent c) {
        this.accessoryPanel = new JPanel(new BorderLayout(10, 10));
        this.accessoryPanel.setName("GTKFileChooser.accessoryPanel");
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterComboBoxModel);
        super.uninstallUI(c);
        if (this.accessoryPanel != null) {
            this.accessoryPanel.removeAll();
        }
        this.accessoryPanel = null;
        this.getFileChooser().removeAll();
    }

    @Override
    public void installComponents(JFileChooser fc) {
        super.installComponents(fc);
        boolean leftToRight = fc.getComponentOrientation().isLeftToRight();
        fc.setLayout(new BorderLayout());
        fc.setAlignmentX(0.5f);
        JPanel topButtonPanel = new JPanel(new FlowLayout(3, 0, 0));
        topButtonPanel.setBorder(new EmptyBorder(10, 10, 0, 10));
        topButtonPanel.setName("GTKFileChooser.topButtonPanel");
        if (!UIManager.getBoolean("FileChooser.readOnly")) {
            JButton newFolderButton = new JButton(this.getNewFolderAction());
            newFolderButton.setName("GTKFileChooser.newFolderButton");
            newFolderButton.setMnemonic(this.newFolderButtonMnemonic);
            newFolderButton.setToolTipText(this.newFolderButtonToolTipText);
            newFolderButton.setText(this.newFolderButtonText);
            topButtonPanel.add(newFolderButton);
        }
        JButton deleteFileButton = new JButton(this.deleteFileButtonText);
        deleteFileButton.setName("GTKFileChooser.deleteFileButton");
        deleteFileButton.setMnemonic(this.deleteFileButtonMnemonic);
        deleteFileButton.setToolTipText(this.deleteFileButtonToolTipText);
        deleteFileButton.setEnabled(false);
        topButtonPanel.add(deleteFileButton);
        RenameFileAction rfa = new RenameFileAction();
        JButton renameFileButton = new JButton(rfa);
        if (this.readOnly) {
            rfa.setEnabled(false);
        }
        renameFileButton.setText(this.renameFileButtonText);
        renameFileButton.setName("GTKFileChooser.renameFileButton");
        renameFileButton.setMnemonic(this.renameFileButtonMnemonic);
        renameFileButton.setToolTipText(this.renameFileButtonToolTipText);
        topButtonPanel.add(renameFileButton);
        fc.add((Component)topButtonPanel, "North");
        JPanel interior = new JPanel();
        interior.setBorder(new EmptyBorder(0, 10, 10, 10));
        interior.setName("GTKFileChooser.interiorPanel");
        this.align(interior);
        interior.setLayout(new BoxLayout(interior, 3));
        fc.add((Component)interior, "Center");
        JPanel comboBoxPanel = new JPanel(new FlowLayout(1, 0, 0){

            @Override
            public void layoutContainer(Container target) {
                super.layoutContainer(target);
                JComboBox comboBox = GTKFileChooserUI.this.directoryComboBox;
                if (comboBox.getWidth() > target.getWidth()) {
                    comboBox.setBounds(0, comboBox.getY(), target.getWidth(), comboBox.getHeight());
                }
            }
        });
        comboBoxPanel.setBorder(new EmptyBorder(0, 0, 4, 0));
        comboBoxPanel.setName("GTKFileChooser.directoryComboBoxPanel");
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox = new JComboBox(this.directoryComboBoxModel);
        this.directoryComboBox.setName("GTKFileChooser.directoryComboBox");
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setMaximumRowCount(8);
        comboBoxPanel.add(this.directoryComboBox);
        interior.add(comboBoxPanel);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setName("GTKFileChooser.centerPanel");
        JSplitPane splitPanel = new JSplitPane();
        splitPanel.setName("GTKFileChooser.splitPanel");
        splitPanel.setDividerLocation((GTKFileChooserUI.PREF_SIZE.width - 8) / 2);
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.setName("GTKFileChooser.directoryListPanel");
        TableCellRenderer headerRenderer = new JTableHeader().getDefaultRenderer();
        JLabel directoryListLabel = (JLabel)headerRenderer.getTableCellRendererComponent(null, this.foldersLabelText, false, false, 0, 0);
        directoryListLabel.setName("GTKFileChooser.directoryListLabel");
        leftPanel.add((Component)directoryListLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.createDirectoryList(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        directoryListLabel.setDisplayedMnemonic(this.foldersLabelMnemonic);
        directoryListLabel.setLabelFor(this.directoryList);
        this.rightPanel = new JPanel(new GridBagLayout());
        this.rightPanel.setName("GTKFileChooser.fileListPanel");
        headerRenderer = new JTableHeader().getDefaultRenderer();
        JLabel fileListLabel = (JLabel)headerRenderer.getTableCellRendererComponent(null, this.filesLabelText, false, false, 0, 0);
        fileListLabel.setName("GTKFileChooser.fileListLabel");
        this.rightPanel.add((Component)fileListLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.rightPanel.add((Component)this.createFilesList(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        fileListLabel.setDisplayedMnemonic(this.filesLabelMnemonic);
        fileListLabel.setLabelFor(this.fileList);
        splitPanel.add((Component)leftPanel, leftToRight ? "left" : "right");
        splitPanel.add((Component)this.rightPanel, leftToRight ? "right" : "left");
        centerPanel.add((Component)splitPanel, "Center");
        JPanel accessoryPanel = this.getAccessoryPanel();
        JComponent accessory = fc.getAccessory();
        if (accessoryPanel != null) {
            if (accessory == null) {
                accessoryPanel.setPreferredSize(ZERO_ACC_SIZE);
                accessoryPanel.setMaximumSize(ZERO_ACC_SIZE);
            } else {
                this.getAccessoryPanel().add((Component)accessory, "Center");
                accessoryPanel.setPreferredSize(accessory.getPreferredSize());
                accessoryPanel.setMaximumSize(MAX_SIZE);
            }
            this.align(accessoryPanel);
            centerPanel.add((Component)accessoryPanel, "After");
        }
        interior.add(centerPanel);
        interior.add(Box.createRigidArea(vstrut10));
        JPanel pathFieldPanel = new JPanel(new FlowLayout(3, 0, 0));
        pathFieldPanel.setBorder(new EmptyBorder(0, 0, 4, 0));
        JLabel pathFieldLabel = new JLabel(this.pathLabelText);
        pathFieldLabel.setName("GTKFileChooser.pathFieldLabel");
        pathFieldLabel.setDisplayedMnemonic(this.pathLabelMnemonic);
        this.align(pathFieldLabel);
        pathFieldPanel.add(pathFieldLabel);
        pathFieldPanel.add(Box.createRigidArea(hstrut3));
        File currentDirectory = fc.getCurrentDirectory();
        String curDirName = null;
        if (currentDirectory != null) {
            curDirName = currentDirectory.getPath();
        }
        this.pathField = new JLabel(curDirName){

            @Override
            public Dimension getMaximumSize() {
                Dimension d = super.getMaximumSize();
                d.height = this.getPreferredSize().height;
                return d;
            }
        };
        this.pathField.setName("GTKFileChooser.pathField");
        this.align(this.pathField);
        pathFieldPanel.add(this.pathField);
        interior.add(pathFieldPanel);
        this.fileNameTextField = new JTextField(){

            @Override
            public Dimension getMaximumSize() {
                Dimension d = super.getMaximumSize();
                d.height = this.getPreferredSize().height;
                return d;
            }
        };
        pathFieldLabel.setLabelFor(this.fileNameTextField);
        Set<AWTKeyStroke> forwardTraversalKeys = this.fileNameTextField.getFocusTraversalKeys(0);
        forwardTraversalKeys = new HashSet<AWTKeyStroke>(forwardTraversalKeys);
        forwardTraversalKeys.remove(KeyStroke.getKeyStroke(9, 0));
        this.fileNameTextField.setFocusTraversalKeys(0, forwardTraversalKeys);
        this.fileNameTextField.setName("GTKFileChooser.fileNameTextField");
        this.fileNameTextField.getActionMap().put("fileNameCompletionAction", this.getFileNameCompletionAction());
        this.fileNameTextField.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "fileNameCompletionAction");
        interior.add(this.fileNameTextField);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(3, 0, 0));
        panel.setBorder(new EmptyBorder(0, 0, 4, 0));
        JLabel filterLabel = new JLabel(this.filterLabelText);
        filterLabel.setName("GTKFileChooser.filterLabel");
        filterLabel.setDisplayedMnemonic(this.filterLabelMnemonic);
        panel.add(filterLabel);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        fc.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        filterLabel.setLabelFor(this.filterComboBox);
        interior.add(Box.createRigidArea(vstrut10));
        interior.add(panel);
        interior.add(this.filterComboBox);
        this.bottomButtonPanel = new JPanel(new FlowLayout(4));
        this.bottomButtonPanel.setName("GTKFileChooser.bottomButtonPanel");
        this.align(this.bottomButtonPanel);
        JPanel pnButtons = new JPanel(new GridLayout(1, 2, 5, 0));
        JButton cancelButton = this.getCancelButton(fc);
        this.align(cancelButton);
        cancelButton.setMargin(buttonMargin);
        pnButtons.add(cancelButton);
        JButton approveButton = this.getApproveButton(fc);
        this.align(approveButton);
        approveButton.setMargin(buttonMargin);
        pnButtons.add(approveButton);
        this.bottomButtonPanel.add(pnButtons);
        if (fc.getControlButtonsAreShown()) {
            fc.add((Component)this.bottomButtonPanel, "South");
        }
    }

    @Override
    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        this.gtkFCPropertyChangeListener = new GTKFCPropertyChangeListener();
        fc.addPropertyChangeListener(this.gtkFCPropertyChangeListener);
    }

    private int getMnemonic(String key, Locale l) {
        return SwingUtilities2.getUIDefaultsInt((Object)key, l);
    }

    @Override
    protected void uninstallListeners(JFileChooser fc) {
        super.uninstallListeners(fc);
        if (this.gtkFCPropertyChangeListener != null) {
            fc.removePropertyChangeListener(this.gtkFCPropertyChangeListener);
        }
    }

    @Override
    protected void installDefaults(JFileChooser fc) {
        super.installDefaults(fc);
        this.readOnly = UIManager.getBoolean("FileChooser.readOnly");
        this.showDirectoryIcons = Boolean.TRUE.equals(fc.getClientProperty("GTKFileChooser.showDirectoryIcons"));
        this.showFileIcons = Boolean.TRUE.equals(fc.getClientProperty("GTKFileChooser.showFileIcons"));
    }

    @Override
    protected void installIcons(JFileChooser fc) {
        this.directoryIcon = UIManager.getIcon("FileView.directoryIcon");
        this.fileIcon = UIManager.getIcon("FileView.fileIcon");
    }

    @Override
    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        Locale l = fc.getLocale();
        this.newFolderDialogText = UIManager.getString((Object)"FileChooser.newFolderDialogText", l);
        this.newFolderErrorText = UIManager.getString((Object)"FileChooser.newFolderErrorText", l);
        this.newFolderErrorSeparator = UIManager.getString((Object)"FileChooser.newFolderErrorSeparator", l);
        this.newFolderButtonText = UIManager.getString((Object)"FileChooser.newFolderButtonText", l);
        this.newFolderNoDirectoryErrorTitleText = UIManager.getString((Object)"FileChooser.newFolderNoDirectoryErrorTitleText", l);
        this.newFolderNoDirectoryErrorText = UIManager.getString((Object)"FileChooser.newFolderNoDirectoryErrorText", l);
        this.deleteFileButtonText = UIManager.getString((Object)"FileChooser.deleteFileButtonText", l);
        this.renameFileButtonText = UIManager.getString((Object)"FileChooser.renameFileButtonText", l);
        this.newFolderButtonMnemonic = this.getMnemonic("FileChooser.newFolderButtonMnemonic", l);
        this.deleteFileButtonMnemonic = this.getMnemonic("FileChooser.deleteFileButtonMnemonic", l);
        this.renameFileButtonMnemonic = this.getMnemonic("FileChooser.renameFileButtonMnemonic", l);
        this.newFolderButtonToolTipText = UIManager.getString((Object)"FileChooser.newFolderButtonToolTipText", l);
        this.deleteFileButtonToolTipText = UIManager.getString((Object)"FileChooser.deleteFileButtonToolTipText", l);
        this.renameFileButtonToolTipText = UIManager.getString((Object)"FileChooser.renameFileButtonToolTipText", l);
        this.renameFileDialogText = UIManager.getString((Object)"FileChooser.renameFileDialogText", l);
        this.renameFileErrorTitle = UIManager.getString((Object)"FileChooser.renameFileErrorTitle", l);
        this.renameFileErrorText = UIManager.getString((Object)"FileChooser.renameFileErrorText", l);
        this.foldersLabelText = UIManager.getString((Object)"FileChooser.foldersLabelText", l);
        this.foldersLabelMnemonic = this.getMnemonic("FileChooser.foldersLabelMnemonic", l);
        this.filesLabelText = UIManager.getString((Object)"FileChooser.filesLabelText", l);
        this.filesLabelMnemonic = this.getMnemonic("FileChooser.filesLabelMnemonic", l);
        this.pathLabelText = UIManager.getString((Object)"FileChooser.pathLabelText", l);
        this.pathLabelMnemonic = this.getMnemonic("FileChooser.pathLabelMnemonic", l);
        this.filterLabelText = UIManager.getString((Object)"FileChooser.filterLabelText", l);
        this.filterLabelMnemonic = UIManager.getInt("FileChooser.filterLabelMnemonic");
    }

    @Override
    protected void uninstallStrings(JFileChooser fc) {
        super.uninstallStrings(fc);
        this.newFolderButtonText = null;
        this.deleteFileButtonText = null;
        this.renameFileButtonText = null;
        this.newFolderButtonToolTipText = null;
        this.deleteFileButtonToolTipText = null;
        this.renameFileButtonToolTipText = null;
        this.renameFileDialogText = null;
        this.renameFileErrorTitle = null;
        this.renameFileErrorText = null;
        this.foldersLabelText = null;
        this.filesLabelText = null;
        this.pathLabelText = null;
        this.newFolderDialogText = null;
        this.newFolderErrorText = null;
        this.newFolderErrorSeparator = null;
    }

    protected JScrollPane createFilesList() {
        this.fileList = new JList();
        this.fileList.setName("GTKFileChooser.fileList");
        this.fileList.putClientProperty("AccessibleName", this.filesLabelText);
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.fileList.setSelectionMode(2);
        } else {
            this.fileList.setSelectionMode(0);
        }
        this.fileList.setModel(new GTKFileListModel());
        this.fileList.getSelectionModel().removeSelectionInterval(0, 0);
        this.fileList.setCellRenderer(new FileCellRenderer());
        this.fileList.addListSelectionListener(this.createListSelectionListener(this.getFileChooser()));
        this.fileList.addMouseListener(this.createDoubleClickListener(this.getFileChooser(), this.fileList));
        this.align(this.fileList);
        JScrollPane scrollpane = new JScrollPane(this.fileList);
        scrollpane.setVerticalScrollBarPolicy(22);
        scrollpane.setName("GTKFileChooser.fileListScrollPane");
        scrollpane.setPreferredSize(prefListSize);
        scrollpane.setMaximumSize(MAX_SIZE);
        this.align(scrollpane);
        return scrollpane;
    }

    protected JScrollPane createDirectoryList() {
        this.directoryList = new JList();
        this.directoryList.setName("GTKFileChooser.directoryList");
        this.directoryList.putClientProperty("AccessibleName", this.foldersLabelText);
        this.align(this.directoryList);
        this.directoryList.setCellRenderer(new DirectoryCellRenderer());
        this.directoryListModel = new GTKDirectoryListModel();
        this.directoryList.getSelectionModel().removeSelectionInterval(0, 0);
        this.directoryList.setModel(this.directoryListModel);
        this.directoryList.addMouseListener(this.createDoubleClickListener(this.getFileChooser(), this.directoryList));
        this.directoryList.addListSelectionListener(this.createListSelectionListener(this.getFileChooser()));
        JScrollPane scrollpane = new JScrollPane(this.directoryList);
        scrollpane.setVerticalScrollBarPolicy(22);
        scrollpane.setName("GTKFileChooser.directoryListScrollPane");
        scrollpane.setMaximumSize(MAX_SIZE);
        scrollpane.setPreferredSize(prefListSize);
        this.align(scrollpane);
        return scrollpane;
    }

    @Override
    protected void createModel() {
        this.model = new GTKDirectoryModel();
    }

    @Override
    public BasicDirectoryModel getModel() {
        return this.model;
    }

    @Override
    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d;
        Dimension prefSize = new Dimension(PREF_SIZE);
        JComponent accessory = this.getFileChooser().getAccessory();
        if (accessory != null) {
            prefSize.width += accessory.getPreferredSize().width + 20;
        }
        if ((d = c.getLayout().preferredLayoutSize(c)) != null) {
            return new Dimension(d.width < prefSize.width ? prefSize.width : d.width, d.height < prefSize.height ? prefSize.height : d.height);
        }
        return prefSize;
    }

    @Override
    public Dimension getMinimumSize(JComponent x) {
        return new Dimension(MIN_SIZE);
    }

    @Override
    public Dimension getMaximumSize(JComponent x) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void align(JComponent c) {
        c.setAlignmentX(0.0f);
        c.setAlignmentY(0.0f);
    }

    @Override
    public Action getNewFolderAction() {
        if (this.newFolderAction == null) {
            this.newFolderAction = new NewFolderAction();
            this.newFolderAction.setEnabled(!this.readOnly);
        }
        return this.newFolderAction;
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    static /* synthetic */ void access$500(GTKFileChooserUI x0, boolean x1) {
        x0.setDirectorySelected(x1);
    }

    static /* synthetic */ void access$600(GTKFileChooserUI x0, File x1) {
        x0.setDirectory(x1);
    }

    static /* synthetic */ void access$700(GTKFileChooserUI x0, boolean x1) {
        x0.setDirectorySelected(x1);
    }

    static /* synthetic */ void access$800(GTKFileChooserUI x0, boolean x1) {
        x0.setDirectorySelected(x1);
    }

    static /* synthetic */ void access$900(GTKFileChooserUI x0, File x1) {
        x0.setDirectory(x1);
    }

    static /* synthetic */ void access$1000(GTKFileChooserUI x0, boolean x1) {
        x0.setDirectorySelected(x1);
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = GTKFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public void setSelectedItem(Object filter) {
            if (filter != null) {
                GTKFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            FileFilter currentFilter = GTKFileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (FileFilter filter : this.filters) {
                    if (filter != currentFilter) continue;
                    found = true;
                }
                if (!found) {
                    GTKFileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return GTKFileChooserUI.this.getFileChooser().getFileFilter();
        }

        @Override
        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        @Override
        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return GTKFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer
    implements UIResource {
        @Override
        public String getName() {
            String name = super.getName();
            if (name == null) {
                return "ComboBox.renderer";
            }
            return name;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setName("ComboBox.listRenderer");
            if (value != null) {
                if (value instanceof FileFilter) {
                    this.setText(((FileFilter)value).getDescription());
                }
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private class RenameFileAction
    extends AbstractAction {
        protected RenameFileAction() {
            super("editFileName");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GTKFileChooserUI.this.getFileName().equals("")) {
                return;
            }
            JFileChooser fc = GTKFileChooserUI.this.getFileChooser();
            File currentDirectory = fc.getCurrentDirectory();
            String newFileName = (String)JOptionPane.showInputDialog(fc, new MessageFormat(GTKFileChooserUI.this.renameFileDialogText).format(new Object[]{GTKFileChooserUI.this.getFileName()}), GTKFileChooserUI.this.renameFileButtonText, -1, null, null, GTKFileChooserUI.this.getFileName());
            if (newFileName != null) {
                File oldFile = fc.getFileSystemView().createFileObject(currentDirectory, GTKFileChooserUI.this.getFileName());
                File newFile = fc.getFileSystemView().createFileObject(currentDirectory, newFileName);
                if (oldFile == null || newFile == null || !GTKFileChooserUI.this.getModel().renameFile(oldFile, newFile)) {
                    JOptionPane.showMessageDialog(fc, new MessageFormat(GTKFileChooserUI.this.renameFileErrorText).format(new Object[]{GTKFileChooserUI.this.getFileName(), newFileName}), GTKFileChooserUI.this.renameFileErrorTitle, 0);
                } else {
                    GTKFileChooserUI.this.setFileName(GTKFileChooserUI.this.getFileChooser().getName(newFile));
                    fc.rescanCurrentDirectory();
                }
            }
        }
    }

    private class GTKApproveSelectionAction
    extends BasicFileChooserUI.ApproveSelectionAction {
        private GTKApproveSelectionAction() {
            super(GTKFileChooserUI.this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GTKFileChooserUI.this.isDirectorySelected()) {
                File dir = GTKFileChooserUI.this.getDirectory();
                try {
                    if (dir != null) {
                        dir = ShellFolder.getNormalizedFile(dir);
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (GTKFileChooserUI.this.getFileChooser().getCurrentDirectory().equals(dir)) {
                    GTKFileChooserUI.this.directoryList.clearSelection();
                    GTKFileChooserUI.this.fileList.clearSelection();
                    ListSelectionModel sm = GTKFileChooserUI.this.fileList.getSelectionModel();
                    if (sm instanceof DefaultListSelectionModel) {
                        ((DefaultListSelectionModel)sm).moveLeadSelectionIndex(0);
                        sm.setAnchorSelectionIndex(0);
                    }
                    GTKFileChooserUI.this.rescanCurrentDirectory(GTKFileChooserUI.this.getFileChooser());
                    return;
                }
            }
            super.actionPerformed(e);
        }
    }

    private class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GTKFileChooserUI.this.readOnly) {
                return;
            }
            JFileChooser fc = GTKFileChooserUI.this.getFileChooser();
            File currentDirectory = fc.getCurrentDirectory();
            String dirName = JOptionPane.showInputDialog(fc, GTKFileChooserUI.this.newFolderDialogText, GTKFileChooserUI.this.newFolderButtonText, -1);
            if (dirName != null) {
                if (!currentDirectory.exists()) {
                    JOptionPane.showMessageDialog(fc, MessageFormat.format(GTKFileChooserUI.this.newFolderNoDirectoryErrorText, dirName), GTKFileChooserUI.this.newFolderNoDirectoryErrorTitleText, 0);
                    return;
                }
                File newDir = fc.getFileSystemView().createFileObject(currentDirectory, dirName);
                if (newDir == null || !newDir.mkdir()) {
                    JOptionPane.showMessageDialog(fc, GTKFileChooserUI.this.newFolderErrorText + GTKFileChooserUI.this.newFolderErrorSeparator + " \"" + dirName + "\"", GTKFileChooserUI.this.newFolderErrorText, 0);
                }
                fc.rescanCurrentDirectory();
            }
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f = (File)GTKFileChooserUI.this.directoryComboBox.getSelectedItem();
            GTKFileChooserUI.this.getFileChooser().setCurrentDirectory(f);
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector<File> directories = new Vector();
        File selectedDirectory = null;
        JFileChooser chooser = GTKFileChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File dir = GTKFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
        }

        private void addItem(File directory) {
            File canonical;
            if (directory == null) {
                return;
            }
            int oldSize = this.directories.size();
            this.directories.clear();
            if (oldSize > 0) {
                this.fireIntervalRemoved(this, 0, oldSize);
            }
            try {
                canonical = this.fsv.createFileObject(ShellFolder.getNormalizedFile(directory).getPath());
            }
            catch (IOException e) {
                canonical = directory;
            }
            File f = canonical;
            do {
                this.directories.add(f);
            } while ((f = f.getParentFile()) != null);
            int newSize = this.directories.size();
            if (newSize > 0) {
                this.fireIntervalAdded(this, 0, newSize);
            }
            this.setSelectedItem(canonical);
        }

        @Override
        public void setSelectedItem(Object selectedDirectory) {
            this.selectedDirectory = (File)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        @Override
        public int getSize() {
            return this.directories.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }
    }

    protected class DirectoryCellRenderer
    extends DefaultListCellRenderer {
        protected DirectoryCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (GTKFileChooserUI.this.showDirectoryIcons) {
                this.setIcon(GTKFileChooserUI.this.getFileChooser().getIcon((File)value));
                this.setText(GTKFileChooserUI.this.getFileChooser().getName((File)value));
            } else {
                this.setText(GTKFileChooserUI.this.getFileChooser().getName((File)value) + "/");
            }
            return this;
        }
    }

    protected class FileCellRenderer
    extends DefaultListCellRenderer {
        protected FileCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText(GTKFileChooserUI.this.getFileChooser().getName((File)value));
            if (GTKFileChooserUI.this.showFileIcons) {
                this.setIcon(GTKFileChooserUI.this.getFileChooser().getIcon((File)value));
            }
            return this;
        }
    }

    protected class GTKFileListModel
    extends AbstractListModel
    implements ListDataListener {
        public GTKFileListModel() {
            GTKFileChooserUI.this.getModel().addListDataListener(this);
        }

        @Override
        public int getSize() {
            return GTKFileChooserUI.this.getModel().getFiles().size();
        }

        public boolean contains(Object o) {
            return GTKFileChooserUI.this.getModel().getFiles().contains(o);
        }

        public int indexOf(Object o) {
            return GTKFileChooserUI.this.getModel().getFiles().indexOf(o);
        }

        @Override
        public Object getElementAt(int index) {
            return GTKFileChooserUI.this.getModel().getFiles().elementAt(index);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.fireIntervalAdded(this, e.getIndex0(), e.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.fireIntervalRemoved(this, e.getIndex0(), e.getIndex1());
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, 0, GTKFileChooserUI.this.getModel().getFiles().size() - 1);
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.fireContentsChanged();
        }
    }

    protected class GTKDirectoryListModel
    extends AbstractListModel
    implements ListDataListener {
        File curDir;

        public GTKDirectoryListModel() {
            GTKFileChooserUI.this.getModel().addListDataListener(this);
            this.directoryChanged();
        }

        @Override
        public int getSize() {
            return GTKFileChooserUI.this.getModel().getDirectories().size() + 1;
        }

        @Override
        public Object getElementAt(int index) {
            return index > 0 ? GTKFileChooserUI.this.getModel().getDirectories().elementAt(index - 1) : this.curDir;
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.fireIntervalAdded(this, e.getIndex0(), e.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.fireIntervalRemoved(this, e.getIndex0(), e.getIndex1());
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, 0, GTKFileChooserUI.this.getModel().getDirectories().size() - 1);
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.fireContentsChanged();
        }

        private void directoryChanged() {
            this.curDir = GTKFileChooserUI.this.getFileChooser().getFileSystemView().createFileObject(GTKFileChooserUI.this.getFileChooser().getCurrentDirectory(), ".");
        }
    }

    private class GTKDirectoryModel
    extends BasicDirectoryModel {
        FileSystemView fsv;
        private Comparator<File> fileComparator;

        public GTKDirectoryModel() {
            super(GTKFileChooserUI.this.getFileChooser());
            this.fileComparator = new Comparator<File>(){

                @Override
                public int compare(File o, File o1) {
                    return GTKDirectoryModel.this.fsv.getSystemDisplayName(o).compareTo(GTKDirectoryModel.this.fsv.getSystemDisplayName(o1));
                }
            };
        }

        @Override
        protected void sort(Vector<? extends File> v) {
            this.fsv = GTKFileChooserUI.this.getFileChooser().getFileSystemView();
            Collections.sort(v, this.fileComparator);
        }
    }

    private class GTKFCPropertyChangeListener
    implements PropertyChangeListener {
        private GTKFCPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("GTKFileChooser.showDirectoryIcons")) {
                GTKFileChooserUI.this.showDirectoryIcons = Boolean.TRUE.equals(e.getNewValue());
            } else if (prop.equals("GTKFileChooser.showFileIcons")) {
                GTKFileChooserUI.this.showFileIcons = Boolean.TRUE.equals(e.getNewValue());
            }
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        protected SelectionListener() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void valueChanged(ListSelectionEvent e) {
            block7: {
                block8: {
                    block9: {
                        if (e.getValueIsAdjusting()) break block7;
                        chooser = GTKFileChooserUI.this.getFileChooser();
                        list = (JList)e.getSource();
                        if (!chooser.isMultiSelectionEnabled()) break block8;
                        files = null;
                        objects = list.getSelectedValues();
                        if (objects == null) break block9;
                        if (objects.length != 1 || !((File)objects[0]).isDirectory() || !chooser.isTraversable((File)objects[0])) ** GOTO lbl-1000
                        if (chooser.getFileSelectionMode() != 1 || !chooser.getFileSystemView().isFileSystem((File)objects[0])) {
                            GTKFileChooserUI.access$500(GTKFileChooserUI.this, true);
                            GTKFileChooserUI.access$600(GTKFileChooserUI.this, (File)objects[0]);
                        } else lbl-1000:
                        // 2 sources

                        {
                            fList = new ArrayList<File>(objects.length);
                            for (Object object : objects) {
                                f = (File)object;
                                if ((!chooser.isFileSelectionEnabled() || !f.isFile()) && (!chooser.isDirectorySelectionEnabled() || !f.isDirectory())) continue;
                                fList.add(f);
                            }
                            if (fList.size() > 0) {
                                files = fList.toArray(new File[fList.size()]);
                            }
                            GTKFileChooserUI.access$700(GTKFileChooserUI.this, false);
                        }
                    }
                    chooser.setSelectedFiles(files);
                    break block7;
                }
                file = (File)list.getSelectedValue();
                if (file == null || !file.isDirectory() || !chooser.isTraversable(file)) ** GOTO lbl-1000
                if (chooser.getFileSelectionMode() == 0 || !chooser.getFileSystemView().isFileSystem(file)) {
                    GTKFileChooserUI.access$800(GTKFileChooserUI.this, true);
                    GTKFileChooserUI.access$900(GTKFileChooserUI.this, file);
                } else lbl-1000:
                // 2 sources

                {
                    GTKFileChooserUI.access$1000(GTKFileChooserUI.this, false);
                    if (file != null) {
                        chooser.setSelectedFile(file);
                    }
                }
            }
        }
    }

    class DoubleClickListener
    extends MouseAdapter {
        JList list;

        public DoubleClickListener(JList list) {
            this.list = list;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int index;
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (index = this.list.locationToIndex(e.getPoint())) >= 0) {
                File f = (File)this.list.getModel().getElementAt(index);
                try {
                    f = ShellFolder.getNormalizedFile(f);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (GTKFileChooserUI.this.getFileChooser().isTraversable(f)) {
                    this.list.clearSelection();
                    if (GTKFileChooserUI.this.getFileChooser().getCurrentDirectory().equals(f)) {
                        GTKFileChooserUI.this.rescanCurrentDirectory(GTKFileChooserUI.this.getFileChooser());
                    } else {
                        GTKFileChooserUI.this.getFileChooser().setCurrentDirectory(f);
                    }
                } else {
                    GTKFileChooserUI.this.getFileChooser().approveSelection();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            if (this.list != null) {
                TransferHandler th2;
                TransferHandler th1 = GTKFileChooserUI.this.getFileChooser().getTransferHandler();
                if (th1 != (th2 = this.list.getTransferHandler())) {
                    this.list.setTransferHandler(th1);
                }
                if (GTKFileChooserUI.this.getFileChooser().getDragEnabled() != this.list.getDragEnabled()) {
                    this.list.setDragEnabled(GTKFileChooserUI.this.getFileChooser().getDragEnabled());
                }
            }
        }
    }

    private class GTKFileView
    extends BasicFileChooserUI.BasicFileView {
        public GTKFileView() {
            super(GTKFileChooserUI.this);
            this.iconCache = null;
        }

        @Override
        public void clearIconCache() {
        }

        @Override
        public Icon getCachedIcon(File f) {
            return null;
        }

        @Override
        public void cacheIcon(File f, Icon i) {
        }

        @Override
        public Icon getIcon(File f) {
            return f != null && f.isDirectory() ? GTKFileChooserUI.this.directoryIcon : GTKFileChooserUI.this.fileIcon;
        }
    }
}

