/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.LabeledComponent;
import sun.tools.jconsole.Messages;
import sun.tools.jconsole.OverviewPanel;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.PlotterPanel;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.TimeComboBox;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.VMPanel;
import sun.tools.jconsole.VariableGridLayout;

class ThreadTab
extends Tab
implements ActionListener,
DocumentListener,
ListSelectionListener {
    PlotterPanel threadMeter;
    TimeComboBox timeComboBox;
    JTabbedPane threadListTabbedPane;
    DefaultListModel<Long> listModel;
    JTextField filterTF;
    JLabel messageLabel;
    JSplitPane threadsSplitPane;
    HashMap<Long, String> nameCache = new HashMap();
    private ThreadOverviewPanel overviewPanel;
    private boolean plotterListening = false;
    private static final String threadCountKey = "threadCount";
    private static final String peakKey = "peak";
    private static final Color threadCountColor = Plotter.defaultColor;
    private static final Color peakColor = Color.red;
    private static final Border thinEmptyBorder = new EmptyBorder(2, 2, 2, 2);
    private long[] oldThreads = new long[0];
    long lastSelected = -1L;

    public static String getTabName() {
        return Messages.THREADS;
    }

    public ThreadTab(VMPanel vmPanel) {
        super(vmPanel, ThreadTab.getTabName());
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(new EmptyBorder(4, 4, 3, 4));
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel plotterPanel = new JPanel(new VariableGridLayout(0, 1, 4, 4, true, true));
        this.add((Component)topPanel, "North");
        this.add((Component)plotterPanel, "Center");
        JPanel controlPanel = new JPanel(new FlowLayout(1, 20, 5));
        topPanel.add((Component)controlPanel, "Center");
        this.threadMeter = new PlotterPanel(Messages.NUMBER_OF_THREADS, Plotter.Unit.NONE, true);
        this.threadMeter.plotter.createSequence(threadCountKey, Messages.LIVE_THREADS, threadCountColor, true);
        this.threadMeter.plotter.createSequence(peakKey, Messages.PEAK, peakColor, true);
        Utilities.setAccessibleName(this.threadMeter.plotter, Messages.THREAD_TAB_THREAD_PLOTTER_ACCESSIBLE_NAME);
        plotterPanel.add(this.threadMeter);
        this.timeComboBox = new TimeComboBox(this.threadMeter.plotter);
        controlPanel.add(new LabeledComponent(Messages.TIME_RANGE_COLON, Resources.getMnemonicInt(Messages.TIME_RANGE_COLON), this.timeComboBox));
        this.listModel = new DefaultListModel();
        JTextArea textArea = new JTextArea();
        textArea.setBorder(thinEmptyBorder);
        textArea.setEditable(false);
        Utilities.setAccessibleName(textArea, Messages.THREAD_TAB_THREAD_INFO_ACCESSIBLE_NAME);
        ThreadJList list = new ThreadJList(this.listModel, textArea);
        Dimension di = new Dimension(super.getPreferredSize());
        di.width = Math.min(di.width, 200);
        JScrollPane threadlistSP = new JScrollPane(list);
        threadlistSP.setPreferredSize(di);
        threadlistSP.setBorder(null);
        JScrollPane textAreaSP = new JScrollPane(textArea);
        textAreaSP.setBorder(null);
        this.threadListTabbedPane = new JTabbedPane(1);
        this.threadsSplitPane = new JSplitPane(1, threadlistSP, textAreaSP);
        this.threadsSplitPane.setOneTouchExpandable(true);
        this.threadsSplitPane.setBorder(null);
        JPanel firstTabPanel = new JPanel(new BorderLayout());
        firstTabPanel.setOpaque(false);
        JPanel firstTabToolPanel = new JPanel(new FlowLayout(0, 5, 2));
        firstTabToolPanel.setOpaque(false);
        this.filterTF = new PromptingTextField("Filter", 20);
        this.filterTF.getDocument().addDocumentListener(this);
        firstTabToolPanel.add(this.filterTF);
        JSeparator separator = new JSeparator(1);
        separator.setPreferredSize(new Dimension(separator.getPreferredSize().width, this.filterTF.getPreferredSize().height));
        firstTabToolPanel.add(separator);
        JButton detectDeadlockButton = new JButton(Messages.DETECT_DEADLOCK);
        detectDeadlockButton.setMnemonic(Resources.getMnemonicInt(Messages.DETECT_DEADLOCK));
        detectDeadlockButton.setActionCommand("detectDeadlock");
        detectDeadlockButton.addActionListener(this);
        detectDeadlockButton.setToolTipText(Messages.DETECT_DEADLOCK_TOOLTIP);
        firstTabToolPanel.add(detectDeadlockButton);
        this.messageLabel = new JLabel();
        firstTabToolPanel.add(this.messageLabel);
        firstTabPanel.add((Component)this.threadsSplitPane, "Center");
        firstTabPanel.add((Component)firstTabToolPanel, "South");
        this.threadListTabbedPane.addTab(Messages.THREADS, firstTabPanel);
        plotterPanel.add(this.threadListTabbedPane);
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        final ProxyClient proxyClient = this.vmPanel.getProxyClient();
        if (!this.plotterListening) {
            proxyClient.addWeakPropertyChangeListener(this.threadMeter.plotter);
            this.plotterListening = true;
        }
        return new SwingWorker<Boolean, Object>(){
            private int tlCount;
            private int tpCount;
            private long ttCount;
            private long[] threads;
            private long timeStamp;

            @Override
            public Boolean doInBackground() {
                try {
                    ThreadMXBean threadMBean = proxyClient.getThreadMXBean();
                    this.tlCount = threadMBean.getThreadCount();
                    this.tpCount = threadMBean.getPeakThreadCount();
                    this.ttCount = ThreadTab.this.overviewPanel != null ? threadMBean.getTotalStartedThreadCount() : 0L;
                    for (long newThread : this.threads = threadMBean.getAllThreadIds()) {
                        String name;
                        ThreadInfo ti;
                        if (ThreadTab.this.nameCache.get(newThread) != null || (ti = threadMBean.getThreadInfo(newThread)) == null || (name = ti.getThreadName()) == null) continue;
                        ThreadTab.this.nameCache.put(newThread, name);
                    }
                    this.timeStamp = System.currentTimeMillis();
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
                catch (UndeclaredThrowableException e) {
                    return false;
                }
            }

            @Override
            protected void done() {
                String filter;
                try {
                    if (!((Boolean)this.get()).booleanValue()) {
                        return;
                    }
                }
                catch (InterruptedException ex) {
                    return;
                }
                catch (ExecutionException ex) {
                    if (JConsole.isDebug()) {
                        ex.printStackTrace();
                    }
                    return;
                }
                ThreadTab.this.threadMeter.plotter.addValues(this.timeStamp, this.tlCount, this.tpCount);
                ThreadTab.this.threadMeter.setValueLabel(this.tlCount + "");
                if (ThreadTab.this.overviewPanel != null) {
                    ThreadTab.this.overviewPanel.updateThreadsInfo(this.tlCount, this.tpCount, this.ttCount, this.timeStamp);
                }
                boolean doFilter = (filter = ThreadTab.this.filterTF.getText().toLowerCase(Locale.ENGLISH)).length() > 0;
                ArrayList<Long> l = new ArrayList<Long>();
                for (long t : this.threads) {
                    l.add(t);
                }
                Iterator iterator = l.iterator();
                while (iterator.hasNext()) {
                    long newThread = (Long)iterator.next();
                    String name = ThreadTab.this.nameCache.get(newThread);
                    if (!doFilter || name == null || name.toLowerCase(Locale.ENGLISH).indexOf(filter) >= 0) continue;
                    iterator.remove();
                }
                long[] newThreads = this.threads;
                if (l.size() < this.threads.length) {
                    newThreads = new long[l.size()];
                    for (int i = 0; i < newThreads.length; ++i) {
                        newThreads[i] = (Long)l.get(i);
                    }
                }
                for (long oldThread : ThreadTab.this.oldThreads) {
                    boolean found = false;
                    for (long newThread : newThreads) {
                        if (newThread != oldThread) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    ThreadTab.this.listModel.removeElement(oldThread);
                    if (doFilter) continue;
                    ThreadTab.this.nameCache.remove(oldThread);
                }
                for (int i = newThreads.length - 1; i >= 0; --i) {
                    long newThread = newThreads[i];
                    boolean found = false;
                    for (long oldThread : ThreadTab.this.oldThreads) {
                        if (newThread != oldThread) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    ThreadTab.this.listModel.addElement(newThread);
                }
                ThreadTab.access$202(ThreadTab.this, newThreads);
            }
        };
    }

    @Override
    public void valueChanged(ListSelectionEvent ev) {
        ThreadJList list = (ThreadJList)ev.getSource();
        final JTextArea textArea = list.textArea;
        Long selected = (Long)list.getSelectedValue();
        if (selected == null) {
            if (this.lastSelected != -1L) {
                selected = this.lastSelected;
            }
        } else {
            this.lastSelected = selected;
        }
        textArea.setText("");
        if (selected != null) {
            final long threadID = selected;
            this.workerAdd(new Runnable(){

                @Override
                public void run() {
                    ProxyClient proxyClient = ThreadTab.this.vmPanel.getProxyClient();
                    StringBuilder sb = new StringBuilder();
                    try {
                        ThreadMXBean threadMBean = proxyClient.getThreadMXBean();
                        ThreadInfo ti = null;
                        MonitorInfo[] monitors = null;
                        if (proxyClient.isLockUsageSupported() && threadMBean.isObjectMonitorUsageSupported()) {
                            ThreadInfo[] infos = threadMBean.dumpAllThreads(true, false);
                            for (ThreadInfo info : infos) {
                                if (info.getThreadId() != threadID) continue;
                                ti = info;
                                monitors = info.getLockedMonitors();
                                break;
                            }
                        } else {
                            ti = threadMBean.getThreadInfo(threadID, Integer.MAX_VALUE);
                        }
                        if (ti != null) {
                            if (ti.getLockName() == null) {
                                sb.append(Resources.format(Messages.NAME_STATE, ti.getThreadName(), ti.getThreadState().toString()));
                            } else if (ti.getLockOwnerName() == null) {
                                sb.append(Resources.format(Messages.NAME_STATE_LOCK_NAME, ti.getThreadName(), ti.getThreadState().toString(), ti.getLockName()));
                            } else {
                                sb.append(Resources.format(Messages.NAME_STATE_LOCK_NAME_LOCK_OWNER, ti.getThreadName(), ti.getThreadState().toString(), ti.getLockName(), ti.getLockOwnerName()));
                            }
                            sb.append(Resources.format(Messages.BLOCKED_COUNT_WAITED_COUNT, ti.getBlockedCount(), ti.getWaitedCount()));
                            sb.append(Messages.STACK_TRACE);
                            int index = 0;
                            for (StackTraceElement e : ti.getStackTrace()) {
                                sb.append(e.toString() + "\n");
                                if (monitors != null) {
                                    for (MonitorInfo mi : monitors) {
                                        if (mi.getLockedStackDepth() != index) continue;
                                        sb.append(Resources.format(Messages.MONITOR_LOCKED, mi.toString()));
                                    }
                                }
                                ++index;
                            }
                        }
                    }
                    catch (IOException ex) {
                    }
                    catch (UndeclaredThrowableException e) {
                        proxyClient.markAsDead();
                    }
                    final String text = sb.toString();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            textArea.setText(text);
                            textArea.setCaretPosition(0);
                        }
                    });
                }
            });
        }
    }

    private void doUpdate() {
        this.workerAdd(new Runnable(){

            @Override
            public void run() {
                ThreadTab.this.update();
            }
        });
    }

    private void detectDeadlock() {
        this.workerAdd(new Runnable(){

            @Override
            public void run() {
                try {
                    final Long[][] deadlockedThreads = ThreadTab.this.getDeadlockedThreadIds();
                    if (deadlockedThreads == null || deadlockedThreads.length == 0) {
                        new Thread(){

                            @Override
                            public void run() {
                                try {
                                    SwingUtilities.invokeAndWait(new Runnable(){

                                        @Override
                                        public void run() {
                                            String msg = Messages.NO_DEADLOCK_DETECTED;
                                            ThreadTab.this.messageLabel.setText(msg);
                                            ThreadTab.this.threadListTabbedPane.revalidate();
                                        }
                                    });
                                    1.sleep(30000L);
                                }
                                catch (InterruptedException ex) {
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    // empty catch block
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ThreadTab.this.messageLabel.setText("");
                                    }
                                });
                            }
                        }.start();
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            while (ThreadTab.this.threadListTabbedPane.getTabCount() > 1) {
                                ThreadTab.this.threadListTabbedPane.removeTabAt(1);
                            }
                            if (deadlockedThreads != null) {
                                for (int i = 0; i < deadlockedThreads.length; ++i) {
                                    DefaultListModel<Long> listModel = new DefaultListModel<Long>();
                                    JTextArea textArea = new JTextArea();
                                    textArea.setBorder(thinEmptyBorder);
                                    textArea.setEditable(false);
                                    Utilities.setAccessibleName(textArea, Messages.THREAD_TAB_THREAD_INFO_ACCESSIBLE_NAME);
                                    ThreadJList list = new ThreadJList(listModel, textArea);
                                    JScrollPane threadlistSP = new JScrollPane(list);
                                    JScrollPane textAreaSP = new JScrollPane(textArea);
                                    threadlistSP.setBorder(null);
                                    textAreaSP.setBorder(null);
                                    JSplitPane splitPane = new JSplitPane(1, threadlistSP, textAreaSP);
                                    splitPane.setOneTouchExpandable(true);
                                    splitPane.setBorder(null);
                                    splitPane.setDividerLocation(ThreadTab.this.threadsSplitPane.getDividerLocation());
                                    String tabName = deadlockedThreads.length > 1 ? Resources.format(Messages.DEADLOCK_TAB_N, i + 1) : Messages.DEADLOCK_TAB;
                                    ThreadTab.this.threadListTabbedPane.addTab(tabName, splitPane);
                                    Long[] arr$ = deadlockedThreads[i];
                                    int len$ = arr$.length;
                                    for (int i$ = 0; i$ < len$; ++i$) {
                                        long t = arr$[i$];
                                        listModel.addElement(t);
                                    }
                                }
                                ThreadTab.this.threadListTabbedPane.setSelectedIndex(1);
                            }
                        }
                    });
                }
                catch (IOException e) {
                }
                catch (UndeclaredThrowableException e) {
                    ThreadTab.this.vmPanel.getProxyClient().markAsDead();
                }
            }
        });
    }

    public Long[][] getDeadlockedThreadIds() throws IOException {
        ProxyClient proxyClient = this.vmPanel.getProxyClient();
        ThreadMXBean threadMBean = proxyClient.getThreadMXBean();
        long[] ids = proxyClient.findDeadlockedThreads();
        if (ids == null) {
            return null;
        }
        ThreadInfo[] infos = threadMBean.getThreadInfo(ids, Integer.MAX_VALUE);
        ArrayList<Long[]> dcycles = new ArrayList<Long[]>();
        ArrayList<Long> cycle = new ArrayList<Long>();
        boolean[] visited = new boolean[ids.length];
        int deadlockedThread = -1;
        block0: while (true) {
            if (deadlockedThread < 0) {
                if (cycle.size() > 0) {
                    dcycles.add(cycle.toArray(new Long[0]));
                    cycle = new ArrayList();
                }
                for (int j = 0; j < ids.length; ++j) {
                    if (visited[j]) continue;
                    deadlockedThread = j;
                    visited[j] = true;
                    break;
                }
                if (deadlockedThread < 0) break;
            }
            cycle.add(ids[deadlockedThread]);
            long nextThreadId = infos[deadlockedThread].getLockOwnerId();
            int j = 0;
            while (true) {
                if (j >= ids.length) continue block0;
                ThreadInfo ti = infos[j];
                if (ti.getThreadId() == nextThreadId) {
                    if (visited[j]) {
                        deadlockedThread = -1;
                        continue block0;
                    }
                    deadlockedThread = j;
                    visited[j] = true;
                    continue block0;
                }
                ++j;
            }
            break;
        }
        return (Long[][])dcycles.toArray((T[])new Long[0][0]);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = ((AbstractButton)evt.getSource()).getActionCommand();
        if (cmd == "detectDeadlock") {
            this.messageLabel.setText("");
            this.detectDeadlock();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.doUpdate();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.doUpdate();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.doUpdate();
    }

    @Override
    OverviewPanel[] getOverviewPanels() {
        if (this.overviewPanel == null) {
            this.overviewPanel = new ThreadOverviewPanel();
        }
        return new OverviewPanel[]{this.overviewPanel};
    }

    static /* synthetic */ long[] access$202(ThreadTab x0, long[] x1) {
        x0.oldThreads = x1;
        return x1;
    }

    private static class ThreadOverviewPanel
    extends OverviewPanel {
        ThreadOverviewPanel() {
            super(Messages.THREADS, ThreadTab.threadCountKey, Messages.LIVE_THREADS, null);
        }

        private void updateThreadsInfo(long tlCount, long tpCount, long ttCount, long timeStamp) {
            this.getPlotter().addValues(timeStamp, tlCount);
            this.getInfoLabel().setText(Resources.format(Messages.THREAD_TAB_INFO_LABEL_FORMAT, tlCount, tpCount, ttCount));
        }
    }

    private class PromptingTextField
    extends JTextField
    implements FocusListener {
        private String prompt;
        boolean promptRemoved;
        Color fg;

        public PromptingTextField(String prompt, int columns) {
            super(prompt, columns);
            this.promptRemoved = false;
            this.prompt = prompt;
            this.updateForeground();
            this.addFocusListener(this);
            Utilities.setAccessibleName(this, prompt);
        }

        @Override
        public void revalidate() {
            super.revalidate();
            this.updateForeground();
        }

        private void updateForeground() {
            this.fg = UIManager.getColor("TextField.foreground");
            if (this.promptRemoved) {
                this.setForeground(this.fg);
            } else {
                this.setForeground(Color.gray);
            }
        }

        @Override
        public String getText() {
            if (!this.promptRemoved) {
                return "";
            }
            return super.getText();
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!this.promptRemoved) {
                this.setText("");
                this.setForeground(this.fg);
                this.promptRemoved = true;
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.promptRemoved && this.getText().equals("")) {
                this.setText(this.prompt);
                this.setForeground(Color.gray);
                this.promptRemoved = false;
            }
        }
    }

    private class ThreadJList
    extends JList<Long> {
        private JTextArea textArea;

        ThreadJList(DefaultListModel<Long> listModel, JTextArea textArea) {
            super(listModel);
            this.textArea = textArea;
            this.setBorder(thinEmptyBorder);
            this.addListSelectionListener(ThreadTab.this);
            this.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (value != null) {
                        String name = ThreadTab.this.nameCache.get(value);
                        if (name == null) {
                            name = value.toString();
                        }
                        this.setText(name);
                    }
                    return this;
                }
            });
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = Math.max(d.width, 100);
            return d;
        }
    }
}

