/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import sun.security.provider.ByteArrayAccess;
import sun.security.provider.DigestBase;

public final class SHA2
extends DigestBase {
    private static final int ITERATION = 64;
    private static final int[] ROUND_CONSTS = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private final int[] W;
    private final int[] state;

    public SHA2() {
        super("SHA-256", 32, 64);
        this.state = new int[8];
        this.W = new int[64];
        this.implReset();
    }

    private SHA2(SHA2 base) {
        super(base);
        this.state = (int[])base.state.clone();
        this.W = new int[64];
    }

    @Override
    public Object clone() {
        return new SHA2(this);
    }

    @Override
    void implReset() {
        this.state[0] = 1779033703;
        this.state[1] = -1150833019;
        this.state[2] = 1013904242;
        this.state[3] = -1521486534;
        this.state[4] = 1359893119;
        this.state[5] = -1694144372;
        this.state[6] = 528734635;
        this.state[7] = 1541459225;
    }

    @Override
    void implDigest(byte[] out, int ofs) {
        long bitsProcessed = this.bytesProcessed << 3;
        int index = (int)this.bytesProcessed & 0x3F;
        int padLen = index < 56 ? 56 - index : 120 - index;
        this.engineUpdate(padding, 0, padLen);
        ByteArrayAccess.i2bBig4((int)(bitsProcessed >>> 32), this.buffer, 56);
        ByteArrayAccess.i2bBig4((int)bitsProcessed, this.buffer, 60);
        this.implCompress(this.buffer, 0);
        ByteArrayAccess.i2bBig(this.state, 0, out, ofs, 32);
    }

    private static int lf_ch(int x, int y, int z) {
        return x & y ^ ~x & z;
    }

    private static int lf_maj(int x, int y, int z) {
        return x & y ^ x & z ^ y & z;
    }

    private static int lf_R(int x, int s) {
        return x >>> s;
    }

    private static int lf_S(int x, int s) {
        return x >>> s | x << 32 - s;
    }

    private static int lf_sigma0(int x) {
        return SHA2.lf_S(x, 2) ^ SHA2.lf_S(x, 13) ^ SHA2.lf_S(x, 22);
    }

    private static int lf_sigma1(int x) {
        return SHA2.lf_S(x, 6) ^ SHA2.lf_S(x, 11) ^ SHA2.lf_S(x, 25);
    }

    private static int lf_delta0(int x) {
        return SHA2.lf_S(x, 7) ^ SHA2.lf_S(x, 18) ^ SHA2.lf_R(x, 3);
    }

    private static int lf_delta1(int x) {
        return SHA2.lf_S(x, 17) ^ SHA2.lf_S(x, 19) ^ SHA2.lf_R(x, 10);
    }

    @Override
    void implCompress(byte[] buf, int ofs) {
        ByteArrayAccess.b2iBig64(buf, ofs, this.W);
        for (int t = 16; t < 64; ++t) {
            this.W[t] = SHA2.lf_delta1(this.W[t - 2]) + this.W[t - 7] + SHA2.lf_delta0(this.W[t - 15]) + this.W[t - 16];
        }
        int a = this.state[0];
        int b = this.state[1];
        int c = this.state[2];
        int d = this.state[3];
        int e = this.state[4];
        int f = this.state[5];
        int g = this.state[6];
        int h = this.state[7];
        for (int i = 0; i < 64; ++i) {
            int T1 = h + SHA2.lf_sigma1(e) + SHA2.lf_ch(e, f, g) + ROUND_CONSTS[i] + this.W[i];
            int T2 = SHA2.lf_sigma0(a) + SHA2.lf_maj(a, b, c);
            h = g;
            g = f;
            f = e;
            e = d + T1;
            d = c;
            c = b;
            b = a;
            a = T1 + T2;
        }
        this.state[0] = this.state[0] + a;
        this.state[1] = this.state[1] + b;
        this.state[2] = this.state[2] + c;
        this.state[3] = this.state[3] + d;
        this.state[4] = this.state[4] + e;
        this.state[5] = this.state[5] + f;
        this.state[6] = this.state[6] + g;
        this.state[7] = this.state[7] + h;
    }
}

