/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.ShutdownChannelGroupException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.ThreadPool;

abstract class Port
extends AsynchronousChannelGroupImpl {
    static final short POLLIN = 1;
    static final short POLLOUT = 4;
    static final short POLLERR = 8;
    static final short POLLHUP = 16;
    protected final ReadWriteLock fdToChannelLock = new ReentrantReadWriteLock();
    protected final Map<Integer, PollableChannel> fdToChannel = new HashMap<Integer, PollableChannel>();

    Port(AsynchronousChannelProvider provider, ThreadPool pool) {
        super(provider, pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void register(int fd, PollableChannel ch) {
        this.fdToChannelLock.writeLock().lock();
        try {
            if (this.isShutdown()) {
                throw new ShutdownChannelGroupException();
            }
            this.fdToChannel.put(fd, ch);
        }
        finally {
            this.fdToChannelLock.writeLock().unlock();
        }
    }

    void unregisterImpl(int fd) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregister(int fd) {
        boolean checkForShutdown = false;
        this.unregisterImpl(fd);
        this.fdToChannelLock.writeLock().lock();
        try {
            this.fdToChannel.remove(fd);
            if (this.fdToChannel.isEmpty()) {
                checkForShutdown = true;
            }
        }
        finally {
            this.fdToChannelLock.writeLock().unlock();
        }
        if (checkForShutdown && this.isShutdown()) {
            try {
                this.shutdownNow();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    abstract void startPoll(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final boolean isEmpty() {
        this.fdToChannelLock.writeLock().lock();
        try {
            boolean bl = this.fdToChannel.isEmpty();
            return bl;
        }
        finally {
            this.fdToChannelLock.writeLock().unlock();
        }
    }

    @Override
    final Object attachForeignChannel(final Channel channel, FileDescriptor fd) {
        int fdVal = IOUtil.fdVal(fd);
        this.register(fdVal, new PollableChannel(){

            @Override
            public void onEvent(int events, boolean mayInvokeDirect) {
            }

            @Override
            public void close() throws IOException {
                channel.close();
            }
        });
        return fdVal;
    }

    @Override
    final void detachForeignChannel(Object key) {
        this.unregister((Integer)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void closeAllChannels() {
        int count;
        int MAX_BATCH_SIZE = 128;
        PollableChannel[] channels = new PollableChannel[128];
        do {
            this.fdToChannelLock.writeLock().lock();
            count = 0;
            try {
                for (Integer fd : this.fdToChannel.keySet()) {
                    channels[count++] = this.fdToChannel.get(fd);
                    if (count < 128) continue;
                    break;
                }
            }
            finally {
                this.fdToChannelLock.writeLock().unlock();
            }
            for (int i = 0; i < count; ++i) {
                try {
                    channels[i].close();
                    continue;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
        } while (count > 0);
    }

    static interface PollableChannel
    extends Closeable {
        public void onEvent(int var1, boolean var2);
    }
}

