/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.peer.SystemTrayPeer;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.X11.Native;
import sun.awt.X11.XAtom;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XMSelection;
import sun.awt.X11.XMSelectionListener;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XTrayIconPeer;
import sun.awt.X11.XlibWrapper;
import sun.util.logging.PlatformLogger;

public class XSystemTrayPeer
implements SystemTrayPeer,
XMSelectionListener {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XSystemTrayPeer");
    SystemTray target;
    static XSystemTrayPeer peerInstance;
    private volatile boolean available;
    private final XMSelection selection = new XMSelection("_NET_SYSTEM_TRAY");
    private static final int SCREEN = 0;
    private static final String SYSTEM_TRAY_PROPERTY_NAME = "systemTray";
    private static final XAtom _NET_SYSTEM_TRAY;
    private static final XAtom _XEMBED_INFO;
    private static final XAtom _NET_SYSTEM_TRAY_OPCODE;
    private static final XAtom _NET_WM_ICON;
    private static final long SYSTEM_TRAY_REQUEST_DOCK = 0L;

    XSystemTrayPeer(SystemTray target) {
        this.target = target;
        peerInstance = this;
        this.selection.addSelectionListener(this);
        long selection_owner = this.selection.getOwner(0);
        this.available = selection_owner != 0L;
        log.fine(" check if system tray is available. selection owner: " + selection_owner);
    }

    @Override
    public void ownerChanged(int screen, XMSelection sel, long newOwner, long data, long timestamp) {
        if (screen != 0) {
            return;
        }
        if (!this.available) {
            this.available = true;
            this.firePropertyChange(SYSTEM_TRAY_PROPERTY_NAME, null, this.target);
        } else {
            this.removeTrayPeers();
        }
        this.createTrayPeers();
    }

    @Override
    public void ownerDeath(int screen, XMSelection sel, long deadOwner) {
        if (screen != 0) {
            return;
        }
        if (this.available) {
            this.available = false;
            this.firePropertyChange(SYSTEM_TRAY_PROPERTY_NAME, this.target, null);
            this.removeTrayPeers();
        }
    }

    @Override
    public void selectionChanged(int screen, XMSelection sel, long owner, XPropertyEvent event) {
    }

    @Override
    public Dimension getTrayIconSize() {
        return new Dimension(24, 24);
    }

    boolean isAvailable() {
        return this.available;
    }

    void dispose() {
        this.selection.removeSelectionListener(this);
    }

    void addTrayIcon(XTrayIconPeer tiPeer) throws AWTException {
        long selection_owner = this.selection.getOwner(0);
        log.fine(" send SYSTEM_TRAY_REQUEST_DOCK message to owner: " + selection_owner);
        if (selection_owner == 0L) {
            throw new AWTException("TrayIcon couldn't be displayed.");
        }
        long tray_window = tiPeer.getWindow();
        long[] data = new long[]{0L, 1L};
        long data_ptr = Native.card32ToData(data);
        _XEMBED_INFO.setAtomData(tray_window, data_ptr, data.length);
        this.sendMessage(selection_owner, 0L, tray_window, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMessage(long win, long msg, long data1, long data2, long data3) {
        XClientMessageEvent xev = new XClientMessageEvent();
        try {
            xev.set_type(33);
            xev.set_window(win);
            xev.set_format(32);
            xev.set_message_type(_NET_SYSTEM_TRAY_OPCODE.getAtom());
            xev.set_data(0, 0L);
            xev.set_data(1, msg);
            xev.set_data(2, data1);
            xev.set_data(3, data2);
            xev.set_data(4, data3);
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), win, false, 0L, xev.pData);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        finally {
            xev.dispose();
        }
    }

    static XSystemTrayPeer getPeerInstance() {
        return peerInstance;
    }

    private void firePropertyChange(final String propertyName, final Object oldValue, final Object newValue) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AWTAccessor.getSystemTrayAccessor().firePropertyChange(XSystemTrayPeer.this.target, propertyName, oldValue, newValue);
            }
        };
        this.invokeOnEachAppContext(runnable);
    }

    private void createTrayPeers() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TrayIcon[] icons = XSystemTrayPeer.this.target.getTrayIcons();
                try {
                    for (TrayIcon ti : icons) {
                        AWTAccessor.getTrayIconAccessor().addNotify(ti);
                    }
                }
                catch (AWTException aWTException) {
                    // empty catch block
                }
            }
        };
        this.invokeOnEachAppContext(runnable);
    }

    private void removeTrayPeers() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TrayIcon[] icons;
                for (TrayIcon ti : icons = XSystemTrayPeer.this.target.getTrayIcons()) {
                    AWTAccessor.getTrayIconAccessor().removeNotify(ti);
                }
            }
        };
        this.invokeOnEachAppContext(runnable);
    }

    private void invokeOnEachAppContext(Runnable runnable) {
        for (AppContext appContext : AppContext.getAppContexts()) {
            SunToolkit.invokeLaterOnAppContext(appContext, runnable);
        }
    }

    static {
        _NET_SYSTEM_TRAY = XAtom.get("_NET_SYSTEM_TRAY_S0");
        _XEMBED_INFO = XAtom.get("_XEMBED_INFO");
        _NET_SYSTEM_TRAY_OPCODE = XAtom.get("_NET_SYSTEM_TRAY_OPCODE");
        _NET_WM_ICON = XAtom.get("_NET_WM_ICON");
    }
}

