/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.InvocationEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import sun.awt.AWTAutoShutdown;
import sun.awt.AWTSecurityManager;
import sun.awt.MostRecentKeyValue;
import sun.awt.SunToolkit;
import sun.misc.JavaAWTAccess;
import sun.misc.SharedSecrets;
import sun.util.logging.PlatformLogger;

public final class AppContext {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.AppContext");
    public static final Object EVENT_QUEUE_KEY = new StringBuffer("EventQueue");
    public static final Object EVENT_QUEUE_LOCK_KEY = new StringBuilder("EventQueue.Lock");
    public static final Object EVENT_QUEUE_COND_KEY = new StringBuilder("EventQueue.Condition");
    private static final Map<ThreadGroup, AppContext> threadGroup2appContext = Collections.synchronizedMap(new IdentityHashMap());
    private static volatile AppContext mainAppContext = null;
    private final HashMap table = new HashMap();
    private final ThreadGroup threadGroup;
    private PropertyChangeSupport changeSupport = null;
    public static final String DISPOSED_PROPERTY_NAME = "disposed";
    public static final String GUI_DISPOSED = "guidisposed";
    private volatile State state = State.VALID;
    private static final AtomicInteger numAppContexts = new AtomicInteger(0);
    private final ClassLoader contextClassLoader;
    private static final ThreadLocal<AppContext> threadAppContext = new ThreadLocal();
    private long DISPOSAL_TIMEOUT = 5000L;
    private long THREAD_INTERRUPT_TIMEOUT = 1000L;
    private MostRecentKeyValue mostRecentKeyValue = null;
    private MostRecentKeyValue shadowMostRecentKeyValue = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<AppContext> getAppContexts() {
        Map<ThreadGroup, AppContext> map = threadGroup2appContext;
        synchronized (map) {
            return new HashSet<AppContext>(threadGroup2appContext.values());
        }
    }

    public boolean isDisposed() {
        return this.state == State.DISPOSED;
    }

    AppContext(ThreadGroup threadGroup) {
        numAppContexts.incrementAndGet();
        this.threadGroup = threadGroup;
        threadGroup2appContext.put(threadGroup, this);
        this.contextClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        ReentrantLock eventQueuePushPopLock = new ReentrantLock();
        this.put(EVENT_QUEUE_LOCK_KEY, eventQueuePushPopLock);
        Condition eventQueuePushPopCond = eventQueuePushPopLock.newCondition();
        this.put(EVENT_QUEUE_COND_KEY, eventQueuePushPopCond);
    }

    private static final void initMainAppContext() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ThreadGroup currentThreadGroup = Thread.currentThread().getThreadGroup();
                ThreadGroup parentThreadGroup = currentThreadGroup.getParent();
                while (parentThreadGroup != null) {
                    currentThreadGroup = parentThreadGroup;
                    parentThreadGroup = currentThreadGroup.getParent();
                }
                mainAppContext = SunToolkit.createNewAppContext(currentThreadGroup);
                return null;
            }
        });
    }

    public static final AppContext getAppContext() {
        if (numAppContexts.get() == 1 && mainAppContext != null) {
            return mainAppContext;
        }
        AppContext appContext = threadAppContext.get();
        if (null == appContext) {
            appContext = AccessController.doPrivileged(new PrivilegedAction<AppContext>(){

                @Override
                public AppContext run() {
                    ThreadGroup currentThreadGroup;
                    ThreadGroup threadGroup = currentThreadGroup = Thread.currentThread().getThreadGroup();
                    if (numAppContexts.get() == 0) {
                        if (System.getProperty("javaplugin.version") == null && System.getProperty("javawebstart.version") == null) {
                            AppContext.initMainAppContext();
                        } else if (System.getProperty("javafx.version") != null && threadGroup.getParent() != null) {
                            SunToolkit.createNewAppContext();
                        }
                    }
                    AppContext context = (AppContext)threadGroup2appContext.get(threadGroup);
                    while (context == null) {
                        if ((threadGroup = threadGroup.getParent()) == null) {
                            return null;
                        }
                        context = (AppContext)threadGroup2appContext.get(threadGroup);
                    }
                    for (ThreadGroup tg = currentThreadGroup; tg != threadGroup; tg = tg.getParent()) {
                        threadGroup2appContext.put(tg, context);
                    }
                    threadAppContext.set(context);
                    return context;
                }
            });
        }
        return appContext;
    }

    public static final boolean isMainContext(AppContext ctx) {
        return ctx != null && ctx == mainAppContext;
    }

    private static final AppContext getExecutionAppContext() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && securityManager instanceof AWTSecurityManager) {
            AWTSecurityManager awtSecMgr = (AWTSecurityManager)securityManager;
            AppContext secAppContext = awtSecMgr.getAppContext();
            return secAppContext;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws IllegalThreadStateException {
        if (this.threadGroup.parentOf(Thread.currentThread().getThreadGroup())) {
            throw new IllegalThreadStateException("Current Thread is contained within AppContext to be disposed.");
        }
        AppContext appContext = this;
        synchronized (appContext) {
            if (this.state != State.VALID) {
                return;
            }
            this.state = State.BEING_DISPOSED;
        }
        final PropertyChangeSupport changeSupport = this.changeSupport;
        if (changeSupport != null) {
            changeSupport.firePropertyChange(DISPOSED_PROPERTY_NAME, false, true);
        }
        final Object notificationLock = new Object();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Window[] windowsToDispose;
                for (Window w : windowsToDispose = Window.getOwnerlessWindows()) {
                    try {
                        w.dispose();
                    }
                    catch (Throwable t) {
                        log.finer("exception occured while disposing app context", t);
                    }
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        if (!GraphicsEnvironment.isHeadless() && SystemTray.isSupported()) {
                            TrayIcon[] trayIconsToDispose;
                            SystemTray systemTray = SystemTray.getSystemTray();
                            for (TrayIcon ti : trayIconsToDispose = systemTray.getTrayIcons()) {
                                systemTray.remove(ti);
                            }
                        }
                        return null;
                    }
                });
                if (changeSupport != null) {
                    changeSupport.firePropertyChange(AppContext.GUI_DISPOSED, false, true);
                }
                Object object = notificationLock;
                synchronized (object) {
                    notificationLock.notifyAll();
                }
            }
        };
        Object object = notificationLock;
        synchronized (object) {
            SunToolkit.postEvent(this, new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
            try {
                notificationLock.wait(this.DISPOSAL_TIMEOUT);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = notificationLock;
                synchronized (object) {
                    notificationLock.notifyAll();
                }
            }
        };
        object = notificationLock;
        synchronized (object) {
            SunToolkit.postEvent(this, new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
            try {
                notificationLock.wait(this.DISPOSAL_TIMEOUT);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        object = this;
        synchronized (object) {
            this.state = State.DISPOSED;
        }
        this.threadGroup.interrupt();
        long startTime = System.currentTimeMillis();
        long endTime = startTime + this.THREAD_INTERRUPT_TIMEOUT;
        while (this.threadGroup.activeCount() > 0 && System.currentTimeMillis() < endTime) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        this.threadGroup.stop();
        startTime = System.currentTimeMillis();
        endTime = startTime + this.THREAD_INTERRUPT_TIMEOUT;
        while (this.threadGroup.activeCount() > 0 && System.currentTimeMillis() < endTime) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        int numSubGroups = this.threadGroup.activeGroupCount();
        if (numSubGroups > 0) {
            ThreadGroup[] subGroups = new ThreadGroup[numSubGroups];
            numSubGroups = this.threadGroup.enumerate(subGroups);
            for (int subGroup = 0; subGroup < numSubGroups; ++subGroup) {
                threadGroup2appContext.remove(subGroups[subGroup]);
            }
        }
        threadGroup2appContext.remove(this.threadGroup);
        threadAppContext.set(null);
        try {
            this.threadGroup.destroy();
        }
        catch (IllegalThreadStateException e) {
            // empty catch block
        }
        HashMap hashMap = this.table;
        synchronized (hashMap) {
            this.table.clear();
        }
        numAppContexts.decrementAndGet();
        this.mostRecentKeyValue = null;
    }

    static void stopEventDispatchThreads() {
        for (AppContext appContext : AppContext.getAppContexts()) {
            if (appContext.isDisposed()) continue;
            PostShutdownEventRunnable r = new PostShutdownEventRunnable(appContext);
            if (appContext != AppContext.getAppContext()) {
                CreateThreadAction action = new CreateThreadAction(appContext, r);
                Thread thread = (Thread)AccessController.doPrivileged(action);
                thread.start();
                continue;
            }
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        HashMap hashMap = this.table;
        synchronized (hashMap) {
            MostRecentKeyValue recent = this.mostRecentKeyValue;
            if (recent != null && recent.key == key) {
                return recent.value;
            }
            Object value = this.table.get(key);
            if (this.mostRecentKeyValue == null) {
                this.mostRecentKeyValue = new MostRecentKeyValue(key, value);
                this.shadowMostRecentKeyValue = new MostRecentKeyValue(key, value);
            } else {
                MostRecentKeyValue auxKeyValue = this.mostRecentKeyValue;
                this.shadowMostRecentKeyValue.setPair(key, value);
                this.mostRecentKeyValue = this.shadowMostRecentKeyValue;
                this.shadowMostRecentKeyValue = auxKeyValue;
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        HashMap hashMap = this.table;
        synchronized (hashMap) {
            MostRecentKeyValue recent = this.mostRecentKeyValue;
            if (recent != null && recent.key == key) {
                recent.value = value;
            }
            return this.table.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        HashMap hashMap = this.table;
        synchronized (hashMap) {
            MostRecentKeyValue recent = this.mostRecentKeyValue;
            if (recent != null && recent.key == key) {
                recent.value = null;
            }
            return this.table.remove(key);
        }
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public String toString() {
        return this.getClass().getName() + "[threadGroup=" + this.threadGroup.getName() + "]";
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(propertyName);
    }

    static {
        SharedSecrets.setJavaAWTAccess(new JavaAWTAccess(){

            @Override
            public Object get(Object key) {
                AppContext ac = AppContext.getAppContext();
                return ac == null ? null : ac.get(key);
            }

            @Override
            public void put(Object key, Object value) {
                AppContext ac = AppContext.getAppContext();
                if (ac != null) {
                    ac.put(key, value);
                }
            }

            @Override
            public void remove(Object key) {
                AppContext ac = AppContext.getAppContext();
                if (ac != null) {
                    ac.remove(key);
                }
            }

            @Override
            public boolean isDisposed() {
                AppContext ac = AppContext.getAppContext();
                return ac == null ? true : ac.isDisposed();
            }

            @Override
            public boolean isMainAppContext() {
                return numAppContexts.get() == 1 && mainAppContext != null;
            }

            private boolean hasRootThreadGroup(final AppContext ecx) {
                return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        return ecx.threadGroup.getParent() == null;
                    }
                });
            }

            @Override
            public Object getAppletContext() {
                if (numAppContexts.get() == 0) {
                    return null;
                }
                AppContext ecx = AppContext.getExecutionAppContext();
                if (numAppContexts.get() > 0) {
                    ecx = ecx != null ? ecx : AppContext.getAppContext();
                }
                boolean isMainAppContext = ecx == null || mainAppContext == ecx || mainAppContext == null && this.hasRootThreadGroup(ecx);
                return isMainAppContext ? null : ecx;
            }
        });
    }

    static final class CreateThreadAction
    implements PrivilegedAction {
        private final AppContext appContext;
        private final Runnable runnable;

        public CreateThreadAction(AppContext ac, Runnable r) {
            this.appContext = ac;
            this.runnable = r;
        }

        public Object run() {
            Thread t = new Thread(this.appContext.getThreadGroup(), this.runnable);
            t.setContextClassLoader(this.appContext.getContextClassLoader());
            t.setPriority(6);
            t.setDaemon(true);
            return t;
        }
    }

    static final class PostShutdownEventRunnable
    implements Runnable {
        private final AppContext appContext;

        public PostShutdownEventRunnable(AppContext ac) {
            this.appContext = ac;
        }

        @Override
        public void run() {
            EventQueue eq = (EventQueue)this.appContext.get(EVENT_QUEUE_KEY);
            if (eq != null) {
                eq.postEvent(AWTAutoShutdown.getShutdownEvent());
            }
        }
    }

    private static enum State {
        VALID,
        BEING_DISPOSED,
        DISPOSED;

    }
}

