/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.SocketPermission;
import java.net.URL;
import java.security.CodeSigner;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;

public class CodeSource
implements Serializable {
    private static final long serialVersionUID = 4977541819976013951L;
    private URL location;
    private transient CodeSigner[] signers = null;
    private transient Certificate[] certs = null;
    private transient SocketPermission sp;
    private transient CertificateFactory factory = null;

    public CodeSource(URL url, Certificate[] certs) {
        this.location = url;
        if (certs != null) {
            this.certs = (Certificate[])certs.clone();
        }
    }

    public CodeSource(URL url, CodeSigner[] signers) {
        this.location = url;
        if (signers != null) {
            this.signers = (CodeSigner[])signers.clone();
        }
    }

    public int hashCode() {
        if (this.location != null) {
            return this.location.hashCode();
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CodeSource)) {
            return false;
        }
        CodeSource cs = (CodeSource)obj;
        if (this.location == null ? cs.location != null : !this.location.equals(cs.location)) {
            return false;
        }
        return this.matchCerts(cs, true);
    }

    public final URL getLocation() {
        return this.location;
    }

    public final Certificate[] getCertificates() {
        if (this.certs != null) {
            return (Certificate[])this.certs.clone();
        }
        if (this.signers != null) {
            ArrayList<? extends Certificate> certChains = new ArrayList<Certificate>();
            for (int i = 0; i < this.signers.length; ++i) {
                certChains.addAll(this.signers[i].getSignerCertPath().getCertificates());
            }
            this.certs = certChains.toArray(new Certificate[certChains.size()]);
            return (Certificate[])this.certs.clone();
        }
        return null;
    }

    public final CodeSigner[] getCodeSigners() {
        if (this.signers != null) {
            return (CodeSigner[])this.signers.clone();
        }
        if (this.certs != null) {
            this.signers = this.convertCertArrayToSignerArray(this.certs);
            return (CodeSigner[])this.signers.clone();
        }
        return null;
    }

    public boolean implies(CodeSource codesource) {
        if (codesource == null) {
            return false;
        }
        return this.matchCerts(codesource, false) && this.matchLocation(codesource);
    }

    private boolean matchCerts(CodeSource that, boolean strict) {
        if (this.certs == null && this.signers == null) {
            if (strict) {
                return that.certs == null && that.signers == null;
            }
            return true;
        }
        if (this.signers != null && that.signers != null) {
            if (strict && this.signers.length != that.signers.length) {
                return false;
            }
            for (int i = 0; i < this.signers.length; ++i) {
                boolean match = false;
                for (int j = 0; j < that.signers.length; ++j) {
                    if (!this.signers[i].equals(that.signers[j])) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            return true;
        }
        if (this.certs != null && that.certs != null) {
            if (strict && this.certs.length != that.certs.length) {
                return false;
            }
            for (int i = 0; i < this.certs.length; ++i) {
                boolean match = false;
                for (int j = 0; j < that.certs.length; ++j) {
                    if (!this.certs[i].equals(that.certs[j])) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean matchLocation(CodeSource that) {
        if (this.location == null) {
            return true;
        }
        if (that == null || that.location == null) {
            return false;
        }
        if (this.location.equals(that.location)) {
            return true;
        }
        if (!this.location.getProtocol().equalsIgnoreCase(that.location.getProtocol())) {
            return false;
        }
        if (this.location.getPort() != -1 && this.location.getPort() != that.location.getPort()) {
            return false;
        }
        if (this.location.getFile().endsWith("/-")) {
            String thisPath = this.location.getFile().substring(0, this.location.getFile().length() - 1);
            if (!that.location.getFile().startsWith(thisPath)) {
                return false;
            }
        } else if (this.location.getFile().endsWith("/*")) {
            int last = that.location.getFile().lastIndexOf(47);
            if (last == -1) {
                return false;
            }
            String thisPath = this.location.getFile().substring(0, this.location.getFile().length() - 1);
            String thatPath = that.location.getFile().substring(0, last + 1);
            if (!thatPath.equals(thisPath)) {
                return false;
            }
        } else if (!that.location.getFile().equals(this.location.getFile()) && !that.location.getFile().equals(this.location.getFile() + "/")) {
            return false;
        }
        if (this.location.getRef() != null && !this.location.getRef().equals(that.location.getRef())) {
            return false;
        }
        String thisHost = this.location.getHost();
        String thatHost = that.location.getHost();
        if (!(thisHost == null || ("".equals(thisHost) || "localhost".equals(thisHost)) && ("".equals(thatHost) || "localhost".equals(thatHost)) || thisHost.equalsIgnoreCase(thatHost))) {
            if (thatHost == null) {
                return false;
            }
            if (this.sp == null) {
                this.sp = new SocketPermission(thisHost, "resolve");
            }
            if (that.sp == null) {
                that.sp = new SocketPermission(thatHost, "resolve");
            }
            if (!this.sp.implies(that.sp)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.location);
        if (this.certs != null && this.certs.length > 0) {
            for (int i = 0; i < this.certs.length; ++i) {
                sb.append(" " + this.certs[i]);
            }
        } else if (this.signers != null && this.signers.length > 0) {
            for (int i = 0; i < this.signers.length; ++i) {
                sb.append(" " + this.signers[i]);
            }
        } else {
            sb.append(" <no signer certificates>");
        }
        sb.append(")");
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        if (this.certs == null || this.certs.length == 0) {
            oos.writeInt(0);
        } else {
            oos.writeInt(this.certs.length);
            for (int i = 0; i < this.certs.length; ++i) {
                Certificate cert = this.certs[i];
                try {
                    oos.writeUTF(cert.getType());
                    byte[] encoded = cert.getEncoded();
                    oos.writeInt(encoded.length);
                    oos.write(encoded);
                    continue;
                }
                catch (CertificateEncodingException cee) {
                    throw new IOException(cee.getMessage());
                }
            }
        }
        if (this.signers != null && this.signers.length > 0) {
            oos.writeObject(this.signers);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Hashtable<String, CertificateFactory> cfs = null;
        ois.defaultReadObject();
        int size = ois.readInt();
        if (size > 0) {
            cfs = new Hashtable<String, CertificateFactory>(3);
            this.certs = new Certificate[size];
        }
        for (int i = 0; i < size; ++i) {
            CertificateFactory cf;
            String certType = ois.readUTF();
            if (cfs.containsKey(certType)) {
                cf = (CertificateFactory)cfs.get(certType);
            } else {
                try {
                    cf = CertificateFactory.getInstance(certType);
                }
                catch (CertificateException ce) {
                    throw new ClassNotFoundException("Certificate factory for " + certType + " not found");
                }
                cfs.put(certType, cf);
            }
            byte[] encoded = null;
            try {
                encoded = new byte[ois.readInt()];
            }
            catch (OutOfMemoryError oome) {
                throw new IOException("Certificate too big");
            }
            ois.readFully(encoded);
            ByteArrayInputStream bais = new ByteArrayInputStream(encoded);
            try {
                this.certs[i] = cf.generateCertificate(bais);
            }
            catch (CertificateException ce) {
                throw new IOException(ce.getMessage());
            }
            bais.close();
        }
        try {
            this.signers = (CodeSigner[])((CodeSigner[])ois.readObject()).clone();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private CodeSigner[] convertCertArrayToSignerArray(Certificate[] certs) {
        if (certs == null) {
            return null;
        }
        try {
            if (this.factory == null) {
                this.factory = CertificateFactory.getInstance("X.509");
            }
            int i = 0;
            ArrayList<CodeSigner> signers = new ArrayList<CodeSigner>();
            while (i < certs.length) {
                int j;
                ArrayList<Certificate> certChain = new ArrayList<Certificate>();
                certChain.add(certs[i++]);
                for (j = i; j < certs.length && certs[j] instanceof X509Certificate && ((X509Certificate)certs[j]).getBasicConstraints() != -1; ++j) {
                    certChain.add(certs[j]);
                }
                i = j;
                CertPath certPath = this.factory.generateCertPath(certChain);
                signers.add(new CodeSigner(certPath, null));
            }
            if (signers.isEmpty()) {
                return null;
            }
            return signers.toArray(new CodeSigner[signers.size()]);
        }
        catch (CertificateException e) {
            return null;
        }
    }
}

