/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.InvalidObjectException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.UnexpectedException;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.util.Map;
import java.util.WeakHashMap;
import sun.rmi.server.Util;
import sun.rmi.server.WeakClassHashMap;

public class RemoteObjectInvocationHandler
extends RemoteObject
implements InvocationHandler {
    private static final long serialVersionUID = 2L;
    private static final MethodToHash_Maps methodToHash_Maps = new MethodToHash_Maps();

    public RemoteObjectInvocationHandler(RemoteRef ref) {
        super(ref);
        if (ref == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return this.invokeObjectMethod(proxy, method, args);
        }
        return this.invokeRemoteMethod(proxy, method, args);
    }

    private Object invokeObjectMethod(Object proxy, Method method, Object[] args) {
        String name = method.getName();
        if (name.equals("hashCode")) {
            return this.hashCode();
        }
        if (name.equals("equals")) {
            Object obj = args[0];
            return proxy == obj || obj != null && Proxy.isProxyClass(obj.getClass()) && this.equals(Proxy.getInvocationHandler(obj));
        }
        if (name.equals("toString")) {
            return this.proxyToString(proxy);
        }
        throw new IllegalArgumentException("unexpected Object method: " + method);
    }

    private Object invokeRemoteMethod(Object proxy, Method method, Object[] args) throws Exception {
        try {
            if (!(proxy instanceof Remote)) {
                throw new IllegalArgumentException("proxy not Remote instance");
            }
            return this.ref.invoke((Remote)proxy, method, args, RemoteObjectInvocationHandler.getMethodHash(method));
        }
        catch (Exception e2) {
            UnexpectedException e2;
            if (!(e2 instanceof RuntimeException)) {
                Class<?> cl = proxy.getClass();
                try {
                    method = cl.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException nsme) {
                    throw (IllegalArgumentException)new IllegalArgumentException().initCause(nsme);
                }
                Class<?> thrownType = e2.getClass();
                for (Class<?> declaredType : method.getExceptionTypes()) {
                    if (!declaredType.isAssignableFrom(thrownType)) continue;
                    throw e2;
                }
                e2 = new UnexpectedException("unexpected exception", e2);
            }
            throw e2;
        }
    }

    private String proxyToString(Object proxy) {
        int dot;
        Class<?>[] interfaces = proxy.getClass().getInterfaces();
        if (interfaces.length == 0) {
            return "Proxy[" + this + "]";
        }
        String iface = interfaces[0].getName();
        if (iface.equals("java.rmi.Remote") && interfaces.length > 1) {
            iface = interfaces[1].getName();
        }
        if ((dot = iface.lastIndexOf(46)) >= 0) {
            iface = iface.substring(dot + 1);
        }
        return "Proxy[" + iface + "," + this + "]";
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("no data in stream; class: " + this.getClass().getName());
    }

    private static long getMethodHash(Method method) {
        return (Long)((Map)methodToHash_Maps.get(method.getDeclaringClass())).get(method);
    }

    private static class MethodToHash_Maps
    extends WeakClassHashMap<Map<Method, Long>> {
        MethodToHash_Maps() {
        }

        @Override
        protected Map<Method, Long> computeValue(Class<?> remoteClass) {
            return new WeakHashMap<Method, Long>(){

                @Override
                public synchronized Long get(Object key) {
                    Long hash = (Long)super.get(key);
                    if (hash == null) {
                        Method method = (Method)key;
                        hash = Util.computeMethodHash(method);
                        this.put(method, hash);
                    }
                    return hash;
                }
            };
        }
    }
}

