/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import sun.invoke.util.ValueConversions;
import sun.misc.Unsafe;

public abstract class MethodHandle {
    private final MethodType type;
    final LambdaForm form;
    private static final LambdaForm.NamedFunction NF_reinvokerTarget;
    private static final long FORM_OFFSET;

    public MethodType type() {
        return this.type;
    }

    MethodHandle(MethodType type, LambdaForm form) {
        type.getClass();
        form.getClass();
        this.type = type;
        this.form = form;
        form.prepare();
    }

    @PolymorphicSignature
    public final native Object invokeExact(Object ... var1) throws Throwable;

    @PolymorphicSignature
    public final native Object invoke(Object ... var1) throws Throwable;

    @PolymorphicSignature
    final native Object invokeBasic(Object ... var1) throws Throwable;

    @PolymorphicSignature
    static native Object linkToVirtual(Object ... var0) throws Throwable;

    @PolymorphicSignature
    static native Object linkToStatic(Object ... var0) throws Throwable;

    @PolymorphicSignature
    static native Object linkToSpecial(Object ... var0) throws Throwable;

    @PolymorphicSignature
    static native Object linkToInterface(Object ... var0) throws Throwable;

    public Object invokeWithArguments(Object ... arguments) throws Throwable {
        int argc = arguments == null ? 0 : arguments.length;
        MethodType type = this.type();
        if (type.parameterCount() != argc || this.isVarargsCollector()) {
            return this.asType(MethodType.genericMethodType(argc)).invokeWithArguments(arguments);
        }
        MethodHandle invoker = type.invokers().varargsInvoker();
        return invoker.invokeExact(this, arguments);
    }

    public Object invokeWithArguments(List<?> arguments) throws Throwable {
        return this.invokeWithArguments(arguments.toArray());
    }

    public MethodHandle asType(MethodType newType) {
        if (!this.type.isConvertibleTo(newType)) {
            throw new WrongMethodTypeException("cannot convert " + this + " to " + newType);
        }
        return this.convertArguments(newType);
    }

    public MethodHandle asSpreader(Class<?> arrayType, int arrayLength) {
        this.asSpreaderChecks(arrayType, arrayLength);
        int spreadArgPos = this.type.parameterCount() - arrayLength;
        return MethodHandleImpl.makeSpreadArguments(this, arrayType, spreadArgPos, arrayLength);
    }

    private void asSpreaderChecks(Class<?> arrayType, int arrayLength) {
        this.spreadArrayChecks(arrayType, arrayLength);
        int nargs = this.type().parameterCount();
        if (nargs < arrayLength || arrayLength < 0) {
            throw MethodHandleStatics.newIllegalArgumentException("bad spread array length");
        }
        if (arrayType != Object[].class && arrayLength != 0) {
            boolean sawProblem = false;
            Class<?> arrayElement = arrayType.getComponentType();
            for (int i = nargs - arrayLength; i < nargs; ++i) {
                if (MethodType.canConvert(arrayElement, this.type().parameterType(i))) continue;
                sawProblem = true;
                break;
            }
            if (sawProblem) {
                ArrayList ptypes = new ArrayList(this.type().parameterList());
                for (int i = nargs - arrayLength; i < nargs; ++i) {
                    ptypes.set(i, arrayElement);
                }
                this.asType(MethodType.methodType(this.type().returnType(), ptypes));
            }
        }
    }

    private void spreadArrayChecks(Class<?> arrayType, int arrayLength) {
        Class<?> arrayElement = arrayType.getComponentType();
        if (arrayElement == null) {
            throw MethodHandleStatics.newIllegalArgumentException("not an array type", arrayType);
        }
        if ((arrayLength & 0x7F) != arrayLength) {
            if ((arrayLength & 0xFF) != arrayLength) {
                throw MethodHandleStatics.newIllegalArgumentException("array length is not legal", arrayLength);
            }
            assert (arrayLength >= 128);
            if (arrayElement == Long.TYPE || arrayElement == Double.TYPE) {
                throw MethodHandleStatics.newIllegalArgumentException("array length is not legal for long[] or double[]", arrayLength);
            }
        }
    }

    public MethodHandle asCollector(Class<?> arrayType, int arrayLength) {
        this.asCollectorChecks(arrayType, arrayLength);
        int collectArgPos = this.type().parameterCount() - 1;
        MethodHandle target = this;
        if (arrayType != this.type().parameterType(collectArgPos)) {
            target = this.convertArguments(this.type().changeParameterType(collectArgPos, arrayType));
        }
        MethodHandle collector = ValueConversions.varargsArray(arrayType, arrayLength);
        return MethodHandles.collectArguments(target, collectArgPos, collector);
    }

    private boolean asCollectorChecks(Class<?> arrayType, int arrayLength) {
        this.spreadArrayChecks(arrayType, arrayLength);
        int nargs = this.type().parameterCount();
        if (nargs != 0) {
            Class<?> lastParam = this.type().parameterType(nargs - 1);
            if (lastParam == arrayType) {
                return true;
            }
            if (lastParam.isAssignableFrom(arrayType)) {
                return false;
            }
        }
        throw MethodHandleStatics.newIllegalArgumentException("array type not assignable to trailing argument", this, arrayType);
    }

    public MethodHandle asVarargsCollector(Class<?> arrayType) {
        Class<?> arrayElement = arrayType.getComponentType();
        boolean lastMatch = this.asCollectorChecks(arrayType, 0);
        if (this.isVarargsCollector() && lastMatch) {
            return this;
        }
        return MethodHandleImpl.makeVarargsCollector(this, arrayType);
    }

    public boolean isVarargsCollector() {
        return false;
    }

    public MethodHandle asFixedArity() {
        assert (!this.isVarargsCollector());
        return this;
    }

    public MethodHandle bindTo(Object x) {
        Class<?> ptype;
        MethodType type = this.type();
        if (type.parameterCount() == 0 || (ptype = type.parameterType(0)).isPrimitive()) {
            throw MethodHandleStatics.newIllegalArgumentException("no leading reference parameter", x);
        }
        x = ptype.cast(x);
        return this.bindReceiver(x);
    }

    public String toString() {
        if (MethodHandleStatics.DEBUG_METHOD_HANDLE_NAMES) {
            return this.debugString();
        }
        return this.standardString();
    }

    String standardString() {
        return "MethodHandle" + this.type;
    }

    String debugString() {
        return this.standardString() + "/LF=" + this.internalForm() + this.internalProperties();
    }

    MethodHandle setVarargs(MemberName member) throws IllegalAccessException {
        Class<?> arrayType;
        if (!member.isVarargs()) {
            return this;
        }
        int argc = this.type().parameterCount();
        if (argc != 0 && (arrayType = this.type().parameterType(argc - 1)).isArray()) {
            return MethodHandleImpl.makeVarargsCollector(this, arrayType);
        }
        throw member.makeAccessException("cannot make variable arity", null);
    }

    MethodHandle viewAsType(MethodType newType) {
        if (!this.type.isViewableAs(newType)) {
            throw new InternalError();
        }
        return MethodHandleImpl.makePairwiseConvert(this, newType, 0);
    }

    LambdaForm internalForm() {
        return this.form;
    }

    MemberName internalMemberName() {
        return null;
    }

    Object internalValues() {
        return null;
    }

    Object internalProperties() {
        return "";
    }

    MethodHandle convertArguments(MethodType newType) {
        return MethodHandleImpl.makePairwiseConvert(this, newType, 1);
    }

    MethodHandle bindArgument(int pos, char basicType, Object value) {
        return this.rebind().bindArgument(pos, basicType, value);
    }

    MethodHandle bindReceiver(Object receiver) {
        return this.bindArgument(0, 'L', receiver);
    }

    MethodHandle bindImmediate(int pos, char basicType, Object value) {
        assert (pos == 0 && basicType == 'L' && value instanceof Unsafe);
        MethodType type2 = this.type.dropParameterTypes(pos, pos + 1);
        LambdaForm form2 = this.form.bindImmediate(pos + 1, basicType, value);
        return this.copyWith(type2, form2);
    }

    MethodHandle copyWith(MethodType mt, LambdaForm lf) {
        throw new InternalError("copyWith: " + this.getClass());
    }

    MethodHandle dropArguments(MethodType srcType, int pos, int drops) {
        return this.rebind().dropArguments(srcType, pos, drops);
    }

    MethodHandle permuteArguments(MethodType newType, int[] reorder) {
        return this.rebind().permuteArguments(newType, reorder);
    }

    MethodHandle rebind() {
        MethodType type2 = this.type();
        LambdaForm form2 = MethodHandle.reinvokerForm(type2.basicType());
        return BoundMethodHandle.bindSingle(type2, form2, this);
    }

    MethodHandle reinvokerTarget() {
        throw new InternalError("not a reinvoker MH: " + this.getClass().getName() + ": " + this);
    }

    static LambdaForm reinvokerForm(MethodType mtype) {
        int ARG_LIMIT;
        LambdaForm reinvoker = (mtype = mtype.basicType()).form().cachedLambdaForm(8);
        if (reinvoker != null) {
            return reinvoker;
        }
        MethodHandle MH_invokeBasic = MethodHandles.basicInvoker(mtype);
        boolean THIS_BMH = false;
        boolean ARG_BASE = true;
        int nameCursor = ARG_LIMIT = 1 + mtype.parameterCount();
        int NEXT_MH = nameCursor++;
        int REINVOKE = nameCursor++;
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, mtype.invokerType());
        names[NEXT_MH] = new LambdaForm.Name(NF_reinvokerTarget, names[0]);
        Object[] targetArgs = Arrays.copyOfRange(names, 0, ARG_LIMIT, Object[].class);
        targetArgs[0] = names[NEXT_MH];
        names[REINVOKE] = new LambdaForm.Name(MH_invokeBasic, targetArgs);
        return mtype.form().setCachedLambdaForm(8, new LambdaForm("BMH.reinvoke", ARG_LIMIT, names));
    }

    void updateForm(LambdaForm newForm) {
        if (this.form == newForm) {
            return;
        }
        MethodHandleStatics.UNSAFE.putObject((Object)this, FORM_OFFSET, (Object)newForm);
        this.form.prepare();
    }

    static {
        MethodHandleImpl.initStatics();
        try {
            NF_reinvokerTarget = new LambdaForm.NamedFunction(MethodHandle.class.getDeclaredMethod("reinvokerTarget", new Class[0]));
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
        try {
            FORM_OFFSET = MethodHandleStatics.UNSAFE.objectFieldOffset(MethodHandle.class.getDeclaredField("form"));
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface PolymorphicSignature {
    }
}

