/*
 * Decompiled with CFR 0.152.
 */
package sun.util;

import java.lang.ref.SoftReference;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.spi.TimeZoneNameProvider;
import sun.util.LocaleServiceProviderPool;
import sun.util.calendar.ZoneInfo;
import sun.util.resources.LocaleData;
import sun.util.resources.OpenListResourceBundle;

public final class TimeZoneNameUtility {
    private static ConcurrentHashMap<Locale, SoftReference<OpenListResourceBundle>> cachedBundles = new ConcurrentHashMap();
    private static ConcurrentHashMap<Locale, SoftReference<String[][]>> cachedZoneData = new ConcurrentHashMap();

    public static final String[][] getZoneStrings(Locale locale) {
        String[][] zones;
        SoftReference<String[][]> data = cachedZoneData.get(locale);
        if (data == null || (zones = data.get()) == null) {
            zones = TimeZoneNameUtility.loadZoneStrings(locale);
            data = new SoftReference<String[][]>(zones);
            cachedZoneData.put(locale, data);
        }
        return zones;
    }

    private static final String[][] loadZoneStrings(Locale locale) {
        LinkedList<String[]> zones = new LinkedList<String[]>();
        OpenListResourceBundle rb = TimeZoneNameUtility.getBundle(locale);
        Enumeration<String> keys = rb.getKeys();
        String[] names = null;
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            names = TimeZoneNameUtility.retrieveDisplayNames(rb, key, locale);
            if (names == null) continue;
            zones.add(names);
        }
        String[][] zonesArray = new String[zones.size()][];
        return (String[][])zones.toArray((T[])zonesArray);
    }

    public static final String[] retrieveDisplayNames(String id, Locale locale) {
        OpenListResourceBundle rb = TimeZoneNameUtility.getBundle(locale);
        return TimeZoneNameUtility.retrieveDisplayNames(rb, id, locale);
    }

    private static final String[] retrieveDisplayNames(OpenListResourceBundle rb, String id, Locale locale) {
        LocaleServiceProviderPool pool = LocaleServiceProviderPool.getPool(TimeZoneNameProvider.class);
        String[] names = null;
        if (pool.hasProviders()) {
            names = pool.getLocalizedObject(TimeZoneNameGetter.INSTANCE, locale, rb, id, new Object[0]);
        }
        if (names == null) {
            try {
                names = rb.getStringArray(id);
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        return names;
    }

    private static final OpenListResourceBundle getBundle(Locale locale) {
        OpenListResourceBundle rb;
        SoftReference<OpenListResourceBundle> data = cachedBundles.get(locale);
        if (data == null || (rb = data.get()) == null) {
            rb = LocaleData.getTimeZoneNames(locale);
            data = new SoftReference<OpenListResourceBundle>(rb);
            cachedBundles.put(locale, data);
        }
        return rb;
    }

    private static class TimeZoneNameGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<TimeZoneNameProvider, String[]> {
        private static final TimeZoneNameGetter INSTANCE = new TimeZoneNameGetter();

        private TimeZoneNameGetter() {
        }

        @Override
        public String[] getObject(TimeZoneNameProvider timeZoneNameProvider, Locale locale, String requestID, Object ... params) {
            assert (params.length == 0);
            String[] names = null;
            String queryID = requestID;
            if (queryID.equals("GMT")) {
                names = TimeZoneNameGetter.buildZoneStrings(timeZoneNameProvider, locale, queryID);
            } else {
                Map<String, String> aliases = ZoneInfo.getAliasTable();
                if (aliases != null) {
                    if (aliases.containsKey(queryID)) {
                        String prevID = queryID;
                        while ((queryID = aliases.get(queryID)) != null) {
                            prevID = queryID;
                        }
                        queryID = prevID;
                    }
                    if ((names = TimeZoneNameGetter.buildZoneStrings(timeZoneNameProvider, locale, queryID)) == null) {
                        names = TimeZoneNameGetter.examineAliases(timeZoneNameProvider, locale, queryID, aliases, aliases.entrySet());
                    }
                }
            }
            if (names != null) {
                names[0] = requestID;
            }
            return names;
        }

        private static String[] examineAliases(TimeZoneNameProvider tznp, Locale locale, String id, Map<String, String> aliases, Set<Map.Entry<String, String>> aliasesSet) {
            if (aliases.containsValue(id)) {
                for (Map.Entry<String, String> entry : aliasesSet) {
                    if (!entry.getValue().equals(id)) continue;
                    String alias = entry.getKey();
                    String[] names = TimeZoneNameGetter.buildZoneStrings(tznp, locale, alias);
                    if (names != null) {
                        return names;
                    }
                    names = TimeZoneNameGetter.examineAliases(tznp, locale, alias, aliases, aliasesSet);
                    if (names == null) continue;
                    return names;
                }
            }
            return null;
        }

        private static String[] buildZoneStrings(TimeZoneNameProvider tznp, Locale locale, String id) {
            String[] names = new String[5];
            for (int i = 1; i <= 4; ++i) {
                names[i] = tznp.getDisplayName(id, i >= 3, i % 2, locale);
                if (i < 3 || names[i] != null) continue;
                names[i] = names[i - 2];
            }
            if (names[1] == null) {
                names = null;
            }
            return names;
        }
    }
}

