/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import sun.security.util.BitArray;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.Gregorian;

class DerInputBuffer
extends ByteArrayInputStream
implements Cloneable {
    DerInputBuffer(byte[] buf) {
        super(buf);
    }

    DerInputBuffer(byte[] buf, int offset, int len) {
        super(buf, offset, len);
    }

    DerInputBuffer dup() {
        try {
            DerInputBuffer retval = (DerInputBuffer)this.clone();
            retval.mark(Integer.MAX_VALUE);
            return retval;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    byte[] toByteArray() {
        int len = this.available();
        if (len <= 0) {
            return null;
        }
        byte[] retval = new byte[len];
        System.arraycopy(this.buf, this.pos, retval, 0, len);
        return retval;
    }

    int peek() throws IOException {
        if (this.pos >= this.count) {
            throw new IOException("out of data");
        }
        return this.buf[this.pos];
    }

    public boolean equals(Object other) {
        if (other instanceof DerInputBuffer) {
            return this.equals((DerInputBuffer)other);
        }
        return false;
    }

    boolean equals(DerInputBuffer other) {
        if (this == other) {
            return true;
        }
        int max = this.available();
        if (other.available() != max) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            if (this.buf[this.pos + i] == other.buf[other.pos + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int retval = 0;
        int len = this.available();
        int p = this.pos;
        for (int i = 0; i < len; ++i) {
            retval += this.buf[p + i] * i;
        }
        return retval;
    }

    void truncate(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("insufficient data");
        }
        this.count = this.pos + len;
    }

    BigInteger getBigInteger(int len, boolean makePositive) throws IOException {
        if (len > this.available()) {
            throw new IOException("short read of integer");
        }
        if (len == 0) {
            throw new IOException("Invalid encoding: zero length Int value");
        }
        byte[] bytes = new byte[len];
        System.arraycopy(this.buf, this.pos, bytes, 0, len);
        this.skip(len);
        if (makePositive) {
            return new BigInteger(1, bytes);
        }
        return new BigInteger(bytes);
    }

    public int getInteger(int len) throws IOException {
        BigInteger result = this.getBigInteger(len, false);
        if (result.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0) {
            throw new IOException("Integer below minimum valid value");
        }
        if (result.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new IOException("Integer exceeds maximum valid value");
        }
        return result.intValue();
    }

    public byte[] getBitString(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("short read of bit string");
        }
        if (len == 0) {
            throw new IOException("Invalid encoding: zero length bit string");
        }
        byte numOfPadBits = this.buf[this.pos];
        if (numOfPadBits < 0 || numOfPadBits > 7) {
            throw new IOException("Invalid number of padding bits");
        }
        byte[] retval = new byte[len - 1];
        System.arraycopy(this.buf, this.pos + 1, retval, 0, len - 1);
        if (numOfPadBits != 0) {
            int n = len - 2;
            retval[n] = (byte)(retval[n] & 255 << numOfPadBits);
        }
        this.skip(len);
        return retval;
    }

    byte[] getBitString() throws IOException {
        return this.getBitString(this.available());
    }

    BitArray getUnalignedBitString() throws IOException {
        if (this.pos >= this.count) {
            return null;
        }
        int len = this.available();
        int unusedBits = this.buf[this.pos] & 0xFF;
        if (unusedBits > 7) {
            throw new IOException("Invalid value for unused bits: " + unusedBits);
        }
        byte[] bits = new byte[len - 1];
        int length = bits.length == 0 ? 0 : bits.length * 8 - unusedBits;
        System.arraycopy(this.buf, this.pos + 1, bits, 0, len - 1);
        BitArray bitArray = new BitArray(length, bits);
        this.pos = this.count;
        return bitArray;
    }

    public Date getUTCTime(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("short read of DER UTC Time");
        }
        if (len < 11 || len > 17) {
            throw new IOException("DER UTC Time length error");
        }
        return this.getTime(len, false);
    }

    public Date getGeneralizedTime(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("short read of DER Generalized Time");
        }
        if (len < 13 || len > 23) {
            throw new IOException("DER Generalized Time length error");
        }
        return this.getTime(len, true);
    }

    private Date getTime(int len, boolean generalized) throws IOException {
        int second;
        int year;
        String type = null;
        if (generalized) {
            type = "Generalized";
            year = 1000 * Character.digit((char)this.buf[this.pos++], 10);
            year += 100 * Character.digit((char)this.buf[this.pos++], 10);
            year += 10 * Character.digit((char)this.buf[this.pos++], 10);
            year += Character.digit((char)this.buf[this.pos++], 10);
            len -= 2;
        } else {
            type = "UTC";
            year = 10 * Character.digit((char)this.buf[this.pos++], 10);
            year = (year += Character.digit((char)this.buf[this.pos++], 10)) < 50 ? (year += 2000) : (year += 1900);
        }
        int month = 10 * Character.digit((char)this.buf[this.pos++], 10);
        month += Character.digit((char)this.buf[this.pos++], 10);
        int day = 10 * Character.digit((char)this.buf[this.pos++], 10);
        day += Character.digit((char)this.buf[this.pos++], 10);
        int hour = 10 * Character.digit((char)this.buf[this.pos++], 10);
        hour += Character.digit((char)this.buf[this.pos++], 10);
        int minute = 10 * Character.digit((char)this.buf[this.pos++], 10);
        minute += Character.digit((char)this.buf[this.pos++], 10);
        int millis = 0;
        if ((len -= 10) > 2 && len < 12) {
            second = 10 * Character.digit((char)this.buf[this.pos++], 10);
            second += Character.digit((char)this.buf[this.pos++], 10);
            len -= 2;
            if (this.buf[this.pos] == 46 || this.buf[this.pos] == 44) {
                --len;
                ++this.pos;
                int precision = 0;
                int peek = this.pos;
                while (this.buf[peek] != 90 && this.buf[peek] != 43 && this.buf[peek] != 45) {
                    ++peek;
                    ++precision;
                }
                switch (precision) {
                    case 3: {
                        millis += 100 * Character.digit((char)this.buf[this.pos++], 10);
                        millis += 10 * Character.digit((char)this.buf[this.pos++], 10);
                        millis += Character.digit((char)this.buf[this.pos++], 10);
                        break;
                    }
                    case 2: {
                        millis += 100 * Character.digit((char)this.buf[this.pos++], 10);
                        millis += 10 * Character.digit((char)this.buf[this.pos++], 10);
                        break;
                    }
                    case 1: {
                        millis += 100 * Character.digit((char)this.buf[this.pos++], 10);
                        break;
                    }
                    default: {
                        throw new IOException("Parse " + type + " time, unsupported precision for seconds value");
                    }
                }
                len -= precision;
            }
        } else {
            second = 0;
        }
        if (month == 0 || day == 0 || month > 12 || day > 31 || hour >= 24 || minute >= 60 || second >= 60) {
            throw new IOException("Parse " + type + " time, invalid format");
        }
        Gregorian gcal = CalendarSystem.getGregorianCalendar();
        CalendarDate date = ((CalendarSystem)gcal).newCalendarDate(null);
        date.setDate(year, month, day);
        date.setTimeOfDay(hour, minute, second, millis);
        long time = ((CalendarSystem)gcal).getTime(date);
        if (len != 1 && len != 5) {
            throw new IOException("Parse " + type + " time, invalid offset");
        }
        switch (this.buf[this.pos++]) {
            case 43: {
                int hr = 10 * Character.digit((char)this.buf[this.pos++], 10);
                int min = 10 * Character.digit((char)this.buf[this.pos++], 10);
                if ((hr += Character.digit((char)this.buf[this.pos++], 10)) >= 24 || (min += Character.digit((char)this.buf[this.pos++], 10)) >= 60) {
                    throw new IOException("Parse " + type + " time, +hhmm");
                }
                time -= (long)((hr * 60 + min) * 60 * 1000);
                break;
            }
            case 45: {
                int hr = 10 * Character.digit((char)this.buf[this.pos++], 10);
                int min = 10 * Character.digit((char)this.buf[this.pos++], 10);
                if ((hr += Character.digit((char)this.buf[this.pos++], 10)) >= 24 || (min += Character.digit((char)this.buf[this.pos++], 10)) >= 60) {
                    throw new IOException("Parse " + type + " time, -hhmm");
                }
                time += (long)((hr * 60 + min) * 60 * 1000);
                break;
            }
            case 90: {
                break;
            }
            default: {
                throw new IOException("Parse " + type + " time, garbage offset");
            }
        }
        return new Date(time);
    }
}

