/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import java.util.WeakHashMap;
import javax.crypto.BadPaddingException;
import sun.security.jca.JCAUtil;

public final class RSACore {
    private static final boolean ENABLE_BLINDING = true;
    private static final int BLINDING_MAX_REUSE = 50;
    private static final Map<BigInteger, BlindingParameters> blindingCache = new WeakHashMap<BigInteger, BlindingParameters>();

    private RSACore() {
    }

    public static int getByteLength(BigInteger b) {
        int n = b.bitLength();
        return n + 7 >> 3;
    }

    public static int getByteLength(RSAKey key) {
        return RSACore.getByteLength(key.getModulus());
    }

    public static byte[] convert(byte[] b, int ofs, int len) {
        if (ofs == 0 && len == b.length) {
            return b;
        }
        byte[] t = new byte[len];
        System.arraycopy(b, ofs, t, 0, len);
        return t;
    }

    public static byte[] rsa(byte[] msg, RSAPublicKey key) throws BadPaddingException {
        return RSACore.crypt(msg, key.getModulus(), key.getPublicExponent());
    }

    public static byte[] rsa(byte[] msg, RSAPrivateKey key) throws BadPaddingException {
        if (key instanceof RSAPrivateCrtKey) {
            return RSACore.crtCrypt(msg, (RSAPrivateCrtKey)key);
        }
        return RSACore.crypt(msg, key.getModulus(), key.getPrivateExponent());
    }

    private static byte[] crypt(byte[] msg, BigInteger n, BigInteger exp) throws BadPaddingException {
        BigInteger m = RSACore.parseMsg(msg, n);
        BigInteger c = m.modPow(exp, n);
        return RSACore.toByteArray(c, RSACore.getByteLength(n));
    }

    private static byte[] crtCrypt(byte[] msg, RSAPrivateCrtKey key) throws BadPaddingException {
        BigInteger m2;
        BigInteger n = key.getModulus();
        BigInteger c = RSACore.parseMsg(msg, n);
        BigInteger p = key.getPrimeP();
        BigInteger q = key.getPrimeQ();
        BigInteger dP = key.getPrimeExponentP();
        BigInteger dQ = key.getPrimeExponentQ();
        BigInteger qInv = key.getCrtCoefficient();
        BlindingParameters params = RSACore.getBlindingParameters(key);
        BigInteger m1 = (c = c.multiply(params.re).mod(n)).modPow(dP, p);
        BigInteger mtmp = m1.subtract(m2 = c.modPow(dQ, q));
        if (mtmp.signum() < 0) {
            mtmp = mtmp.add(p);
        }
        BigInteger h = mtmp.multiply(qInv).mod(p);
        BigInteger m = h.multiply(q).add(m2);
        if (params != null) {
            m = m.multiply(params.rInv).mod(n);
        }
        return RSACore.toByteArray(m, RSACore.getByteLength(n));
    }

    private static BigInteger parseMsg(byte[] msg, BigInteger n) throws BadPaddingException {
        BigInteger m = new BigInteger(1, msg);
        if (m.compareTo(n) >= 0) {
            throw new BadPaddingException("Message is larger than modulus");
        }
        return m;
    }

    private static byte[] toByteArray(BigInteger bi, int len) {
        byte[] b = bi.toByteArray();
        int n = b.length;
        if (n == len) {
            return b;
        }
        if (n == len + 1 && b[0] == 0) {
            byte[] t = new byte[len];
            System.arraycopy(b, 1, t, 0, len);
            return t;
        }
        assert (n < len);
        byte[] t = new byte[len];
        System.arraycopy(b, 0, t, len - n, n);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BlindingParameters getBlindingParameters(RSAPrivateCrtKey key) {
        BlindingParameters params;
        BigInteger modulus = key.getModulus();
        BigInteger e = key.getPublicExponent();
        Map<BigInteger, BlindingParameters> map = blindingCache;
        synchronized (map) {
            params = blindingCache.get(modulus);
        }
        if (params != null && params.valid(e)) {
            return params;
        }
        int len = modulus.bitLength();
        SecureRandom random = JCAUtil.getSecureRandom();
        BigInteger r = new BigInteger(len, random).mod(modulus);
        BigInteger re = r.modPow(e, modulus);
        BigInteger rInv = r.modInverse(modulus);
        params = new BlindingParameters(e, re, rInv);
        Map<BigInteger, BlindingParameters> map2 = blindingCache;
        synchronized (map2) {
            blindingCache.put(modulus, params);
        }
        return params;
    }

    private static final class BlindingParameters {
        final BigInteger e;
        final BigInteger re;
        final BigInteger rInv;
        private volatile int remainingUses;

        BlindingParameters(BigInteger e, BigInteger re, BigInteger rInv) {
            this.e = e;
            this.re = re;
            this.rInv = rInv;
            this.remainingUses = 49;
        }

        boolean valid(BigInteger e) {
            int k;
            return (k = this.remainingUses--) > 0 && this.e.equals(e);
        }
    }
}

