/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Checksum;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class Authenticator {
    public int authenticator_vno;
    public Realm crealm;
    public PrincipalName cname;
    Checksum cksum;
    public int cusec;
    public KerberosTime ctime;
    EncryptionKey subKey;
    Integer seqNumber;
    public AuthorizationData authorizationData;

    public Authenticator(Realm new_crealm, PrincipalName new_cname, Checksum new_cksum, int new_cusec, KerberosTime new_ctime, EncryptionKey new_subKey, Integer new_seqNumber, AuthorizationData new_authorizationData) {
        this.authenticator_vno = 5;
        this.crealm = new_crealm;
        this.cname = new_cname;
        this.cksum = new_cksum;
        this.cusec = new_cusec;
        this.ctime = new_ctime;
        this.subKey = new_subKey;
        this.seqNumber = new_seqNumber;
        this.authorizationData = new_authorizationData;
    }

    public Authenticator(byte[] data) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        this.init(new DerValue(data));
    }

    public Authenticator(DerValue encoding) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        this.init(encoding);
    }

    private void init(DerValue encoding) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        if ((encoding.getTag() & 0x1F) != 2 || !encoding.isApplication() || !encoding.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if (der.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.authenticator_vno = subDer.getData().getBigInteger().intValue();
        if (this.authenticator_vno != 5) {
            throw new KrbApErrException(39);
        }
        this.crealm = Realm.parse(der.getData(), (byte)1, false);
        this.cname = PrincipalName.parse(der.getData(), (byte)2, false);
        this.cksum = Checksum.parse(der.getData(), (byte)3, true);
        subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) != 4) {
            throw new Asn1Exception(906);
        }
        this.cusec = subDer.getData().getBigInteger().intValue();
        this.ctime = KerberosTime.parse(der.getData(), (byte)5, false);
        if (der.getData().available() > 0) {
            this.subKey = EncryptionKey.parse(der.getData(), (byte)6, true);
        } else {
            this.subKey = null;
            this.seqNumber = null;
            this.authorizationData = null;
        }
        if (der.getData().available() > 0) {
            if ((der.getData().peekByte() & 0x1F) == 7 && ((subDer = der.getData().getDerValue()).getTag() & 0x1F) == 7) {
                this.seqNumber = new Integer(subDer.getData().getBigInteger().intValue());
            }
        } else {
            this.seqNumber = null;
            this.authorizationData = null;
        }
        this.authorizationData = der.getData().available() > 0 ? AuthorizationData.parse(der.getData(), (byte)8, true) : null;
        if (der.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        Vector<DerValue> v = new Vector<DerValue>();
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.authenticator_vno));
        v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)0), temp.toByteArray()));
        v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)1), this.crealm.asn1Encode()));
        v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)2), this.cname.asn1Encode()));
        if (this.cksum != null) {
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)3), this.cksum.asn1Encode()));
        }
        temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.cusec));
        v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)4), temp.toByteArray()));
        v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)5), this.ctime.asn1Encode()));
        if (this.subKey != null) {
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)6), this.subKey.asn1Encode()));
        }
        if (this.seqNumber != null) {
            temp = new DerOutputStream();
            temp.putInteger(BigInteger.valueOf(this.seqNumber.longValue()));
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)7), temp.toByteArray()));
        }
        if (this.authorizationData != null) {
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)8), this.authorizationData.asn1Encode()));
        }
        Object[] der = new DerValue[v.size()];
        v.copyInto(der);
        temp = new DerOutputStream();
        temp.putSequence((DerValue[])der);
        DerOutputStream out = new DerOutputStream();
        out.write(DerValue.createTag((byte)64, true, (byte)2), temp);
        return out.toByteArray();
    }

    public final Checksum getChecksum() {
        return this.cksum;
    }

    public final Integer getSeqNumber() {
        return this.seqNumber;
    }

    public final EncryptionKey getSubKey() {
        return this.subKey;
    }
}

