/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.server.LogStream;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.rmi.runtime.Log;
import sun.rmi.transport.tcp.MultiplexConnectionInfo;
import sun.rmi.transport.tcp.MultiplexInputStream;
import sun.rmi.transport.tcp.MultiplexOutputStream;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPConnection;
import sun.security.action.GetPropertyAction;

final class ConnectionMultiplexer {
    static int logLevel = LogStream.parseLevel(ConnectionMultiplexer.getLogLevel());
    static final Log multiplexLog = Log.getLog("sun.rmi.transport.tcp.multiplex", "multiplex", logLevel);
    private static final int OPEN = 225;
    private static final int CLOSE = 226;
    private static final int CLOSEACK = 227;
    private static final int REQUEST = 228;
    private static final int TRANSMIT = 229;
    private TCPChannel channel;
    private InputStream in;
    private OutputStream out;
    private boolean orig;
    private DataInputStream dataIn;
    private DataOutputStream dataOut;
    private Hashtable<Integer, MultiplexConnectionInfo> connectionTable = new Hashtable(7);
    private int numConnections = 0;
    private static final int maxConnections = 256;
    private int lastID = 4097;
    private boolean alive = true;

    private static String getLogLevel() {
        return AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.tcp.multiplex.logLevel"));
    }

    public ConnectionMultiplexer(TCPChannel channel, InputStream in, OutputStream out, boolean orig) {
        this.channel = channel;
        this.in = in;
        this.out = out;
        this.orig = orig;
        this.dataIn = new DataInputStream(in);
        this.dataOut = new DataOutputStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        try {
            while (true) {
                int op = this.dataIn.readUnsignedByte();
                switch (op) {
                    case 225: {
                        MultiplexConnectionInfo info;
                        int id = this.dataIn.readUnsignedShort();
                        if (multiplexLog.isLoggable(Log.VERBOSE)) {
                            multiplexLog.log(Log.VERBOSE, "operation  OPEN " + id);
                        }
                        if ((info = this.connectionTable.get(id)) != null) {
                            throw new IOException("OPEN: Connection ID already exists");
                        }
                        info = new MultiplexConnectionInfo(id);
                        info.in = new MultiplexInputStream(this, info, 2048);
                        info.out = new MultiplexOutputStream(this, info, 2048);
                        Hashtable<Integer, MultiplexConnectionInfo> hashtable = this.connectionTable;
                        synchronized (hashtable) {
                            this.connectionTable.put(id, info);
                            ++this.numConnections;
                        }
                        TCPConnection conn = new TCPConnection(this.channel, info.in, info.out);
                        this.channel.acceptMultiplexConnection(conn);
                        break;
                    }
                    case 226: {
                        MultiplexConnectionInfo info;
                        int id = this.dataIn.readUnsignedShort();
                        if (multiplexLog.isLoggable(Log.VERBOSE)) {
                            multiplexLog.log(Log.VERBOSE, "operation  CLOSE " + id);
                        }
                        if ((info = this.connectionTable.get(id)) == null) {
                            throw new IOException("CLOSE: Invalid connection ID");
                        }
                        info.in.disconnect();
                        info.out.disconnect();
                        if (!info.closed) {
                            this.sendCloseAck(info);
                        }
                        Hashtable<Integer, MultiplexConnectionInfo> hashtable = this.connectionTable;
                        synchronized (hashtable) {
                            this.connectionTable.remove(id);
                            --this.numConnections;
                            break;
                        }
                    }
                    case 227: {
                        MultiplexConnectionInfo info;
                        int id = this.dataIn.readUnsignedShort();
                        if (multiplexLog.isLoggable(Log.VERBOSE)) {
                            multiplexLog.log(Log.VERBOSE, "operation  CLOSEACK " + id);
                        }
                        if ((info = this.connectionTable.get(id)) == null) {
                            throw new IOException("CLOSEACK: Invalid connection ID");
                        }
                        if (!info.closed) {
                            throw new IOException("CLOSEACK: Connection not closed");
                        }
                        info.in.disconnect();
                        info.out.disconnect();
                        Hashtable<Integer, MultiplexConnectionInfo> hashtable = this.connectionTable;
                        synchronized (hashtable) {
                            this.connectionTable.remove(id);
                            --this.numConnections;
                            break;
                        }
                    }
                    case 228: {
                        int id = this.dataIn.readUnsignedShort();
                        MultiplexConnectionInfo info = this.connectionTable.get(id);
                        if (info == null) {
                            throw new IOException("REQUEST: Invalid connection ID");
                        }
                        int length = this.dataIn.readInt();
                        if (multiplexLog.isLoggable(Log.VERBOSE)) {
                            multiplexLog.log(Log.VERBOSE, "operation  REQUEST " + id + ": " + length);
                        }
                        info.out.request(length);
                        break;
                    }
                    case 229: {
                        int id = this.dataIn.readUnsignedShort();
                        MultiplexConnectionInfo info = this.connectionTable.get(id);
                        if (info == null) {
                            throw new IOException("SEND: Invalid connection ID");
                        }
                        int length = this.dataIn.readInt();
                        if (multiplexLog.isLoggable(Log.VERBOSE)) {
                            multiplexLog.log(Log.VERBOSE, "operation  TRANSMIT " + id + ": " + length);
                        }
                        info.in.receive(length, this.dataIn);
                        break;
                    }
                    default: {
                        throw new IOException("Invalid operation: " + Integer.toHexString(op));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            this.shutDown();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TCPConnection openConnection() throws IOException {
        int id;
        do {
            ++this.lastID;
            this.lastID &= Short.MAX_VALUE;
            id = this.lastID;
            if (!this.orig) continue;
            id |= 0x8000;
        } while (this.connectionTable.get(id) != null);
        MultiplexConnectionInfo info = new MultiplexConnectionInfo(id);
        info.in = new MultiplexInputStream(this, info, 2048);
        info.out = new MultiplexOutputStream(this, info, 2048);
        Object object = this.connectionTable;
        synchronized (object) {
            if (!this.alive) {
                throw new IOException("Multiplexer connection dead");
            }
            if (this.numConnections >= 256) {
                throw new IOException("Cannot exceed 256 simultaneous multiplexed connections");
            }
            this.connectionTable.put(id, info);
            ++this.numConnections;
        }
        object = this.dataOut;
        synchronized (object) {
            try {
                this.dataOut.writeByte(225);
                this.dataOut.writeShort(id);
                this.dataOut.flush();
            }
            catch (IOException e) {
                multiplexLog.log(Log.BRIEF, "exception: ", e);
                this.shutDown();
                throw e;
            }
        }
        return new TCPConnection(this.channel, info.in, info.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Hashtable<Integer, MultiplexConnectionInfo> hashtable = this.connectionTable;
        synchronized (hashtable) {
            if (!this.alive) {
                return;
            }
            this.alive = false;
            Enumeration<MultiplexConnectionInfo> enum_ = this.connectionTable.elements();
            while (enum_.hasMoreElements()) {
                MultiplexConnectionInfo info = enum_.nextElement();
                info.in.disconnect();
                info.out.disconnect();
            }
            this.connectionTable.clear();
            this.numConnections = 0;
        }
        try {
            this.in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRequest(MultiplexConnectionInfo info, int len) throws IOException {
        DataOutputStream dataOutputStream = this.dataOut;
        synchronized (dataOutputStream) {
            if (this.alive && !info.closed) {
                try {
                    this.dataOut.writeByte(228);
                    this.dataOut.writeShort(info.id);
                    this.dataOut.writeInt(len);
                    this.dataOut.flush();
                }
                catch (IOException e) {
                    multiplexLog.log(Log.BRIEF, "exception: ", e);
                    this.shutDown();
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendTransmit(MultiplexConnectionInfo info, byte[] buf, int off, int len) throws IOException {
        DataOutputStream dataOutputStream = this.dataOut;
        synchronized (dataOutputStream) {
            if (this.alive && !info.closed) {
                try {
                    this.dataOut.writeByte(229);
                    this.dataOut.writeShort(info.id);
                    this.dataOut.writeInt(len);
                    this.dataOut.write(buf, off, len);
                    this.dataOut.flush();
                }
                catch (IOException e) {
                    multiplexLog.log(Log.BRIEF, "exception: ", e);
                    this.shutDown();
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendClose(MultiplexConnectionInfo info) throws IOException {
        info.out.disconnect();
        DataOutputStream dataOutputStream = this.dataOut;
        synchronized (dataOutputStream) {
            if (this.alive && !info.closed) {
                try {
                    this.dataOut.writeByte(226);
                    this.dataOut.writeShort(info.id);
                    this.dataOut.flush();
                    info.closed = true;
                }
                catch (IOException e) {
                    multiplexLog.log(Log.BRIEF, "exception: ", e);
                    this.shutDown();
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendCloseAck(MultiplexConnectionInfo info) throws IOException {
        DataOutputStream dataOutputStream = this.dataOut;
        synchronized (dataOutputStream) {
            if (this.alive && !info.closed) {
                try {
                    this.dataOut.writeByte(227);
                    this.dataOut.writeShort(info.id);
                    this.dataOut.flush();
                    info.closed = true;
                }
                catch (IOException e) {
                    multiplexLog.log(Log.BRIEF, "exception: ", e);
                    this.shutDown();
                    throw e;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutDown();
    }
}

