/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.rmi.server.LogStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import sun.reflect.misc.ReflectUtil;
import sun.rmi.runtime.Log;
import sun.security.action.GetPropertyAction;

public final class LoaderHandler {
    static final int logLevel = LogStream.parseLevel(AccessController.doPrivileged(new GetPropertyAction("sun.rmi.loader.logLevel")));
    static final Log loaderLog = Log.getLog("sun.rmi.loader", "loader", logLevel);
    private static String codebaseProperty = null;
    private static URL[] codebaseURLs;
    private static final Map<ClassLoader, Void> codebaseLoaders;
    private static final HashMap<LoaderKey, LoaderEntry> loaderTable;
    private static final ReferenceQueue<Loader> refQueue;
    private static final Map<String, Object[]> pathToURLsCache;

    private LoaderHandler() {
    }

    private static synchronized URL[] getDefaultCodebaseURLs() throws MalformedURLException {
        if (codebaseURLs == null) {
            codebaseURLs = codebaseProperty != null ? LoaderHandler.pathToURLs(codebaseProperty) : new URL[0];
        }
        return codebaseURLs;
    }

    public static Class<?> loadClass(String codebase, String name, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        if (loaderLog.isLoggable(Log.BRIEF)) {
            loaderLog.log(Log.BRIEF, "name = \"" + name + "\", " + "codebase = \"" + (codebase != null ? codebase : "") + "\"" + (defaultLoader != null ? ", defaultLoader = " + defaultLoader : ""));
        }
        URL[] urls = codebase != null ? LoaderHandler.pathToURLs(codebase) : LoaderHandler.getDefaultCodebaseURLs();
        if (defaultLoader != null) {
            try {
                Class<?> c = LoaderHandler.loadClassForName(name, false, defaultLoader);
                if (loaderLog.isLoggable(Log.VERBOSE)) {
                    loaderLog.log(Log.VERBOSE, "class \"" + name + "\" found via defaultLoader, " + "defined by " + c.getClassLoader());
                }
                return c;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return LoaderHandler.loadClass(urls, name);
    }

    public static String getClassAnnotation(Class<?> cl) {
        ClassLoader loader;
        String name = cl.getName();
        int nameLength = name.length();
        if (nameLength > 0 && name.charAt(0) == '[') {
            int i;
            for (i = 1; nameLength > i && name.charAt(i) == '['; ++i) {
            }
            if (nameLength > i && name.charAt(i) != 'L') {
                return null;
            }
        }
        if ((loader = cl.getClassLoader()) == null || codebaseLoaders.containsKey(loader)) {
            return codebaseProperty;
        }
        String annotation = null;
        if (loader instanceof Loader) {
            annotation = ((Loader)loader).getClassAnnotation();
        } else if (loader instanceof URLClassLoader) {
            try {
                URL[] urls = ((URLClassLoader)loader).getURLs();
                if (urls != null) {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        Permissions perms = new Permissions();
                        for (int i = 0; i < urls.length; ++i) {
                            Permission p = urls[i].openConnection().getPermission();
                            if (p == null || perms.implies(p)) continue;
                            sm.checkPermission(p);
                            perms.add(p);
                        }
                    }
                    annotation = LoaderHandler.urlsToPath(urls);
                }
            }
            catch (IOException | SecurityException e) {
                // empty catch block
            }
        }
        if (annotation != null) {
            return annotation;
        }
        return codebaseProperty;
    }

    public static ClassLoader getClassLoader(String codebase) throws MalformedURLException {
        ClassLoader parent = LoaderHandler.getRMIContextClassLoader();
        URL[] urls = codebase != null ? LoaderHandler.pathToURLs(codebase) : LoaderHandler.getDefaultCodebaseURLs();
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return parent;
        }
        sm.checkPermission(new RuntimePermission("getClassLoader"));
        Loader loader = LoaderHandler.lookupLoader(urls, parent);
        if (loader != null) {
            loader.checkPermissions();
        }
        return loader;
    }

    public static Object getSecurityContext(ClassLoader loader) {
        URL[] urls;
        if (loader instanceof Loader && (urls = ((Loader)loader).getURLs()).length > 0) {
            return urls[0];
        }
        return null;
    }

    public static void registerCodebaseLoader(ClassLoader loader) {
        codebaseLoaders.put(loader, null);
    }

    private static Class<?> loadClass(URL[] urls, String name) throws ClassNotFoundException {
        SecurityManager sm;
        ClassLoader parent = LoaderHandler.getRMIContextClassLoader();
        if (loaderLog.isLoggable(Log.VERBOSE)) {
            loaderLog.log(Log.VERBOSE, "(thread context class loader: " + parent + ")");
        }
        if ((sm = System.getSecurityManager()) == null) {
            try {
                Class<?> c = LoaderHandler.loadClassForName(name, false, parent);
                if (loaderLog.isLoggable(Log.VERBOSE)) {
                    loaderLog.log(Log.VERBOSE, "class \"" + name + "\" found via " + "thread context class loader " + "(no security manager: codebase disabled), " + "defined by " + c.getClassLoader());
                }
                return c;
            }
            catch (ClassNotFoundException e) {
                if (loaderLog.isLoggable(Log.BRIEF)) {
                    loaderLog.log(Log.BRIEF, "class \"" + name + "\" not found via " + "thread context class loader " + "(no security manager: codebase disabled)", e);
                }
                throw new ClassNotFoundException(e.getMessage() + " (no security manager: RMI class loader disabled)", e.getException());
            }
        }
        Loader loader = LoaderHandler.lookupLoader(urls, parent);
        try {
            if (loader != null) {
                loader.checkPermissions();
            }
        }
        catch (SecurityException e) {
            try {
                Class<?> c = LoaderHandler.loadClassForName(name, false, parent);
                if (loaderLog.isLoggable(Log.VERBOSE)) {
                    loaderLog.log(Log.VERBOSE, "class \"" + name + "\" found via " + "thread context class loader " + "(access to codebase denied), " + "defined by " + c.getClassLoader());
                }
                return c;
            }
            catch (ClassNotFoundException unimportant) {
                if (loaderLog.isLoggable(Log.BRIEF)) {
                    loaderLog.log(Log.BRIEF, "class \"" + name + "\" not found via " + "thread context class loader " + "(access to codebase denied)", e);
                }
                throw new ClassNotFoundException("access to class loader denied", e);
            }
        }
        try {
            Class<?> c = LoaderHandler.loadClassForName(name, false, loader);
            if (loaderLog.isLoggable(Log.VERBOSE)) {
                loaderLog.log(Log.VERBOSE, "class \"" + name + "\" " + "found via codebase, " + "defined by " + c.getClassLoader());
            }
            return c;
        }
        catch (ClassNotFoundException e) {
            if (loaderLog.isLoggable(Log.BRIEF)) {
                loaderLog.log(Log.BRIEF, "class \"" + name + "\" not found via codebase", e);
            }
            throw e;
        }
    }

    public static Class<?> loadProxyClass(String codebase, String[] interfaces, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        if (loaderLog.isLoggable(Log.BRIEF)) {
            loaderLog.log(Log.BRIEF, "interfaces = " + Arrays.asList(interfaces) + ", " + "codebase = \"" + (codebase != null ? codebase : "") + "\"" + (defaultLoader != null ? ", defaultLoader = " + defaultLoader : ""));
        }
        ClassLoader parent = LoaderHandler.getRMIContextClassLoader();
        if (loaderLog.isLoggable(Log.VERBOSE)) {
            loaderLog.log(Log.VERBOSE, "(thread context class loader: " + parent + ")");
        }
        URL[] urls = codebase != null ? LoaderHandler.pathToURLs(codebase) : LoaderHandler.getDefaultCodebaseURLs();
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            try {
                Class<?> c = LoaderHandler.loadProxyClass(interfaces, defaultLoader, parent, false);
                if (loaderLog.isLoggable(Log.VERBOSE)) {
                    loaderLog.log(Log.VERBOSE, "(no security manager: codebase disabled) proxy class defined by " + c.getClassLoader());
                }
                return c;
            }
            catch (ClassNotFoundException e) {
                if (loaderLog.isLoggable(Log.BRIEF)) {
                    loaderLog.log(Log.BRIEF, "(no security manager: codebase disabled) proxy class resolution failed", e);
                }
                throw new ClassNotFoundException(e.getMessage() + " (no security manager: RMI class loader disabled)", e.getException());
            }
        }
        Loader loader = LoaderHandler.lookupLoader(urls, parent);
        try {
            if (loader != null) {
                loader.checkPermissions();
            }
        }
        catch (SecurityException e) {
            try {
                Class<?> c = LoaderHandler.loadProxyClass(interfaces, defaultLoader, parent, false);
                if (loaderLog.isLoggable(Log.VERBOSE)) {
                    loaderLog.log(Log.VERBOSE, "(access to codebase denied) proxy class defined by " + c.getClassLoader());
                }
                return c;
            }
            catch (ClassNotFoundException unimportant) {
                if (loaderLog.isLoggable(Log.BRIEF)) {
                    loaderLog.log(Log.BRIEF, "(access to codebase denied) proxy class resolution failed", e);
                }
                throw new ClassNotFoundException("access to class loader denied", e);
            }
        }
        try {
            Class<?> c = LoaderHandler.loadProxyClass(interfaces, defaultLoader, loader, true);
            if (loaderLog.isLoggable(Log.VERBOSE)) {
                loaderLog.log(Log.VERBOSE, "proxy class defined by " + c.getClassLoader());
            }
            return c;
        }
        catch (ClassNotFoundException e) {
            if (loaderLog.isLoggable(Log.BRIEF)) {
                loaderLog.log(Log.BRIEF, "proxy class resolution failed", e);
            }
            throw e;
        }
    }

    private static Class<?> loadProxyClass(String[] interfaceNames, ClassLoader defaultLoader, ClassLoader codebaseLoader, boolean preferCodebase) throws ClassNotFoundException {
        boolean[] nonpublic;
        Class[] classObjs;
        ClassLoader proxyLoader;
        block12: {
            proxyLoader = null;
            classObjs = new Class[interfaceNames.length];
            nonpublic = new boolean[]{false};
            if (defaultLoader != null) {
                block11: {
                    try {
                        proxyLoader = LoaderHandler.loadProxyInterfaces(interfaceNames, defaultLoader, classObjs, nonpublic);
                        if (!loaderLog.isLoggable(Log.VERBOSE)) break block11;
                        ClassLoader[] definingLoaders = new ClassLoader[classObjs.length];
                        for (int i = 0; i < definingLoaders.length; ++i) {
                            definingLoaders[i] = classObjs[i].getClassLoader();
                        }
                        loaderLog.log(Log.VERBOSE, "proxy interfaces found via defaultLoader, defined by " + Arrays.asList(definingLoaders));
                    }
                    catch (ClassNotFoundException e) {
                        break block12;
                    }
                }
                if (!nonpublic[0]) {
                    if (preferCodebase) {
                        try {
                            return Proxy.getProxyClass(codebaseLoader, classObjs);
                        }
                        catch (IllegalArgumentException e) {
                            // empty catch block
                        }
                    }
                    proxyLoader = defaultLoader;
                }
                return LoaderHandler.loadProxyClass(proxyLoader, classObjs);
            }
        }
        nonpublic[0] = false;
        proxyLoader = LoaderHandler.loadProxyInterfaces(interfaceNames, codebaseLoader, classObjs, nonpublic);
        if (loaderLog.isLoggable(Log.VERBOSE)) {
            ClassLoader[] definingLoaders = new ClassLoader[classObjs.length];
            for (int i = 0; i < definingLoaders.length; ++i) {
                definingLoaders[i] = classObjs[i].getClassLoader();
            }
            loaderLog.log(Log.VERBOSE, "proxy interfaces found via codebase, defined by " + Arrays.asList(definingLoaders));
        }
        if (!nonpublic[0]) {
            proxyLoader = codebaseLoader;
        }
        return LoaderHandler.loadProxyClass(proxyLoader, classObjs);
    }

    private static Class<?> loadProxyClass(ClassLoader loader, Class[] interfaces) throws ClassNotFoundException {
        try {
            return Proxy.getProxyClass(loader, interfaces);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException("error creating dynamic proxy class", e);
        }
    }

    private static ClassLoader loadProxyInterfaces(String[] interfaces, ClassLoader loader, Class[] classObjs, boolean[] nonpublic) throws ClassNotFoundException {
        ClassLoader nonpublicLoader = null;
        for (int i = 0; i < interfaces.length; ++i) {
            classObjs[i] = LoaderHandler.loadClassForName(interfaces[i], false, loader);
            Class<?> cl = classObjs[i];
            if (Modifier.isPublic(cl.getModifiers())) continue;
            ClassLoader current = cl.getClassLoader();
            if (loaderLog.isLoggable(Log.VERBOSE)) {
                loaderLog.log(Log.VERBOSE, "non-public interface \"" + interfaces[i] + "\" defined by " + current);
            }
            if (!nonpublic[0]) {
                nonpublicLoader = current;
                nonpublic[0] = true;
                continue;
            }
            if (current == nonpublicLoader) continue;
            throw new IllegalAccessError("non-public interfaces defined in different class loaders");
        }
        return nonpublicLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL[] pathToURLs(String path) throws MalformedURLException {
        Map<String, Object[]> map = pathToURLsCache;
        synchronized (map) {
            Object[] v = pathToURLsCache.get(path);
            if (v != null) {
                return (URL[])v[0];
            }
        }
        StringTokenizer st = new StringTokenizer(path);
        URL[] urls = new URL[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            urls[i] = new URL(st.nextToken());
            ++i;
        }
        Map<String, Object[]> map2 = pathToURLsCache;
        synchronized (map2) {
            pathToURLsCache.put(path, new Object[]{urls, new SoftReference<String>(path)});
        }
        return urls;
    }

    private static String urlsToPath(URL[] urls) {
        if (urls.length == 0) {
            return null;
        }
        if (urls.length == 1) {
            return urls[0].toExternalForm();
        }
        StringBuffer path = new StringBuffer(urls[0].toExternalForm());
        for (int i = 1; i < urls.length; ++i) {
            path.append(' ');
            path.append(urls[i].toExternalForm());
        }
        return path.toString();
    }

    private static ClassLoader getRMIContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Loader lookupLoader(final URL[] urls, final ClassLoader parent) {
        Class<LoaderHandler> clazz = LoaderHandler.class;
        synchronized (LoaderHandler.class) {
            Loader loader;
            LoaderEntry entry;
            while ((entry = (LoaderEntry)refQueue.poll()) != null) {
                if (entry.removed) continue;
                loaderTable.remove(entry.key);
            }
            LoaderKey key = new LoaderKey(urls, parent);
            entry = loaderTable.get(key);
            if (entry == null || (loader = (Loader)entry.get()) == null) {
                if (entry != null) {
                    loaderTable.remove(key);
                    entry.removed = true;
                }
                AccessControlContext acc = LoaderHandler.getLoaderAccessControlContext(urls);
                loader = AccessController.doPrivileged(new PrivilegedAction<Loader>(){

                    @Override
                    public Loader run() {
                        return new Loader(urls, parent);
                    }
                }, acc);
                entry = new LoaderEntry(key, loader);
                loaderTable.put(key, entry);
            }
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return loader;
        }
    }

    private static AccessControlContext getLoaderAccessControlContext(URL[] urls) {
        PermissionCollection perms = AccessController.doPrivileged(new PrivilegedAction<PermissionCollection>(){

            @Override
            public PermissionCollection run() {
                CodeSource codesource = new CodeSource(null, (Certificate[])null);
                Policy p = Policy.getPolicy();
                if (p != null) {
                    return p.getPermissions(codesource);
                }
                return new Permissions();
            }
        });
        perms.add(new RuntimePermission("createClassLoader"));
        perms.add(new PropertyPermission("java.*", "read"));
        LoaderHandler.addPermissionsForURLs(urls, perms, true);
        ProtectionDomain pd = new ProtectionDomain(new CodeSource(urls.length > 0 ? urls[0] : null, (Certificate[])null), perms);
        return new AccessControlContext(new ProtectionDomain[]{pd});
    }

    public static void addPermissionsForURLs(URL[] urls, PermissionCollection perms, boolean forLoader) {
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            try {
                Permission p2;
                URLConnection urlConnection = url.openConnection();
                Permission p = urlConnection.getPermission();
                if (p == null) continue;
                if (p instanceof FilePermission) {
                    String path = p.getName();
                    int endIndex = path.lastIndexOf(File.separatorChar);
                    if (endIndex != -1) {
                        if ((path = path.substring(0, endIndex + 1)).endsWith(File.separator)) {
                            path = path + "-";
                        }
                        if (!perms.implies(p2 = new FilePermission(path, "read"))) {
                            perms.add(p2);
                        }
                        perms.add(new FilePermission(path, "read"));
                        continue;
                    }
                    if (perms.implies(p)) continue;
                    perms.add(p);
                    continue;
                }
                if (!perms.implies(p)) {
                    perms.add(p);
                }
                if (!forLoader) continue;
                URL hostURL = url;
                URLConnection conn = urlConnection;
                while (conn instanceof JarURLConnection) {
                    hostURL = ((JarURLConnection)conn).getJarFileURL();
                    conn = hostURL.openConnection();
                }
                String host = hostURL.getHost();
                if (host == null || !p.implies(new SocketPermission(host, "resolve")) || perms.implies(p2 = new SocketPermission(host, "connect,accept"))) continue;
                perms.add(p2);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private static Class<?> loadClassForName(String name, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        if (loader == null) {
            ReflectUtil.checkPackageAccess(name);
        }
        return Class.forName(name, initialize, loader);
    }

    static {
        String prop = AccessController.doPrivileged(new GetPropertyAction("java.rmi.server.codebase"));
        if (prop != null && prop.trim().length() > 0) {
            codebaseProperty = prop;
        }
        codebaseURLs = null;
        codebaseLoaders = Collections.synchronizedMap(new IdentityHashMap(5));
        for (ClassLoader codebaseLoader = ClassLoader.getSystemClassLoader(); codebaseLoader != null; codebaseLoader = codebaseLoader.getParent()) {
            codebaseLoaders.put(codebaseLoader, null);
        }
        loaderTable = new HashMap(5);
        refQueue = new ReferenceQueue();
        pathToURLsCache = new WeakHashMap<String, Object[]>(5);
    }

    private static class Loader
    extends URLClassLoader {
        private ClassLoader parent;
        private String annotation;
        private Permissions permissions;

        private Loader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
            this.parent = parent;
            this.permissions = new Permissions();
            LoaderHandler.addPermissionsForURLs(urls, this.permissions, false);
            this.annotation = LoaderHandler.urlsToPath(urls);
        }

        public String getClassAnnotation() {
            return this.annotation;
        }

        private void checkPermissions() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                Enumeration<Permission> enum_ = this.permissions.elements();
                while (enum_.hasMoreElements()) {
                    sm.checkPermission(enum_.nextElement());
                }
            }
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codesource) {
            PermissionCollection perms = super.getPermissions(codesource);
            return perms;
        }

        public String toString() {
            return super.toString() + "[\"" + this.annotation + "\"]";
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.parent == null) {
                ReflectUtil.checkPackageAccess(name);
            }
            return super.loadClass(name, resolve);
        }
    }

    private static class LoaderEntry
    extends WeakReference<Loader> {
        public LoaderKey key;
        public boolean removed = false;

        public LoaderEntry(LoaderKey key, Loader loader) {
            super(loader, refQueue);
            this.key = key;
        }
    }

    private static class LoaderKey {
        private URL[] urls;
        private ClassLoader parent;
        private int hashValue;

        public LoaderKey(URL[] urls, ClassLoader parent) {
            this.urls = urls;
            this.parent = parent;
            if (parent != null) {
                this.hashValue = parent.hashCode();
            }
            for (int i = 0; i < urls.length; ++i) {
                this.hashValue ^= urls[i].hashCode();
            }
        }

        public int hashCode() {
            return this.hashValue;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LoaderKey) {
                LoaderKey other = (LoaderKey)obj;
                if (this.parent != other.parent) {
                    return false;
                }
                if (this.urls == other.urls) {
                    return true;
                }
                if (this.urls.length != other.urls.length) {
                    return false;
                }
                for (int i = 0; i < this.urls.length; ++i) {
                    if (this.urls[i].equals(other.urls[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

