/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import com.sun.nio.sctp.SctpSocketOption;
import com.sun.nio.sctp.SctpStandardSocketOptions;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.AlreadyBoundException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Set;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Net;
import sun.nio.ch.SctpStdSocketOption;
import sun.security.action.GetPropertyAction;

public class SctpNet {
    static final String osName = AccessController.doPrivileged(new GetPropertyAction("os.name"));
    private static boolean revealLocalAddress;
    private static volatile boolean propRevealLocalAddr;

    private static boolean IPv4MappedAddresses() {
        return "SunOS".equals(osName);
    }

    static boolean throwAlreadyBoundException() throws IOException {
        throw new AlreadyBoundException();
    }

    static void listen(int fd, int backlog) throws IOException {
        SctpNet.listen0(fd, backlog);
    }

    static int connect(int fd, InetAddress remote, int remotePort) throws IOException {
        return SctpNet.connect0(fd, remote, remotePort);
    }

    static void close(int fd) throws IOException {
        SctpNet.close0(fd);
    }

    static void preClose(int fd) throws IOException {
        SctpNet.preClose0(fd);
    }

    static FileDescriptor socket(boolean oneToOne) throws IOException {
        int nativefd = SctpNet.socket0(oneToOne);
        return IOUtil.newFD(nativefd);
    }

    static void bindx(int fd, InetAddress[] addrs, int port, boolean add) throws IOException {
        SctpNet.bindx(fd, addrs, port, addrs.length, add, SctpNet.IPv4MappedAddresses());
    }

    static Set<SocketAddress> getLocalAddresses(int fd) throws IOException {
        Set<SocketAddress> set = null;
        SocketAddress[] saa = SctpNet.getLocalAddresses0(fd);
        if (saa != null) {
            set = SctpNet.getRevealedLocalAddressSet(saa);
        }
        return set;
    }

    private static Set<SocketAddress> getRevealedLocalAddressSet(SocketAddress[] saa) {
        SecurityManager sm = System.getSecurityManager();
        HashSet<SocketAddress> set = new HashSet<SocketAddress>(saa.length);
        for (SocketAddress sa : saa) {
            set.add(SctpNet.getRevealedLocalAddress(sa, sm));
        }
        return set;
    }

    private static SocketAddress getRevealedLocalAddress(SocketAddress sa, SecurityManager sm) {
        if (sm == null || sa == null) {
            return sa;
        }
        InetSocketAddress ia = (InetSocketAddress)sa;
        if (!propRevealLocalAddr) {
            try {
                revealLocalAddress = Boolean.parseBoolean(AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("jdk.net.revealLocalAddress");
                    }
                }));
            }
            catch (Exception e) {
                // empty catch block
            }
            propRevealLocalAddr = true;
        }
        if (!revealLocalAddress) {
            try {
                sm.checkConnect(ia.getAddress().getHostAddress(), -1);
            }
            catch (SecurityException e) {
                return new InetSocketAddress(InetAddress.getLoopbackAddress(), ia.getPort());
            }
        }
        return sa;
    }

    static Set<SocketAddress> getRemoteAddresses(int fd, int assocId) throws IOException {
        HashSet<SocketAddress> set = null;
        SocketAddress[] saa = SctpNet.getRemoteAddresses0(fd, assocId);
        if (saa != null) {
            set = new HashSet<SocketAddress>(saa.length);
            for (SocketAddress sa : saa) {
                set.add(sa);
            }
        }
        return set;
    }

    static void setSocketOption(int fd, SctpSocketOption name, Object value, int assocId) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Invalid option value");
        }
        Class type = name.type();
        if (!type.isInstance(value)) {
            throw new IllegalArgumentException("Invalid option value");
        }
        if (name.equals(SctpStandardSocketOptions.SCTP_INIT_MAXSTREAMS)) {
            SctpStandardSocketOptions.InitMaxStreams maxStreamValue = (SctpStandardSocketOptions.InitMaxStreams)value;
            SctpNet.setInitMsgOption0(fd, maxStreamValue.maxInStreams(), maxStreamValue.maxOutStreams());
        } else if (name.equals(SctpStandardSocketOptions.SCTP_PRIMARY_ADDR) || name.equals(SctpStandardSocketOptions.SCTP_SET_PEER_PRIMARY_ADDR)) {
            SocketAddress addr = (SocketAddress)value;
            if (addr == null) {
                throw new IllegalArgumentException("Invalid option value");
            }
            Net.checkAddress(addr);
            InetSocketAddress netAddr = (InetSocketAddress)addr;
            if (name.equals(SctpStandardSocketOptions.SCTP_PRIMARY_ADDR)) {
                SctpNet.setPrimAddrOption0(fd, assocId, netAddr.getAddress(), netAddr.getPort());
            } else {
                SctpNet.setPeerPrimAddrOption0(fd, assocId, netAddr.getAddress(), netAddr.getPort(), SctpNet.IPv4MappedAddresses());
            }
        } else if (name.equals(SctpStandardSocketOptions.SCTP_DISABLE_FRAGMENTS) || name.equals(SctpStandardSocketOptions.SCTP_EXPLICIT_COMPLETE) || name.equals(SctpStandardSocketOptions.SCTP_FRAGMENT_INTERLEAVE) || name.equals(SctpStandardSocketOptions.SCTP_NODELAY) || name.equals(SctpStandardSocketOptions.SO_SNDBUF) || name.equals(SctpStandardSocketOptions.SO_RCVBUF) || name.equals(SctpStandardSocketOptions.SO_LINGER)) {
            SctpNet.setIntOption(fd, name, value);
        } else {
            throw new AssertionError((Object)"Unknown socket option");
        }
    }

    static Object getSocketOption(int fd, SctpSocketOption name, int assocId) throws IOException {
        if (name.equals(SctpStandardSocketOptions.SCTP_SET_PEER_PRIMARY_ADDR)) {
            throw new IllegalArgumentException("SCTP_SET_PEER_PRIMARY_ADDR cannot be retrieved");
        }
        if (name.equals(SctpStandardSocketOptions.SCTP_INIT_MAXSTREAMS)) {
            int[] values = new int[2];
            SctpNet.getInitMsgOption0(fd, values);
            return SctpStandardSocketOptions.InitMaxStreams.create(values[0], values[1]);
        }
        if (name.equals(SctpStandardSocketOptions.SCTP_PRIMARY_ADDR)) {
            return SctpNet.getPrimAddrOption0(fd, assocId);
        }
        if (name.equals(SctpStandardSocketOptions.SCTP_DISABLE_FRAGMENTS) || name.equals(SctpStandardSocketOptions.SCTP_EXPLICIT_COMPLETE) || name.equals(SctpStandardSocketOptions.SCTP_FRAGMENT_INTERLEAVE) || name.equals(SctpStandardSocketOptions.SCTP_NODELAY) || name.equals(SctpStandardSocketOptions.SO_SNDBUF) || name.equals(SctpStandardSocketOptions.SO_RCVBUF) || name.equals(SctpStandardSocketOptions.SO_LINGER)) {
            return SctpNet.getIntOption(fd, name);
        }
        throw new AssertionError((Object)"Unknown socket option");
    }

    static void setIntOption(int fd, SctpSocketOption name, Object value) throws IOException {
        boolean b;
        int i;
        if (value == null) {
            throw new IllegalArgumentException("Invalid option value");
        }
        Class type = name.type();
        if (type != Integer.class && type != Boolean.class) {
            throw new AssertionError((Object)"Should not reach here");
        }
        if (name == SctpStandardSocketOptions.SO_RCVBUF || name == SctpStandardSocketOptions.SO_SNDBUF) {
            i = (Integer)value;
            if (i < 0) {
                throw new IllegalArgumentException("Invalid send/receive buffer size");
            }
        } else if (name == SctpStandardSocketOptions.SO_LINGER) {
            i = (Integer)value;
            if (i < 0) {
                value = -1;
            }
            if (i > 65535) {
                value = 65535;
            }
        } else if (name.equals(SctpStandardSocketOptions.SCTP_FRAGMENT_INTERLEAVE) && ((i = ((Integer)value).intValue()) < 0 || i > 2)) {
            throw new IllegalArgumentException("Invalid value for SCTP_FRAGMENT_INTERLEAVE");
        }
        int arg = type == Integer.class ? (Integer)value : ((b = ((Boolean)value).booleanValue()) ? 1 : 0);
        SctpNet.setIntOption0(fd, ((SctpStdSocketOption)name).constValue(), arg);
    }

    static Object getIntOption(int fd, SctpSocketOption name) throws IOException {
        Class type = name.type();
        if (type != Integer.class && type != Boolean.class) {
            throw new AssertionError((Object)"Should not reach here");
        }
        if (!(name instanceof SctpStdSocketOption)) {
            throw new AssertionError((Object)"Should not reach here");
        }
        int value = SctpNet.getIntOption0(fd, ((SctpStdSocketOption)name).constValue());
        if (type == Integer.class) {
            return value;
        }
        return value == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    static void shutdown(int fd, int assocId) throws IOException {
        SctpNet.shutdown0(fd, assocId);
    }

    static FileDescriptor branch(int fd, int assocId) throws IOException {
        int nativefd = SctpNet.branch0(fd, assocId);
        return IOUtil.newFD(nativefd);
    }

    static native int socket0(boolean var0) throws IOException;

    static native void listen0(int var0, int var1) throws IOException;

    static native int connect0(int var0, InetAddress var1, int var2) throws IOException;

    static native void close0(int var0) throws IOException;

    static native void preClose0(int var0) throws IOException;

    static native void bindx(int var0, InetAddress[] var1, int var2, int var3, boolean var4, boolean var5) throws IOException;

    static native int getIntOption0(int var0, int var1) throws IOException;

    static native void setIntOption0(int var0, int var1, int var2) throws IOException;

    static native SocketAddress[] getLocalAddresses0(int var0) throws IOException;

    static native SocketAddress[] getRemoteAddresses0(int var0, int var1) throws IOException;

    static native int branch0(int var0, int var1) throws IOException;

    static native void setPrimAddrOption0(int var0, int var1, InetAddress var2, int var3) throws IOException;

    static native void setPeerPrimAddrOption0(int var0, int var1, InetAddress var2, int var3, boolean var4) throws IOException;

    static native SocketAddress getPrimAddrOption0(int var0, int var1) throws IOException;

    static native void getInitMsgOption0(int var0, int[] var1) throws IOException;

    static native void setInitMsgOption0(int var0, int var1, int var2) throws IOException;

    static native void shutdown0(int var0, int var1);

    static native void init();

    static {
        SctpNet.init();
    }
}

