/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.PollArrayWrapper;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;
import sun.nio.ch.Util;

abstract class AbstractPollSelectorImpl
extends SelectorImpl {
    PollArrayWrapper pollWrapper;
    protected final int INIT_CAP = 10;
    protected SelectionKeyImpl[] channelArray;
    protected int channelOffset = 0;
    protected int totalChannels;
    private boolean closed = false;
    private Object closeLock = new Object();

    AbstractPollSelectorImpl(SelectorProvider sp, int channels, int offset) {
        super(sp);
        this.totalChannels = channels;
        this.channelOffset = offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void putEventOps(SelectionKeyImpl sk, int ops) {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                throw new ClosedSelectorException();
            }
            this.pollWrapper.putEventOps(sk.getIndex(), ops);
        }
    }

    @Override
    public Selector wakeup() {
        this.pollWrapper.interrupt();
        return this;
    }

    @Override
    protected abstract int doSelect(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implClose() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (int i = this.channelOffset; i < this.totalChannels; ++i) {
                SelectionKeyImpl ski = this.channelArray[i];
                assert (ski.getIndex() != -1);
                ski.setIndex(-1);
                this.deregister(ski);
                SelectableChannel selch = this.channelArray[i].channel();
                if (selch.isOpen() || selch.isRegistered()) continue;
                ((SelChImpl)((Object)selch)).kill();
            }
            this.implCloseInterrupt();
            this.pollWrapper.free();
            this.pollWrapper = null;
            this.selectedKeys = null;
            this.channelArray = null;
            this.totalChannels = 0;
        }
    }

    protected abstract void implCloseInterrupt() throws IOException;

    protected int updateSelectedKeys() {
        int numKeysUpdated = 0;
        for (int i = this.channelOffset; i < this.totalChannels; ++i) {
            int rOps = this.pollWrapper.getReventOps(i);
            if (rOps == 0) continue;
            SelectionKeyImpl sk = this.channelArray[i];
            this.pollWrapper.putReventOps(i, 0);
            if (this.selectedKeys.contains(sk)) {
                if (!sk.channel.translateAndSetReadyOps(rOps, sk)) continue;
                ++numKeysUpdated;
                continue;
            }
            sk.channel.translateAndSetReadyOps(rOps, sk);
            if ((sk.nioReadyOps() & sk.nioInterestOps()) == 0) continue;
            this.selectedKeys.add(sk);
            ++numKeysUpdated;
        }
        return numKeysUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implRegister(SelectionKeyImpl ski) {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                throw new ClosedSelectorException();
            }
            if (this.channelArray.length == this.totalChannels) {
                int newSize = this.pollWrapper.totalChannels * 2;
                SelectionKeyImpl[] temp = new SelectionKeyImpl[newSize];
                for (int i = this.channelOffset; i < this.totalChannels; ++i) {
                    temp[i] = this.channelArray[i];
                }
                this.channelArray = temp;
                this.pollWrapper.grow(newSize);
            }
            this.channelArray[this.totalChannels] = ski;
            ski.setIndex(this.totalChannels);
            this.pollWrapper.addEntry(ski.channel);
            ++this.totalChannels;
            this.keys.add(ski);
        }
    }

    @Override
    protected void implDereg(SelectionKeyImpl ski) throws IOException {
        int i = ski.getIndex();
        assert (i >= 0);
        if (i != this.totalChannels - 1) {
            SelectionKeyImpl endChannel;
            this.channelArray[i] = endChannel = this.channelArray[this.totalChannels - 1];
            endChannel.setIndex(i);
            this.pollWrapper.release(i);
            PollArrayWrapper.replaceEntry(this.pollWrapper, this.totalChannels - 1, this.pollWrapper, i);
        } else {
            this.pollWrapper.release(i);
        }
        this.channelArray[this.totalChannels - 1] = null;
        --this.totalChannels;
        --this.pollWrapper.totalChannels;
        ski.setIndex(-1);
        this.keys.remove(ski);
        this.selectedKeys.remove(ski);
        this.deregister(ski);
        SelectableChannel selch = ski.channel();
        if (!selch.isOpen() && !selch.isRegistered()) {
            ((SelChImpl)((Object)selch)).kill();
        }
    }

    static {
        Util.load();
    }
}

