/*
 * Decompiled with CFR 0.152.
 */
package sun.net.smtp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import sun.net.smtp.SmtpClient;

class SmtpPrintStream
extends PrintStream {
    private SmtpClient target;
    private int lastc = 10;

    SmtpPrintStream(OutputStream fos, SmtpClient cl) throws UnsupportedEncodingException {
        super(fos, false, cl.getEncoding());
        this.target = cl;
    }

    @Override
    public void close() {
        if (this.target == null) {
            return;
        }
        if (this.lastc != 10) {
            this.write(10);
        }
        try {
            this.target.issueCommand(".\r\n", 250);
            this.target.message = null;
            this.out = null;
            this.target = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(int b) {
        try {
            if (this.lastc == 10 && b == 46) {
                this.out.write(46);
            }
            if (b == 10 && this.lastc != 13) {
                this.out.write(13);
            }
            this.out.write(b);
            this.lastc = b;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        try {
            int lc = this.lastc;
            while (--len >= 0) {
                int c = b[off++];
                if (lc == 10 && c == 46) {
                    this.out.write(46);
                }
                if (c == 10 && lc != 13) {
                    this.out.write(13);
                }
                this.out.write(c);
                lc = c;
            }
            this.lastc = lc;
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public void print(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.write(s.charAt(i));
        }
    }
}

