/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.plaf.basic.DragRecognitionSupport;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.text.Position;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.FixedHeightLayoutCache;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.VariableHeightLayoutCache;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicTreeUI
extends TreeUI {
    private static final Object BASELINE_COMPONENT_KEY = new Object();
    private static final Actions SHARED_ACTION = new Actions();
    protected transient Icon collapsedIcon;
    protected transient Icon expandedIcon;
    private Color hashColor;
    protected int leftChildIndent;
    protected int rightChildIndent;
    protected int totalChildIndent;
    protected Dimension preferredMinSize;
    protected int lastSelectedRow;
    protected JTree tree;
    protected transient TreeCellRenderer currentCellRenderer;
    protected boolean createdRenderer;
    protected transient TreeCellEditor cellEditor;
    protected boolean createdCellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected boolean validCachedPreferredSize;
    protected AbstractLayoutCache treeState;
    protected Hashtable<TreePath, Boolean> drawingCache;
    protected boolean largeModel;
    protected AbstractLayoutCache.NodeDimensions nodeDimensions;
    protected TreeModel treeModel;
    protected TreeSelectionModel treeSelectionModel;
    protected int depthOffset;
    protected Component editingComponent;
    protected TreePath editingPath;
    protected int editingRow;
    protected boolean editorHasDifferentSize;
    private int leadRow;
    private boolean ignoreLAChange;
    private boolean leftToRight;
    private PropertyChangeListener propertyChangeListener;
    private PropertyChangeListener selectionModelPropertyChangeListener;
    private MouseListener mouseListener;
    private FocusListener focusListener;
    private KeyListener keyListener;
    private ComponentListener componentListener;
    private CellEditorListener cellEditorListener;
    private TreeSelectionListener treeSelectionListener;
    private TreeModelListener treeModelListener;
    private TreeExpansionListener treeExpansionListener;
    private boolean paintLines = true;
    private boolean lineTypeDashed;
    private long timeFactor = 1000L;
    private Handler handler;
    private MouseEvent releaseEvent;
    private static final TransferHandler defaultTransferHandler = new TreeTransferHandler();

    public static ComponentUI createUI(JComponent x) {
        return new BasicTreeUI();
    }

    static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("selectPrevious"));
        map.put(new Actions("selectPreviousChangeLead"));
        map.put(new Actions("selectPreviousExtendSelection"));
        map.put(new Actions("selectNext"));
        map.put(new Actions("selectNextChangeLead"));
        map.put(new Actions("selectNextExtendSelection"));
        map.put(new Actions("selectChild"));
        map.put(new Actions("selectChildChangeLead"));
        map.put(new Actions("selectParent"));
        map.put(new Actions("selectParentChangeLead"));
        map.put(new Actions("scrollUpChangeSelection"));
        map.put(new Actions("scrollUpChangeLead"));
        map.put(new Actions("scrollUpExtendSelection"));
        map.put(new Actions("scrollDownChangeSelection"));
        map.put(new Actions("scrollDownExtendSelection"));
        map.put(new Actions("scrollDownChangeLead"));
        map.put(new Actions("selectFirst"));
        map.put(new Actions("selectFirstChangeLead"));
        map.put(new Actions("selectFirstExtendSelection"));
        map.put(new Actions("selectLast"));
        map.put(new Actions("selectLastChangeLead"));
        map.put(new Actions("selectLastExtendSelection"));
        map.put(new Actions("toggle"));
        map.put(new Actions("cancel"));
        map.put(new Actions("startEditing"));
        map.put(new Actions("selectAll"));
        map.put(new Actions("clearSelection"));
        map.put(new Actions("scrollLeft"));
        map.put(new Actions("scrollRight"));
        map.put(new Actions("scrollLeftExtendSelection"));
        map.put(new Actions("scrollRightExtendSelection"));
        map.put(new Actions("scrollRightChangeLead"));
        map.put(new Actions("scrollLeftChangeLead"));
        map.put(new Actions("expand"));
        map.put(new Actions("collapse"));
        map.put(new Actions("moveSelectionToParent"));
        map.put(new Actions("addToSelection"));
        map.put(new Actions("toggleAndAnchor"));
        map.put(new Actions("extendTo"));
        map.put(new Actions("moveSelectionTo"));
        map.put(TransferHandler.getCutAction());
        map.put(TransferHandler.getCopyAction());
        map.put(TransferHandler.getPasteAction());
    }

    protected Color getHashColor() {
        return this.hashColor;
    }

    protected void setHashColor(Color color) {
        this.hashColor = color;
    }

    public void setLeftChildIndent(int newAmount) {
        this.leftChildIndent = newAmount;
        this.totalChildIndent = this.leftChildIndent + this.rightChildIndent;
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
        this.updateSize();
    }

    public int getLeftChildIndent() {
        return this.leftChildIndent;
    }

    public void setRightChildIndent(int newAmount) {
        this.rightChildIndent = newAmount;
        this.totalChildIndent = this.leftChildIndent + this.rightChildIndent;
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
        this.updateSize();
    }

    public int getRightChildIndent() {
        return this.rightChildIndent;
    }

    public void setExpandedIcon(Icon newG) {
        this.expandedIcon = newG;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public void setCollapsedIcon(Icon newG) {
        this.collapsedIcon = newG;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    protected void setLargeModel(boolean largeModel) {
        if (this.getRowHeight() < 1) {
            largeModel = false;
        }
        if (this.largeModel != largeModel) {
            this.completeEditing();
            this.largeModel = largeModel;
            this.treeState = this.createLayoutCache();
            this.configureLayoutCache();
            this.updateLayoutCacheExpandedNodesIfNecessary();
            this.updateSize();
        }
    }

    protected boolean isLargeModel() {
        return this.largeModel;
    }

    protected void setRowHeight(int rowHeight) {
        this.completeEditing();
        if (this.treeState != null) {
            this.setLargeModel(this.tree.isLargeModel());
            this.treeState.setRowHeight(rowHeight);
            this.updateSize();
        }
    }

    protected int getRowHeight() {
        return this.tree == null ? -1 : this.tree.getRowHeight();
    }

    protected void setCellRenderer(TreeCellRenderer tcr) {
        this.completeEditing();
        this.updateRenderer();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected TreeCellRenderer getCellRenderer() {
        return this.currentCellRenderer;
    }

    protected void setModel(TreeModel model) {
        this.completeEditing();
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        this.treeModel = model;
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        if (this.treeState != null) {
            this.treeState.setModel(model);
            this.updateLayoutCacheExpandedNodesIfNecessary();
            this.updateSize();
        }
    }

    protected TreeModel getModel() {
        return this.treeModel;
    }

    protected void setRootVisible(boolean newValue) {
        this.completeEditing();
        this.updateDepthOffset();
        if (this.treeState != null) {
            this.treeState.setRootVisible(newValue);
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected boolean isRootVisible() {
        return this.tree != null ? this.tree.isRootVisible() : false;
    }

    protected void setShowsRootHandles(boolean newValue) {
        this.completeEditing();
        this.updateDepthOffset();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected boolean getShowsRootHandles() {
        return this.tree != null ? this.tree.getShowsRootHandles() : false;
    }

    protected void setCellEditor(TreeCellEditor editor) {
        this.updateCellEditor();
    }

    protected TreeCellEditor getCellEditor() {
        return this.tree != null ? this.tree.getCellEditor() : null;
    }

    protected void setEditable(boolean newValue) {
        this.updateCellEditor();
    }

    protected boolean isEditable() {
        return this.tree != null ? this.tree.isEditable() : false;
    }

    protected void setSelectionModel(TreeSelectionModel newLSM) {
        this.completeEditing();
        if (this.selectionModelPropertyChangeListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        if (this.treeSelectionListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removeTreeSelectionListener(this.treeSelectionListener);
        }
        this.treeSelectionModel = newLSM;
        if (this.treeSelectionModel != null) {
            if (this.selectionModelPropertyChangeListener != null) {
                this.treeSelectionModel.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
            }
            if (this.treeSelectionListener != null) {
                this.treeSelectionModel.addTreeSelectionListener(this.treeSelectionListener);
            }
            if (this.treeState != null) {
                this.treeState.setSelectionModel(this.treeSelectionModel);
            }
        } else if (this.treeState != null) {
            this.treeState.setSelectionModel(null);
        }
        if (this.tree != null) {
            this.tree.repaint();
        }
    }

    protected TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    @Override
    public Rectangle getPathBounds(JTree tree, TreePath path) {
        if (tree != null && this.treeState != null) {
            return this.getPathBounds(path, tree.getInsets(), new Rectangle());
        }
        return null;
    }

    private Rectangle getPathBounds(TreePath path, Insets insets, Rectangle bounds) {
        if ((bounds = this.treeState.getBounds(path, bounds)) != null) {
            bounds.x = this.leftToRight ? (bounds.x += insets.left) : this.tree.getWidth() - (bounds.x + bounds.width) - insets.right;
            bounds.y += insets.top;
        }
        return bounds;
    }

    @Override
    public TreePath getPathForRow(JTree tree, int row) {
        return this.treeState != null ? this.treeState.getPathForRow(row) : null;
    }

    @Override
    public int getRowForPath(JTree tree, TreePath path) {
        return this.treeState != null ? this.treeState.getRowForPath(path) : -1;
    }

    @Override
    public int getRowCount(JTree tree) {
        return this.treeState != null ? this.treeState.getRowCount() : 0;
    }

    @Override
    public TreePath getClosestPathForLocation(JTree tree, int x, int y) {
        if (tree != null && this.treeState != null) {
            return this.treeState.getPathClosestTo(x, y -= tree.getInsets().top);
        }
        return null;
    }

    @Override
    public boolean isEditing(JTree tree) {
        return this.editingComponent != null;
    }

    @Override
    public boolean stopEditing(JTree tree) {
        if (this.editingComponent != null && this.cellEditor.stopCellEditing()) {
            this.completeEditing(false, false, true);
            return true;
        }
        return false;
    }

    @Override
    public void cancelEditing(JTree tree) {
        if (this.editingComponent != null) {
            this.completeEditing(false, true, false);
        }
    }

    @Override
    public void startEditingAtPath(JTree tree, TreePath path) {
        tree.scrollPathToVisible(path);
        if (path != null && tree.isVisible(path)) {
            this.startEditing(path, null);
        }
    }

    @Override
    public TreePath getEditingPath(JTree tree) {
        return this.editingPath;
    }

    @Override
    public void installUI(JComponent c) {
        if (c == null) {
            throw new NullPointerException("null component passed to BasicTreeUI.installUI()");
        }
        this.tree = (JTree)c;
        this.prepareForUIInstall();
        this.installDefaults();
        this.installKeyboardActions();
        this.installComponents();
        this.installListeners();
        this.completeUIInstall();
    }

    protected void prepareForUIInstall() {
        this.drawingCache = new Hashtable(7);
        this.leftToRight = BasicGraphicsUtils.isLeftToRight(this.tree);
        this.stopEditingInCompleteEditing = true;
        this.lastSelectedRow = -1;
        this.leadRow = -1;
        this.preferredSize = new Dimension();
        this.largeModel = this.tree.isLargeModel();
        if (this.getRowHeight() <= 0) {
            this.largeModel = false;
        }
        this.setModel(this.tree.getModel());
    }

    protected void completeUIInstall() {
        this.setShowsRootHandles(this.tree.getShowsRootHandles());
        this.updateRenderer();
        this.updateDepthOffset();
        this.setSelectionModel(this.tree.getSelectionModel());
        this.treeState = this.createLayoutCache();
        this.configureLayoutCache();
        this.updateSize();
    }

    protected void installDefaults() {
        if (this.tree.getBackground() == null || this.tree.getBackground() instanceof UIResource) {
            this.tree.setBackground(UIManager.getColor("Tree.background"));
        }
        if (this.getHashColor() == null || this.getHashColor() instanceof UIResource) {
            this.setHashColor(UIManager.getColor("Tree.hash"));
        }
        if (this.tree.getFont() == null || this.tree.getFont() instanceof UIResource) {
            this.tree.setFont(UIManager.getFont("Tree.font"));
        }
        this.setExpandedIcon((Icon)UIManager.get("Tree.expandedIcon"));
        this.setCollapsedIcon((Icon)UIManager.get("Tree.collapsedIcon"));
        this.setLeftChildIndent((Integer)UIManager.get("Tree.leftChildIndent"));
        this.setRightChildIndent((Integer)UIManager.get("Tree.rightChildIndent"));
        LookAndFeel.installProperty(this.tree, "rowHeight", UIManager.get("Tree.rowHeight"));
        this.largeModel = this.tree.isLargeModel() && this.tree.getRowHeight() > 0;
        Object scrollsOnExpand = UIManager.get("Tree.scrollsOnExpand");
        if (scrollsOnExpand != null) {
            LookAndFeel.installProperty(this.tree, "scrollsOnExpand", scrollsOnExpand);
        }
        this.paintLines = UIManager.getBoolean("Tree.paintLines");
        this.lineTypeDashed = UIManager.getBoolean("Tree.lineTypeDashed");
        Long l = (Long)UIManager.get("Tree.timeFactor");
        this.timeFactor = l != null ? l : 1000L;
        Object showsRootHandles = UIManager.get("Tree.showsRootHandles");
        if (showsRootHandles != null) {
            LookAndFeel.installProperty(this.tree, "showsRootHandles", showsRootHandles);
        }
    }

    protected void installListeners() {
        TransferHandler th;
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tree.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.tree.addMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.tree.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tree.addFocusListener(this.focusListener);
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.tree.addKeyListener(this.keyListener);
        }
        if ((this.treeExpansionListener = this.createTreeExpansionListener()) != null) {
            this.tree.addTreeExpansionListener(this.treeExpansionListener);
        }
        if ((this.treeModelListener = this.createTreeModelListener()) != null && this.treeModel != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        if ((this.selectionModelPropertyChangeListener = this.createSelectionModelPropertyChangeListener()) != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        if ((this.treeSelectionListener = this.createTreeSelectionListener()) != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.addTreeSelectionListener(this.treeSelectionListener);
        }
        if ((th = this.tree.getTransferHandler()) == null || th instanceof UIResource) {
            this.tree.setTransferHandler(defaultTransferHandler);
            if (this.tree.getDropTarget() instanceof UIResource) {
                this.tree.setDropTarget(null);
            }
        }
        LookAndFeel.installProperty(this.tree, "opaque", Boolean.TRUE);
    }

    protected void installKeyboardActions() {
        InputMap km = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tree, 1, km);
        km = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tree, 0, km);
        LazyActionMap.installLazyActionMap(this.tree, BasicTreeUI.class, "Tree.actionMap");
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)DefaultLookup.get(this.tree, this, "Tree.ancestorInputMap");
        }
        if (condition == 0) {
            InputMap rtlKeyMap;
            InputMap keyMap = (InputMap)DefaultLookup.get(this.tree, this, "Tree.focusInputMap");
            if (this.tree.getComponentOrientation().isLeftToRight() || (rtlKeyMap = (InputMap)DefaultLookup.get(this.tree, this, "Tree.focusInputMap.RightToLeft")) == null) {
                return keyMap;
            }
            rtlKeyMap.setParent(keyMap);
            return rtlKeyMap;
        }
        return null;
    }

    protected void installComponents() {
        this.rendererPane = this.createCellRendererPane();
        if (this.rendererPane != null) {
            this.tree.add(this.rendererPane);
        }
    }

    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new NodeDimensionsHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    protected KeyListener createKeyListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createSelectionModelPropertyChangeListener() {
        return this.getHandler();
    }

    protected TreeSelectionListener createTreeSelectionListener() {
        return this.getHandler();
    }

    protected CellEditorListener createCellEditorListener() {
        return this.getHandler();
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected TreeExpansionListener createTreeExpansionListener() {
        return this.getHandler();
    }

    protected AbstractLayoutCache createLayoutCache() {
        if (this.isLargeModel() && this.getRowHeight() > 0) {
            return new FixedHeightLayoutCache();
        }
        return new VariableHeightLayoutCache();
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    protected TreeCellEditor createDefaultCellEditor() {
        if (this.currentCellRenderer != null && this.currentCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellEditor editor = new DefaultTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.currentCellRenderer);
            return editor;
        }
        return new DefaultTreeCellEditor(this.tree, null);
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new DefaultTreeCellRenderer();
    }

    protected TreeModelListener createTreeModelListener() {
        return this.getHandler();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.completeEditing();
        this.prepareForUIUninstall();
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    protected void prepareForUIUninstall() {
    }

    protected void completeUIUninstall() {
        if (this.createdRenderer) {
            this.tree.setCellRenderer(null);
        }
        if (this.createdCellEditor) {
            this.tree.setCellEditor(null);
        }
        this.cellEditor = null;
        this.currentCellRenderer = null;
        this.rendererPane = null;
        this.componentListener = null;
        this.propertyChangeListener = null;
        this.mouseListener = null;
        this.focusListener = null;
        this.keyListener = null;
        this.setSelectionModel(null);
        this.treeState = null;
        this.drawingCache = null;
        this.selectionModelPropertyChangeListener = null;
        this.tree = null;
        this.treeModel = null;
        this.treeSelectionModel = null;
        this.treeSelectionListener = null;
        this.treeExpansionListener = null;
    }

    protected void uninstallDefaults() {
        if (this.tree.getTransferHandler() instanceof UIResource) {
            this.tree.setTransferHandler(null);
        }
    }

    protected void uninstallListeners() {
        if (this.componentListener != null) {
            this.tree.removeComponentListener(this.componentListener);
        }
        if (this.propertyChangeListener != null) {
            this.tree.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.mouseListener != null) {
            this.tree.removeMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.tree.removeMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if (this.focusListener != null) {
            this.tree.removeFocusListener(this.focusListener);
        }
        if (this.keyListener != null) {
            this.tree.removeKeyListener(this.keyListener);
        }
        if (this.treeExpansionListener != null) {
            this.tree.removeTreeExpansionListener(this.treeExpansionListener);
        }
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        if (this.selectionModelPropertyChangeListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        if (this.treeSelectionListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removeTreeSelectionListener(this.treeSelectionListener);
        }
        this.handler = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tree, null);
        SwingUtilities.replaceUIInputMap(this.tree, 1, null);
        SwingUtilities.replaceUIInputMap(this.tree, 0, null);
    }

    protected void uninstallComponents() {
        if (this.rendererPane != null) {
            this.tree.remove(this.rendererPane);
        }
    }

    private void redoTheLayout() {
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        int baseline;
        int rowHeight;
        super.getBaseline(c, width, height);
        UIDefaults lafDefaults = UIManager.getLookAndFeelDefaults();
        Component renderer = (Component)lafDefaults.get(BASELINE_COMPONENT_KEY);
        if (renderer == null) {
            TreeCellRenderer tcr = this.createDefaultCellRenderer();
            renderer = tcr.getTreeCellRendererComponent(this.tree, "a", false, false, false, -1, false);
            lafDefaults.put(BASELINE_COMPONENT_KEY, renderer);
        }
        if ((rowHeight = this.tree.getRowHeight()) > 0) {
            baseline = renderer.getBaseline(Integer.MAX_VALUE, rowHeight);
        } else {
            Dimension pref = renderer.getPreferredSize();
            baseline = renderer.getBaseline(pref.width, pref.height);
        }
        return baseline + this.tree.getInsets().top;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        super.getBaselineResizeBehavior(c);
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.tree != c) {
            throw new InternalError("incorrect component");
        }
        if (this.treeState == null) {
            return;
        }
        Rectangle paintBounds = g.getClipBounds();
        Insets insets = this.tree.getInsets();
        TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
        Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
        int row = this.treeState.getRowForPath(initialPath);
        int endY = paintBounds.y + paintBounds.height;
        this.drawingCache.clear();
        if (initialPath != null && paintingEnumerator != null) {
            TreePath parentPath = initialPath;
            for (parentPath = parentPath.getParentPath(); parentPath != null; parentPath = parentPath.getParentPath()) {
                this.paintVerticalPartOfLeg(g, paintBounds, insets, parentPath);
                this.drawingCache.put(parentPath, Boolean.TRUE);
            }
            boolean done = false;
            Rectangle boundsBuffer = new Rectangle();
            boolean rootVisible = this.isRootVisible();
            while (!done && paintingEnumerator.hasMoreElements()) {
                TreePath path = paintingEnumerator.nextElement();
                if (path != null) {
                    boolean isExpanded;
                    boolean hasBeenExpanded;
                    boolean isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                    if (isLeaf) {
                        hasBeenExpanded = false;
                        isExpanded = false;
                    } else {
                        isExpanded = this.treeState.getExpandedState(path);
                        hasBeenExpanded = this.tree.hasBeenExpanded(path);
                    }
                    Rectangle bounds = this.getPathBounds(path, insets, boundsBuffer);
                    if (bounds == null) {
                        return;
                    }
                    parentPath = path.getParentPath();
                    if (parentPath != null) {
                        if (this.drawingCache.get(parentPath) == null) {
                            this.paintVerticalPartOfLeg(g, paintBounds, insets, parentPath);
                            this.drawingCache.put(parentPath, Boolean.TRUE);
                        }
                        this.paintHorizontalPartOfLeg(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    } else if (rootVisible && row == 0) {
                        this.paintHorizontalPartOfLeg(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                        this.paintExpandControl(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    this.paintRow(g, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    if (bounds.y + bounds.height >= endY) {
                        done = true;
                    }
                } else {
                    done = true;
                }
                ++row;
            }
        }
        this.paintDropLine(g);
        this.rendererPane.removeAll();
        this.drawingCache.clear();
    }

    protected boolean isDropLine(JTree.DropLocation loc) {
        return loc != null && loc.getPath() != null && loc.getChildIndex() != -1;
    }

    protected void paintDropLine(Graphics g) {
        JTree.DropLocation loc = this.tree.getDropLocation();
        if (!this.isDropLine(loc)) {
            return;
        }
        Color c = UIManager.getColor("Tree.dropLineColor");
        if (c != null) {
            g.setColor(c);
            Rectangle rect = this.getDropLineRect(loc);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    protected Rectangle getDropLineRect(JTree.DropLocation loc) {
        Rectangle rect;
        TreePath path = loc.getPath();
        int index = loc.getChildIndex();
        boolean ltr = this.leftToRight;
        Insets insets = this.tree.getInsets();
        if (this.tree.getRowCount() == 0) {
            rect = new Rectangle(insets.left, insets.top, this.tree.getWidth() - insets.left - insets.right, 0);
        } else {
            TreeModel model = this.getModel();
            Object root = model.getRoot();
            if (path.getLastPathComponent() == root && index >= model.getChildCount(root)) {
                Rectangle xRect;
                rect = this.tree.getRowBounds(this.tree.getRowCount() - 1);
                rect.y += rect.height;
                if (!this.tree.isRootVisible()) {
                    xRect = this.tree.getRowBounds(0);
                } else if (model.getChildCount(root) == 0) {
                    xRect = this.tree.getRowBounds(0);
                    xRect.x += this.totalChildIndent;
                    xRect.width -= this.totalChildIndent + this.totalChildIndent;
                } else {
                    TreePath lastChildPath = path.pathByAddingChild(model.getChild(root, model.getChildCount(root) - 1));
                    xRect = this.tree.getPathBounds(lastChildPath);
                }
                rect.x = xRect.x;
                rect.width = xRect.width;
            } else {
                rect = this.tree.getPathBounds(path.pathByAddingChild(model.getChild(path.getLastPathComponent(), index)));
            }
        }
        if (rect.y != 0) {
            --rect.y;
        }
        if (!ltr) {
            rect.x = rect.x + rect.width - 100;
        }
        rect.width = 100;
        rect.height = 2;
        return rect;
    }

    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (!this.paintLines) {
            return;
        }
        int depth = path.getPathCount() - 1;
        if ((depth == 0 || depth == 1 && !this.isRootVisible()) && !this.getShowsRootHandles()) {
            return;
        }
        int clipLeft = clipBounds.x;
        int clipRight = clipBounds.x + clipBounds.width;
        int clipTop = clipBounds.y;
        int clipBottom = clipBounds.y + clipBounds.height;
        int lineY = bounds.y + bounds.height / 2;
        if (this.leftToRight) {
            int leftX = bounds.x - this.getRightChildIndent();
            int nodeX = bounds.x - this.getHorizontalLegBuffer();
            if (lineY >= clipTop && lineY < clipBottom && nodeX >= clipLeft && leftX < clipRight && leftX < nodeX) {
                g.setColor(this.getHashColor());
                this.paintHorizontalLine(g, this.tree, lineY, leftX, nodeX - 1);
            }
        } else {
            int nodeX = bounds.x + bounds.width + this.getHorizontalLegBuffer();
            int rightX = bounds.x + bounds.width + this.getRightChildIndent();
            if (lineY >= clipTop && lineY < clipBottom && rightX >= clipLeft && nodeX < clipRight && nodeX < rightX) {
                g.setColor(this.getHashColor());
                this.paintHorizontalLine(g, this.tree, lineY, nodeX, rightX - 1);
            }
        }
    }

    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        if (!this.paintLines) {
            return;
        }
        int depth = path.getPathCount() - 1;
        if (depth == 0 && !this.getShowsRootHandles() && !this.isRootVisible()) {
            return;
        }
        int lineX = this.getRowX(-1, depth + 1);
        lineX = this.leftToRight ? lineX - this.getRightChildIndent() + insets.left : this.tree.getWidth() - lineX - insets.right + this.getRightChildIndent() - 1;
        int clipLeft = clipBounds.x;
        int clipRight = clipBounds.x + (clipBounds.width - 1);
        if (lineX >= clipLeft && lineX <= clipRight) {
            int bottom;
            Object root;
            TreeModel model;
            int clipTop = clipBounds.y;
            int clipBottom = clipBounds.y + clipBounds.height;
            Rectangle parentBounds = this.getPathBounds(this.tree, path);
            Rectangle lastChildBounds = this.getPathBounds(this.tree, this.getLastChildPath(path));
            if (lastChildBounds == null) {
                return;
            }
            int top = parentBounds == null ? Math.max(insets.top + this.getVerticalLegBuffer(), clipTop) : Math.max(parentBounds.y + parentBounds.height + this.getVerticalLegBuffer(), clipTop);
            if (depth == 0 && !this.isRootVisible() && (model = this.getModel()) != null && model.getChildCount(root = model.getRoot()) > 0 && (parentBounds = this.getPathBounds(this.tree, path.pathByAddingChild(model.getChild(root, 0)))) != null) {
                top = Math.max(insets.top + this.getVerticalLegBuffer(), parentBounds.y + parentBounds.height / 2);
            }
            if (top <= (bottom = Math.min(lastChildBounds.y + lastChildBounds.height / 2, clipBottom))) {
                g.setColor(this.getHashColor());
                this.paintVerticalLine(g, this.tree, lineX, top, bottom);
            }
        }
    }

    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        Object value = path.getLastPathComponent();
        if (!(isLeaf || hasBeenExpanded && this.treeModel.getChildCount(value) <= 0)) {
            int middleXOfKnob = this.leftToRight ? bounds.x - this.getRightChildIndent() + 1 : bounds.x + bounds.width + this.getRightChildIndent() - 1;
            int middleYOfKnob = bounds.y + bounds.height / 2;
            if (isExpanded) {
                Icon expandedIcon = this.getExpandedIcon();
                if (expandedIcon != null) {
                    this.drawCentered(this.tree, g, expandedIcon, middleXOfKnob, middleYOfKnob);
                }
            } else {
                Icon collapsedIcon = this.getCollapsedIcon();
                if (collapsedIcon != null) {
                    this.drawCentered(this.tree, g, collapsedIcon, middleXOfKnob, middleYOfKnob);
                }
            }
        }
    }

    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.editingComponent != null && this.editingRow == row) {
            return;
        }
        int leadIndex = this.tree.hasFocus() ? this.getLeadSelectionRow() : -1;
        Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), this.tree.isRowSelected(row), isExpanded, isLeaf, row, leadIndex == row);
        this.rendererPane.paintComponent(g, component, this.tree, bounds.x, bounds.y, bounds.width, bounds.height, true);
    }

    protected boolean shouldPaintExpandControl(TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (isLeaf) {
            return false;
        }
        int depth = path.getPathCount() - 1;
        return depth != 0 && (depth != 1 || this.isRootVisible()) || this.getShowsRootHandles();
    }

    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        if (this.lineTypeDashed) {
            this.drawDashedVerticalLine(g, x, top, bottom);
        } else {
            g.drawLine(x, top, x, bottom);
        }
    }

    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        if (this.lineTypeDashed) {
            this.drawDashedHorizontalLine(g, y, left, right);
        } else {
            g.drawLine(left, y, right, y);
        }
    }

    protected int getVerticalLegBuffer() {
        return 0;
    }

    protected int getHorizontalLegBuffer() {
        return 0;
    }

    private int findCenteredX(int x, int iconWidth) {
        return this.leftToRight ? x - (int)Math.ceil((double)iconWidth / 2.0) : x - (int)Math.floor((double)iconWidth / 2.0);
    }

    protected void drawCentered(Component c, Graphics graphics, Icon icon, int x, int y) {
        icon.paintIcon(c, graphics, this.findCenteredX(x, icon.getIconWidth()), y - icon.getIconHeight() / 2);
    }

    protected void drawDashedHorizontalLine(Graphics g, int y, int x1, int x2) {
        x1 += x1 % 2;
        for (int x = x1; x <= x2; x += 2) {
            g.drawLine(x, y, x, y);
        }
    }

    protected void drawDashedVerticalLine(Graphics g, int x, int y1, int y2) {
        y1 += y1 % 2;
        for (int y = y1; y <= y2; y += 2) {
            g.drawLine(x, y, x, y);
        }
    }

    protected int getRowX(int row, int depth) {
        return this.totalChildIndent * (depth + this.depthOffset);
    }

    protected void updateLayoutCacheExpandedNodes() {
        if (this.treeModel != null && this.treeModel.getRoot() != null) {
            this.updateExpandedDescendants(new TreePath(this.treeModel.getRoot()));
        }
    }

    private void updateLayoutCacheExpandedNodesIfNecessary() {
        if (this.treeModel != null && this.treeModel.getRoot() != null) {
            TreePath rootPath = new TreePath(this.treeModel.getRoot());
            if (this.tree.isExpanded(rootPath)) {
                this.updateLayoutCacheExpandedNodes();
            } else {
                this.treeState.setExpandedState(rootPath, false);
            }
        }
    }

    protected void updateExpandedDescendants(TreePath path) {
        this.completeEditing();
        if (this.treeState != null) {
            this.treeState.setExpandedState(path, true);
            Enumeration<TreePath> descendants = this.tree.getExpandedDescendants(path);
            if (descendants != null) {
                while (descendants.hasMoreElements()) {
                    path = descendants.nextElement();
                    this.treeState.setExpandedState(path, true);
                }
            }
            this.updateLeadSelectionRow();
            this.updateSize();
        }
    }

    protected TreePath getLastChildPath(TreePath parent) {
        int childCount;
        if (this.treeModel != null && (childCount = this.treeModel.getChildCount(parent.getLastPathComponent())) > 0) {
            return parent.pathByAddingChild(this.treeModel.getChild(parent.getLastPathComponent(), childCount - 1));
        }
        return null;
    }

    protected void updateDepthOffset() {
        this.depthOffset = this.isRootVisible() ? (this.getShowsRootHandles() ? 1 : 0) : (!this.getShowsRootHandles() ? -1 : 0);
    }

    protected void updateCellEditor() {
        TreeCellEditor newEditor;
        this.completeEditing();
        if (this.tree == null) {
            newEditor = null;
        } else if (this.tree.isEditable()) {
            newEditor = this.tree.getCellEditor();
            if (newEditor == null && (newEditor = this.createDefaultCellEditor()) != null) {
                this.tree.setCellEditor(newEditor);
                this.createdCellEditor = true;
            }
        } else {
            newEditor = null;
        }
        if (newEditor != this.cellEditor) {
            if (this.cellEditor != null && this.cellEditorListener != null) {
                this.cellEditor.removeCellEditorListener(this.cellEditorListener);
            }
            this.cellEditor = newEditor;
            if (this.cellEditorListener == null) {
                this.cellEditorListener = this.createCellEditorListener();
            }
            if (newEditor != null && this.cellEditorListener != null) {
                newEditor.addCellEditorListener(this.cellEditorListener);
            }
            this.createdCellEditor = false;
        }
    }

    protected void updateRenderer() {
        if (this.tree != null) {
            TreeCellRenderer newCellRenderer = this.tree.getCellRenderer();
            if (newCellRenderer == null) {
                this.tree.setCellRenderer(this.createDefaultCellRenderer());
                this.createdRenderer = true;
            } else {
                this.createdRenderer = false;
                this.currentCellRenderer = newCellRenderer;
                if (this.createdCellEditor) {
                    this.tree.setCellEditor(null);
                }
            }
        } else {
            this.createdRenderer = false;
            this.currentCellRenderer = null;
        }
        this.updateCellEditor();
    }

    protected void configureLayoutCache() {
        if (this.treeState != null && this.tree != null) {
            if (this.nodeDimensions == null) {
                this.nodeDimensions = this.createNodeDimensions();
            }
            this.treeState.setNodeDimensions(this.nodeDimensions);
            this.treeState.setRootVisible(this.tree.isRootVisible());
            this.treeState.setRowHeight(this.tree.getRowHeight());
            this.treeState.setSelectionModel(this.getSelectionModel());
            if (this.treeState.getModel() != this.tree.getModel()) {
                this.treeState.setModel(this.tree.getModel());
            }
            this.updateLayoutCacheExpandedNodesIfNecessary();
            if (this.isLargeModel()) {
                if (this.componentListener == null) {
                    this.componentListener = this.createComponentListener();
                    if (this.componentListener != null) {
                        this.tree.addComponentListener(this.componentListener);
                    }
                }
            } else if (this.componentListener != null) {
                this.tree.removeComponentListener(this.componentListener);
                this.componentListener = null;
            }
        } else if (this.componentListener != null) {
            this.tree.removeComponentListener(this.componentListener);
            this.componentListener = null;
        }
    }

    protected void updateSize() {
        this.validCachedPreferredSize = false;
        this.tree.treeDidChange();
    }

    private void updateSize0() {
        this.validCachedPreferredSize = false;
        this.tree.revalidate();
    }

    protected void updateCachedPreferredSize() {
        if (this.treeState != null) {
            Insets i = this.tree.getInsets();
            if (this.isLargeModel()) {
                JScrollPane pane;
                JScrollBar bar;
                Rectangle visRect = this.tree.getVisibleRect();
                if (visRect.x == 0 && visRect.y == 0 && visRect.width == 0 && visRect.height == 0 && this.tree.getVisibleRowCount() > 0) {
                    visRect.width = 1;
                    visRect.height = this.tree.getRowHeight() * this.tree.getVisibleRowCount();
                } else {
                    visRect.x -= i.left;
                    visRect.y -= i.top;
                }
                Container component = SwingUtilities.getUnwrappedParent(this.tree);
                if (component instanceof JViewport && (component = component.getParent()) instanceof JScrollPane && (bar = (pane = (JScrollPane)component).getHorizontalScrollBar()) != null && bar.isVisible()) {
                    int height = bar.getHeight();
                    visRect.y -= height;
                    visRect.height += height;
                }
                this.preferredSize.width = this.treeState.getPreferredWidth(visRect);
            } else {
                this.preferredSize.width = this.treeState.getPreferredWidth(null);
            }
            this.preferredSize.height = this.treeState.getPreferredHeight();
            this.preferredSize.width += i.left + i.right;
            this.preferredSize.height += i.top + i.bottom;
        }
        this.validCachedPreferredSize = true;
    }

    protected void pathWasExpanded(TreePath path) {
        if (this.tree != null) {
            this.tree.fireTreeExpanded(path);
        }
    }

    protected void pathWasCollapsed(TreePath path) {
        if (this.tree != null) {
            this.tree.fireTreeCollapsed(path);
        }
    }

    protected void ensureRowsAreVisible(int beginRow, int endRow) {
        if (this.tree != null && beginRow >= 0 && endRow < this.getRowCount(this.tree)) {
            boolean scrollVert = DefaultLookup.getBoolean(this.tree, this, "Tree.scrollsHorizontallyAndVertically", false);
            if (beginRow == endRow) {
                Rectangle scrollBounds = this.getPathBounds(this.tree, this.getPathForRow(this.tree, beginRow));
                if (scrollBounds != null) {
                    if (!scrollVert) {
                        scrollBounds.x = this.tree.getVisibleRect().x;
                        scrollBounds.width = 1;
                    }
                    this.tree.scrollRectToVisible(scrollBounds);
                }
            } else {
                Rectangle beginRect = this.getPathBounds(this.tree, this.getPathForRow(this.tree, beginRow));
                if (beginRect != null) {
                    Rectangle visRect = this.tree.getVisibleRect();
                    Rectangle testRect = beginRect;
                    int beginY = beginRect.y;
                    int maxY = beginY + visRect.height;
                    for (int counter = beginRow + 1; counter <= endRow; ++counter) {
                        testRect = this.getPathBounds(this.tree, this.getPathForRow(this.tree, counter));
                        if (testRect == null) {
                            return;
                        }
                        if (testRect.y + testRect.height <= maxY) continue;
                        counter = endRow;
                    }
                    this.tree.scrollRectToVisible(new Rectangle(visRect.x, beginY, 1, testRect.y + testRect.height - beginY));
                }
            }
        }
    }

    public void setPreferredMinSize(Dimension newSize) {
        this.preferredMinSize = newSize;
    }

    public Dimension getPreferredMinSize() {
        if (this.preferredMinSize == null) {
            return null;
        }
        return new Dimension(this.preferredMinSize);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getPreferredSize(c, true);
    }

    public Dimension getPreferredSize(JComponent c, boolean checkConsistency) {
        Dimension pSize = this.getPreferredMinSize();
        if (!this.validCachedPreferredSize) {
            this.updateCachedPreferredSize();
        }
        if (this.tree != null) {
            if (pSize != null) {
                return new Dimension(Math.max(pSize.width, this.preferredSize.width), Math.max(pSize.height, this.preferredSize.height));
            }
            return new Dimension(this.preferredSize.width, this.preferredSize.height);
        }
        if (pSize != null) {
            return pSize;
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        if (this.tree != null) {
            return this.getPreferredSize(this.tree);
        }
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    protected void completeEditing() {
        if (this.tree.getInvokesStopCellEditing() && this.stopEditingInCompleteEditing && this.editingComponent != null) {
            this.cellEditor.stopCellEditing();
        }
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean messageStop, boolean messageCancel, boolean messageTree) {
        if (this.stopEditingInCompleteEditing && this.editingComponent != null) {
            Component oldComponent = this.editingComponent;
            TreePath oldPath = this.editingPath;
            TreeCellEditor oldEditor = this.cellEditor;
            Object newValue = oldEditor.getCellEditorValue();
            Rectangle editingBounds = this.getPathBounds(this.tree, this.editingPath);
            boolean requestFocus = this.tree != null && (this.tree.hasFocus() || SwingUtilities.findFocusOwner(this.editingComponent) != null);
            this.editingComponent = null;
            this.editingPath = null;
            if (messageStop) {
                oldEditor.stopCellEditing();
            } else if (messageCancel) {
                oldEditor.cancelCellEditing();
            }
            this.tree.remove(oldComponent);
            if (this.editorHasDifferentSize) {
                this.treeState.invalidatePathBounds(oldPath);
                this.updateSize();
            } else if (editingBounds != null) {
                editingBounds.x = 0;
                editingBounds.width = this.tree.getSize().width;
                this.tree.repaint(editingBounds);
            }
            if (requestFocus) {
                this.tree.requestFocus();
            }
            if (messageTree) {
                this.treeModel.valueForPathChanged(oldPath, newValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startEditingOnRelease(TreePath path, MouseEvent event, MouseEvent releaseEvent) {
        this.releaseEvent = releaseEvent;
        try {
            boolean bl = this.startEditing(path, event);
            return bl;
        }
        finally {
            this.releaseEvent = null;
        }
    }

    protected boolean startEditing(TreePath path, MouseEvent event) {
        if (this.isEditing(this.tree) && this.tree.getInvokesStopCellEditing() && !this.stopEditing(this.tree)) {
            return false;
        }
        this.completeEditing();
        if (this.cellEditor != null && this.tree.isPathEditable(path)) {
            int row = this.getRowForPath(this.tree, path);
            if (this.cellEditor.isCellEditable(event)) {
                this.editingComponent = this.cellEditor.getTreeCellEditorComponent(this.tree, path.getLastPathComponent(), this.tree.isPathSelected(path), this.tree.isExpanded(path), this.treeModel.isLeaf(path.getLastPathComponent()), row);
                Rectangle nodeBounds = this.getPathBounds(this.tree, path);
                if (nodeBounds == null) {
                    return false;
                }
                this.editingRow = row;
                Dimension editorSize = this.editingComponent.getPreferredSize();
                if (editorSize.height != nodeBounds.height && this.getRowHeight() > 0) {
                    editorSize.height = this.getRowHeight();
                }
                if (editorSize.width != nodeBounds.width || editorSize.height != nodeBounds.height) {
                    this.editorHasDifferentSize = true;
                    this.treeState.invalidatePathBounds(path);
                    this.updateSize();
                    nodeBounds = this.getPathBounds(this.tree, path);
                    if (nodeBounds == null) {
                        return false;
                    }
                } else {
                    this.editorHasDifferentSize = false;
                }
                this.tree.add(this.editingComponent);
                this.editingComponent.setBounds(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                this.editingPath = path;
                if (this.editingComponent instanceof JComponent) {
                    ((JComponent)this.editingComponent).revalidate();
                } else {
                    this.editingComponent.validate();
                }
                this.editingComponent.repaint();
                if (this.cellEditor.shouldSelectCell(event)) {
                    this.stopEditingInCompleteEditing = false;
                    this.tree.setSelectionRow(row);
                    this.stopEditingInCompleteEditing = true;
                }
                Component focusedComponent = SwingUtilities2.compositeRequestFocus(this.editingComponent);
                boolean selectAll = true;
                if (event != null) {
                    Point componentPoint = SwingUtilities.convertPoint(this.tree, new Point(event.getX(), event.getY()), this.editingComponent);
                    Component activeComponent = SwingUtilities.getDeepestComponentAt(this.editingComponent, componentPoint.x, componentPoint.y);
                    if (activeComponent != null) {
                        MouseInputHandler handler = new MouseInputHandler(this.tree, activeComponent, event, focusedComponent);
                        if (this.releaseEvent != null) {
                            handler.mouseReleased(this.releaseEvent);
                        }
                        selectAll = false;
                    }
                }
                if (selectAll && focusedComponent instanceof JTextField) {
                    ((JTextField)focusedComponent).selectAll();
                }
                return true;
            }
            this.editingComponent = null;
        }
        return false;
    }

    protected void checkForClickInExpandControl(TreePath path, int mouseX, int mouseY) {
        if (this.isLocationInExpandControl(path, mouseX, mouseY)) {
            this.handleExpandControlClick(path, mouseX, mouseY);
        }
    }

    protected boolean isLocationInExpandControl(TreePath path, int mouseX, int mouseY) {
        if (path != null && !this.treeModel.isLeaf(path.getLastPathComponent())) {
            Insets i = this.tree.getInsets();
            int boxWidth = this.getExpandedIcon() != null ? this.getExpandedIcon().getIconWidth() : 8;
            int boxLeftX = this.getRowX(this.tree.getRowForPath(path), path.getPathCount() - 1);
            boxLeftX = this.leftToRight ? boxLeftX + i.left - this.getRightChildIndent() + 1 : this.tree.getWidth() - boxLeftX - i.right + this.getRightChildIndent() - 1;
            boxLeftX = this.findCenteredX(boxLeftX, boxWidth);
            return mouseX >= boxLeftX && mouseX < boxLeftX + boxWidth;
        }
        return false;
    }

    protected void handleExpandControlClick(TreePath path, int mouseX, int mouseY) {
        this.toggleExpandState(path);
    }

    protected void toggleExpandState(TreePath path) {
        if (!this.tree.isExpanded(path)) {
            int row = this.getRowForPath(this.tree, path);
            this.tree.expandPath(path);
            this.updateSize();
            if (row != -1) {
                if (this.tree.getScrollsOnExpand()) {
                    this.ensureRowsAreVisible(row, row + this.treeState.getVisibleChildCount(path));
                } else {
                    this.ensureRowsAreVisible(row, row);
                }
            }
        } else {
            this.tree.collapsePath(path);
            this.updateSize();
        }
    }

    protected boolean isToggleSelectionEvent(MouseEvent event) {
        return SwingUtilities.isLeftMouseButton(event) && BasicGraphicsUtils.isMenuShortcutKeyDown(event);
    }

    protected boolean isMultiSelectEvent(MouseEvent event) {
        return SwingUtilities.isLeftMouseButton(event) && event.isShiftDown();
    }

    protected boolean isToggleEvent(MouseEvent event) {
        if (!SwingUtilities.isLeftMouseButton(event)) {
            return false;
        }
        int clickCount = this.tree.getToggleClickCount();
        if (clickCount <= 0) {
            return false;
        }
        return event.getClickCount() % clickCount == 0;
    }

    protected void selectPathForEvent(TreePath path, MouseEvent event) {
        if (this.isMultiSelectEvent(event)) {
            int anchorRow;
            TreePath anchor = this.getAnchorSelectionPath();
            int n = anchorRow = anchor == null ? -1 : this.getRowForPath(this.tree, anchor);
            if (anchorRow == -1 || this.tree.getSelectionModel().getSelectionMode() == 1) {
                this.tree.setSelectionPath(path);
            } else {
                int row = this.getRowForPath(this.tree, path);
                TreePath lastAnchorPath = anchor;
                if (this.isToggleSelectionEvent(event)) {
                    if (this.tree.isRowSelected(anchorRow)) {
                        this.tree.addSelectionInterval(anchorRow, row);
                    } else {
                        this.tree.removeSelectionInterval(anchorRow, row);
                        this.tree.addSelectionInterval(row, row);
                    }
                } else if (row < anchorRow) {
                    this.tree.setSelectionInterval(row, anchorRow);
                } else {
                    this.tree.setSelectionInterval(anchorRow, row);
                }
                this.lastSelectedRow = row;
                this.setAnchorSelectionPath(lastAnchorPath);
                this.setLeadSelectionPath(path);
            }
        } else if (this.isToggleSelectionEvent(event)) {
            if (this.tree.isPathSelected(path)) {
                this.tree.removeSelectionPath(path);
            } else {
                this.tree.addSelectionPath(path);
            }
            this.lastSelectedRow = this.getRowForPath(this.tree, path);
            this.setAnchorSelectionPath(path);
            this.setLeadSelectionPath(path);
        } else if (SwingUtilities.isLeftMouseButton(event)) {
            this.tree.setSelectionPath(path);
            if (this.isToggleEvent(event)) {
                this.toggleExpandState(path);
            }
        }
    }

    protected boolean isLeaf(int row) {
        TreePath path = this.getPathForRow(this.tree, row);
        if (path != null) {
            return this.treeModel.isLeaf(path.getLastPathComponent());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAnchorSelectionPath(TreePath newPath) {
        this.ignoreLAChange = true;
        try {
            this.tree.setAnchorSelectionPath(newPath);
        }
        finally {
            this.ignoreLAChange = false;
        }
    }

    private TreePath getAnchorSelectionPath() {
        return this.tree.getAnchorSelectionPath();
    }

    private void setLeadSelectionPath(TreePath newPath) {
        this.setLeadSelectionPath(newPath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLeadSelectionPath(TreePath newPath, boolean repaint) {
        Rectangle bounds = repaint ? this.getPathBounds(this.tree, this.getLeadSelectionPath()) : null;
        this.ignoreLAChange = true;
        try {
            this.tree.setLeadSelectionPath(newPath);
        }
        finally {
            this.ignoreLAChange = false;
        }
        this.leadRow = this.getRowForPath(this.tree, newPath);
        if (repaint) {
            if (bounds != null) {
                this.tree.repaint(this.getRepaintPathBounds(bounds));
            }
            if ((bounds = this.getPathBounds(this.tree, newPath)) != null) {
                this.tree.repaint(this.getRepaintPathBounds(bounds));
            }
        }
    }

    private Rectangle getRepaintPathBounds(Rectangle bounds) {
        if (UIManager.getBoolean("Tree.repaintWholeRow")) {
            bounds.x = 0;
            bounds.width = this.tree.getWidth();
        }
        return bounds;
    }

    private TreePath getLeadSelectionPath() {
        return this.tree.getLeadSelectionPath();
    }

    protected void updateLeadSelectionRow() {
        this.leadRow = this.getRowForPath(this.tree, this.getLeadSelectionPath());
    }

    protected int getLeadSelectionRow() {
        return this.leadRow;
    }

    private void extendSelection(TreePath newLead) {
        TreePath aPath = this.getAnchorSelectionPath();
        int aRow = aPath == null ? -1 : this.getRowForPath(this.tree, aPath);
        int newIndex = this.getRowForPath(this.tree, newLead);
        if (aRow == -1) {
            this.tree.setSelectionRow(newIndex);
        } else {
            if (aRow < newIndex) {
                this.tree.setSelectionInterval(aRow, newIndex);
            } else {
                this.tree.setSelectionInterval(newIndex, aRow);
            }
            this.setAnchorSelectionPath(aPath);
            this.setLeadSelectionPath(newLead);
        }
    }

    private void repaintPath(TreePath path) {
        Rectangle bounds;
        if (path != null && (bounds = this.getPathBounds(this.tree, path)) != null) {
            this.tree.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    private static class Actions
    extends UIAction {
        private static final String SELECT_PREVIOUS = "selectPrevious";
        private static final String SELECT_PREVIOUS_CHANGE_LEAD = "selectPreviousChangeLead";
        private static final String SELECT_PREVIOUS_EXTEND_SELECTION = "selectPreviousExtendSelection";
        private static final String SELECT_NEXT = "selectNext";
        private static final String SELECT_NEXT_CHANGE_LEAD = "selectNextChangeLead";
        private static final String SELECT_NEXT_EXTEND_SELECTION = "selectNextExtendSelection";
        private static final String SELECT_CHILD = "selectChild";
        private static final String SELECT_CHILD_CHANGE_LEAD = "selectChildChangeLead";
        private static final String SELECT_PARENT = "selectParent";
        private static final String SELECT_PARENT_CHANGE_LEAD = "selectParentChangeLead";
        private static final String SCROLL_UP_CHANGE_SELECTION = "scrollUpChangeSelection";
        private static final String SCROLL_UP_CHANGE_LEAD = "scrollUpChangeLead";
        private static final String SCROLL_UP_EXTEND_SELECTION = "scrollUpExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_SELECTION = "scrollDownChangeSelection";
        private static final String SCROLL_DOWN_EXTEND_SELECTION = "scrollDownExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_LEAD = "scrollDownChangeLead";
        private static final String SELECT_FIRST = "selectFirst";
        private static final String SELECT_FIRST_CHANGE_LEAD = "selectFirstChangeLead";
        private static final String SELECT_FIRST_EXTEND_SELECTION = "selectFirstExtendSelection";
        private static final String SELECT_LAST = "selectLast";
        private static final String SELECT_LAST_CHANGE_LEAD = "selectLastChangeLead";
        private static final String SELECT_LAST_EXTEND_SELECTION = "selectLastExtendSelection";
        private static final String TOGGLE = "toggle";
        private static final String CANCEL_EDITING = "cancel";
        private static final String START_EDITING = "startEditing";
        private static final String SELECT_ALL = "selectAll";
        private static final String CLEAR_SELECTION = "clearSelection";
        private static final String SCROLL_LEFT = "scrollLeft";
        private static final String SCROLL_RIGHT = "scrollRight";
        private static final String SCROLL_LEFT_EXTEND_SELECTION = "scrollLeftExtendSelection";
        private static final String SCROLL_RIGHT_EXTEND_SELECTION = "scrollRightExtendSelection";
        private static final String SCROLL_RIGHT_CHANGE_LEAD = "scrollRightChangeLead";
        private static final String SCROLL_LEFT_CHANGE_LEAD = "scrollLeftChangeLead";
        private static final String EXPAND = "expand";
        private static final String COLLAPSE = "collapse";
        private static final String MOVE_SELECTION_TO_PARENT = "moveSelectionToParent";
        private static final String ADD_TO_SELECTION = "addToSelection";
        private static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        private static final String EXTEND_TO = "extendTo";
        private static final String MOVE_SELECTION_TO = "moveSelectionTo";

        Actions() {
            super(null);
        }

        Actions(String key) {
            super(key);
        }

        @Override
        public boolean isEnabled(Object o) {
            if (o instanceof JTree && this.getName() == CANCEL_EDITING) {
                return ((JTree)o).isEditing();
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTree tree = (JTree)e.getSource();
            BasicTreeUI ui = (BasicTreeUI)BasicLookAndFeel.getUIOfType(tree.getUI(), BasicTreeUI.class);
            if (ui == null) {
                return;
            }
            String key = this.getName();
            if (key == SELECT_PREVIOUS) {
                this.increment(tree, ui, -1, false, true);
            } else if (key == SELECT_PREVIOUS_CHANGE_LEAD) {
                this.increment(tree, ui, -1, false, false);
            } else if (key == SELECT_PREVIOUS_EXTEND_SELECTION) {
                this.increment(tree, ui, -1, true, true);
            } else if (key == SELECT_NEXT) {
                this.increment(tree, ui, 1, false, true);
            } else if (key == SELECT_NEXT_CHANGE_LEAD) {
                this.increment(tree, ui, 1, false, false);
            } else if (key == SELECT_NEXT_EXTEND_SELECTION) {
                this.increment(tree, ui, 1, true, true);
            } else if (key == SELECT_CHILD) {
                this.traverse(tree, ui, 1, true);
            } else if (key == SELECT_CHILD_CHANGE_LEAD) {
                this.traverse(tree, ui, 1, false);
            } else if (key == SELECT_PARENT) {
                this.traverse(tree, ui, -1, true);
            } else if (key == SELECT_PARENT_CHANGE_LEAD) {
                this.traverse(tree, ui, -1, false);
            } else if (key == SCROLL_UP_CHANGE_SELECTION) {
                this.page(tree, ui, -1, false, true);
            } else if (key == SCROLL_UP_CHANGE_LEAD) {
                this.page(tree, ui, -1, false, false);
            } else if (key == SCROLL_UP_EXTEND_SELECTION) {
                this.page(tree, ui, -1, true, true);
            } else if (key == SCROLL_DOWN_CHANGE_SELECTION) {
                this.page(tree, ui, 1, false, true);
            } else if (key == SCROLL_DOWN_EXTEND_SELECTION) {
                this.page(tree, ui, 1, true, true);
            } else if (key == SCROLL_DOWN_CHANGE_LEAD) {
                this.page(tree, ui, 1, false, false);
            } else if (key == SELECT_FIRST) {
                this.home(tree, ui, -1, false, true);
            } else if (key == SELECT_FIRST_CHANGE_LEAD) {
                this.home(tree, ui, -1, false, false);
            } else if (key == SELECT_FIRST_EXTEND_SELECTION) {
                this.home(tree, ui, -1, true, true);
            } else if (key == SELECT_LAST) {
                this.home(tree, ui, 1, false, true);
            } else if (key == SELECT_LAST_CHANGE_LEAD) {
                this.home(tree, ui, 1, false, false);
            } else if (key == SELECT_LAST_EXTEND_SELECTION) {
                this.home(tree, ui, 1, true, true);
            } else if (key == TOGGLE) {
                this.toggle(tree, ui);
            } else if (key == CANCEL_EDITING) {
                this.cancelEditing(tree, ui);
            } else if (key == START_EDITING) {
                this.startEditing(tree, ui);
            } else if (key == SELECT_ALL) {
                this.selectAll(tree, ui, true);
            } else if (key == CLEAR_SELECTION) {
                this.selectAll(tree, ui, false);
            } else if (key == ADD_TO_SELECTION) {
                int lead;
                if (ui.getRowCount(tree) > 0 && !tree.isRowSelected(lead = ui.getLeadSelectionRow())) {
                    TreePath aPath = ui.getAnchorSelectionPath();
                    tree.addSelectionRow(lead);
                    ui.setAnchorSelectionPath(aPath);
                }
            } else if (key == TOGGLE_AND_ANCHOR) {
                if (ui.getRowCount(tree) > 0) {
                    int lead = ui.getLeadSelectionRow();
                    TreePath lPath = ui.getLeadSelectionPath();
                    if (!tree.isRowSelected(lead)) {
                        tree.addSelectionRow(lead);
                    } else {
                        tree.removeSelectionRow(lead);
                        ui.setLeadSelectionPath(lPath);
                    }
                    ui.setAnchorSelectionPath(lPath);
                }
            } else if (key == EXTEND_TO) {
                this.extendSelection(tree, ui);
            } else if (key == MOVE_SELECTION_TO) {
                if (ui.getRowCount(tree) > 0) {
                    int lead = ui.getLeadSelectionRow();
                    tree.setSelectionInterval(lead, lead);
                }
            } else if (key == SCROLL_LEFT) {
                this.scroll(tree, ui, 0, -10);
            } else if (key == SCROLL_RIGHT) {
                this.scroll(tree, ui, 0, 10);
            } else if (key == SCROLL_LEFT_EXTEND_SELECTION) {
                this.scrollChangeSelection(tree, ui, -1, true, true);
            } else if (key == SCROLL_RIGHT_EXTEND_SELECTION) {
                this.scrollChangeSelection(tree, ui, 1, true, true);
            } else if (key == SCROLL_RIGHT_CHANGE_LEAD) {
                this.scrollChangeSelection(tree, ui, 1, false, false);
            } else if (key == SCROLL_LEFT_CHANGE_LEAD) {
                this.scrollChangeSelection(tree, ui, -1, false, false);
            } else if (key == EXPAND) {
                this.expand(tree, ui);
            } else if (key == COLLAPSE) {
                this.collapse(tree, ui);
            } else if (key == MOVE_SELECTION_TO_PARENT) {
                this.moveSelectionToParent(tree, ui);
            }
        }

        private void scrollChangeSelection(JTree tree, BasicTreeUI ui, int direction, boolean addToSelection, boolean changeSelection) {
            int rowCount = ui.getRowCount(tree);
            if (rowCount > 0 && ui.treeSelectionModel != null) {
                TreePath newPath;
                Rectangle visRect = tree.getVisibleRect();
                if (direction == -1) {
                    newPath = ui.getClosestPathForLocation(tree, visRect.x, visRect.y);
                    visRect.x = Math.max(0, visRect.x - visRect.width);
                } else {
                    visRect.x = Math.min(Math.max(0, tree.getWidth() - visRect.width), visRect.x + visRect.width);
                    newPath = ui.getClosestPathForLocation(tree, visRect.x, visRect.y + visRect.height);
                }
                tree.scrollRectToVisible(visRect);
                if (addToSelection) {
                    ui.extendSelection(newPath);
                } else if (changeSelection) {
                    tree.setSelectionPath(newPath);
                } else {
                    ui.setLeadSelectionPath(newPath, true);
                }
            }
        }

        private void scroll(JTree component, BasicTreeUI ui, int direction, int amount) {
            Rectangle visRect = component.getVisibleRect();
            Dimension size = component.getSize();
            if (direction == 0) {
                visRect.x += amount;
                visRect.x = Math.max(0, visRect.x);
                visRect.x = Math.min(Math.max(0, size.width - visRect.width), visRect.x);
            } else {
                visRect.y += amount;
                visRect.y = Math.max(0, visRect.y);
                visRect.y = Math.min(Math.max(0, size.width - visRect.height), visRect.y);
            }
            component.scrollRectToVisible(visRect);
        }

        private void extendSelection(JTree tree, BasicTreeUI ui) {
            int lead;
            if (ui.getRowCount(tree) > 0 && (lead = ui.getLeadSelectionRow()) != -1) {
                TreePath leadP = ui.getLeadSelectionPath();
                TreePath aPath = ui.getAnchorSelectionPath();
                int aRow = ui.getRowForPath(tree, aPath);
                if (aRow == -1) {
                    aRow = 0;
                }
                tree.setSelectionInterval(aRow, lead);
                ui.setLeadSelectionPath(leadP);
                ui.setAnchorSelectionPath(aPath);
            }
        }

        private void selectAll(JTree tree, BasicTreeUI ui, boolean selectAll) {
            int rowCount = ui.getRowCount(tree);
            if (rowCount > 0) {
                if (selectAll) {
                    if (tree.getSelectionModel().getSelectionMode() == 1) {
                        int lead = ui.getLeadSelectionRow();
                        if (lead != -1) {
                            tree.setSelectionRow(lead);
                        } else if (tree.getMinSelectionRow() == -1) {
                            tree.setSelectionRow(0);
                            ui.ensureRowsAreVisible(0, 0);
                        }
                        return;
                    }
                    TreePath lastPath = ui.getLeadSelectionPath();
                    TreePath aPath = ui.getAnchorSelectionPath();
                    if (lastPath != null && !tree.isVisible(lastPath)) {
                        lastPath = null;
                    }
                    tree.setSelectionInterval(0, rowCount - 1);
                    if (lastPath != null) {
                        ui.setLeadSelectionPath(lastPath);
                    }
                    if (aPath != null && tree.isVisible(aPath)) {
                        ui.setAnchorSelectionPath(aPath);
                    }
                } else {
                    TreePath lastPath = ui.getLeadSelectionPath();
                    TreePath aPath = ui.getAnchorSelectionPath();
                    tree.clearSelection();
                    ui.setAnchorSelectionPath(aPath);
                    ui.setLeadSelectionPath(lastPath);
                }
            }
        }

        private void startEditing(JTree tree, BasicTreeUI ui) {
            int editRow;
            TreePath lead = ui.getLeadSelectionPath();
            int n = editRow = lead != null ? ui.getRowForPath(tree, lead) : -1;
            if (editRow != -1) {
                tree.startEditingAtPath(lead);
            }
        }

        private void cancelEditing(JTree tree, BasicTreeUI ui) {
            tree.cancelEditing();
        }

        private void toggle(JTree tree, BasicTreeUI ui) {
            int selRow = ui.getLeadSelectionRow();
            if (selRow != -1 && !ui.isLeaf(selRow)) {
                TreePath aPath = ui.getAnchorSelectionPath();
                TreePath lPath = ui.getLeadSelectionPath();
                ui.toggleExpandState(ui.getPathForRow(tree, selRow));
                ui.setAnchorSelectionPath(aPath);
                ui.setLeadSelectionPath(lPath);
            }
        }

        private void expand(JTree tree, BasicTreeUI ui) {
            int selRow = ui.getLeadSelectionRow();
            tree.expandRow(selRow);
        }

        private void collapse(JTree tree, BasicTreeUI ui) {
            int selRow = ui.getLeadSelectionRow();
            tree.collapseRow(selRow);
        }

        private void increment(JTree tree, BasicTreeUI ui, int direction, boolean addToSelection, boolean changeSelection) {
            int rowCount;
            if (!addToSelection && !changeSelection && tree.getSelectionModel().getSelectionMode() != 4) {
                changeSelection = true;
            }
            if (ui.treeSelectionModel != null && (rowCount = tree.getRowCount()) > 0) {
                int selIndex = ui.getLeadSelectionRow();
                int newIndex = selIndex == -1 ? (direction == 1 ? 0 : rowCount - 1) : Math.min(rowCount - 1, Math.max(0, selIndex + direction));
                if (addToSelection && ui.treeSelectionModel.getSelectionMode() != 1) {
                    ui.extendSelection(tree.getPathForRow(newIndex));
                } else if (changeSelection) {
                    tree.setSelectionInterval(newIndex, newIndex);
                } else {
                    ui.setLeadSelectionPath(tree.getPathForRow(newIndex), true);
                }
                ui.ensureRowsAreVisible(newIndex, newIndex);
                ui.lastSelectedRow = newIndex;
            }
        }

        private void traverse(JTree tree, BasicTreeUI ui, int direction, boolean changeSelection) {
            int rowCount;
            if (!changeSelection && tree.getSelectionModel().getSelectionMode() != 4) {
                changeSelection = true;
            }
            if ((rowCount = tree.getRowCount()) > 0) {
                int newIndex;
                int minSelIndex = ui.getLeadSelectionRow();
                if (minSelIndex == -1) {
                    newIndex = 0;
                } else if (direction == 1) {
                    TreePath minSelPath = ui.getPathForRow(tree, minSelIndex);
                    int childCount = tree.getModel().getChildCount(minSelPath.getLastPathComponent());
                    newIndex = -1;
                    if (!ui.isLeaf(minSelIndex)) {
                        if (!tree.isExpanded(minSelIndex)) {
                            ui.toggleExpandState(minSelPath);
                        } else if (childCount > 0) {
                            newIndex = Math.min(minSelIndex + 1, rowCount - 1);
                        }
                    }
                } else if (!ui.isLeaf(minSelIndex) && tree.isExpanded(minSelIndex)) {
                    ui.toggleExpandState(ui.getPathForRow(tree, minSelIndex));
                    newIndex = -1;
                } else {
                    TreePath path = ui.getPathForRow(tree, minSelIndex);
                    newIndex = path != null && path.getPathCount() > 1 ? ui.getRowForPath(tree, path.getParentPath()) : -1;
                }
                if (newIndex != -1) {
                    if (changeSelection) {
                        tree.setSelectionInterval(newIndex, newIndex);
                    } else {
                        ui.setLeadSelectionPath(ui.getPathForRow(tree, newIndex), true);
                    }
                    ui.ensureRowsAreVisible(newIndex, newIndex);
                }
            }
        }

        private void moveSelectionToParent(JTree tree, BasicTreeUI ui) {
            int newIndex;
            int selRow = ui.getLeadSelectionRow();
            TreePath path = ui.getPathForRow(tree, selRow);
            if (path != null && path.getPathCount() > 1 && (newIndex = ui.getRowForPath(tree, path.getParentPath())) != -1) {
                tree.setSelectionInterval(newIndex, newIndex);
                ui.ensureRowsAreVisible(newIndex, newIndex);
            }
        }

        private void page(JTree tree, BasicTreeUI ui, int direction, boolean addToSelection, boolean changeSelection) {
            int rowCount;
            if (!addToSelection && !changeSelection && tree.getSelectionModel().getSelectionMode() != 4) {
                changeSelection = true;
            }
            if ((rowCount = ui.getRowCount(tree)) > 0 && ui.treeSelectionModel != null) {
                Rectangle newRect;
                TreePath newPath;
                Dimension maxSize = tree.getSize();
                TreePath lead = ui.getLeadSelectionPath();
                Rectangle visRect = tree.getVisibleRect();
                if (direction == -1) {
                    newPath = ui.getClosestPathForLocation(tree, visRect.x, visRect.y);
                    if (newPath.equals(lead)) {
                        visRect.y = Math.max(0, visRect.y - visRect.height);
                        newPath = tree.getClosestPathForLocation(visRect.x, visRect.y);
                    }
                } else {
                    visRect.y = Math.min(maxSize.height, visRect.y + visRect.height - 1);
                    newPath = tree.getClosestPathForLocation(visRect.x, visRect.y);
                    if (newPath.equals(lead)) {
                        visRect.y = Math.min(maxSize.height, visRect.y + visRect.height - 1);
                        newPath = tree.getClosestPathForLocation(visRect.x, visRect.y);
                    }
                }
                if ((newRect = ui.getPathBounds(tree, newPath)) != null) {
                    newRect.x = visRect.x;
                    newRect.width = visRect.width;
                    if (direction == -1) {
                        newRect.height = visRect.height;
                    } else {
                        newRect.y -= visRect.height - newRect.height;
                        newRect.height = visRect.height;
                    }
                    if (addToSelection) {
                        ui.extendSelection(newPath);
                    } else if (changeSelection) {
                        tree.setSelectionPath(newPath);
                    } else {
                        ui.setLeadSelectionPath(newPath, true);
                    }
                    tree.scrollRectToVisible(newRect);
                }
            }
        }

        private void home(JTree tree, final BasicTreeUI ui, int direction, boolean addToSelection, boolean changeSelection) {
            int rowCount;
            if (!addToSelection && !changeSelection && tree.getSelectionModel().getSelectionMode() != 4) {
                changeSelection = true;
            }
            if ((rowCount = ui.getRowCount(tree)) > 0) {
                if (direction == -1) {
                    ui.ensureRowsAreVisible(0, 0);
                    if (addToSelection) {
                        int aRow;
                        TreePath aPath = ui.getAnchorSelectionPath();
                        int n = aRow = aPath == null ? -1 : ui.getRowForPath(tree, aPath);
                        if (aRow == -1) {
                            tree.setSelectionInterval(0, 0);
                        } else {
                            tree.setSelectionInterval(0, aRow);
                            ui.setAnchorSelectionPath(aPath);
                            ui.setLeadSelectionPath(ui.getPathForRow(tree, 0));
                        }
                    } else if (changeSelection) {
                        tree.setSelectionInterval(0, 0);
                    } else {
                        ui.setLeadSelectionPath(ui.getPathForRow(tree, 0), true);
                    }
                } else {
                    ui.ensureRowsAreVisible(rowCount - 1, rowCount - 1);
                    if (addToSelection) {
                        int aRow;
                        TreePath aPath = ui.getAnchorSelectionPath();
                        int n = aRow = aPath == null ? -1 : ui.getRowForPath(tree, aPath);
                        if (aRow == -1) {
                            tree.setSelectionInterval(rowCount - 1, rowCount - 1);
                        } else {
                            tree.setSelectionInterval(aRow, rowCount - 1);
                            ui.setAnchorSelectionPath(aPath);
                            ui.setLeadSelectionPath(ui.getPathForRow(tree, rowCount - 1));
                        }
                    } else if (changeSelection) {
                        tree.setSelectionInterval(rowCount - 1, rowCount - 1);
                    } else {
                        ui.setLeadSelectionPath(ui.getPathForRow(tree, rowCount - 1), true);
                    }
                    if (ui.isLargeModel()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ui.ensureRowsAreVisible(rowCount - 1, rowCount - 1);
                            }
                        });
                    }
                }
            }
        }
    }

    private class Handler
    implements CellEditorListener,
    FocusListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    TreeExpansionListener,
    TreeModelListener,
    TreeSelectionListener,
    DragRecognitionSupport.BeforeDrag {
        private String prefix = "";
        private String typedString = "";
        private long lastTime = 0L;
        private boolean dragPressDidSelection;
        private boolean dragStarted;
        private TreePath pressedPath;
        private MouseEvent pressedEvent;
        private boolean valueChangedOnPress;

        private Handler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.getRowCount() > 0 && BasicTreeUI.this.tree.hasFocus() && BasicTreeUI.this.tree.isEnabled()) {
                TreePath path;
                if (e.isAltDown() || BasicGraphicsUtils.isMenuShortcutKeyDown(e) || this.isNavigationKey(e)) {
                    return;
                }
                boolean startingFromSelection = true;
                char c = e.getKeyChar();
                long time = e.getWhen();
                int startingRow = BasicTreeUI.this.tree.getLeadSelectionRow();
                if (time - this.lastTime < BasicTreeUI.this.timeFactor) {
                    this.typedString = this.typedString + c;
                    if (this.prefix.length() == 1 && c == this.prefix.charAt(0)) {
                        ++startingRow;
                    } else {
                        this.prefix = this.typedString;
                    }
                } else {
                    ++startingRow;
                    this.prefix = this.typedString = "" + c;
                }
                this.lastTime = time;
                if (startingRow < 0 || startingRow >= BasicTreeUI.this.tree.getRowCount()) {
                    startingFromSelection = false;
                    startingRow = 0;
                }
                if ((path = BasicTreeUI.this.tree.getNextMatch(this.prefix, startingRow, Position.Bias.Forward)) != null) {
                    BasicTreeUI.this.tree.setSelectionPath(path);
                    int row = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, path);
                    BasicTreeUI.this.ensureRowsAreVisible(row, row);
                } else if (startingFromSelection && (path = BasicTreeUI.this.tree.getNextMatch(this.prefix, 0, Position.Bias.Forward)) != null) {
                    BasicTreeUI.this.tree.setSelectionPath(path);
                    int row = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, path);
                    BasicTreeUI.this.ensureRowsAreVisible(row, row);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (BasicTreeUI.this.tree != null && this.isNavigationKey(e)) {
                this.prefix = "";
                this.typedString = "";
                this.lastTime = 0L;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        private boolean isNavigationKey(KeyEvent event) {
            InputMap inputMap = BasicTreeUI.this.tree.getInputMap(1);
            KeyStroke key = KeyStroke.getKeyStrokeForEvent(event);
            return inputMap != null && inputMap.get(key) != null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getSource() == BasicTreeUI.this.treeSelectionModel) {
                BasicTreeUI.this.treeSelectionModel.resetRowSelection();
            } else if (event.getSource() == BasicTreeUI.this.tree) {
                String changeName = event.getPropertyName();
                if (changeName == "leadSelectionPath") {
                    if (!BasicTreeUI.this.ignoreLAChange) {
                        BasicTreeUI.this.updateLeadSelectionRow();
                        BasicTreeUI.this.repaintPath((TreePath)event.getOldValue());
                        BasicTreeUI.this.repaintPath((TreePath)event.getNewValue());
                    }
                } else if (changeName == "anchorSelectionPath" && !BasicTreeUI.this.ignoreLAChange) {
                    BasicTreeUI.this.repaintPath((TreePath)event.getOldValue());
                    BasicTreeUI.this.repaintPath((TreePath)event.getNewValue());
                }
                if (changeName == "cellRenderer") {
                    BasicTreeUI.this.setCellRenderer((TreeCellRenderer)event.getNewValue());
                    BasicTreeUI.this.redoTheLayout();
                } else if (changeName == "model") {
                    BasicTreeUI.this.setModel((TreeModel)event.getNewValue());
                } else if (changeName == "rootVisible") {
                    BasicTreeUI.this.setRootVisible((Boolean)event.getNewValue());
                } else if (changeName == "showsRootHandles") {
                    BasicTreeUI.this.setShowsRootHandles((Boolean)event.getNewValue());
                } else if (changeName == "rowHeight") {
                    BasicTreeUI.this.setRowHeight((Integer)event.getNewValue());
                } else if (changeName == "cellEditor") {
                    BasicTreeUI.this.setCellEditor((TreeCellEditor)event.getNewValue());
                } else if (changeName == "editable") {
                    BasicTreeUI.this.setEditable((Boolean)event.getNewValue());
                } else if (changeName == "largeModel") {
                    BasicTreeUI.this.setLargeModel(BasicTreeUI.this.tree.isLargeModel());
                } else if (changeName == "selectionModel") {
                    BasicTreeUI.this.setSelectionModel(BasicTreeUI.this.tree.getSelectionModel());
                } else if (changeName == "font") {
                    BasicTreeUI.this.completeEditing();
                    if (BasicTreeUI.this.treeState != null) {
                        BasicTreeUI.this.treeState.invalidateSizes();
                    }
                    BasicTreeUI.this.updateSize();
                } else if (changeName == "componentOrientation") {
                    if (BasicTreeUI.this.tree != null) {
                        BasicTreeUI.this.leftToRight = BasicGraphicsUtils.isLeftToRight(BasicTreeUI.this.tree);
                        BasicTreeUI.this.redoTheLayout();
                        BasicTreeUI.this.tree.treeDidChange();
                        InputMap km = BasicTreeUI.this.getInputMap(0);
                        SwingUtilities.replaceUIInputMap(BasicTreeUI.this.tree, 0, km);
                    }
                } else if ("dropLocation" == changeName) {
                    JTree.DropLocation oldValue = (JTree.DropLocation)event.getOldValue();
                    this.repaintDropLocation(oldValue);
                    this.repaintDropLocation(BasicTreeUI.this.tree.getDropLocation());
                }
            }
        }

        private void repaintDropLocation(JTree.DropLocation loc) {
            if (loc == null) {
                return;
            }
            Rectangle r = BasicTreeUI.this.isDropLine(loc) ? BasicTreeUI.this.getDropLineRect(loc) : BasicTreeUI.this.tree.getPathBounds(loc.getPath());
            if (r != null) {
                BasicTreeUI.this.tree.repaint(r);
            }
        }

        private boolean isActualPath(TreePath path, int x, int y) {
            if (path == null) {
                return false;
            }
            Rectangle bounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, path);
            if (bounds == null || y > bounds.y + bounds.height) {
                return false;
            }
            return x >= bounds.x && x <= bounds.x + bounds.width;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities2.shouldIgnore(e, BasicTreeUI.this.tree)) {
                return;
            }
            if (BasicTreeUI.this.isEditing(BasicTreeUI.this.tree) && BasicTreeUI.this.tree.getInvokesStopCellEditing() && !BasicTreeUI.this.stopEditing(BasicTreeUI.this.tree)) {
                return;
            }
            BasicTreeUI.this.completeEditing();
            this.pressedPath = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, e.getX(), e.getY());
            if (BasicTreeUI.this.tree.getDragEnabled()) {
                this.mousePressedDND(e);
            } else {
                SwingUtilities2.adjustFocus(BasicTreeUI.this.tree);
                this.handleSelection(e);
            }
        }

        private void mousePressedDND(MouseEvent e) {
            this.pressedEvent = e;
            boolean grabFocus = true;
            this.dragStarted = false;
            this.valueChangedOnPress = false;
            if (this.isActualPath(this.pressedPath, e.getX(), e.getY()) && DragRecognitionSupport.mousePressed(e)) {
                this.dragPressDidSelection = false;
                if (BasicGraphicsUtils.isMenuShortcutKeyDown(e)) {
                    return;
                }
                if (!e.isShiftDown() && BasicTreeUI.this.tree.isPathSelected(this.pressedPath)) {
                    BasicTreeUI.this.setAnchorSelectionPath(this.pressedPath);
                    BasicTreeUI.this.setLeadSelectionPath(this.pressedPath, true);
                    return;
                }
                this.dragPressDidSelection = true;
                grabFocus = false;
            }
            if (grabFocus) {
                SwingUtilities2.adjustFocus(BasicTreeUI.this.tree);
            }
            this.handleSelection(e);
        }

        void handleSelection(MouseEvent e) {
            if (this.pressedPath != null) {
                int x;
                Rectangle bounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, this.pressedPath);
                if (bounds == null || e.getY() >= bounds.y + bounds.height) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    BasicTreeUI.this.checkForClickInExpandControl(this.pressedPath, e.getX(), e.getY());
                }
                if ((x = e.getX()) >= bounds.x && x < bounds.x + bounds.width && (BasicTreeUI.this.tree.getDragEnabled() || !BasicTreeUI.this.startEditing(this.pressedPath, e))) {
                    BasicTreeUI.this.selectPathForEvent(this.pressedPath, e);
                }
            }
        }

        @Override
        public void dragStarting(MouseEvent me) {
            this.dragStarted = true;
            if (BasicGraphicsUtils.isMenuShortcutKeyDown(me)) {
                BasicTreeUI.this.tree.addSelectionPath(this.pressedPath);
                BasicTreeUI.this.setAnchorSelectionPath(this.pressedPath);
                BasicTreeUI.this.setLeadSelectionPath(this.pressedPath, true);
            }
            this.pressedEvent = null;
            this.pressedPath = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SwingUtilities2.shouldIgnore(e, BasicTreeUI.this.tree)) {
                return;
            }
            if (BasicTreeUI.this.tree.getDragEnabled()) {
                DragRecognitionSupport.mouseDragged(e, this);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities2.shouldIgnore(e, BasicTreeUI.this.tree)) {
                return;
            }
            if (BasicTreeUI.this.tree.getDragEnabled()) {
                this.mouseReleasedDND(e);
            }
            this.pressedEvent = null;
            this.pressedPath = null;
        }

        private void mouseReleasedDND(MouseEvent e) {
            MouseEvent me = DragRecognitionSupport.mouseReleased(e);
            if (me != null) {
                SwingUtilities2.adjustFocus(BasicTreeUI.this.tree);
                if (!this.dragPressDidSelection) {
                    this.handleSelection(me);
                }
            }
            if (!this.dragStarted && this.pressedPath != null && !this.valueChangedOnPress && this.isActualPath(this.pressedPath, this.pressedEvent.getX(), this.pressedEvent.getY())) {
                BasicTreeUI.this.startEditingOnRelease(this.pressedPath, this.pressedEvent, e);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (BasicTreeUI.this.tree != null) {
                Rectangle pBounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, BasicTreeUI.this.tree.getLeadSelectionPath());
                if (pBounds != null) {
                    BasicTreeUI.this.tree.repaint(BasicTreeUI.this.getRepaintPathBounds(pBounds));
                }
                if ((pBounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, BasicTreeUI.this.getLeadSelectionPath())) != null) {
                    BasicTreeUI.this.tree.repaint(BasicTreeUI.this.getRepaintPathBounds(pBounds));
                }
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.focusGained(e);
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            BasicTreeUI.this.completeEditing(false, false, true);
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            BasicTreeUI.this.completeEditing(false, false, false);
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            TreePath[] paths;
            this.valueChangedOnPress = true;
            BasicTreeUI.this.completeEditing();
            if (BasicTreeUI.this.tree.getExpandsSelectedPaths() && BasicTreeUI.this.treeSelectionModel != null && (paths = BasicTreeUI.this.treeSelectionModel.getSelectionPaths()) != null) {
                for (int counter = paths.length - 1; counter >= 0; --counter) {
                    TreePath path = paths[counter].getParentPath();
                    boolean expand = true;
                    while (path != null) {
                        if (BasicTreeUI.this.treeModel.isLeaf(path.getLastPathComponent())) {
                            expand = false;
                            path = null;
                            continue;
                        }
                        path = path.getParentPath();
                    }
                    if (!expand) continue;
                    BasicTreeUI.this.tree.makeVisible(paths[counter]);
                }
            }
            TreePath oldLead = BasicTreeUI.this.getLeadSelectionPath();
            BasicTreeUI.this.lastSelectedRow = BasicTreeUI.this.tree.getMinSelectionRow();
            TreePath lead = BasicTreeUI.this.tree.getSelectionModel().getLeadSelectionPath();
            BasicTreeUI.this.setAnchorSelectionPath(lead);
            BasicTreeUI.this.setLeadSelectionPath(lead);
            TreePath[] changedPaths = event.getPaths();
            Rectangle visRect = BasicTreeUI.this.tree.getVisibleRect();
            boolean paintPaths = true;
            int nWidth = BasicTreeUI.this.tree.getWidth();
            if (changedPaths != null) {
                int maxCounter = changedPaths.length;
                if (maxCounter > 4) {
                    BasicTreeUI.this.tree.repaint();
                    paintPaths = false;
                } else {
                    for (int counter = 0; counter < maxCounter; ++counter) {
                        Rectangle nodeBounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, changedPaths[counter]);
                        if (nodeBounds == null || !visRect.intersects(nodeBounds)) continue;
                        BasicTreeUI.this.tree.repaint(0, nodeBounds.y, nWidth, nodeBounds.height);
                    }
                }
            }
            if (paintPaths) {
                Rectangle nodeBounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, oldLead);
                if (nodeBounds != null && visRect.intersects(nodeBounds)) {
                    BasicTreeUI.this.tree.repaint(0, nodeBounds.y, nWidth, nodeBounds.height);
                }
                if ((nodeBounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, lead)) != null && visRect.intersects(nodeBounds)) {
                    BasicTreeUI.this.tree.repaint(0, nodeBounds.y, nWidth, nodeBounds.height);
                }
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            if (event != null && BasicTreeUI.this.tree != null) {
                TreePath path = event.getPath();
                BasicTreeUI.this.updateExpandedDescendants(path);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            if (event != null && BasicTreeUI.this.tree != null) {
                TreePath path = event.getPath();
                BasicTreeUI.this.completeEditing();
                if (path != null && BasicTreeUI.this.tree.isVisible(path)) {
                    BasicTreeUI.this.treeState.setExpandedState(path, false);
                    BasicTreeUI.this.updateLeadSelectionRow();
                    BasicTreeUI.this.updateSize();
                }
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            if (BasicTreeUI.this.treeState != null && e != null) {
                TreePath parentPath = e.getTreePath();
                int[] indices = e.getChildIndices();
                if (indices == null || indices.length == 0) {
                    BasicTreeUI.this.treeState.treeNodesChanged(e);
                    BasicTreeUI.this.updateSize();
                } else if (BasicTreeUI.this.treeState.isExpanded(parentPath)) {
                    int minIndex = indices[0];
                    for (int i = indices.length - 1; i > 0; --i) {
                        minIndex = Math.min(indices[i], minIndex);
                    }
                    Object minChild = BasicTreeUI.this.treeModel.getChild(parentPath.getLastPathComponent(), minIndex);
                    TreePath minPath = parentPath.pathByAddingChild(minChild);
                    Rectangle minBounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, minPath);
                    BasicTreeUI.this.treeState.treeNodesChanged(e);
                    BasicTreeUI.this.updateSize0();
                    Rectangle newMinBounds = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, minPath);
                    if (minBounds == null || newMinBounds == null) {
                        return;
                    }
                    if (indices.length == 1 && newMinBounds.height == minBounds.height) {
                        BasicTreeUI.this.tree.repaint(0, minBounds.y, BasicTreeUI.this.tree.getWidth(), minBounds.height);
                    } else {
                        BasicTreeUI.this.tree.repaint(0, minBounds.y, BasicTreeUI.this.tree.getWidth(), BasicTreeUI.this.tree.getHeight() - minBounds.y);
                    }
                } else {
                    BasicTreeUI.this.treeState.treeNodesChanged(e);
                }
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            if (BasicTreeUI.this.treeState != null && e != null) {
                BasicTreeUI.this.treeState.treeNodesInserted(e);
                BasicTreeUI.this.updateLeadSelectionRow();
                TreePath path = e.getTreePath();
                if (BasicTreeUI.this.treeState.isExpanded(path)) {
                    BasicTreeUI.this.updateSize();
                } else {
                    int[] indices = e.getChildIndices();
                    int childCount = BasicTreeUI.this.treeModel.getChildCount(path.getLastPathComponent());
                    if (indices != null && childCount - indices.length == 0) {
                        BasicTreeUI.this.updateSize();
                    }
                }
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            if (BasicTreeUI.this.treeState != null && e != null) {
                BasicTreeUI.this.treeState.treeNodesRemoved(e);
                BasicTreeUI.this.updateLeadSelectionRow();
                TreePath path = e.getTreePath();
                if (BasicTreeUI.this.treeState.isExpanded(path) || BasicTreeUI.this.treeModel.getChildCount(path.getLastPathComponent()) == 0) {
                    BasicTreeUI.this.updateSize();
                }
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            if (BasicTreeUI.this.treeState != null && e != null) {
                BasicTreeUI.this.treeState.treeStructureChanged(e);
                BasicTreeUI.this.updateLeadSelectionRow();
                TreePath pPath = e.getTreePath();
                if (pPath != null) {
                    pPath = pPath.getParentPath();
                }
                if (pPath == null || BasicTreeUI.this.treeState.isExpanded(pPath)) {
                    BasicTreeUI.this.updateSize();
                }
            }
        }
    }

    static class TreeTransferHandler
    extends TransferHandler
    implements UIResource,
    Comparator<TreePath> {
        private JTree tree;

        TreeTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JTree) {
                TreePath[] displayPaths;
                this.tree = (JTree)c;
                TreePath[] paths = this.tree.getSelectionPaths();
                if (paths == null || paths.length == 0) {
                    return null;
                }
                StringBuffer plainBuf = new StringBuffer();
                StringBuffer htmlBuf = new StringBuffer();
                htmlBuf.append("<html>\n<body>\n<ul>\n");
                TreeModel model = this.tree.getModel();
                Object lastPath = null;
                for (TreePath path : displayPaths = this.getDisplayOrderPaths(paths)) {
                    Object node = path.getLastPathComponent();
                    boolean leaf = model.isLeaf(node);
                    String label = this.getDisplayString(path, true, leaf);
                    plainBuf.append(label + "\n");
                    htmlBuf.append("  <li>" + label + "\n");
                }
                plainBuf.deleteCharAt(plainBuf.length() - 1);
                htmlBuf.append("</ul>\n</body>\n</html>");
                this.tree = null;
                return new BasicTransferable(plainBuf.toString(), htmlBuf.toString());
            }
            return null;
        }

        @Override
        public int compare(TreePath o1, TreePath o2) {
            int row1 = this.tree.getRowForPath(o1);
            int row2 = this.tree.getRowForPath(o2);
            return row1 - row2;
        }

        String getDisplayString(TreePath path, boolean selected, boolean leaf) {
            int row = this.tree.getRowForPath(path);
            boolean hasFocus = this.tree.getLeadSelectionRow() == row;
            Object node = path.getLastPathComponent();
            return this.tree.convertValueToText(node, selected, this.tree.isExpanded(row), leaf, row, hasFocus);
        }

        TreePath[] getDisplayOrderPaths(TreePath[] paths) {
            ArrayList<TreePath> selOrder = new ArrayList<TreePath>();
            for (TreePath path : paths) {
                selOrder.add(path);
            }
            Collections.sort(selOrder, this);
            int n = selOrder.size();
            TreePath[] displayPaths = new TreePath[n];
            for (int i = 0; i < n; ++i) {
                displayPaths[i] = (TreePath)selOrder.get(i);
            }
            return displayPaths;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected Component source;
        protected Component destination;
        private Component focusComponent;
        private boolean dispatchedEvent;

        public MouseInputHandler(Component source, Component destination, MouseEvent event) {
            this(source, destination, event, null);
        }

        MouseInputHandler(Component source, Component destination, MouseEvent event, Component focusComponent) {
            this.source = source;
            this.destination = destination;
            this.source.addMouseListener(this);
            this.source.addMouseMotionListener(this);
            SwingUtilities2.setSkipClickCount(destination, event.getClickCount() - 1);
            destination.dispatchEvent(SwingUtilities.convertMouseEvent(source, event, destination));
            this.focusComponent = focusComponent;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.destination != null) {
                this.dispatchedEvent = true;
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, e, this.destination));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, e, this.destination));
            }
            this.removeFromSource();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                this.removeFromSource();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                this.removeFromSource();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.destination != null) {
                this.dispatchedEvent = true;
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, e, this.destination));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.removeFromSource();
        }

        protected void removeFromSource() {
            if (this.source != null) {
                this.source.removeMouseListener(this);
                this.source.removeMouseMotionListener(this);
                if (this.focusComponent != null && this.focusComponent == this.destination && !this.dispatchedEvent && this.focusComponent instanceof JTextField) {
                    ((JTextField)this.focusComponent).selectAll();
                }
            }
            this.destination = null;
            this.source = null;
        }
    }

    public class TreeCancelEditingAction
    extends AbstractAction {
        public TreeCancelEditingAction(String name) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BasicTreeUI.this.tree != null) {
                SHARED_ACTION.cancelEditing(BasicTreeUI.this.tree, BasicTreeUI.this);
            }
        }

        @Override
        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled() && BasicTreeUI.this.isEditing(BasicTreeUI.this.tree);
        }
    }

    public class TreeToggleAction
    extends AbstractAction {
        public TreeToggleAction(String name) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BasicTreeUI.this.tree != null) {
                SHARED_ACTION.toggle(BasicTreeUI.this.tree, BasicTreeUI.this);
            }
        }

        @Override
        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeHomeAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreeHomeAction(int direction, String name) {
            this(direction, name, false, true);
        }

        private TreeHomeAction(int direction, String name, boolean addToSelection, boolean changeSelection) {
            this.direction = direction;
            this.changeSelection = changeSelection;
            this.addToSelection = addToSelection;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BasicTreeUI.this.tree != null) {
                SHARED_ACTION.home(BasicTreeUI.this.tree, BasicTreeUI.this, this.direction, this.addToSelection, this.changeSelection);
            }
        }

        @Override
        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeIncrementAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreeIncrementAction(int direction, String name) {
            this(direction, name, false, true);
        }

        private TreeIncrementAction(int direction, String name, boolean addToSelection, boolean changeSelection) {
            this.direction = direction;
            this.addToSelection = addToSelection;
            this.changeSelection = changeSelection;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BasicTreeUI.this.tree != null) {
                SHARED_ACTION.increment(BasicTreeUI.this.tree, BasicTreeUI.this, this.direction, this.addToSelection, this.changeSelection);
            }
        }

        @Override
        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreePageAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreePageAction(int direction, String name) {
            this(direction, name, false, true);
        }

        private TreePageAction(int direction, String name, boolean addToSelection, boolean changeSelection) {
            this.direction = direction;
            this.addToSelection = addToSelection;
            this.changeSelection = changeSelection;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BasicTreeUI.this.tree != null) {
                SHARED_ACTION.page(BasicTreeUI.this.tree, BasicTreeUI.this, this.direction, this.addToSelection, this.changeSelection);
            }
        }

        @Override
        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeTraverseAction
    extends AbstractAction {
        protected int direction;
        private boolean changeSelection;

        public TreeTraverseAction(int direction, String name) {
            this(direction, name, true);
        }

        private TreeTraverseAction(int direction, String name, boolean changeSelection) {
            this.direction = direction;
            this.changeSelection = changeSelection;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BasicTreeUI.this.tree != null) {
                SHARED_ACTION.traverse(BasicTreeUI.this.tree, BasicTreeUI.this, this.direction, this.changeSelection);
            }
        }

        @Override
        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class SelectionModelPropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            BasicTreeUI.this.getHandler().propertyChange(event);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            BasicTreeUI.this.getHandler().propertyChange(event);
        }
    }

    public class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        @Override
        public void mousePressed(MouseEvent e) {
            BasicTreeUI.this.getHandler().mousePressed(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            BasicTreeUI.this.getHandler().mouseDragged(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            BasicTreeUI.this.getHandler().mouseMoved(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            BasicTreeUI.this.getHandler().mouseReleased(e);
        }
    }

    public class NodeDimensionsHandler
    extends AbstractLayoutCache.NodeDimensions {
        @Override
        public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle size) {
            if (BasicTreeUI.this.editingComponent != null && BasicTreeUI.this.editingRow == row) {
                Dimension prefSize = BasicTreeUI.this.editingComponent.getPreferredSize();
                int rh = BasicTreeUI.this.getRowHeight();
                if (rh > 0 && rh != prefSize.height) {
                    prefSize.height = rh;
                }
                if (size != null) {
                    size.x = this.getRowX(row, depth);
                    size.width = prefSize.width;
                    size.height = prefSize.height;
                } else {
                    size = new Rectangle(this.getRowX(row, depth), 0, prefSize.width, prefSize.height);
                }
                return size;
            }
            if (BasicTreeUI.this.currentCellRenderer != null) {
                Component aComponent = BasicTreeUI.this.currentCellRenderer.getTreeCellRendererComponent(BasicTreeUI.this.tree, value, BasicTreeUI.this.tree.isRowSelected(row), expanded, BasicTreeUI.this.treeModel.isLeaf(value), row, false);
                if (BasicTreeUI.this.tree != null) {
                    BasicTreeUI.this.rendererPane.add(aComponent);
                    aComponent.validate();
                }
                Dimension prefSize = aComponent.getPreferredSize();
                if (size != null) {
                    size.x = this.getRowX(row, depth);
                    size.width = prefSize.width;
                    size.height = prefSize.height;
                } else {
                    size = new Rectangle(this.getRowX(row, depth), 0, prefSize.width, prefSize.height);
                }
                return size;
            }
            return null;
        }

        protected int getRowX(int row, int depth) {
            return BasicTreeUI.this.getRowX(row, depth);
        }
    }

    public class FocusHandler
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            BasicTreeUI.this.getHandler().focusGained(e);
        }

        @Override
        public void focusLost(FocusEvent e) {
            BasicTreeUI.this.getHandler().focusLost(e);
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        @Override
        public void keyTyped(KeyEvent e) {
            BasicTreeUI.this.getHandler().keyTyped(e);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            BasicTreeUI.this.getHandler().keyPressed(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            BasicTreeUI.this.getHandler().keyReleased(e);
        }
    }

    public class CellEditorHandler
    implements CellEditorListener {
        @Override
        public void editingStopped(ChangeEvent e) {
            BasicTreeUI.this.getHandler().editingStopped(e);
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            BasicTreeUI.this.getHandler().editingCanceled(e);
        }
    }

    public class TreeSelectionHandler
    implements TreeSelectionListener {
        @Override
        public void valueChanged(TreeSelectionEvent event) {
            BasicTreeUI.this.getHandler().valueChanged(event);
        }
    }

    public class TreeModelHandler
    implements TreeModelListener {
        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            BasicTreeUI.this.getHandler().treeNodesChanged(e);
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            BasicTreeUI.this.getHandler().treeNodesInserted(e);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            BasicTreeUI.this.getHandler().treeNodesRemoved(e);
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            BasicTreeUI.this.getHandler().treeStructureChanged(e);
        }
    }

    public class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer;
        protected JScrollBar scrollBar;

        @Override
        public void componentMoved(ComponentEvent e) {
            if (this.timer == null) {
                JScrollPane scrollPane = this.getScrollPane();
                if (scrollPane == null) {
                    BasicTreeUI.this.updateSize();
                } else {
                    this.scrollBar = scrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = scrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            BasicTreeUI.this.updateSize();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }

        protected JScrollPane getScrollPane() {
            Container c;
            for (c = BasicTreeUI.this.tree.getParent(); c != null && !(c instanceof JScrollPane); c = c.getParent()) {
            }
            if (c instanceof JScrollPane) {
                return (JScrollPane)c;
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                BasicTreeUI.this.updateSize();
                this.timer = null;
                this.scrollBar = null;
            }
        }
    }

    public class TreeExpansionHandler
    implements TreeExpansionListener {
        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            BasicTreeUI.this.getHandler().treeExpanded(event);
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            BasicTreeUI.this.getHandler().treeCollapsed(event);
        }
    }
}

