/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameImpl;

public class CompositeName
implements Name {
    private transient NameImpl impl;
    private static final long serialVersionUID = 1667768148915813118L;

    protected CompositeName(Enumeration<String> comps) {
        this.impl = new NameImpl(null, comps);
    }

    public CompositeName(String n) throws InvalidNameException {
        this.impl = new NameImpl(null, n);
    }

    public CompositeName() {
        this.impl = new NameImpl(null);
    }

    public String toString() {
        return this.impl.toString();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof CompositeName && this.impl.equals(((CompositeName)obj).impl);
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    @Override
    public int compareTo(Object obj) {
        if (!(obj instanceof CompositeName)) {
            throw new ClassCastException("Not a CompositeName");
        }
        return this.impl.compareTo(((CompositeName)obj).impl);
    }

    @Override
    public Object clone() {
        return new CompositeName(this.getAll());
    }

    @Override
    public int size() {
        return this.impl.size();
    }

    @Override
    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    @Override
    public Enumeration<String> getAll() {
        return this.impl.getAll();
    }

    @Override
    public String get(int posn) {
        return this.impl.get(posn);
    }

    @Override
    public Name getPrefix(int posn) {
        Enumeration comps = this.impl.getPrefix(posn);
        return new CompositeName(comps);
    }

    @Override
    public Name getSuffix(int posn) {
        Enumeration comps = this.impl.getSuffix(posn);
        return new CompositeName(comps);
    }

    @Override
    public boolean startsWith(Name n) {
        if (n instanceof CompositeName) {
            return this.impl.startsWith(n.size(), n.getAll());
        }
        return false;
    }

    @Override
    public boolean endsWith(Name n) {
        if (n instanceof CompositeName) {
            return this.impl.endsWith(n.size(), n.getAll());
        }
        return false;
    }

    @Override
    public Name addAll(Name suffix) throws InvalidNameException {
        if (suffix instanceof CompositeName) {
            this.impl.addAll(suffix.getAll());
            return this;
        }
        throw new InvalidNameException("Not a composite name: " + suffix.toString());
    }

    @Override
    public Name addAll(int posn, Name n) throws InvalidNameException {
        if (n instanceof CompositeName) {
            this.impl.addAll(posn, n.getAll());
            return this;
        }
        throw new InvalidNameException("Not a composite name: " + n.toString());
    }

    @Override
    public Name add(String comp) throws InvalidNameException {
        this.impl.add(comp);
        return this;
    }

    @Override
    public Name add(int posn, String comp) throws InvalidNameException {
        this.impl.add(posn, comp);
        return this;
    }

    @Override
    public Object remove(int posn) throws InvalidNameException {
        return this.impl.remove(posn);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(this.size());
        Enumeration<String> comps = this.getAll();
        while (comps.hasMoreElements()) {
            s.writeObject(comps.nextElement());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.impl = new NameImpl(null);
        int n = s.readInt();
        try {
            while (--n >= 0) {
                this.add((String)s.readObject());
            }
        }
        catch (InvalidNameException e) {
            throw new StreamCorruptedException("Invalid name");
        }
    }
}

