/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Arrays;
import java.util.HashSet;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanInfo;
import javax.management.openmbean.OpenMBeanOperationInfo;

public class OpenMBeanInfoSupport
extends MBeanInfo
implements OpenMBeanInfo {
    static final long serialVersionUID = 4349395935420511492L;
    private transient Integer myHashCode = null;
    private transient String myToString = null;

    public OpenMBeanInfoSupport(String className, String description, OpenMBeanAttributeInfo[] openAttributes, OpenMBeanConstructorInfo[] openConstructors, OpenMBeanOperationInfo[] openOperations, MBeanNotificationInfo[] notifications) {
        this(className, description, openAttributes, openConstructors, openOperations, notifications, (Descriptor)null);
    }

    public OpenMBeanInfoSupport(String className, String description, OpenMBeanAttributeInfo[] openAttributes, OpenMBeanConstructorInfo[] openConstructors, OpenMBeanOperationInfo[] openOperations, MBeanNotificationInfo[] notifications, Descriptor descriptor) {
        super(className, description, OpenMBeanInfoSupport.attributeArray(openAttributes), OpenMBeanInfoSupport.constructorArray(openConstructors), OpenMBeanInfoSupport.operationArray(openOperations), notifications == null ? null : (MBeanNotificationInfo[])notifications.clone(), descriptor);
    }

    private static MBeanAttributeInfo[] attributeArray(OpenMBeanAttributeInfo[] src) {
        if (src == null) {
            return null;
        }
        MBeanAttributeInfo[] dst = new MBeanAttributeInfo[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    private static MBeanConstructorInfo[] constructorArray(OpenMBeanConstructorInfo[] src) {
        if (src == null) {
            return null;
        }
        MBeanConstructorInfo[] dst = new MBeanConstructorInfo[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    private static MBeanOperationInfo[] operationArray(OpenMBeanOperationInfo[] src) {
        if (src == null) {
            return null;
        }
        MBeanOperationInfo[] dst = new MBeanOperationInfo[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    @Override
    public boolean equals(Object obj) {
        OpenMBeanInfo other;
        if (obj == null) {
            return false;
        }
        try {
            other = (OpenMBeanInfo)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (!this.getClassName().equals(other.getClassName())) {
            return false;
        }
        if (!OpenMBeanInfoSupport.sameArrayContents(this.getAttributes(), other.getAttributes())) {
            return false;
        }
        if (!OpenMBeanInfoSupport.sameArrayContents(this.getConstructors(), other.getConstructors())) {
            return false;
        }
        if (!OpenMBeanInfoSupport.sameArrayContents(this.getOperations(), other.getOperations())) {
            return false;
        }
        return OpenMBeanInfoSupport.sameArrayContents(this.getNotifications(), other.getNotifications());
    }

    private static <T> boolean sameArrayContents(T[] a1, T[] a2) {
        return new HashSet<T>(Arrays.asList(a1)).equals(new HashSet<T>(Arrays.asList(a2)));
    }

    @Override
    public int hashCode() {
        if (this.myHashCode == null) {
            int value = 0;
            value += this.getClassName().hashCode();
            value += OpenMBeanInfoSupport.arraySetHash(this.getAttributes());
            value += OpenMBeanInfoSupport.arraySetHash(this.getConstructors());
            value += OpenMBeanInfoSupport.arraySetHash(this.getOperations());
            this.myHashCode = value += OpenMBeanInfoSupport.arraySetHash(this.getNotifications());
        }
        return this.myHashCode;
    }

    private static <T> int arraySetHash(T[] a) {
        return new HashSet<T>(Arrays.asList(a)).hashCode();
    }

    @Override
    public String toString() {
        if (this.myToString == null) {
            this.myToString = this.getClass().getName() + "(mbean_class_name=" + this.getClassName() + ",attributes=" + Arrays.asList(this.getAttributes()).toString() + ",constructors=" + Arrays.asList(this.getConstructors()).toString() + ",operations=" + Arrays.asList(this.getOperations()).toString() + ",notifications=" + Arrays.asList(this.getNotifications()).toString() + ",descriptor=" + this.getDescriptor() + ")";
        }
        return this.myToString;
    }
}

