/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

public abstract class AtomicIntegerFieldUpdater<T> {
    @CallerSensitive
    public static <U> AtomicIntegerFieldUpdater<U> newUpdater(Class<U> tclass, String fieldName) {
        return new AtomicIntegerFieldUpdaterImpl<U>(tclass, fieldName, Reflection.getCallerClass());
    }

    protected AtomicIntegerFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, int var2, int var3);

    public abstract boolean weakCompareAndSet(T var1, int var2, int var3);

    public abstract void set(T var1, int var2);

    public abstract void lazySet(T var1, int var2);

    public abstract int get(T var1);

    public int getAndSet(T obj, int newValue) {
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), newValue)) {
        }
        return current;
    }

    public int getAndIncrement(T obj) {
        int next;
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current + 1)) {
        }
        return current;
    }

    public int getAndDecrement(T obj) {
        int next;
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current - 1)) {
        }
        return current;
    }

    public int getAndAdd(T obj, int delta) {
        int next;
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current + delta)) {
        }
        return current;
    }

    public int incrementAndGet(T obj) {
        int next;
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current + 1)) {
        }
        return next;
    }

    public int decrementAndGet(T obj) {
        int next;
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current - 1)) {
        }
        return next;
    }

    public int addAndGet(T obj, int delta) {
        int next;
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current + delta)) {
        }
        return next;
    }

    private static class AtomicIntegerFieldUpdaterImpl<T>
    extends AtomicIntegerFieldUpdater<T> {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private final long offset;
        private final Class<T> tclass;
        private final Class cclass;

        AtomicIntegerFieldUpdaterImpl(Class<T> tclass, String fieldName, Class<?> caller) {
            Field field = null;
            int modifiers = 0;
            try {
                field = tclass.getDeclaredField(fieldName);
                modifiers = field.getModifiers();
                ReflectUtil.ensureMemberAccess(caller, tclass, null, modifiers);
                ReflectUtil.checkPackageAccess(tclass);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            Class<?> fieldt = field.getType();
            if (fieldt != Integer.TYPE) {
                throw new IllegalArgumentException("Must be integer type");
            }
            if (!Modifier.isVolatile(modifiers)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(modifiers) && caller != tclass ? caller : null;
            this.tclass = tclass;
            this.offset = unsafe.objectFieldOffset(field);
        }

        private void fullCheck(T obj) {
            if (!this.tclass.isInstance(obj)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(obj);
            }
        }

        @Override
        public boolean compareAndSet(T obj, int expect, int update) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return unsafe.compareAndSwapInt(obj, this.offset, expect, update);
        }

        @Override
        public boolean weakCompareAndSet(T obj, int expect, int update) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return unsafe.compareAndSwapInt(obj, this.offset, expect, update);
        }

        @Override
        public void set(T obj, int newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            unsafe.putIntVolatile(obj, this.offset, newValue);
        }

        @Override
        public void lazySet(T obj, int newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            unsafe.putOrderedInt(obj, this.offset, newValue);
        }

        @Override
        public final int get(T obj) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return unsafe.getIntVolatile(obj, this.offset);
        }

        private void ensureProtectedAccess(T obj) {
            if (this.cclass.isInstance(obj)) {
                return;
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + obj.getClass().getName()));
        }
    }
}

