/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.sun.xml.internal.ws.org.objectweb.asm.ClassWriter;
import com.sun.xml.internal.ws.org.objectweb.asm.Label;
import com.sun.xml.internal.ws.org.objectweb.asm.MethodVisitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeForm;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import sun.invoke.util.VerifyAccess;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;
import sun.misc.Unsafe;

class InvokerBytecodeGenerator {
    private static final String MH = "java/lang/invoke/MethodHandle";
    private static final String BMH = "java/lang/invoke/BoundMethodHandle";
    private static final String LF = "java/lang/invoke/LambdaForm";
    private static final String LFN = "java/lang/invoke/LambdaForm$Name";
    private static final String CLS = "java/lang/Class";
    private static final String OBJ = "java/lang/Object";
    private static final String OBJARY = "[Ljava/lang/Object;";
    private static final String LF_SIG = "Ljava/lang/invoke/LambdaForm;";
    private static final String LFN_SIG = "Ljava/lang/invoke/LambdaForm$Name;";
    private static final String LL_SIG = "(Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String superName = "java/lang/invoke/LambdaForm";
    private final String className;
    private final String sourceFile;
    private final LambdaForm lambdaForm;
    private final String invokerName;
    private final MethodType invokerType;
    private final int[] localsMap;
    private ClassWriter cw;
    private MethodVisitor mv;
    private static final MemberName.Factory MEMBERNAME_FACTORY = MemberName.getFactory();
    private static final Class<?> HOST_CLASS = LambdaForm.class;
    private static final HashMap<String, Integer> DUMP_CLASS_FILES_COUNTERS;
    private static final File DUMP_CLASS_FILES_DIR;
    Map<Object, CpPatch> cpPatches = new HashMap<Object, CpPatch>();
    int cph = 0;
    private static Class<?>[] STATICALLY_INVOCABLE_PACKAGES;
    static int nfi;

    private InvokerBytecodeGenerator(LambdaForm lambdaForm, int localsMapSize, String className, String invokerName, MethodType invokerType) {
        if (invokerName.contains(".")) {
            int p = invokerName.indexOf(".");
            className = invokerName.substring(0, p);
            invokerName = invokerName.substring(p + 1);
        }
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            className = InvokerBytecodeGenerator.makeDumpableClassName(className);
        }
        this.className = "java/lang/invoke/LambdaForm$" + className;
        this.sourceFile = "LambdaForm$" + className;
        this.lambdaForm = lambdaForm;
        this.invokerName = invokerName;
        this.invokerType = invokerType;
        this.localsMap = new int[localsMapSize];
    }

    private InvokerBytecodeGenerator(String className, String invokerName, MethodType invokerType) {
        this(null, invokerType.parameterCount(), className, invokerName, invokerType);
        for (int i = 0; i < this.localsMap.length; ++i) {
            this.localsMap[i] = invokerType.parameterSlotCount() - invokerType.parameterSlotDepth(i);
        }
    }

    private InvokerBytecodeGenerator(String className, LambdaForm form, MethodType invokerType) {
        this(form, form.names.length, className, form.debugName, invokerType);
        LambdaForm.Name[] names = form.names;
        int index = 0;
        for (int i = 0; i < this.localsMap.length; ++i) {
            this.localsMap[i] = index;
            index += Wrapper.forBasicType(names[i].type).stackSlots();
        }
    }

    static void maybeDump(final String className, final byte[] classFile) {
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            System.out.println("dump: " + className);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        String dumpName = className;
                        File dumpFile = new File(DUMP_CLASS_FILES_DIR, dumpName + ".class");
                        dumpFile.getParentFile().mkdirs();
                        FileOutputStream file = new FileOutputStream(dumpFile);
                        file.write(classFile);
                        file.close();
                        return null;
                    }
                    catch (IOException ex) {
                        throw MethodHandleStatics.newInternalError(ex);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeDumpableClassName(String className) {
        Integer ctr;
        HashMap<String, Integer> hashMap = DUMP_CLASS_FILES_COUNTERS;
        synchronized (hashMap) {
            ctr = DUMP_CLASS_FILES_COUNTERS.get(className);
            if (ctr == null) {
                ctr = 0;
            }
            DUMP_CLASS_FILES_COUNTERS.put(className, ctr + 1);
        }
        String sfx = ctr.toString();
        while (sfx.length() < 3) {
            sfx = "0" + sfx;
        }
        className = className + sfx;
        return className;
    }

    String constantPlaceholder(Object arg) {
        String cpPlaceholder = "CONSTANT_PLACEHOLDER_" + this.cph++;
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            cpPlaceholder = cpPlaceholder + " <<" + arg.toString() + ">>";
        }
        if (this.cpPatches.containsKey(cpPlaceholder)) {
            throw new InternalError("observed CP placeholder twice: " + cpPlaceholder);
        }
        int index = this.cw.newConst(cpPlaceholder);
        this.cpPatches.put(cpPlaceholder, new CpPatch(index, cpPlaceholder, arg));
        return cpPlaceholder;
    }

    Object[] cpPatches(byte[] classFile) {
        int size = InvokerBytecodeGenerator.getConstantPoolSize(classFile);
        Object[] res = new Object[size];
        for (CpPatch p : this.cpPatches.values()) {
            if (p.index >= size) {
                throw new InternalError("in cpool[" + size + "]: " + p + "\n" + Arrays.toString(Arrays.copyOf(classFile, 20)));
            }
            res[p.index] = p.value;
        }
        return res;
    }

    private static int getConstantPoolSize(byte[] classFile) {
        return (classFile[8] & 0xFF) << 8 | classFile[9] & 0xFF;
    }

    private MemberName loadMethod(byte[] classFile) {
        Class<?> invokerClass = InvokerBytecodeGenerator.loadAndInitializeInvokerClass(classFile, this.cpPatches(classFile));
        return InvokerBytecodeGenerator.resolveInvokerMember(invokerClass, this.invokerName, this.invokerType);
    }

    private static Class<?> loadAndInitializeInvokerClass(byte[] classBytes, Object[] patches) {
        Class invokerClass = MethodHandleStatics.UNSAFE.defineAnonymousClass(HOST_CLASS, classBytes, patches);
        MethodHandleStatics.UNSAFE.ensureClassInitialized(invokerClass);
        return invokerClass;
    }

    private static MemberName resolveInvokerMember(Class<?> invokerClass, String name, MethodType type) {
        MemberName member = new MemberName(invokerClass, name, type, 6);
        try {
            member = MEMBERNAME_FACTORY.resolveOrFail((byte)6, member, HOST_CLASS, ReflectiveOperationException.class);
        }
        catch (ReflectiveOperationException e) {
            throw MethodHandleStatics.newInternalError(e);
        }
        return member;
    }

    private void classFilePrologue() {
        boolean NOT_ACC_PUBLIC = false;
        this.cw = new ClassWriter(3);
        this.cw.visit(50, 48, this.className, null, "java/lang/invoke/LambdaForm", null);
        this.cw.visitSource(this.sourceFile, null);
        String invokerDesc = this.invokerType.toMethodDescriptorString();
        this.mv = this.cw.visitMethod(8, this.invokerName, invokerDesc, null, null);
    }

    private void classFileEpilogue() {
        this.mv.visitMaxs(0, 0);
        this.mv.visitEnd();
    }

    private void emitConst(Object con) {
        long x;
        if (con == null) {
            this.mv.visitInsn(1);
            return;
        }
        if (con instanceof Integer) {
            this.emitIconstInsn((Integer)con);
            return;
        }
        if (con instanceof Long && (x = ((Long)con).longValue()) == (long)((short)x)) {
            this.emitIconstInsn((int)x);
            this.mv.visitInsn(133);
            return;
        }
        if (con instanceof Float && (x = ((Float)con).floatValue()) == (float)((short)x)) {
            this.emitIconstInsn((int)x);
            this.mv.visitInsn(134);
            return;
        }
        if (con instanceof Double && (x = ((Double)con).doubleValue()) == (double)((short)x)) {
            this.emitIconstInsn((int)x);
            this.mv.visitInsn(135);
            return;
        }
        if (con instanceof Boolean) {
            this.emitIconstInsn((Boolean)con != false ? 1 : 0);
            return;
        }
        this.mv.visitLdcInsn(con);
    }

    private void emitIconstInsn(int i) {
        int opcode;
        switch (i) {
            case 0: {
                opcode = 3;
                break;
            }
            case 1: {
                opcode = 4;
                break;
            }
            case 2: {
                opcode = 5;
                break;
            }
            case 3: {
                opcode = 6;
                break;
            }
            case 4: {
                opcode = 7;
                break;
            }
            case 5: {
                opcode = 8;
                break;
            }
            default: {
                if (i == (byte)i) {
                    this.mv.visitIntInsn(16, i & 0xFF);
                } else if (i == (short)i) {
                    this.mv.visitIntInsn(17, (char)i);
                } else {
                    this.mv.visitLdcInsn(i);
                }
                return;
            }
        }
        this.mv.visitInsn(opcode);
    }

    private void emitLoadInsn(char type, int index) {
        int opcode;
        switch (type) {
            case 'I': {
                opcode = 21;
                break;
            }
            case 'J': {
                opcode = 22;
                break;
            }
            case 'F': {
                opcode = 23;
                break;
            }
            case 'D': {
                opcode = 24;
                break;
            }
            case 'L': {
                opcode = 25;
                break;
            }
            default: {
                throw new InternalError("unknown type: " + type);
            }
        }
        this.mv.visitVarInsn(opcode, this.localsMap[index]);
    }

    private void emitAloadInsn(int index) {
        this.emitLoadInsn('L', index);
    }

    private void emitStoreInsn(char type, int index) {
        int opcode;
        switch (type) {
            case 'I': {
                opcode = 54;
                break;
            }
            case 'J': {
                opcode = 55;
                break;
            }
            case 'F': {
                opcode = 56;
                break;
            }
            case 'D': {
                opcode = 57;
                break;
            }
            case 'L': {
                opcode = 58;
                break;
            }
            default: {
                throw new InternalError("unknown type: " + type);
            }
        }
        this.mv.visitVarInsn(opcode, this.localsMap[index]);
    }

    private void emitAstoreInsn(int index) {
        this.emitStoreInsn('L', index);
    }

    private void emitBoxing(Class<?> type) {
        Wrapper wrapper = Wrapper.forPrimitiveType(type);
        String owner = "java/lang/" + wrapper.wrapperType().getSimpleName();
        String name = "valueOf";
        String desc = "(" + wrapper.basicTypeChar() + ")L" + owner + ";";
        this.mv.visitMethodInsn(184, owner, name, desc);
    }

    private void emitUnboxing(Class<?> type) {
        Wrapper wrapper = Wrapper.forWrapperType(type);
        String owner = "java/lang/" + wrapper.wrapperType().getSimpleName();
        String name = wrapper.primitiveSimpleName() + "Value";
        String desc = "()" + wrapper.basicTypeChar();
        this.mv.visitTypeInsn(192, owner);
        this.mv.visitMethodInsn(182, owner, name, desc);
    }

    private void emitImplicitConversion(char ptype, Class<?> pclass) {
        switch (ptype) {
            case 'L': {
                if (VerifyType.isNullConversion(Object.class, pclass)) {
                    return;
                }
                if (InvokerBytecodeGenerator.isStaticallyNameable(pclass)) {
                    this.mv.visitTypeInsn(192, InvokerBytecodeGenerator.getInternalName(pclass));
                } else {
                    this.mv.visitLdcInsn(this.constantPlaceholder(pclass));
                    this.mv.visitTypeInsn(192, CLS);
                    this.mv.visitInsn(95);
                    this.mv.visitMethodInsn(182, CLS, "cast", LL_SIG);
                    if (pclass.isArray()) {
                        this.mv.visitTypeInsn(192, OBJARY);
                    }
                }
                return;
            }
            case 'I': {
                if (!VerifyType.isNullConversion(Integer.TYPE, pclass)) {
                    this.emitPrimCast(ptype, Wrapper.basicTypeChar(pclass));
                }
                return;
            }
            case 'J': {
                assert (pclass == Long.TYPE);
                return;
            }
            case 'F': {
                assert (pclass == Float.TYPE);
                return;
            }
            case 'D': {
                assert (pclass == Double.TYPE);
                return;
            }
        }
        throw new InternalError("bad implicit conversion: tc=" + ptype + ": " + pclass);
    }

    private void emitReturnInsn(Class<?> type) {
        int opcode;
        switch (Wrapper.basicTypeChar(type)) {
            case 'I': {
                opcode = 172;
                break;
            }
            case 'J': {
                opcode = 173;
                break;
            }
            case 'F': {
                opcode = 174;
                break;
            }
            case 'D': {
                opcode = 175;
                break;
            }
            case 'L': {
                opcode = 176;
                break;
            }
            case 'V': {
                opcode = 177;
                break;
            }
            default: {
                throw new InternalError("unknown return type: " + type);
            }
        }
        this.mv.visitInsn(opcode);
    }

    private static String getInternalName(Class<?> c) {
        assert (VerifyAccess.isTypeVisible(c, Object.class));
        return c.getName().replace('.', '/');
    }

    static MemberName generateCustomizedCode(LambdaForm form, MethodType invokerType) {
        InvokerBytecodeGenerator g = new InvokerBytecodeGenerator("MH", form, invokerType);
        return g.loadMethod(g.generateCustomizedCodeBytes());
    }

    private byte[] generateCustomizedCodeBytes() {
        this.classFilePrologue();
        this.mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Hidden;", true);
        this.mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Compiled;", true);
        this.mv.visitAnnotation("Ljava/lang/invoke/ForceInline;", true);
        for (int i = this.lambdaForm.arity; i < this.lambdaForm.names.length; ++i) {
            LambdaForm.Name name = this.lambdaForm.names[i];
            MemberName member = name.function.member();
            if (this.isSelectAlternative(member)) {
                this.emitSelectAlternative(name, this.lambdaForm.names[i + 1]);
                ++i;
            } else if (InvokerBytecodeGenerator.isStaticallyInvocable(member)) {
                this.emitStaticInvoke(member, name);
            } else {
                this.emitInvoke(name);
            }
            if (i == this.lambdaForm.names.length - 1 && i == this.lambdaForm.result || name.type == 'V') continue;
            this.emitStoreInsn(name.type, name.index());
        }
        this.emitReturn();
        this.classFileEpilogue();
        this.bogusMethod(this.lambdaForm);
        byte[] classFile = this.cw.toByteArray();
        InvokerBytecodeGenerator.maybeDump(this.className, classFile);
        return classFile;
    }

    void emitInvoke(LambdaForm.Name name) {
        MethodHandle target = name.function.resolvedHandle;
        assert (target != null) : name.exprString();
        this.mv.visitLdcInsn(this.constantPlaceholder(target));
        this.mv.visitTypeInsn(192, MH);
        for (int i = 0; i < name.arguments.length; ++i) {
            this.emitPushArgument(name, i);
        }
        MethodType type = name.function.methodType();
        this.mv.visitMethodInsn(182, MH, "invokeBasic", type.basicType().toMethodDescriptorString());
    }

    static boolean isStaticallyInvocable(MemberName member) {
        if (member == null) {
            return false;
        }
        if (member.isConstructor()) {
            return false;
        }
        Class<?> cls = member.getDeclaringClass();
        if (cls.isArray() || cls.isPrimitive()) {
            return false;
        }
        if (cls.isAnonymousClass() || cls.isLocalClass()) {
            return false;
        }
        if (cls.getClassLoader() != MethodHandle.class.getClassLoader()) {
            return false;
        }
        if (!member.isPrivate() && VerifyAccess.isSamePackage(MethodHandle.class, cls)) {
            return true;
        }
        return member.isPublic() && InvokerBytecodeGenerator.isStaticallyNameable(cls);
    }

    static boolean isStaticallyNameable(Class<?> cls) {
        while (cls.isArray()) {
            cls = cls.getComponentType();
        }
        if (cls.isPrimitive()) {
            return true;
        }
        if (cls.getClassLoader() != Object.class.getClassLoader()) {
            return false;
        }
        if (VerifyAccess.isSamePackage(MethodHandle.class, cls)) {
            return true;
        }
        if (!Modifier.isPublic(cls.getModifiers())) {
            return false;
        }
        for (Class<?> pkgcls : STATICALLY_INVOCABLE_PACKAGES) {
            if (!VerifyAccess.isSamePackage(pkgcls, cls)) continue;
            return true;
        }
        return false;
    }

    void emitStaticInvoke(MemberName member, LambdaForm.Name name) {
        assert (member.equals(name.function.member()));
        String cname = InvokerBytecodeGenerator.getInternalName(member.getDeclaringClass());
        String mname = member.getName();
        byte refKind = member.getReferenceKind();
        if (refKind == 7) {
            assert (member.canBeStaticallyBound()) : member;
            refKind = 5;
        }
        for (int i = 0; i < name.arguments.length; ++i) {
            this.emitPushArgument(name, i);
        }
        if (member.isMethod()) {
            String mtype = member.getMethodType().toMethodDescriptorString();
            this.mv.visitMethodInsn(this.refKindOpcode(refKind), cname, mname, mtype);
        } else {
            String mtype = MethodType.toFieldDescriptorString(member.getFieldType());
            this.mv.visitFieldInsn(this.refKindOpcode(refKind), cname, mname, mtype);
        }
    }

    int refKindOpcode(byte refKind) {
        switch (refKind) {
            case 5: {
                return 182;
            }
            case 6: {
                return 184;
            }
            case 7: {
                return 183;
            }
            case 9: {
                return 185;
            }
            case 1: {
                return 180;
            }
            case 3: {
                return 181;
            }
            case 2: {
                return 178;
            }
            case 4: {
                return 179;
            }
        }
        throw new InternalError("refKind=" + refKind);
    }

    private boolean isSelectAlternative(MemberName member) {
        return member != null && member.getDeclaringClass() == MethodHandleImpl.class && member.getName().equals("selectAlternative");
    }

    private void emitSelectAlternative(LambdaForm.Name selectAlternativeName, LambdaForm.Name invokeBasicName) {
        MethodType type = selectAlternativeName.function.methodType();
        LambdaForm.Name receiver = (LambdaForm.Name)invokeBasicName.arguments[0];
        Label L_fallback = new Label();
        Label L_done = new Label();
        this.emitPushArgument(selectAlternativeName, 0);
        this.mv.visitInsn(4);
        this.mv.visitJumpInsn(160, L_fallback);
        MethodHandle target = (MethodHandle)selectAlternativeName.arguments[1];
        this.emitPushArgument(selectAlternativeName, 1);
        this.emitAstoreInsn(receiver.index());
        this.emitInvoke(invokeBasicName);
        this.mv.visitJumpInsn(167, L_done);
        this.mv.visitLabel(L_fallback);
        MethodHandle fallback = (MethodHandle)selectAlternativeName.arguments[2];
        this.emitPushArgument(selectAlternativeName, 2);
        this.emitAstoreInsn(receiver.index());
        this.emitInvoke(invokeBasicName);
        this.mv.visitLabel(L_done);
    }

    private void emitPushArgument(LambdaForm.Name name, int paramIndex) {
        Object arg = name.arguments[paramIndex];
        char ptype = name.function.parameterType(paramIndex);
        MethodType mtype = name.function.methodType();
        if (arg instanceof LambdaForm.Name) {
            LambdaForm.Name n = (LambdaForm.Name)arg;
            this.emitLoadInsn(n.type, n.index());
            this.emitImplicitConversion(n.type, mtype.parameterType(paramIndex));
        } else if ((arg == null || arg instanceof String) && ptype == 'L') {
            this.emitConst(arg);
        } else if (Wrapper.isWrapperType(arg.getClass()) && ptype != 'L') {
            this.emitConst(arg);
        } else {
            this.mv.visitLdcInsn(this.constantPlaceholder(arg));
            this.emitImplicitConversion('L', mtype.parameterType(paramIndex));
        }
    }

    private void emitReturn() {
        if (this.lambdaForm.result == -1) {
            this.mv.visitInsn(177);
        } else {
            LambdaForm.Name rn = this.lambdaForm.names[this.lambdaForm.result];
            char rtype = Wrapper.basicTypeChar(this.invokerType.returnType());
            if (this.lambdaForm.result != this.lambdaForm.names.length - 1) {
                this.emitLoadInsn(rn.type, this.lambdaForm.result);
            }
            if (rtype != rn.type) {
                if (rtype == 'L') {
                    char boxedType = Wrapper.forWrapperType(this.invokerType.returnType()).basicTypeChar();
                    if (boxedType != rn.type) {
                        this.emitPrimCast(rn.type, boxedType);
                    }
                    this.emitBoxing(this.invokerType.returnType());
                } else if (rn.type != 'L') {
                    this.emitPrimCast(rn.type, rtype);
                } else {
                    throw new InternalError("no ref-to-prim (unboxing) casts supported right now");
                }
            }
            this.emitReturnInsn(this.invokerType.returnType());
        }
    }

    private void emitPrimCast(char from, char to) {
        if (from == to) {
            return;
        }
        Wrapper wfrom = Wrapper.forBasicType(from);
        Wrapper wto = Wrapper.forBasicType(to);
        if (wfrom.isSubwordOrInt()) {
            this.emitI2X(to);
        } else if (wto.isSubwordOrInt()) {
            this.emitX2I(from);
            if (wto.bitWidth() < 32) {
                this.emitI2X(to);
            }
        } else {
            boolean error = false;
            switch (from) {
                case 'J': {
                    if (to == 'F') {
                        this.mv.visitInsn(137);
                        break;
                    }
                    if (to == 'D') {
                        this.mv.visitInsn(138);
                        break;
                    }
                    error = true;
                    break;
                }
                case 'F': {
                    if (to == 'J') {
                        this.mv.visitInsn(140);
                        break;
                    }
                    if (to == 'D') {
                        this.mv.visitInsn(141);
                        break;
                    }
                    error = true;
                    break;
                }
                case 'D': {
                    if (to == 'J') {
                        this.mv.visitInsn(143);
                        break;
                    }
                    if (to == 'F') {
                        this.mv.visitInsn(144);
                        break;
                    }
                    error = true;
                    break;
                }
                default: {
                    error = true;
                }
            }
            if (error) {
                throw new IllegalStateException("unhandled prim cast: " + from + "2" + to);
            }
        }
    }

    private void emitI2X(char type) {
        switch (type) {
            case 'B': {
                this.mv.visitInsn(145);
                break;
            }
            case 'S': {
                this.mv.visitInsn(147);
                break;
            }
            case 'C': {
                this.mv.visitInsn(146);
                break;
            }
            case 'I': {
                break;
            }
            case 'J': {
                this.mv.visitInsn(133);
                break;
            }
            case 'F': {
                this.mv.visitInsn(134);
                break;
            }
            case 'D': {
                this.mv.visitInsn(135);
                break;
            }
            case 'Z': {
                this.mv.visitInsn(4);
                this.mv.visitInsn(126);
                break;
            }
            default: {
                throw new InternalError("unknown type: " + type);
            }
        }
    }

    private void emitX2I(char type) {
        switch (type) {
            case 'J': {
                this.mv.visitInsn(136);
                break;
            }
            case 'F': {
                this.mv.visitInsn(139);
                break;
            }
            case 'D': {
                this.mv.visitInsn(142);
                break;
            }
            default: {
                throw new InternalError("unknown type: " + type);
            }
        }
    }

    private static String basicTypeCharSignature(String prefix, MethodType type) {
        StringBuilder buf = new StringBuilder(prefix);
        for (Class<?> ptype : type.parameterList()) {
            buf.append(Wrapper.forBasicType(ptype).basicTypeChar());
        }
        buf.append('_').append(Wrapper.forBasicType(type.returnType()).basicTypeChar());
        return buf.toString();
    }

    static MemberName generateLambdaFormInterpreterEntryPoint(String sig) {
        assert (LambdaForm.isValidSignature(sig));
        char tret = LambdaForm.signatureReturn(sig);
        MethodType type = MethodType.methodType(LambdaForm.typeClass(tret), MethodHandle.class);
        int arity = LambdaForm.signatureArity(sig);
        for (int i = 1; i < arity; ++i) {
            type = type.appendParameterTypes(LambdaForm.typeClass(sig.charAt(i)));
        }
        InvokerBytecodeGenerator g = new InvokerBytecodeGenerator("LFI", "interpret_" + tret, type);
        return g.loadMethod(g.generateLambdaFormInterpreterEntryPointBytes());
    }

    private byte[] generateLambdaFormInterpreterEntryPointBytes() {
        this.classFilePrologue();
        this.mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Hidden;", true);
        this.mv.visitAnnotation("Ljava/lang/invoke/DontInline;", true);
        this.emitIconstInsn(this.invokerType.parameterCount());
        this.mv.visitTypeInsn(189, OBJ);
        for (int i = 0; i < this.invokerType.parameterCount(); ++i) {
            Class<?> ptype = this.invokerType.parameterType(i);
            this.mv.visitInsn(89);
            this.emitIconstInsn(i);
            this.emitLoadInsn(Wrapper.basicTypeChar(ptype), i);
            if (ptype.isPrimitive()) {
                this.emitBoxing(ptype);
            }
            this.mv.visitInsn(83);
        }
        this.emitAloadInsn(0);
        this.mv.visitFieldInsn(180, MH, "form", LF_SIG);
        this.mv.visitInsn(95);
        this.mv.visitMethodInsn(182, "java/lang/invoke/LambdaForm", "interpretWithArguments", "([Ljava/lang/Object;)Ljava/lang/Object;");
        Class<?> rtype = this.invokerType.returnType();
        if (rtype.isPrimitive() && rtype != Void.TYPE) {
            this.emitUnboxing(Wrapper.asWrapperType(rtype));
        }
        this.emitReturnInsn(rtype);
        this.classFileEpilogue();
        this.bogusMethod(this.invokerType);
        byte[] classFile = this.cw.toByteArray();
        InvokerBytecodeGenerator.maybeDump(this.className, classFile);
        return classFile;
    }

    static MemberName generateNamedFunctionInvoker(MethodTypeForm typeForm) {
        MethodType invokerType = LambdaForm.NamedFunction.INVOKER_METHOD_TYPE;
        String invokerName = InvokerBytecodeGenerator.basicTypeCharSignature("invoke_", typeForm.erasedType());
        InvokerBytecodeGenerator g = new InvokerBytecodeGenerator("NFI", invokerName, invokerType);
        return g.loadMethod(g.generateNamedFunctionInvokerImpl(typeForm));
    }

    private byte[] generateNamedFunctionInvokerImpl(MethodTypeForm typeForm) {
        Wrapper dstWrapper;
        MethodType dstType = typeForm.erasedType();
        this.classFilePrologue();
        this.mv.visitAnnotation("Ljava/lang/invoke/LambdaForm$Hidden;", true);
        this.mv.visitAnnotation("Ljava/lang/invoke/ForceInline;", true);
        this.emitAloadInsn(0);
        for (int i = 0; i < dstType.parameterCount(); ++i) {
            this.emitAloadInsn(1);
            this.emitIconstInsn(i);
            this.mv.visitInsn(50);
            Class<?> dptype = dstType.parameterType(i);
            if (!dptype.isPrimitive()) continue;
            Class<?> sptype = dstType.basicType().wrap().parameterType(i);
            dstWrapper = Wrapper.forBasicType(dptype);
            Wrapper srcWrapper = dstWrapper.isSubwordOrInt() ? Wrapper.INT : dstWrapper;
            this.emitUnboxing(srcWrapper.wrapperType());
            this.emitPrimCast(srcWrapper.basicTypeChar(), dstWrapper.basicTypeChar());
        }
        String targetDesc = dstType.basicType().toMethodDescriptorString();
        this.mv.visitMethodInsn(182, MH, "invokeBasic", targetDesc);
        Class<?> rtype = dstType.returnType();
        if (rtype != Void.TYPE && rtype.isPrimitive()) {
            Wrapper srcWrapper = Wrapper.forBasicType(rtype);
            dstWrapper = srcWrapper.isSubwordOrInt() ? Wrapper.INT : srcWrapper;
            this.emitPrimCast(srcWrapper.basicTypeChar(), dstWrapper.basicTypeChar());
            this.emitBoxing(dstWrapper.primitiveType());
        }
        if (rtype == Void.TYPE) {
            this.mv.visitInsn(1);
        }
        this.emitReturnInsn(Object.class);
        this.classFileEpilogue();
        this.bogusMethod(dstType);
        byte[] classFile = this.cw.toByteArray();
        InvokerBytecodeGenerator.maybeDump(this.className, classFile);
        return classFile;
    }

    private void bogusMethod(Object ... os) {
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            this.mv = this.cw.visitMethod(8, "dummy", "()V", null, null);
            for (Object o : os) {
                this.mv.visitLdcInsn(o.toString());
                this.mv.visitInsn(87);
            }
            this.mv.visitInsn(177);
            this.mv.visitMaxs(0, 0);
            this.mv.visitEnd();
        }
    }

    static {
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            DUMP_CLASS_FILES_COUNTERS = new HashMap();
            try {
                File dumpDir = new File("DUMP_CLASS_FILES");
                if (!dumpDir.exists()) {
                    dumpDir.mkdirs();
                }
                DUMP_CLASS_FILES_DIR = dumpDir;
                System.out.println("Dumping class files to " + DUMP_CLASS_FILES_DIR + "/...");
            }
            catch (Exception e) {
                throw MethodHandleStatics.newInternalError(e);
            }
        } else {
            DUMP_CLASS_FILES_COUNTERS = null;
            DUMP_CLASS_FILES_DIR = null;
        }
        STATICALLY_INVOCABLE_PACKAGES = new Class[]{Object.class, Arrays.class, Unsafe.class};
        nfi = 0;
    }

    class CpPatch {
        final int index;
        final String placeholder;
        final Object value;

        CpPatch(int index, String placeholder, Object value) {
            this.index = index;
            this.placeholder = placeholder;
            this.value = value;
        }

        public String toString() {
            return "CpPatch/index=" + this.index + ",placeholder=" + this.placeholder + ",value=" + this.value;
        }
    }
}

