/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms.implementations;

import com.sun.org.apache.xml.internal.security.signature.NodeFilter;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XPath2NodeFilter
implements NodeFilter {
    boolean hasUnionFilter;
    boolean hasSubstractFilter;
    boolean hasIntersectFilter;
    Set unionNodes;
    Set substractNodes;
    Set intersectNodes;
    int inSubstract = -1;
    int inIntersect = -1;
    int inUnion = -1;

    XPath2NodeFilter(List unionNodes, List substractNodes, List intersectNodes) {
        this.hasUnionFilter = !unionNodes.isEmpty();
        this.unionNodes = XPath2NodeFilter.convertNodeListToSet(unionNodes);
        this.hasSubstractFilter = !substractNodes.isEmpty();
        this.substractNodes = XPath2NodeFilter.convertNodeListToSet(substractNodes);
        this.hasIntersectFilter = !intersectNodes.isEmpty();
        this.intersectNodes = XPath2NodeFilter.convertNodeListToSet(intersectNodes);
    }

    @Override
    public int isNodeInclude(Node currentNode) {
        int result = 1;
        if (this.hasSubstractFilter && XPath2NodeFilter.rooted(currentNode, this.substractNodes)) {
            result = -1;
        } else if (this.hasIntersectFilter && !XPath2NodeFilter.rooted(currentNode, this.intersectNodes)) {
            result = 0;
        }
        if (result == 1) {
            return 1;
        }
        if (this.hasUnionFilter) {
            if (XPath2NodeFilter.rooted(currentNode, this.unionNodes)) {
                return 1;
            }
            result = 0;
        }
        return result;
    }

    @Override
    public int isNodeIncludeDO(Node n, int level) {
        int result = 1;
        if (this.hasSubstractFilter) {
            if (this.inSubstract == -1 || level <= this.inSubstract) {
                this.inSubstract = XPath2NodeFilter.inList(n, this.substractNodes) ? level : -1;
            }
            if (this.inSubstract != -1) {
                result = -1;
            }
        }
        if (result != -1 && this.hasIntersectFilter && (this.inIntersect == -1 || level <= this.inIntersect)) {
            if (!XPath2NodeFilter.inList(n, this.intersectNodes)) {
                this.inIntersect = -1;
                result = 0;
            } else {
                this.inIntersect = level;
            }
        }
        if (level <= this.inUnion) {
            this.inUnion = -1;
        }
        if (result == 1) {
            return 1;
        }
        if (this.hasUnionFilter) {
            if (this.inUnion == -1 && XPath2NodeFilter.inList(n, this.unionNodes)) {
                this.inUnion = level;
            }
            if (this.inUnion != -1) {
                return 1;
            }
            result = 0;
        }
        return result;
    }

    static boolean rooted(Node currentNode, Set nodeList) {
        if (nodeList.isEmpty()) {
            return false;
        }
        if (nodeList.contains(currentNode)) {
            return true;
        }
        for (Node rootNode : nodeList) {
            if (!XMLUtils.isDescendantOrSelf(rootNode, currentNode)) continue;
            return true;
        }
        return false;
    }

    static boolean inList(Node currentNode, Set nodeList) {
        return nodeList.contains(currentNode);
    }

    private static Set convertNodeListToSet(List l) {
        HashSet<Node> result = new HashSet<Node>();
        for (int j = 0; j < l.size(); ++j) {
            NodeList rootNodes = (NodeList)l.get(j);
            int length = rootNodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node rootNode = rootNodes.item(i);
                result.add(rootNode);
            }
        }
        return result;
    }
}

