/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.finder;

import com.sun.beans.TypeResolver;
import com.sun.beans.WeakCache;
import com.sun.beans.finder.AbstractFinder;
import com.sun.beans.finder.PrimitiveWrapperMap;
import com.sun.beans.finder.Signature;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import sun.reflect.misc.ReflectUtil;

public final class MethodFinder
extends AbstractFinder<Method> {
    private static final WeakCache<Signature, Method> CACHE = new WeakCache();
    private final String name;

    public static Method findMethod(Class<?> type, String name, Class<?> ... args) throws NoSuchMethodException {
        boolean cached;
        if (name == null) {
            throw new IllegalArgumentException("Method name is not set");
        }
        PrimitiveWrapperMap.replacePrimitivesWithWrappers(args);
        Signature signature = new Signature(type, name, args);
        Method method = CACHE.get(signature);
        boolean bl = cached = method != null;
        if (cached && ReflectUtil.isPackageAccessible(method.getDeclaringClass())) {
            return method;
        }
        method = MethodFinder.findAccessibleMethod((Method)new MethodFinder(name, args).find(type.getMethods()));
        if (!cached) {
            CACHE.put(signature, method);
        }
        return method;
    }

    public static Method findInstanceMethod(Class<?> type, String name, Class<?> ... args) throws NoSuchMethodException {
        Method method = MethodFinder.findMethod(type, name, args);
        if (Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException("Method '" + name + "' is static");
        }
        return method;
    }

    public static Method findStaticMethod(Class<?> type, String name, Class<?> ... args) throws NoSuchMethodException {
        Method method = MethodFinder.findMethod(type, name, args);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException("Method '" + name + "' is not static");
        }
        return method;
    }

    public static Method findAccessibleMethod(Method method) throws NoSuchMethodException {
        Class<?> type = method.getDeclaringClass();
        if (Modifier.isPublic(type.getModifiers()) && ReflectUtil.isPackageAccessible(type)) {
            return method;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException("Method '" + method.getName() + "' is not accessible");
        }
        for (Type generic : type.getGenericInterfaces()) {
            try {
                return MethodFinder.findAccessibleMethod(method, generic);
            }
            catch (NoSuchMethodException exception) {
            }
        }
        return MethodFinder.findAccessibleMethod(method, type.getGenericSuperclass());
    }

    private static Method findAccessibleMethod(Method method, Type generic) throws NoSuchMethodException {
        String name = method.getName();
        Object[] params = method.getParameterTypes();
        if (generic instanceof Class) {
            Class type = (Class)generic;
            return MethodFinder.findAccessibleMethod(type.getMethod(name, (Class<?>[])params));
        }
        if (generic instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)generic;
            Class type = (Class)pt.getRawType();
            for (Method m : type.getMethods()) {
                Object[] pts;
                if (!m.getName().equals(name) || (pts = m.getParameterTypes()).length != params.length) continue;
                if (Arrays.equals(params, pts)) {
                    return MethodFinder.findAccessibleMethod(m);
                }
                Type[] gpts = m.getGenericParameterTypes();
                if (params.length != gpts.length || !Arrays.equals(params, TypeResolver.erase(TypeResolver.resolve((Type)pt, gpts)))) continue;
                return MethodFinder.findAccessibleMethod(m);
            }
        }
        throw new NoSuchMethodException("Method '" + name + "' is not accessible");
    }

    private MethodFinder(String name, Class<?>[] args) {
        super(args);
        this.name = name;
    }

    @Override
    protected Class<?>[] getParameters(Method method) {
        return method.getParameterTypes();
    }

    @Override
    protected boolean isVarArgs(Method method) {
        return method.isVarArgs();
    }

    @Override
    protected boolean isValid(Method method) {
        return super.isValid(method) && method.getName().equals(this.name);
    }
}

