/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class KeyGeneratorCore {
    private final String name;
    private final int defaultKeySize;
    private int keySize;
    private SecureRandom random;

    KeyGeneratorCore(String name, int defaultKeySize) {
        this.name = name;
        this.defaultKeySize = defaultKeySize;
        this.implInit(null);
    }

    void implInit(SecureRandom random) {
        this.keySize = this.defaultKeySize;
        this.random = random;
    }

    void implInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException(this.name + " key generation does not take any parameters");
    }

    void implInit(int keysize, SecureRandom random) {
        if (keysize < 40) {
            throw new InvalidParameterException("Key length must be at least 40 bits");
        }
        this.keySize = keysize;
        this.random = random;
    }

    SecretKey implGenerateKey() {
        if (this.random == null) {
            this.random = SunJCE.RANDOM;
        }
        byte[] b = new byte[this.keySize + 7 >> 3];
        this.random.nextBytes(b);
        return new SecretKeySpec(b, this.name);
    }

    public static final class ARCFOURKeyGenerator
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore core = new KeyGeneratorCore("ARCFOUR", 128);

        @Override
        protected void engineInit(SecureRandom random) {
            this.core.implInit(random);
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            this.core.implInit(params, random);
        }

        @Override
        protected void engineInit(int keySize, SecureRandom random) {
            if (keySize < 40 || keySize > 1024) {
                throw new InvalidParameterException("Key length for ARCFOUR must be between 40 and 1024 bits");
            }
            this.core.implInit(keySize, random);
        }

        @Override
        protected SecretKey engineGenerateKey() {
            return this.core.implGenerateKey();
        }
    }

    public static final class RC2KeyGenerator
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore core = new KeyGeneratorCore("RC2", 128);

        @Override
        protected void engineInit(SecureRandom random) {
            this.core.implInit(random);
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            this.core.implInit(params, random);
        }

        @Override
        protected void engineInit(int keySize, SecureRandom random) {
            if (keySize < 40 || keySize > 1024) {
                throw new InvalidParameterException("Key length for RC2 must be between 40 and 1024 bits");
            }
            this.core.implInit(keySize, random);
        }

        @Override
        protected SecretKey engineGenerateKey() {
            return this.core.implGenerateKey();
        }
    }

    public static final class HmacSHA512KG
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore core = new KeyGeneratorCore("HmacSHA512", 512);

        @Override
        protected void engineInit(SecureRandom random) {
            this.core.implInit(random);
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            this.core.implInit(params, random);
        }

        @Override
        protected void engineInit(int keySize, SecureRandom random) {
            this.core.implInit(keySize, random);
        }

        @Override
        protected SecretKey engineGenerateKey() {
            return this.core.implGenerateKey();
        }
    }

    public static final class HmacSHA384KG
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore core = new KeyGeneratorCore("HmacSHA384", 384);

        @Override
        protected void engineInit(SecureRandom random) {
            this.core.implInit(random);
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            this.core.implInit(params, random);
        }

        @Override
        protected void engineInit(int keySize, SecureRandom random) {
            this.core.implInit(keySize, random);
        }

        @Override
        protected SecretKey engineGenerateKey() {
            return this.core.implGenerateKey();
        }
    }

    public static final class HmacSHA256KG
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore core = new KeyGeneratorCore("HmacSHA256", 256);

        @Override
        protected void engineInit(SecureRandom random) {
            this.core.implInit(random);
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            this.core.implInit(params, random);
        }

        @Override
        protected void engineInit(int keySize, SecureRandom random) {
            this.core.implInit(keySize, random);
        }

        @Override
        protected SecretKey engineGenerateKey() {
            return this.core.implGenerateKey();
        }
    }
}

