/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

final class HmacCore
implements Cloneable {
    private final MessageDigest md;
    private final byte[] k_ipad;
    private final byte[] k_opad;
    private boolean first;
    private final int blockLen;

    HmacCore(MessageDigest md, int bl) {
        this.md = md;
        this.blockLen = bl;
        this.k_ipad = new byte[this.blockLen];
        this.k_opad = new byte[this.blockLen];
        this.first = true;
    }

    HmacCore(String digestAlgorithm, int bl) throws NoSuchAlgorithmException {
        this(MessageDigest.getInstance(digestAlgorithm), bl);
    }

    private HmacCore(HmacCore other) throws CloneNotSupportedException {
        this.md = (MessageDigest)other.md.clone();
        this.blockLen = other.blockLen;
        this.k_ipad = (byte[])other.k_ipad.clone();
        this.k_opad = (byte[])other.k_opad.clone();
        this.first = other.first;
    }

    int getDigestLength() {
        return this.md.getDigestLength();
    }

    void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("HMAC does not use parameters");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Secret key expected");
        }
        byte[] secret = key.getEncoded();
        if (secret == null) {
            throw new InvalidKeyException("Missing key data");
        }
        if (secret.length > this.blockLen) {
            byte[] tmp = this.md.digest(secret);
            Arrays.fill(secret, (byte)0);
            secret = tmp;
        }
        for (int i = 0; i < this.blockLen; ++i) {
            byte si = i < secret.length ? secret[i] : (byte)0;
            this.k_ipad[i] = (byte)(si ^ 0x36);
            this.k_opad[i] = (byte)(si ^ 0x5C);
        }
        Arrays.fill(secret, (byte)0);
        secret = null;
        this.reset();
    }

    void update(byte input) {
        if (this.first) {
            this.md.update(this.k_ipad);
            this.first = false;
        }
        this.md.update(input);
    }

    void update(byte[] input, int offset, int len) {
        if (this.first) {
            this.md.update(this.k_ipad);
            this.first = false;
        }
        this.md.update(input, offset, len);
    }

    void update(ByteBuffer input) {
        if (this.first) {
            this.md.update(this.k_ipad);
            this.first = false;
        }
        this.md.update(input);
    }

    byte[] doFinal() {
        if (this.first) {
            this.md.update(this.k_ipad);
        } else {
            this.first = true;
        }
        try {
            byte[] tmp = this.md.digest();
            this.md.update(this.k_opad);
            this.md.update(tmp);
            this.md.digest(tmp, 0, tmp.length);
            return tmp;
        }
        catch (DigestException e) {
            throw new ProviderException(e);
        }
    }

    void reset() {
        if (!this.first) {
            this.md.reset();
            this.first = true;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return new HmacCore(this);
    }

    public static final class HmacSHA512
    extends MacSpi
    implements Cloneable {
        private final HmacCore core;

        public HmacSHA512() throws NoSuchAlgorithmException {
            this.core = new HmacCore("SHA-512", 128);
        }

        private HmacSHA512(HmacSHA512 base) throws CloneNotSupportedException {
            this.core = (HmacCore)base.core.clone();
        }

        @Override
        protected int engineGetMacLength() {
            return this.core.getDigestLength();
        }

        @Override
        protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.init(key, params);
        }

        @Override
        protected void engineUpdate(byte input) {
            this.core.update(input);
        }

        @Override
        protected void engineUpdate(byte[] input, int offset, int len) {
            this.core.update(input, offset, len);
        }

        @Override
        protected void engineUpdate(ByteBuffer input) {
            this.core.update(input);
        }

        @Override
        protected byte[] engineDoFinal() {
            return this.core.doFinal();
        }

        @Override
        protected void engineReset() {
            this.core.reset();
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return new HmacSHA512(this);
        }
    }

    public static final class HmacSHA384
    extends MacSpi
    implements Cloneable {
        private final HmacCore core;

        public HmacSHA384() throws NoSuchAlgorithmException {
            this.core = new HmacCore("SHA-384", 128);
        }

        private HmacSHA384(HmacSHA384 base) throws CloneNotSupportedException {
            this.core = (HmacCore)base.core.clone();
        }

        @Override
        protected int engineGetMacLength() {
            return this.core.getDigestLength();
        }

        @Override
        protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.init(key, params);
        }

        @Override
        protected void engineUpdate(byte input) {
            this.core.update(input);
        }

        @Override
        protected void engineUpdate(byte[] input, int offset, int len) {
            this.core.update(input, offset, len);
        }

        @Override
        protected void engineUpdate(ByteBuffer input) {
            this.core.update(input);
        }

        @Override
        protected byte[] engineDoFinal() {
            return this.core.doFinal();
        }

        @Override
        protected void engineReset() {
            this.core.reset();
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return new HmacSHA384(this);
        }
    }

    public static final class HmacSHA256
    extends MacSpi
    implements Cloneable {
        private final HmacCore core;

        public HmacSHA256() throws NoSuchAlgorithmException {
            this.core = new HmacCore("SHA-256", 64);
        }

        private HmacSHA256(HmacSHA256 base) throws CloneNotSupportedException {
            this.core = (HmacCore)base.core.clone();
        }

        @Override
        protected int engineGetMacLength() {
            return this.core.getDigestLength();
        }

        @Override
        protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.init(key, params);
        }

        @Override
        protected void engineUpdate(byte input) {
            this.core.update(input);
        }

        @Override
        protected void engineUpdate(byte[] input, int offset, int len) {
            this.core.update(input, offset, len);
        }

        @Override
        protected void engineUpdate(ByteBuffer input) {
            this.core.update(input);
        }

        @Override
        protected byte[] engineDoFinal() {
            return this.core.doFinal();
        }

        @Override
        protected void engineReset() {
            this.core.reset();
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return new HmacSHA256(this);
        }
    }
}

