/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.Immediate;
import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.Operand;
import sun.jvm.hotspot.asm.RTLDataTypes;
import sun.jvm.hotspot.asm.RTLOperations;
import sun.jvm.hotspot.asm.x86.X86DirectAddress;
import sun.jvm.hotspot.asm.x86.X86FloatRegisters;
import sun.jvm.hotspot.asm.x86.X86InstructionFactory;
import sun.jvm.hotspot.asm.x86.X86MMXRegisters;
import sun.jvm.hotspot.asm.x86.X86Opcodes;
import sun.jvm.hotspot.asm.x86.X86PCRelativeAddress;
import sun.jvm.hotspot.asm.x86.X86Register;
import sun.jvm.hotspot.asm.x86.X86RegisterIndirectAddress;
import sun.jvm.hotspot.asm.x86.X86Registers;
import sun.jvm.hotspot.asm.x86.X86SegmentRegister;
import sun.jvm.hotspot.asm.x86.X86SegmentRegisterAddress;
import sun.jvm.hotspot.asm.x86.X86SegmentRegisters;
import sun.jvm.hotspot.asm.x86.X86XMMRegisters;

public class InstructionDecoder
implements X86Opcodes,
RTLDataTypes,
RTLOperations {
    protected String name;
    protected int addrMode1;
    protected int operandType1;
    protected int addrMode2;
    protected int operandType2;
    protected int addrMode3;
    protected int operandType3;
    private int mod;
    private int regOrOpcode;
    private int rm;
    protected int prefixes;
    protected int byteIndex;
    protected int instrStartIndex;

    public InstructionDecoder(String name) {
        this.name = name;
        this.operandType1 = -1;
        this.operandType2 = -1;
        this.operandType3 = -1;
        this.addrMode1 = -1;
        this.addrMode2 = -1;
        this.addrMode3 = -1;
    }

    public InstructionDecoder(String name, int addrMode1, int operandType1) {
        this(name);
        this.addrMode1 = addrMode1;
        this.operandType1 = operandType1;
    }

    public InstructionDecoder(String name, int addrMode1, int operandType1, int addrMode2, int operandType2) {
        this(name, addrMode1, operandType1);
        this.addrMode2 = addrMode2;
        this.operandType2 = operandType2;
    }

    public InstructionDecoder(String name, int addrMode1, int operandType1, int addrMode2, int operandType2, int addrMode3, int operandType3) {
        this(name, addrMode1, operandType1, addrMode2, operandType2);
        this.addrMode3 = addrMode3;
        this.operandType3 = operandType3;
    }

    protected Operand getOperand1(byte[] bytesArray, boolean operandSize, boolean addrSize) {
        if (this.addrMode1 != -1 && this.operandType1 != -1) {
            return this.getOperand(bytesArray, this.addrMode1, this.operandType1, operandSize, addrSize);
        }
        return null;
    }

    protected Operand getOperand2(byte[] bytesArray, boolean operandSize, boolean addrSize) {
        if (this.addrMode2 != -1 && this.operandType2 != -1) {
            return this.getOperand(bytesArray, this.addrMode2, this.operandType2, operandSize, addrSize);
        }
        return null;
    }

    protected Operand getOperand3(byte[] bytesArray, boolean operandSize, boolean addrSize) {
        if (this.addrMode3 != -1 && this.operandType3 != -1) {
            return this.getOperand(bytesArray, this.addrMode3, this.operandType3, operandSize, addrSize);
        }
        return null;
    }

    static int readInt32(byte[] bytesArray, int index) {
        int ret = 0;
        ret = InstructionDecoder.readByte(bytesArray, index);
        ret |= InstructionDecoder.readByte(bytesArray, index + 1) << 8;
        ret |= InstructionDecoder.readByte(bytesArray, index + 2) << 16;
        return ret |= InstructionDecoder.readByte(bytesArray, index + 3) << 24;
    }

    static int readInt16(byte[] bytesArray, int index) {
        int ret = 0;
        ret = InstructionDecoder.readByte(bytesArray, index);
        return ret |= InstructionDecoder.readByte(bytesArray, index + 1) << 8;
    }

    static int readByte(byte[] bytesArray, int index) {
        int ret = 0;
        if (index < bytesArray.length) {
            ret = bytesArray[index];
            ret &= 0xFF;
        }
        return ret;
    }

    private boolean isModRMPresent(int addrMode) {
        return addrMode == 1 || addrMode == 5 || addrMode == 18 || addrMode == 20 || addrMode == 19;
    }

    public int getCurrentIndex() {
        return this.byteIndex;
    }

    public Instruction decode(byte[] bytesArray, int index, int instrStartIndex, int segmentOverride, int prefixes, X86InstructionFactory factory) {
        this.byteIndex = index;
        this.instrStartIndex = instrStartIndex;
        this.prefixes = prefixes;
        boolean operandSize = (prefixes & 0x200 ^ segmentOverride) == 1;
        boolean addrSize = (prefixes & 0x400 ^ segmentOverride) == 1;
        this.name = this.getCorrectOpcodeName(this.name, prefixes, operandSize, addrSize);
        if (this.isModRMPresent(this.addrMode1) || this.isModRMPresent(this.addrMode2) || this.isModRMPresent(this.addrMode3)) {
            int ModRM = InstructionDecoder.readByte(bytesArray, this.byteIndex);
            ++this.byteIndex;
            this.mod = ModRM >> 6 & 3;
            this.regOrOpcode = ModRM >> 3 & 7;
            this.rm = ModRM & 7;
        }
        return this.decodeInstruction(bytesArray, operandSize, addrSize, factory);
    }

    protected Instruction decodeInstruction(byte[] bytesArray, boolean operandSize, boolean addrSize, X86InstructionFactory factory) {
        Operand op1 = this.getOperand1(bytesArray, operandSize, addrSize);
        Operand op2 = this.getOperand2(bytesArray, operandSize, addrSize);
        Operand op3 = this.getOperand3(bytesArray, operandSize, addrSize);
        int size = this.byteIndex - this.instrStartIndex;
        return factory.newGeneralInstruction(this.name, op1, op2, op3, size, this.prefixes);
    }

    private String getCorrectOpcodeName(String oldName, int prefixes, boolean operandSize, boolean addrSize) {
        StringBuffer newName = new StringBuffer(oldName);
        int index = 0;
        block5: for (index = 0; index < oldName.length(); ++index) {
            switch (oldName.charAt(index)) {
                case 'C': {
                    if (addrSize) {
                        newName.setCharAt(index, 'e');
                    }
                    ++index;
                    continue block5;
                }
                case 'N': {
                    if ((prefixes & 0x800) == 0) {
                        newName.setCharAt(index, 'n');
                    }
                    ++index;
                    continue block5;
                }
                case 'S': {
                    if (operandSize) {
                        newName.setCharAt(index, 'l');
                    } else {
                        newName.setCharAt(index, 'w');
                    }
                    ++index;
                    continue block5;
                }
            }
        }
        return newName.toString();
    }

    private Operand getOperand(byte[] bytesArray, int addrMode, int operandType, boolean operandSize, boolean addrSize) {
        Operand op = null;
        block0 : switch (addrMode) {
            case 1: 
            case 19: 
            case 20: {
                X86SegmentRegister segReg = this.getSegmentRegisterFromPrefix(this.prefixes);
                if (this.mod == 3) {
                    if (addrMode == 1) {
                        switch (operandType) {
                            case 1: {
                                op = X86Registers.getRegister8(this.rm);
                                break block0;
                            }
                            case 3: {
                                op = X86Registers.getRegister16(this.rm);
                                break block0;
                            }
                            case 2: {
                                if (operandSize) {
                                    op = X86Registers.getRegister32(this.rm);
                                    break block0;
                                }
                                op = X86Registers.getRegister16(this.rm);
                                break block0;
                            }
                            case 5: {
                                X86Register reg = operandSize ? X86Registers.getRegister32(this.rm) : X86Registers.getRegister16(this.rm);
                                op = new X86RegisterIndirectAddress(segReg, reg, null, 0L);
                                break block0;
                            }
                        }
                        break;
                    }
                    if (addrMode == 19) {
                        op = X86XMMRegisters.getRegister(this.rm);
                        break;
                    }
                    if (addrMode != 20) break;
                    op = X86MMXRegisters.getRegister(this.rm);
                    break;
                }
                int scale = 0;
                int index = 0;
                int base = 0;
                long disp = 0L;
                if (this.rm == 4) {
                    int sib = InstructionDecoder.readByte(bytesArray, this.byteIndex);
                    ++this.byteIndex;
                    scale = sib >> 6 & 3;
                    index = sib >> 3 & 7;
                    base = sib & 7;
                }
                block22 : switch (this.mod) {
                    case 0: {
                        switch (this.rm) {
                            case 4: {
                                if (base == 5) {
                                    disp = InstructionDecoder.readInt32(bytesArray, this.byteIndex);
                                    this.byteIndex += 4;
                                    if (index != 4) {
                                        op = new X86RegisterIndirectAddress(segReg, null, X86Registers.getRegister32(index), disp, scale);
                                        break block22;
                                    }
                                    op = new X86RegisterIndirectAddress(segReg, null, null, disp, scale);
                                    break block22;
                                }
                                if (index != 4) {
                                    op = new X86RegisterIndirectAddress(segReg, X86Registers.getRegister32(base), X86Registers.getRegister32(index), 0L, scale);
                                    break block22;
                                }
                                op = new X86RegisterIndirectAddress(segReg, X86Registers.getRegister32(base), null, 0L, scale);
                                break block22;
                            }
                            case 5: {
                                disp = InstructionDecoder.readInt32(bytesArray, this.byteIndex);
                                this.byteIndex += 4;
                                op = new X86RegisterIndirectAddress(segReg, null, null, disp);
                                break block22;
                            }
                        }
                        base = this.rm;
                        op = new X86RegisterIndirectAddress(segReg, X86Registers.getRegister32(base), null, 0L);
                        break;
                    }
                    case 1: {
                        disp = (byte)InstructionDecoder.readByte(bytesArray, this.byteIndex);
                        ++this.byteIndex;
                        if (this.rm != 4) {
                            base = this.rm;
                            op = new X86RegisterIndirectAddress(segReg, X86Registers.getRegister32(base), null, disp);
                            break;
                        }
                        if (index != 4) {
                            op = new X86RegisterIndirectAddress(segReg, X86Registers.getRegister32(base), X86Registers.getRegister32(index), disp, scale);
                            break;
                        }
                        op = new X86RegisterIndirectAddress(segReg, X86Registers.getRegister32(base), null, disp, scale);
                        break;
                    }
                    case 2: {
                        disp = InstructionDecoder.readInt32(bytesArray, this.byteIndex);
                        this.byteIndex += 4;
                        if (this.rm != 4) {
                            base = this.rm;
                            op = new X86RegisterIndirectAddress(segReg, X86Registers.getRegister32(base), null, disp);
                            break;
                        }
                        op = index != 4 ? new X86RegisterIndirectAddress(segReg, X86Registers.getRegister32(base), X86Registers.getRegister32(index), disp, scale) : new X86RegisterIndirectAddress(segReg, X86Registers.getRegister32(base), null, disp, scale);
                    }
                }
                break;
            }
            case 2: {
                switch (operandType) {
                    case 1: {
                        op = new Immediate(new Integer(InstructionDecoder.readByte(bytesArray, this.byteIndex)));
                        ++this.byteIndex;
                        break block0;
                    }
                    case 3: {
                        op = new Immediate(new Integer(InstructionDecoder.readInt16(bytesArray, this.byteIndex)));
                        this.byteIndex += 2;
                        break block0;
                    }
                    case 2: {
                        if (operandSize) {
                            op = new Immediate(new Integer(InstructionDecoder.readInt32(bytesArray, this.byteIndex)));
                            this.byteIndex += 4;
                            break block0;
                        }
                        op = new Immediate(new Integer(InstructionDecoder.readInt16(bytesArray, this.byteIndex)));
                        this.byteIndex += 2;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (operandType) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (operandSize) {
                            op = X86Registers.getRegister32(operandType - 0);
                            break;
                        }
                        op = X86Registers.getRegister16(operandType - 0);
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        op = X86Registers.getRegister16(operandType - 8);
                        break;
                    }
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        op = X86Registers.getRegister8(operandType - 16);
                        break;
                    }
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: {
                        op = X86SegmentRegisters.getSegmentRegister(operandType - 24);
                    }
                }
                break;
            }
            case 3: {
                long segment = 0L;
                long offset = 0L;
                switch (operandType) {
                    case 5: {
                        if (addrSize) {
                            offset = InstructionDecoder.readInt32(bytesArray, this.byteIndex);
                            this.byteIndex += 4;
                            segment = InstructionDecoder.readInt16(bytesArray, this.byteIndex);
                            this.byteIndex += 2;
                        } else {
                            offset = InstructionDecoder.readInt16(bytesArray, this.byteIndex);
                            this.byteIndex += 2;
                            segment = InstructionDecoder.readInt16(bytesArray, this.byteIndex);
                            this.byteIndex += 2;
                        }
                        op = new X86DirectAddress(segment, offset);
                        break block0;
                    }
                    case 2: {
                        if (addrSize) {
                            offset = InstructionDecoder.readInt32(bytesArray, this.byteIndex);
                            this.byteIndex += 4;
                        } else {
                            offset = InstructionDecoder.readInt16(bytesArray, this.byteIndex);
                            this.byteIndex += 2;
                        }
                        op = new X86DirectAddress(offset);
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (operandType) {
                    case 1: {
                        op = X86Registers.getRegister8(this.regOrOpcode);
                        break block0;
                    }
                    case 3: {
                        op = X86Registers.getRegister16(this.regOrOpcode);
                        break block0;
                    }
                    case 4: {
                        op = X86Registers.getRegister32(this.regOrOpcode);
                        break block0;
                    }
                    case 2: {
                        if (operandSize) {
                            op = X86Registers.getRegister32(this.regOrOpcode);
                            break block0;
                        }
                        op = X86Registers.getRegister16(this.regOrOpcode);
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                op = X86SegmentRegisters.getSegmentRegister(this.regOrOpcode);
                break;
            }
            case 10: {
                int off = 0;
                if (addrSize) {
                    off = InstructionDecoder.readInt32(bytesArray, this.byteIndex);
                    this.byteIndex += 4;
                } else {
                    off = InstructionDecoder.readInt16(bytesArray, this.byteIndex);
                    this.byteIndex += 2;
                }
                op = new X86DirectAddress(off);
                break;
            }
            case 4: {
                long disp = 0L;
                switch (operandType) {
                    case 1: {
                        disp = (byte)InstructionDecoder.readByte(bytesArray, this.byteIndex);
                        ++this.byteIndex;
                        break;
                    }
                    case 2: {
                        if (operandSize) {
                            disp = InstructionDecoder.readInt32(bytesArray, this.byteIndex);
                            this.byteIndex += 4;
                            break;
                        }
                        disp = InstructionDecoder.readInt16(bytesArray, this.byteIndex);
                        this.byteIndex += 2;
                    }
                }
                op = new X86PCRelativeAddress(disp);
                break;
            }
            case 7: {
                op = new X86SegmentRegisterAddress(X86SegmentRegisters.ES, X86Registers.DI);
                break;
            }
            case 8: {
                op = new X86SegmentRegisterAddress(X86SegmentRegisters.DS, X86Registers.SI);
                break;
            }
            case 13: {
                switch (operandType) {
                    case 1: {
                        op = X86Registers.getRegister8(this.mod);
                        break block0;
                    }
                    case 3: {
                        op = X86Registers.getRegister16(this.mod);
                        break block0;
                    }
                    case 4: {
                        op = X86Registers.getRegister32(this.mod);
                        break block0;
                    }
                    case 2: {
                        if (operandSize) {
                            op = X86Registers.getRegister32(this.mod);
                            break block0;
                        }
                        op = X86Registers.getRegister16(this.mod);
                        break block0;
                    }
                }
                break;
            }
            case 18: {
                switch (operandType) {
                    case 0: {
                        op = X86FloatRegisters.getRegister(0);
                        break;
                    }
                    case 1: {
                        op = X86FloatRegisters.getRegister(this.rm);
                    }
                }
                break;
            }
            case 21: {
                op = X86XMMRegisters.getRegister(this.regOrOpcode);
                break;
            }
            case 22: {
                op = X86MMXRegisters.getRegister(this.regOrOpcode);
            }
        }
        return op;
    }

    private X86SegmentRegister getSegmentRegisterFromPrefix(int prefixes) {
        X86SegmentRegister segRegister = null;
        if ((prefixes & 8) != 0) {
            segRegister = X86SegmentRegisters.CS;
        }
        if ((prefixes & 0x20) != 0) {
            segRegister = X86SegmentRegisters.DS;
        }
        if ((prefixes & 0x40) != 0) {
            segRegister = X86SegmentRegisters.ES;
        }
        if ((prefixes & 0x80) != 0) {
            segRegister = X86SegmentRegisters.FS;
        }
        if ((prefixes & 0x10) != 0) {
            segRegister = X86SegmentRegisters.SS;
        }
        if ((prefixes & 0x100) != 0) {
            segRegister = X86SegmentRegisters.GS;
        }
        return segRegister;
    }
}

