/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import com.sun.rmi.rmid.ExecOptionPermission;
import com.sun.rmi.rmid.ExecPermission;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.Channel;
import java.nio.channels.ServerSocketChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.Activator;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteServer;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import sun.rmi.log.LogHandler;
import sun.rmi.log.ReliableLog;
import sun.rmi.registry.RegistryImpl;
import sun.rmi.server.ActivationGroupImpl;
import sun.rmi.server.InactiveGroupException;
import sun.rmi.server.MarshalOutputStream;
import sun.rmi.server.PipeWriter;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.transport.LiveRef;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;
import sun.security.provider.PolicyFile;

public class Activation
implements Serializable {
    private static final long serialVersionUID = 2921265612698155191L;
    private static final byte MAJOR_VERSION = 1;
    private static final byte MINOR_VERSION = 0;
    private static Object execPolicy;
    private static Method execPolicyMethod;
    private static boolean debugExec;
    private Map<ActivationID, ActivationGroupID> idTable = new ConcurrentHashMap<ActivationID, ActivationGroupID>();
    private Map<ActivationGroupID, GroupEntry> groupTable = new ConcurrentHashMap<ActivationGroupID, GroupEntry>();
    private byte majorVersion = 1;
    private byte minorVersion = 0;
    private transient int groupSemaphore;
    private transient int groupCounter;
    private transient ReliableLog log;
    private transient int numUpdates;
    private transient String[] command;
    private static final long groupTimeout;
    private static final int snapshotInterval;
    private static final long execTimeout;
    private static final Object initLock;
    private static boolean initDone;
    private transient Activator activator;
    private transient Activator activatorStub;
    private transient ActivationSystem system;
    private transient ActivationSystem systemStub;
    private transient ActivationMonitor monitor;
    private transient Registry registry;
    private volatile transient boolean shuttingDown = false;
    private volatile transient Object startupLock;
    private transient Thread shutdownHook;
    private static ResourceBundle resources;

    private static int getInt(String name, int def) {
        return AccessController.doPrivileged(new GetIntegerAction(name, def));
    }

    private Activation() {
    }

    private static void startActivation(int port, RMIServerSocketFactory ssf, String logName, String[] childArgs) throws Exception {
        ReliableLog log = new ReliableLog(logName, new ActLogHandler());
        Activation state = (Activation)log.recover();
        state.init(port, ssf, log, childArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(int port, RMIServerSocketFactory ssf, ReliableLog log, String[] childArgs) throws Exception {
        this.log = log;
        this.numUpdates = 0;
        this.shutdownHook = new ShutdownHook();
        this.groupSemaphore = Activation.getInt("sun.rmi.activation.groupThrottle", 3);
        this.groupCounter = 0;
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        ActivationGroupID[] gids = this.groupTable.keySet().toArray(new ActivationGroupID[0]);
        Object object = this.startupLock = new Object();
        synchronized (this.startupLock) {
            this.activator = new ActivatorImpl(port, ssf);
            this.activatorStub = (Activator)RemoteObject.toStub(this.activator);
            this.system = new ActivationSystemImpl(port, ssf);
            this.systemStub = (ActivationSystem)RemoteObject.toStub(this.system);
            this.monitor = new ActivationMonitorImpl(port, ssf);
            this.initCommand(childArgs);
            this.registry = new SystemRegistryImpl(port, null, ssf, this.systemStub);
            if (ssf != null) {
                Object object2 = initLock;
                synchronized (object2) {
                    initDone = true;
                    initLock.notifyAll();
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            this.startupLock = null;
            int i = gids.length;
            while (--i >= 0) {
                try {
                    this.getGroupEntry(gids[i]).restartServices();
                }
                catch (UnknownGroupException e) {
                    System.err.println(Activation.getTextResource("rmid.restart.group.warning"));
                    e.printStackTrace();
                }
            }
            return;
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (!(this.groupTable instanceof ConcurrentHashMap)) {
            this.groupTable = new ConcurrentHashMap<ActivationGroupID, GroupEntry>(this.groupTable);
        }
        if (!(this.idTable instanceof ConcurrentHashMap)) {
            this.idTable = new ConcurrentHashMap<ActivationID, ActivationGroupID>(this.idTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkShutdown() throws ActivationException {
        Object lock = this.startupLock;
        if (lock != null) {
            Object object = lock;
            synchronized (object) {
            }
        }
        if (this.shuttingDown) {
            throw new ActivationException("activation system shutting down");
        }
    }

    private static void unexport(Remote obj) {
        while (true) {
            try {
                while (!UnicastRemoteObject.unexportObject(obj, false)) {
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                continue;
            }
            break;
        }
    }

    private ActivationGroupID getGroupID(ActivationID id) throws UnknownObjectException {
        ActivationGroupID groupID = this.idTable.get(id);
        if (groupID != null) {
            return groupID;
        }
        throw new UnknownObjectException("unknown object: " + id);
    }

    private GroupEntry getGroupEntry(ActivationGroupID id, boolean rm) throws UnknownGroupException {
        GroupEntry entry;
        if (id.getClass() == ActivationGroupID.class && (entry = rm ? this.groupTable.remove(id) : this.groupTable.get(id)) != null && !entry.removed) {
            return entry;
        }
        throw new UnknownGroupException("group unknown");
    }

    private GroupEntry getGroupEntry(ActivationGroupID id) throws UnknownGroupException {
        return this.getGroupEntry(id, false);
    }

    private GroupEntry removeGroupEntry(ActivationGroupID id) throws UnknownGroupException {
        return this.getGroupEntry(id, true);
    }

    private GroupEntry getGroupEntry(ActivationID id) throws UnknownObjectException {
        ActivationGroupID gid = this.getGroupID(id);
        GroupEntry entry = this.groupTable.get(gid);
        if (entry != null && !entry.removed) {
            return entry;
        }
        throw new UnknownObjectException("object's group removed");
    }

    private String[] activationArgs(ActivationGroupDesc desc) {
        Properties props;
        ActivationGroupDesc.CommandEnvironment cmdenv = desc.getCommandEnvironment();
        ArrayList<String> argv = new ArrayList<String>();
        argv.add(cmdenv != null && cmdenv.getCommandPath() != null ? cmdenv.getCommandPath() : this.command[0]);
        if (cmdenv != null && cmdenv.getCommandOptions() != null) {
            argv.addAll(Arrays.asList(cmdenv.getCommandOptions()));
        }
        if ((props = desc.getPropertyOverrides()) != null) {
            Enumeration<?> p = props.propertyNames();
            while (p.hasMoreElements()) {
                String name = (String)p.nextElement();
                argv.add("-D" + name + "=" + props.getProperty(name));
            }
        }
        for (int i = 1; i < this.command.length; ++i) {
            argv.add(this.command[i]);
        }
        String[] realArgv = new String[argv.size()];
        System.arraycopy(argv.toArray(), 0, realArgv, 0, realArgv.length);
        return realArgv;
    }

    private void checkArgs(ActivationGroupDesc desc, String[] cmd) throws SecurityException, ActivationException {
        if (execPolicyMethod != null) {
            if (cmd == null) {
                cmd = this.activationArgs(desc);
            }
            try {
                execPolicyMethod.invoke(execPolicy, desc, cmd);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof SecurityException) {
                    throw (SecurityException)targetException;
                }
                throw new ActivationException(execPolicyMethod.getName() + ": unexpected exception", e);
            }
            catch (Exception e) {
                throw new ActivationException(execPolicyMethod.getName() + ": unexpected exception", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLogRecord(LogRecord rec) throws ActivationException {
        ReliableLog reliableLog = this.log;
        synchronized (reliableLog) {
            this.checkShutdown();
            try {
                this.log.update(rec, true);
            }
            catch (Exception e) {
                this.numUpdates = snapshotInterval;
                System.err.println(Activation.getTextResource("rmid.log.update.warning"));
                e.printStackTrace();
            }
            if (++this.numUpdates < snapshotInterval) {
                return;
            }
            try {
                this.log.snapshot(this);
                this.numUpdates = 0;
            }
            catch (Exception e) {
                System.err.println(Activation.getTextResource("rmid.log.snapshot.warning"));
                e.printStackTrace();
                try {
                    this.system.shutdown();
                }
                catch (RemoteException ignore) {
                    // empty catch block
                }
                throw new ActivationException("log snapshot failed", e);
            }
        }
    }

    private void initCommand(String[] childArgs) {
        this.command = new String[childArgs.length + 2];
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    ((Activation)Activation.this).command[0] = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
                }
                catch (Exception e) {
                    System.err.println(Activation.getTextResource("rmid.unfound.java.home.property"));
                    ((Activation)Activation.this).command[0] = "java";
                }
                return null;
            }
        });
        System.arraycopy(childArgs, 0, this.command, 1, childArgs.length);
        this.command[this.command.length - 1] = "sun.rmi.server.ActivationGroupInit";
    }

    private static void bomb(String error) {
        System.err.println("rmid: " + error);
        System.err.println(MessageFormat.format(Activation.getTextResource("rmid.usage"), "rmid"));
        System.exit(1);
    }

    public static void main(String[] args) {
        boolean stop = false;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        try {
            int port = 1098;
            ActivationServerSocketFactory ssf = null;
            Channel inheritedChannel = AccessController.doPrivileged(new PrivilegedExceptionAction<Channel>(){

                @Override
                public Channel run() throws IOException {
                    return System.inheritedChannel();
                }
            });
            if (inheritedChannel != null && inheritedChannel instanceof ServerSocketChannel) {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        File file = Files.createTempFile("rmid-err", null, new FileAttribute[0]).toFile();
                        PrintStream errStream = new PrintStream(new FileOutputStream(file));
                        System.setErr(errStream);
                        return null;
                    }
                });
                ServerSocket serverSocket = ((ServerSocketChannel)inheritedChannel).socket();
                port = serverSocket.getLocalPort();
                ssf = new ActivationServerSocketFactory(serverSocket);
                System.err.println(new Date());
                System.err.println(Activation.getTextResource("rmid.inherited.channel.info") + ": " + inheritedChannel);
            }
            String log = null;
            ArrayList<String> childArgs = new ArrayList<String>();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-port")) {
                    if (ssf != null) {
                        Activation.bomb(Activation.getTextResource("rmid.syntax.port.badarg"));
                    }
                    if (i + 1 < args.length) {
                        try {
                            port = Integer.parseInt(args[++i]);
                        }
                        catch (NumberFormatException nfe) {
                            Activation.bomb(Activation.getTextResource("rmid.syntax.port.badnumber"));
                        }
                        continue;
                    }
                    Activation.bomb(Activation.getTextResource("rmid.syntax.port.missing"));
                    continue;
                }
                if (args[i].equals("-log")) {
                    if (i + 1 < args.length) {
                        log = args[++i];
                        continue;
                    }
                    Activation.bomb(Activation.getTextResource("rmid.syntax.log.missing"));
                    continue;
                }
                if (args[i].equals("-stop")) {
                    stop = true;
                    continue;
                }
                if (args[i].startsWith("-C")) {
                    childArgs.add(args[i].substring(2));
                    continue;
                }
                Activation.bomb(MessageFormat.format(Activation.getTextResource("rmid.syntax.illegal.option"), args[i]));
            }
            if (log == null) {
                if (ssf != null) {
                    Activation.bomb(Activation.getTextResource("rmid.syntax.log.required"));
                } else {
                    log = "log";
                }
            }
            debugExec = AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.activation.debugExec"));
            String execPolicyClassName = AccessController.doPrivileged(new GetPropertyAction("sun.rmi.activation.execPolicy", null));
            if (execPolicyClassName == null) {
                if (!stop) {
                    DefaultExecPolicy.checkConfiguration();
                }
                execPolicyClassName = "default";
            }
            if (!execPolicyClassName.equals("none")) {
                if (execPolicyClassName.equals("") || execPolicyClassName.equals("default")) {
                    execPolicyClassName = DefaultExecPolicy.class.getName();
                }
                try {
                    Class<?> execPolicyClass = Activation.getRMIClass(execPolicyClassName);
                    execPolicy = execPolicyClass.newInstance();
                    execPolicyMethod = execPolicyClass.getMethod("checkExecCommand", ActivationGroupDesc.class, String[].class);
                }
                catch (Exception e) {
                    if (debugExec) {
                        System.err.println(Activation.getTextResource("rmid.exec.policy.exception"));
                        e.printStackTrace();
                    }
                    Activation.bomb(Activation.getTextResource("rmid.exec.policy.invalid"));
                }
            }
            if (stop) {
                final int finalPort = port;
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        System.setProperty("java.rmi.activation.port", Integer.toString(finalPort));
                        return null;
                    }
                });
                ActivationSystem system = ActivationGroup.getSystem();
                system.shutdown();
                System.exit(0);
            }
            Activation.startActivation(port, ssf, log, childArgs.toArray(new String[childArgs.size()]));
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(Long.MAX_VALUE);
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.err.println(MessageFormat.format(Activation.getTextResource("rmid.unexpected.exception"), e));
            e.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private static String getTextResource(String key) {
        if (resources == null) {
            try {
                resources = ResourceBundle.getBundle("sun.rmi.server.resources.rmid");
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
            if (resources == null) {
                return "[missing resource file: " + key + "]";
            }
        }
        String val = null;
        try {
            val = resources.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (val == null) {
            return "[missing resource: " + key + "]";
        }
        return val;
    }

    private static Class<?> getRMIClass(String execPolicyClassName) throws Exception {
        return RMIClassLoader.loadClass(execPolicyClassName);
    }

    private synchronized String Pstartgroup() throws ActivationException {
        while (true) {
            this.checkShutdown();
            if (this.groupSemaphore > 0) {
                --this.groupSemaphore;
                return "Group-" + this.groupCounter++;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private synchronized void Vstartgroup() {
        ++this.groupSemaphore;
        this.notifyAll();
    }

    static {
        groupTimeout = Activation.getInt("sun.rmi.activation.groupTimeout", 60000);
        snapshotInterval = Activation.getInt("sun.rmi.activation.snapshotInterval", 200);
        execTimeout = Activation.getInt("sun.rmi.activation.execTimeout", 30000);
        initLock = new Object();
        initDone = false;
        resources = null;
    }

    private static class DelayedAcceptServerSocket
    extends ServerSocket {
        private final ServerSocket serverSocket;

        DelayedAcceptServerSocket(ServerSocket serverSocket) throws IOException {
            this.serverSocket = serverSocket;
        }

        @Override
        public void bind(SocketAddress endpoint) throws IOException {
            this.serverSocket.bind(endpoint);
        }

        @Override
        public void bind(SocketAddress endpoint, int backlog) throws IOException {
            this.serverSocket.bind(endpoint, backlog);
        }

        @Override
        public InetAddress getInetAddress() {
            return AccessController.doPrivileged(new PrivilegedAction<InetAddress>(){

                @Override
                public InetAddress run() {
                    return DelayedAcceptServerSocket.this.serverSocket.getInetAddress();
                }
            });
        }

        @Override
        public int getLocalPort() {
            return this.serverSocket.getLocalPort();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return AccessController.doPrivileged(new PrivilegedAction<SocketAddress>(){

                @Override
                public SocketAddress run() {
                    return DelayedAcceptServerSocket.this.serverSocket.getLocalSocketAddress();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Socket accept() throws IOException {
            Object object = initLock;
            synchronized (object) {
                try {
                    while (!initDone) {
                        initLock.wait();
                    }
                }
                catch (InterruptedException ignore) {
                    throw new AssertionError((Object)ignore);
                }
            }
            return this.serverSocket.accept();
        }

        @Override
        public void close() throws IOException {
            this.serverSocket.close();
        }

        @Override
        public ServerSocketChannel getChannel() {
            return this.serverSocket.getChannel();
        }

        @Override
        public boolean isBound() {
            return this.serverSocket.isBound();
        }

        @Override
        public boolean isClosed() {
            return this.serverSocket.isClosed();
        }

        @Override
        public void setSoTimeout(int timeout) throws SocketException {
            this.serverSocket.setSoTimeout(timeout);
        }

        @Override
        public int getSoTimeout() throws IOException {
            return this.serverSocket.getSoTimeout();
        }

        @Override
        public void setReuseAddress(boolean on) throws SocketException {
            this.serverSocket.setReuseAddress(on);
        }

        @Override
        public boolean getReuseAddress() throws SocketException {
            return this.serverSocket.getReuseAddress();
        }

        @Override
        public String toString() {
            return this.serverSocket.toString();
        }

        @Override
        public void setReceiveBufferSize(int size) throws SocketException {
            this.serverSocket.setReceiveBufferSize(size);
        }

        @Override
        public int getReceiveBufferSize() throws SocketException {
            return this.serverSocket.getReceiveBufferSize();
        }
    }

    private static class ActivationServerSocketFactory
    implements RMIServerSocketFactory {
        private final ServerSocket serverSocket;

        ActivationServerSocketFactory(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            return new DelayedAcceptServerSocket(this.serverSocket);
        }
    }

    public static class DefaultExecPolicy {
        public void checkExecCommand(ActivationGroupDesc desc, String[] cmd) throws SecurityException {
            String groupClassName;
            PermissionCollection perms = DefaultExecPolicy.getExecPermissions();
            Properties props = desc.getPropertyOverrides();
            if (props != null) {
                Enumeration<?> p = props.propertyNames();
                while (p.hasMoreElements()) {
                    String name = (String)p.nextElement();
                    String value = props.getProperty(name);
                    String option = "-D" + name + "=" + value;
                    try {
                        DefaultExecPolicy.checkPermission(perms, new ExecOptionPermission(option));
                    }
                    catch (AccessControlException e) {
                        if (value.equals("")) {
                            DefaultExecPolicy.checkPermission(perms, new ExecOptionPermission("-D" + name));
                            continue;
                        }
                        throw e;
                    }
                }
            }
            if ((groupClassName = desc.getClassName()) != null && !groupClassName.equals(ActivationGroupImpl.class.getName()) || desc.getLocation() != null || desc.getData() != null) {
                throw new AccessControlException("access denied (custom group implementation not allowed)");
            }
            ActivationGroupDesc.CommandEnvironment cmdenv = desc.getCommandEnvironment();
            if (cmdenv != null) {
                String[] options;
                String path = cmdenv.getCommandPath();
                if (path != null) {
                    DefaultExecPolicy.checkPermission(perms, new ExecPermission(path));
                }
                if ((options = cmdenv.getCommandOptions()) != null) {
                    for (String option : options) {
                        DefaultExecPolicy.checkPermission(perms, new ExecOptionPermission(option));
                    }
                }
            }
        }

        static void checkConfiguration() {
            Policy policy = AccessController.doPrivileged(new PrivilegedAction<Policy>(){

                @Override
                public Policy run() {
                    return Policy.getPolicy();
                }
            });
            if (!(policy instanceof PolicyFile)) {
                return;
            }
            PermissionCollection perms = DefaultExecPolicy.getExecPermissions();
            Enumeration<Permission> e = perms.elements();
            while (e.hasMoreElements()) {
                Permission p = e.nextElement();
                if (!(p instanceof AllPermission) && !(p instanceof ExecPermission) && !(p instanceof ExecOptionPermission)) continue;
                return;
            }
            System.err.println(Activation.getTextResource("rmid.exec.perms.inadequate"));
        }

        private static PermissionCollection getExecPermissions() {
            PermissionCollection perms = AccessController.doPrivileged(new PrivilegedAction<PermissionCollection>(){

                @Override
                public PermissionCollection run() {
                    CodeSource codesource = new CodeSource(null, (Certificate[])null);
                    Policy p = Policy.getPolicy();
                    if (p != null) {
                        return p.getPermissions(codesource);
                    }
                    return new Permissions();
                }
            });
            return perms;
        }

        private static void checkPermission(PermissionCollection perms, Permission p) throws AccessControlException {
            if (!perms.implies(p)) {
                throw new AccessControlException("access denied " + p.toString());
            }
        }
    }

    private static class LogGroupIncarnation
    extends LogRecord {
        private static final long serialVersionUID = 4146872747377631897L;
        private ActivationGroupID id;
        private long inc;

        LogGroupIncarnation(ActivationGroupID id, long inc) {
            this.id = id;
            this.inc = inc;
        }

        @Override
        Object apply(Object state) {
            try {
                GroupEntry entry = ((Activation)state).getGroupEntry(this.id);
                entry.incarnation = this.inc;
            }
            catch (Exception ignore) {
                System.err.println(MessageFormat.format(Activation.getTextResource("rmid.log.recover.warning"), "LogGroupIncarnation"));
                ignore.printStackTrace();
            }
            return state;
        }
    }

    private static class LogUnregisterGroup
    extends LogRecord {
        private static final long serialVersionUID = -3356306586522147344L;
        private ActivationGroupID id;

        LogUnregisterGroup(ActivationGroupID id) {
            this.id = id;
        }

        @Override
        Object apply(Object state) {
            GroupEntry entry = (GroupEntry)((Activation)state).groupTable.remove(this.id);
            try {
                entry.unregisterGroup(false);
            }
            catch (Exception ignore) {
                System.err.println(MessageFormat.format(Activation.getTextResource("rmid.log.recover.warning"), "LogUnregisterGroup"));
                ignore.printStackTrace();
            }
            return state;
        }
    }

    private static class LogUpdateGroupDesc
    extends LogRecord {
        private static final long serialVersionUID = -1271300989218424337L;
        private ActivationGroupID id;
        private ActivationGroupDesc desc;

        LogUpdateGroupDesc(ActivationGroupID id, ActivationGroupDesc desc) {
            this.id = id;
            this.desc = desc;
        }

        @Override
        Object apply(Object state) {
            try {
                ((Activation)state).getGroupEntry(this.id).setActivationGroupDesc(this.id, this.desc, false);
            }
            catch (Exception ignore) {
                System.err.println(MessageFormat.format(Activation.getTextResource("rmid.log.recover.warning"), "LogUpdateGroupDesc"));
                ignore.printStackTrace();
            }
            return state;
        }
    }

    private static class LogUpdateDesc
    extends LogRecord {
        private static final long serialVersionUID = 545511539051179885L;
        private ActivationID id;
        private ActivationDesc desc;

        LogUpdateDesc(ActivationID id, ActivationDesc desc) {
            this.id = id;
            this.desc = desc;
        }

        @Override
        Object apply(Object state) {
            try {
                ((Activation)state).getGroupEntry(this.id).setActivationDesc(this.id, this.desc, false);
            }
            catch (Exception ignore) {
                System.err.println(MessageFormat.format(Activation.getTextResource("rmid.log.recover.warning"), "LogUpdateDesc"));
                ignore.printStackTrace();
            }
            return state;
        }
    }

    private static class LogRegisterGroup
    extends LogRecord {
        private static final long serialVersionUID = -1966827458515403625L;
        private ActivationGroupID id;
        private ActivationGroupDesc desc;

        LogRegisterGroup(ActivationGroupID id, ActivationGroupDesc desc) {
            this.id = id;
            this.desc = desc;
        }

        @Override
        Object apply(Object state) {
            Map map = ((Activation)state).groupTable;
            Activation activation = (Activation)state;
            activation.getClass();
            map.put(this.id, activation.new GroupEntry(this.id, this.desc));
            return state;
        }
    }

    private static class LogUnregisterObject
    extends LogRecord {
        private static final long serialVersionUID = 6269824097396935501L;
        private ActivationID id;

        LogUnregisterObject(ActivationID id) {
            this.id = id;
        }

        @Override
        Object apply(Object state) {
            try {
                ((Activation)state).getGroupEntry(this.id).unregisterObject(this.id, false);
            }
            catch (Exception ignore) {
                System.err.println(MessageFormat.format(Activation.getTextResource("rmid.log.recover.warning"), "LogUnregisterObject"));
                ignore.printStackTrace();
            }
            return state;
        }
    }

    private static class LogRegisterObject
    extends LogRecord {
        private static final long serialVersionUID = -6280336276146085143L;
        private ActivationID id;
        private ActivationDesc desc;

        LogRegisterObject(ActivationID id, ActivationDesc desc) {
            this.id = id;
            this.desc = desc;
        }

        @Override
        Object apply(Object state) {
            try {
                ((Activation)state).getGroupEntry(this.desc.getGroupID()).registerObject(this.id, this.desc, false);
            }
            catch (Exception ignore) {
                System.err.println(MessageFormat.format(Activation.getTextResource("rmid.log.recover.warning"), "LogRegisterObject"));
                ignore.printStackTrace();
            }
            return state;
        }
    }

    private static abstract class LogRecord
    implements Serializable {
        private static final long serialVersionUID = 8395140512322687529L;

        private LogRecord() {
        }

        abstract Object apply(Object var1) throws Exception;
    }

    private static class ActLogHandler
    extends LogHandler {
        ActLogHandler() {
        }

        @Override
        public Object initialSnapshot() {
            return new Activation();
        }

        @Override
        public Object applyUpdate(Object update, Object state) throws Exception {
            return ((LogRecord)update).apply(state);
        }
    }

    private static class ObjectEntry
    implements Serializable {
        private static final long serialVersionUID = -5500114225321357856L;
        ActivationDesc desc;
        volatile transient MarshalledObject<? extends Remote> stub = null;
        volatile transient boolean removed = false;

        ObjectEntry(ActivationDesc desc) {
            this.desc = desc;
        }

        synchronized MarshalledObject<? extends Remote> activate(ActivationID id, boolean force, ActivationInstantiator inst) throws RemoteException, ActivationException {
            MarshalledObject<? extends Remote> nstub = this.stub;
            if (this.removed) {
                throw new UnknownObjectException("object removed");
            }
            if (!force && nstub != null) {
                return nstub;
            }
            this.stub = nstub = inst.newInstance(id, this.desc);
            return nstub;
        }

        void reset() {
            this.stub = null;
        }
    }

    private class GroupEntry
    implements Serializable {
        private static final long serialVersionUID = 7222464070032993304L;
        private static final int MAX_TRIES = 2;
        private static final int NORMAL = 0;
        private static final int CREATING = 1;
        private static final int TERMINATE = 2;
        private static final int TERMINATING = 3;
        ActivationGroupDesc desc = null;
        ActivationGroupID groupID = null;
        long incarnation = 0L;
        Map<ActivationID, ObjectEntry> objects = new HashMap<ActivationID, ObjectEntry>();
        Set<ActivationID> restartSet = new HashSet<ActivationID>();
        transient ActivationInstantiator group = null;
        transient int status = 0;
        transient long waitTime = 0L;
        transient String groupName = null;
        transient Process child = null;
        transient boolean removed = false;
        transient Watchdog watchdog = null;

        GroupEntry(ActivationGroupID groupID, ActivationGroupDesc desc) {
            this.groupID = groupID;
            this.desc = desc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void restartServices() {
            Iterator<ActivationID> iter = null;
            GroupEntry groupEntry = this;
            synchronized (groupEntry) {
                if (this.restartSet.isEmpty()) {
                    return;
                }
                iter = new HashSet<ActivationID>(this.restartSet).iterator();
            }
            while (iter.hasNext()) {
                ActivationID id = iter.next();
                try {
                    this.activate(id, true);
                }
                catch (Exception e) {
                    if (Activation.this.shuttingDown) {
                        return;
                    }
                    System.err.println(Activation.getTextResource("rmid.restart.service.warning"));
                    e.printStackTrace();
                }
            }
        }

        synchronized void activeGroup(ActivationInstantiator inst, long instIncarnation) throws ActivationException, UnknownGroupException {
            if (this.incarnation != instIncarnation) {
                throw new ActivationException("invalid incarnation");
            }
            if (this.group != null) {
                if (this.group.equals(inst)) {
                    return;
                }
                throw new ActivationException("group already active");
            }
            if (this.child != null && this.status != 1) {
                throw new ActivationException("group not being created");
            }
            this.group = inst;
            this.status = 0;
            this.notifyAll();
        }

        private void checkRemoved() throws UnknownGroupException {
            if (this.removed) {
                throw new UnknownGroupException("group removed");
            }
        }

        private ObjectEntry getObjectEntry(ActivationID id) throws UnknownObjectException {
            if (this.removed) {
                throw new UnknownObjectException("object's group removed");
            }
            ObjectEntry objEntry = this.objects.get(id);
            if (objEntry == null) {
                throw new UnknownObjectException("object unknown");
            }
            return objEntry;
        }

        synchronized void registerObject(ActivationID id, ActivationDesc desc, boolean addRecord) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            this.objects.put(id, new ObjectEntry(desc));
            if (desc.getRestartMode()) {
                this.restartSet.add(id);
            }
            Activation.this.idTable.put(id, this.groupID);
            if (addRecord) {
                Activation.this.addLogRecord(new LogRegisterObject(id, desc));
            }
        }

        synchronized void unregisterObject(ActivationID id, boolean addRecord) throws UnknownGroupException, ActivationException {
            ObjectEntry objEntry = this.getObjectEntry(id);
            objEntry.removed = true;
            this.objects.remove(id);
            if (objEntry.desc.getRestartMode()) {
                this.restartSet.remove(id);
            }
            Activation.this.idTable.remove(id);
            if (addRecord) {
                Activation.this.addLogRecord(new LogUnregisterObject(id));
            }
        }

        synchronized void unregisterGroup(boolean addRecord) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            this.removed = true;
            for (Map.Entry<ActivationID, ObjectEntry> entry : this.objects.entrySet()) {
                ActivationID id = entry.getKey();
                Activation.this.idTable.remove(id);
                ObjectEntry objEntry = entry.getValue();
                objEntry.removed = true;
            }
            this.objects.clear();
            this.restartSet.clear();
            this.reset();
            this.childGone();
            if (addRecord) {
                Activation.this.addLogRecord(new LogUnregisterGroup(this.groupID));
            }
        }

        synchronized ActivationDesc setActivationDesc(ActivationID id, ActivationDesc desc, boolean addRecord) throws UnknownObjectException, UnknownGroupException, ActivationException {
            ObjectEntry objEntry = this.getObjectEntry(id);
            ActivationDesc oldDesc = objEntry.desc;
            objEntry.desc = desc;
            if (desc.getRestartMode()) {
                this.restartSet.add(id);
            } else {
                this.restartSet.remove(id);
            }
            if (addRecord) {
                Activation.this.addLogRecord(new LogUpdateDesc(id, desc));
            }
            return oldDesc;
        }

        synchronized ActivationDesc getActivationDesc(ActivationID id) throws UnknownObjectException, UnknownGroupException {
            return this.getObjectEntry((ActivationID)id).desc;
        }

        synchronized ActivationGroupDesc setActivationGroupDesc(ActivationGroupID id, ActivationGroupDesc desc, boolean addRecord) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            ActivationGroupDesc oldDesc = this.desc;
            this.desc = desc;
            if (addRecord) {
                Activation.this.addLogRecord(new LogUpdateGroupDesc(id, desc));
            }
            return oldDesc;
        }

        synchronized void inactiveGroup(long incarnation, boolean failure) throws UnknownGroupException {
            this.checkRemoved();
            if (this.incarnation != incarnation) {
                throw new UnknownGroupException("invalid incarnation");
            }
            this.reset();
            if (failure) {
                this.terminate();
            } else if (this.child != null && this.status == 0) {
                this.status = 2;
                this.watchdog.noRestart();
            }
        }

        synchronized void activeObject(ActivationID id, MarshalledObject<? extends Remote> mobj) throws UnknownObjectException {
            this.getObjectEntry((ActivationID)id).stub = mobj;
        }

        synchronized void inactiveObject(ActivationID id) throws UnknownObjectException {
            this.getObjectEntry(id).reset();
        }

        private synchronized void reset() {
            this.group = null;
            for (ObjectEntry objectEntry : this.objects.values()) {
                objectEntry.reset();
            }
        }

        private void childGone() {
            if (this.child != null) {
                this.child = null;
                this.watchdog.dispose();
                this.watchdog = null;
                this.status = 0;
                this.notifyAll();
            }
        }

        private void terminate() {
            if (this.child != null && this.status != 3) {
                this.child.destroy();
                this.status = 3;
                this.waitTime = System.currentTimeMillis() + groupTimeout;
                this.notifyAll();
            }
        }

        /*
         * Unable to fully structure code
         */
        private void await() {
            while (true) {
                switch (this.status) {
                    case 0: {
                        return;
                    }
                    case 2: {
                        this.terminate();
                    }
                    case 3: {
                        try {
                            this.child.exitValue();
                        }
                        catch (IllegalThreadStateException e) {
                            now = System.currentTimeMillis();
                            if (this.waitTime <= now) ** GOTO lbl20
                            try {
                                this.wait(this.waitTime - now);
                            }
                            catch (InterruptedException ee) {}
                            break;
                        }
lbl20:
                        // 2 sources

                        this.childGone();
                        return;
                    }
                    case 1: {
                        try {
                            this.wait();
                            break;
                        }
                        catch (InterruptedException var1_3) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        void shutdownFast() {
            Process p = this.child;
            if (p != null) {
                p.destroy();
            }
        }

        synchronized void shutdown() {
            this.reset();
            this.terminate();
            this.await();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MarshalledObject<? extends Remote> activate(ActivationID id, boolean force) throws ActivationException {
            Exception detail = null;
            for (int tries = 2; tries > 0; --tries) {
                boolean failure;
                boolean groupInactive;
                long currentIncarnation;
                block13: {
                    ActivationInstantiator inst;
                    ObjectEntry objEntry;
                    GroupEntry groupEntry = this;
                    synchronized (groupEntry) {
                        objEntry = this.getObjectEntry(id);
                        if (!force && objEntry.stub != null) {
                            return objEntry.stub;
                        }
                        inst = this.getInstantiator(this.groupID);
                        currentIncarnation = this.incarnation;
                    }
                    groupInactive = false;
                    failure = false;
                    try {
                        return objEntry.activate(id, force, inst);
                    }
                    catch (NoSuchObjectException e) {
                        groupInactive = true;
                        detail = e;
                    }
                    catch (ConnectException e) {
                        groupInactive = true;
                        failure = true;
                        detail = e;
                    }
                    catch (ConnectIOException e) {
                        groupInactive = true;
                        failure = true;
                        detail = e;
                    }
                    catch (InactiveGroupException e) {
                        groupInactive = true;
                        detail = e;
                    }
                    catch (RemoteException e) {
                        if (detail != null) break block13;
                        detail = e;
                    }
                }
                if (!groupInactive) continue;
                try {
                    System.err.println(MessageFormat.format(Activation.getTextResource("rmid.group.inactive"), detail.toString()));
                    detail.printStackTrace();
                    Activation.this.getGroupEntry(this.groupID).inactiveGroup(currentIncarnation, failure);
                    continue;
                }
                catch (UnknownGroupException e) {
                    // empty catch block
                }
            }
            throw new ActivationException("object activation failed after 2 tries", detail);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ActivationInstantiator getInstantiator(ActivationGroupID id) throws ActivationException {
            assert (Thread.holdsLock(this));
            this.await();
            if (this.group != null) {
                return this.group;
            }
            this.checkRemoved();
            boolean acquired = false;
            try {
                String string;
                this.groupName = Activation.this.Pstartgroup();
                acquired = true;
                String[] argv = Activation.this.activationArgs(this.desc);
                Activation.this.checkArgs(this.desc, argv);
                if (debugExec) {
                    StringBuffer sb = new StringBuffer(argv[0]);
                    for (int j = 1; j < argv.length; ++j) {
                        sb.append(' ');
                        sb.append(argv[j]);
                    }
                    System.err.println(MessageFormat.format(Activation.getTextResource("rmid.exec.command"), sb.toString()));
                }
                try {
                    this.child = Runtime.getRuntime().exec(argv);
                    this.status = 1;
                    ++this.incarnation;
                    this.watchdog = new Watchdog();
                    this.watchdog.start();
                    Activation.this.addLogRecord(new LogGroupIncarnation(id, this.incarnation));
                    PipeWriter.plugTogetherPair(this.child.getInputStream(), System.out, this.child.getErrorStream(), System.err);
                    try (MarshalOutputStream out = new MarshalOutputStream(this.child.getOutputStream());){
                        out.writeObject(id);
                        out.writeObject(this.desc);
                        out.writeLong(this.incarnation);
                        out.flush();
                    }
                }
                catch (IOException e) {
                    this.terminate();
                    throw new ActivationException("unable to create activation group", e);
                }
                try {
                    long now = System.currentTimeMillis();
                    long stop = now + execTimeout;
                    do {
                        this.wait(stop - now);
                        if (this.group != null) {
                            ActivationInstantiator activationInstantiator = this.group;
                            return activationInstantiator;
                        }
                        now = System.currentTimeMillis();
                    } while (this.status == 1 && now < stop);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.terminate();
                if (this.removed) {
                    string = "activation group unregistered";
                    throw new ActivationException(string);
                }
                string = "timeout creating child process";
                throw new ActivationException(string);
            }
            finally {
                if (acquired) {
                    Activation.this.Vstartgroup();
                }
            }
        }

        private class Watchdog
        extends Thread {
            private final Process groupProcess;
            private final long groupIncarnation;
            private boolean canInterrupt;
            private boolean shouldQuit;
            private boolean shouldRestart;

            Watchdog() {
                super("WatchDog-" + GroupEntry.this.groupName + "-" + GroupEntry.this.incarnation);
                this.groupProcess = GroupEntry.this.child;
                this.groupIncarnation = GroupEntry.this.incarnation;
                this.canInterrupt = true;
                this.shouldQuit = false;
                this.shouldRestart = true;
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (this.shouldQuit) {
                    return;
                }
                try {
                    this.groupProcess.waitFor();
                }
                catch (InterruptedException exit) {
                    return;
                }
                boolean restart = false;
                GroupEntry groupEntry = GroupEntry.this;
                synchronized (groupEntry) {
                    if (this.shouldQuit) {
                        return;
                    }
                    this.canInterrupt = false;
                    Watchdog.interrupted();
                    if (this.groupIncarnation == GroupEntry.this.incarnation) {
                        restart = this.shouldRestart && !Activation.this.shuttingDown;
                        GroupEntry.this.reset();
                        GroupEntry.this.childGone();
                    }
                }
                if (restart) {
                    GroupEntry.this.restartServices();
                }
            }

            void dispose() {
                this.shouldQuit = true;
                if (this.canInterrupt) {
                    this.interrupt();
                }
            }

            void noRestart() {
                this.shouldRestart = false;
            }
        }
    }

    private class ShutdownHook
    extends Thread {
        ShutdownHook() {
            super("rmid ShutdownHook");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Activation activation = Activation.this;
            synchronized (activation) {
                Activation.this.shuttingDown = true;
            }
            for (GroupEntry groupEntry : Activation.this.groupTable.values()) {
                groupEntry.shutdownFast();
            }
        }
    }

    private class Shutdown
    extends Thread {
        Shutdown() {
            super("rmid Shutdown");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Activation.unexport(Activation.this.activator);
                Activation.unexport(Activation.this.system);
                for (GroupEntry groupEntry : Activation.this.groupTable.values()) {
                    groupEntry.shutdown();
                }
                Runtime.getRuntime().removeShutdownHook(Activation.this.shutdownHook);
                Activation.unexport(Activation.this.monitor);
                try {
                    ReliableLog i$ = Activation.this.log;
                    synchronized (i$) {
                        Activation.this.log.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            finally {
                System.err.println(Activation.getTextResource("rmid.daemon.shutdown"));
                System.exit(0);
            }
        }
    }

    class ActivationSystemImpl
    extends RemoteServer
    implements ActivationSystem {
        private static final long serialVersionUID = 9100152600327688967L;

        ActivationSystemImpl(int port, RMIServerSocketFactory ssf) throws RemoteException {
            LiveRef lref = new LiveRef(new ObjID(4), port, null, ssf);
            UnicastServerRef uref = new UnicastServerRef(lref);
            this.ref = uref;
            uref.exportObject(this, null);
        }

        @Override
        public ActivationID registerObject(ActivationDesc desc) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.registerObject");
            ActivationGroupID groupID = desc.getGroupID();
            ActivationID id = new ActivationID(Activation.this.activatorStub);
            Activation.this.getGroupEntry(groupID).registerObject(id, desc, true);
            return id;
        }

        @Override
        public void unregisterObject(ActivationID id) throws ActivationException, UnknownObjectException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.unregisterObject");
            Activation.this.getGroupEntry(id).unregisterObject(id, true);
        }

        @Override
        public ActivationGroupID registerGroup(ActivationGroupDesc desc) throws ActivationException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.registerGroup");
            Activation.this.checkArgs(desc, null);
            ActivationGroupID id = new ActivationGroupID(Activation.this.systemStub);
            GroupEntry entry = new GroupEntry(id, desc);
            Activation.this.groupTable.put(id, entry);
            Activation.this.addLogRecord(new LogRegisterGroup(id, desc));
            return id;
        }

        @Override
        public ActivationMonitor activeGroup(ActivationGroupID id, ActivationInstantiator group, long incarnation) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.activeGroup");
            Activation.this.getGroupEntry(id).activeGroup(group, incarnation);
            return Activation.this.monitor;
        }

        @Override
        public void unregisterGroup(ActivationGroupID id) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.unregisterGroup");
            Activation.this.removeGroupEntry(id).unregisterGroup(true);
        }

        @Override
        public ActivationDesc setActivationDesc(ActivationID id, ActivationDesc desc) throws ActivationException, UnknownObjectException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.setActivationDesc");
            if (!Activation.this.getGroupID(id).equals(desc.getGroupID())) {
                throw new ActivationException("ActivationDesc contains wrong group");
            }
            return Activation.this.getGroupEntry(id).setActivationDesc(id, desc, true);
        }

        @Override
        public ActivationGroupDesc setActivationGroupDesc(ActivationGroupID id, ActivationGroupDesc desc) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.setActivationGroupDesc");
            Activation.this.checkArgs(desc, null);
            return Activation.this.getGroupEntry(id).setActivationGroupDesc(id, desc, true);
        }

        @Override
        public ActivationDesc getActivationDesc(ActivationID id) throws ActivationException, UnknownObjectException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.getActivationDesc");
            return Activation.this.getGroupEntry(id).getActivationDesc(id);
        }

        @Override
        public ActivationGroupDesc getActivationGroupDesc(ActivationGroupID id) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.getActivationGroupDesc");
            return ((Activation)Activation.this).getGroupEntry((ActivationGroupID)id).desc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() throws AccessException {
            Object object;
            RegistryImpl.checkAccess("ActivationSystem.shutdown");
            Object lock = Activation.this.startupLock;
            if (lock != null) {
                object = lock;
                synchronized (object) {
                }
            }
            object = Activation.this;
            synchronized (object) {
                if (!Activation.this.shuttingDown) {
                    Activation.this.shuttingDown = true;
                    new Shutdown().start();
                }
            }
        }
    }

    class ActivationMonitorImpl
    extends UnicastRemoteObject
    implements ActivationMonitor {
        private static final long serialVersionUID = -6214940464757948867L;

        ActivationMonitorImpl(int port, RMIServerSocketFactory ssf) throws RemoteException {
            super(port, null, ssf);
        }

        @Override
        public void inactiveObject(ActivationID id) throws UnknownObjectException, RemoteException {
            try {
                Activation.this.checkShutdown();
            }
            catch (ActivationException e) {
                return;
            }
            RegistryImpl.checkAccess("Activator.inactiveObject");
            Activation.this.getGroupEntry(id).inactiveObject(id);
        }

        @Override
        public void activeObject(ActivationID id, MarshalledObject<? extends Remote> mobj) throws UnknownObjectException, RemoteException {
            try {
                Activation.this.checkShutdown();
            }
            catch (ActivationException e) {
                return;
            }
            RegistryImpl.checkAccess("ActivationSystem.activeObject");
            Activation.this.getGroupEntry(id).activeObject(id, mobj);
        }

        @Override
        public void inactiveGroup(ActivationGroupID id, long incarnation) throws UnknownGroupException, RemoteException {
            try {
                Activation.this.checkShutdown();
            }
            catch (ActivationException e) {
                return;
            }
            RegistryImpl.checkAccess("ActivationMonitor.inactiveGroup");
            Activation.this.getGroupEntry(id).inactiveGroup(incarnation, false);
        }
    }

    class ActivatorImpl
    extends RemoteServer
    implements Activator {
        private static final long serialVersionUID = -3654244726254566136L;

        ActivatorImpl(int port, RMIServerSocketFactory ssf) throws RemoteException {
            LiveRef lref = new LiveRef(new ObjID(1), port, null, ssf);
            UnicastServerRef uref = new UnicastServerRef(lref);
            this.ref = uref;
            uref.exportObject(this, null, false);
        }

        @Override
        public MarshalledObject<? extends Remote> activate(ActivationID id, boolean force) throws ActivationException, UnknownObjectException, RemoteException {
            Activation.this.checkShutdown();
            return Activation.this.getGroupEntry(id).activate(id, force);
        }
    }

    private static class SystemRegistryImpl
    extends RegistryImpl {
        private static final String NAME = ActivationSystem.class.getName();
        private static final long serialVersionUID = 4877330021609408794L;
        private final ActivationSystem systemStub;

        SystemRegistryImpl(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, ActivationSystem systemStub) throws RemoteException {
            super(port, csf, ssf);
            this.systemStub = systemStub;
        }

        @Override
        public Remote lookup(String name) throws RemoteException, NotBoundException {
            if (name.equals(NAME)) {
                return this.systemStub;
            }
            return super.lookup(name);
        }

        @Override
        public String[] list() throws RemoteException {
            String[] list1 = super.list();
            int length = list1.length;
            String[] list2 = new String[length + 1];
            if (length > 0) {
                System.arraycopy(list1, 0, list2, 0, length);
            }
            list2[length] = NAME;
            return list2;
        }

        @Override
        public void bind(String name, Remote obj) throws RemoteException, AlreadyBoundException, AccessException {
            if (name.equals(NAME)) {
                throw new AccessException("binding ActivationSystem is disallowed");
            }
            super.bind(name, obj);
        }

        @Override
        public void unbind(String name) throws RemoteException, NotBoundException, AccessException {
            if (name.equals(NAME)) {
                throw new AccessException("unbinding ActivationSystem is disallowed");
            }
            super.unbind(name);
        }

        @Override
        public void rebind(String name, Remote obj) throws RemoteException, AccessException {
            if (name.equals(NAME)) {
                throw new AccessException("binding ActivationSystem is disallowed");
            }
            super.rebind(name, obj);
        }
    }
}

