/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AcceptPendingException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.NotYetBoundException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.AsynchronousServerSocketChannelImpl;
import sun.nio.ch.CompletedFuture;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Invoker;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.PendingFuture;
import sun.nio.ch.Port;
import sun.nio.ch.SocketDispatcher;
import sun.nio.ch.UnixAsynchronousSocketChannelImpl;
import sun.nio.ch.Util;

class UnixAsynchronousServerSocketChannelImpl
extends AsynchronousServerSocketChannelImpl
implements Port.PollableChannel {
    private static final NativeDispatcher nd = new SocketDispatcher();
    private final Port port;
    private final int fdVal;
    private final AtomicBoolean accepting = new AtomicBoolean();
    private final Object updateLock = new Object();
    private boolean acceptPending;
    private CompletionHandler<AsynchronousSocketChannel, Object> acceptHandler;
    private Object acceptAttachment;
    private PendingFuture<AsynchronousSocketChannel, Object> acceptFuture;
    private AccessControlContext acceptAcc;

    private void enableAccept() {
        this.accepting.set(false);
    }

    UnixAsynchronousServerSocketChannelImpl(Port port) throws IOException {
        super(port);
        try {
            IOUtil.configureBlocking(this.fd, false);
        }
        catch (IOException x) {
            nd.close(this.fd);
            throw x;
        }
        this.port = port;
        this.fdVal = IOUtil.fdVal(this.fd);
        port.register(this.fdVal, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void implClose() throws IOException {
        PendingFuture<AsynchronousSocketChannel, Object> future;
        Object att;
        CompletionHandler<AsynchronousSocketChannel, Object> handler;
        this.port.unregister(this.fdVal);
        nd.close(this.fd);
        Object object = this.updateLock;
        synchronized (object) {
            if (!this.acceptPending) {
                return;
            }
            this.acceptPending = false;
            handler = this.acceptHandler;
            att = this.acceptAttachment;
            future = this.acceptFuture;
        }
        AsynchronousCloseException x = new AsynchronousCloseException();
        x.setStackTrace(new StackTraceElement[0]);
        if (handler == null) {
            future.setFailure(x);
        } else {
            Invoker.invokeIndirectly(this, handler, att, null, x);
        }
    }

    @Override
    public AsynchronousChannelGroupImpl group() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(int events, boolean mayInvokeDirect) {
        Throwable exc;
        InetSocketAddress[] isaa;
        FileDescriptor newfd;
        block22: {
            Object object = this.updateLock;
            synchronized (object) {
                if (!this.acceptPending) {
                    return;
                }
                this.acceptPending = false;
            }
            newfd = new FileDescriptor();
            isaa = new InetSocketAddress[1];
            exc = null;
            try {
                this.begin();
                int n = this.accept0(this.fd, newfd, isaa);
                if (n != -2) break block22;
                Object object2 = this.updateLock;
                synchronized (object2) {
                    this.acceptPending = true;
                }
                this.port.startPoll(this.fdVal, 1);
                return;
            }
            catch (Throwable x2) {
                AsynchronousCloseException x2;
                if (x2 instanceof ClosedChannelException) {
                    x2 = new AsynchronousCloseException();
                }
                exc = x2;
            }
            finally {
                this.end();
            }
        }
        AsynchronousSocketChannel child = null;
        if (exc == null) {
            try {
                child = this.finishAccept(newfd, isaa[0], this.acceptAcc);
            }
            catch (Throwable x3) {
                IOException x3;
                if (!(x3 instanceof IOException) && !(x3 instanceof SecurityException)) {
                    x3 = new IOException(x3);
                }
                exc = x3;
            }
        }
        CompletionHandler<AsynchronousSocketChannel, Object> handler = this.acceptHandler;
        Object att = this.acceptAttachment;
        PendingFuture<AsynchronousSocketChannel, Object> future = this.acceptFuture;
        this.enableAccept();
        if (handler == null) {
            future.setResult(child, exc);
            if (child != null && future.isCancelled()) {
                try {
                    child.close();
                }
                catch (IOException ignore) {}
            }
        } else {
            Invoker.invoke(this, handler, att, child, exc);
        }
    }

    private AsynchronousSocketChannel finishAccept(FileDescriptor newfd, final InetSocketAddress remote, AccessControlContext acc) throws IOException, SecurityException {
        UnixAsynchronousSocketChannelImpl ch = null;
        try {
            ch = new UnixAsynchronousSocketChannelImpl(this.port, newfd, remote);
        }
        catch (IOException x) {
            nd.close(newfd);
            throw x;
        }
        try {
            if (acc != null) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        SecurityManager sm = System.getSecurityManager();
                        if (sm != null) {
                            sm.checkAccept(remote.getAddress().getHostAddress(), remote.getPort());
                        }
                        return null;
                    }
                }, acc);
            } else {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkAccept(remote.getAddress().getHostAddress(), remote.getPort());
                }
            }
        }
        catch (SecurityException x) {
            try {
                ch.close();
            }
            catch (Throwable suppressed) {
                x.addSuppressed(suppressed);
            }
            throw x;
        }
        return ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Future<AsynchronousSocketChannel> implAccept(Object att, CompletionHandler<AsynchronousSocketChannel, Object> handler) {
        Throwable exc;
        InetSocketAddress[] isaa;
        FileDescriptor newfd;
        block20: {
            if (!this.isOpen()) {
                ClosedChannelException e = new ClosedChannelException();
                if (handler == null) {
                    return CompletedFuture.withFailure(e);
                }
                Invoker.invoke(this, handler, att, null, e);
                return null;
            }
            if (this.localAddress == null) {
                throw new NotYetBoundException();
            }
            if (this.isAcceptKilled()) {
                throw new RuntimeException("Accept not allowed due cancellation");
            }
            if (!this.accepting.compareAndSet(false, true)) {
                throw new AcceptPendingException();
            }
            newfd = new FileDescriptor();
            isaa = new InetSocketAddress[1];
            exc = null;
            try {
                this.begin();
                int n = this.accept0(this.fd, newfd, isaa);
                if (n != -2) break block20;
                PendingFuture result = null;
                PendingFuture pendingFuture = this.updateLock;
                synchronized (pendingFuture) {
                    if (handler == null) {
                        this.acceptHandler = null;
                        result = new PendingFuture(this);
                        this.acceptFuture = result;
                    } else {
                        this.acceptHandler = handler;
                        this.acceptAttachment = att;
                    }
                    this.acceptAcc = System.getSecurityManager() == null ? null : AccessController.getContext();
                    this.acceptPending = true;
                }
                this.port.startPoll(this.fdVal, 1);
                pendingFuture = result;
                return pendingFuture;
            }
            catch (Throwable x2) {
                AsynchronousCloseException x2;
                if (x2 instanceof ClosedChannelException) {
                    x2 = new AsynchronousCloseException();
                }
                exc = x2;
            }
            finally {
                this.end();
            }
        }
        AsynchronousSocketChannel child = null;
        if (exc == null) {
            try {
                child = this.finishAccept(newfd, isaa[0], null);
            }
            catch (Throwable x) {
                exc = x;
            }
        }
        this.enableAccept();
        if (handler == null) {
            return CompletedFuture.withResult(child, exc);
        }
        Invoker.invokeIndirectly(this, handler, att, child, exc);
        return null;
    }

    private static native void initIDs();

    private native int accept0(FileDescriptor var1, FileDescriptor var2, InetSocketAddress[] var3) throws IOException;

    static {
        Util.load();
        UnixAsynchronousServerSocketChannelImpl.initIDs();
    }
}

