/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.MissingResourceException;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.spi.LocaleNameProvider;
import sun.security.action.GetPropertyAction;
import sun.util.LocaleServiceProviderPool;
import sun.util.locale.BaseLocale;
import sun.util.locale.InternalLocaleBuilder;
import sun.util.locale.LanguageTag;
import sun.util.locale.LocaleExtensions;
import sun.util.locale.LocaleObjectCache;
import sun.util.locale.LocaleSyntaxException;
import sun.util.locale.LocaleUtils;
import sun.util.locale.ParseStatus;
import sun.util.locale.UnicodeLocaleExtension;
import sun.util.resources.LocaleData;
import sun.util.resources.OpenListResourceBundle;

public final class Locale
implements Cloneable,
Serializable {
    private static final Cache LOCALECACHE = new Cache();
    public static final Locale ENGLISH = Locale.createConstant("en", "");
    public static final Locale FRENCH = Locale.createConstant("fr", "");
    public static final Locale GERMAN = Locale.createConstant("de", "");
    public static final Locale ITALIAN = Locale.createConstant("it", "");
    public static final Locale JAPANESE = Locale.createConstant("ja", "");
    public static final Locale KOREAN = Locale.createConstant("ko", "");
    public static final Locale CHINESE = Locale.createConstant("zh", "");
    public static final Locale SIMPLIFIED_CHINESE = Locale.createConstant("zh", "CN");
    public static final Locale TRADITIONAL_CHINESE = Locale.createConstant("zh", "TW");
    public static final Locale FRANCE = Locale.createConstant("fr", "FR");
    public static final Locale GERMANY = Locale.createConstant("de", "DE");
    public static final Locale ITALY = Locale.createConstant("it", "IT");
    public static final Locale JAPAN = Locale.createConstant("ja", "JP");
    public static final Locale KOREA = Locale.createConstant("ko", "KR");
    public static final Locale CHINA = SIMPLIFIED_CHINESE;
    public static final Locale PRC = SIMPLIFIED_CHINESE;
    public static final Locale TAIWAN = TRADITIONAL_CHINESE;
    public static final Locale UK = Locale.createConstant("en", "GB");
    public static final Locale US = Locale.createConstant("en", "US");
    public static final Locale CANADA = Locale.createConstant("en", "CA");
    public static final Locale CANADA_FRENCH = Locale.createConstant("fr", "CA");
    public static final Locale ROOT = Locale.createConstant("", "");
    public static final char PRIVATE_USE_EXTENSION = 'x';
    public static final char UNICODE_LOCALE_EXTENSION = 'u';
    static final long serialVersionUID = 9149081749638150636L;
    private static final int DISPLAY_LANGUAGE = 0;
    private static final int DISPLAY_COUNTRY = 1;
    private static final int DISPLAY_VARIANT = 2;
    private static final int DISPLAY_SCRIPT = 3;
    private transient BaseLocale baseLocale;
    private transient LocaleExtensions localeExtensions;
    private volatile transient int hashCodeValue = 0;
    private static Locale defaultLocale = null;
    private static Locale defaultDisplayLocale = null;
    private static Locale defaultFormatLocale = null;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("language", String.class), new ObjectStreamField("country", String.class), new ObjectStreamField("variant", String.class), new ObjectStreamField("hashcode", Integer.TYPE), new ObjectStreamField("script", String.class), new ObjectStreamField("extensions", String.class)};
    private static volatile String[] isoLanguages = null;
    private static volatile String[] isoCountries = null;

    private Locale(BaseLocale baseLocale, LocaleExtensions extensions) {
        this.baseLocale = baseLocale;
        this.localeExtensions = extensions;
    }

    public Locale(String language, String country, String variant) {
        if (language == null || country == null || variant == null) {
            throw new NullPointerException();
        }
        this.baseLocale = BaseLocale.getInstance(Locale.convertOldISOCodes(language), "", country, variant);
        this.localeExtensions = Locale.getCompatibilityExtensions(language, "", country, variant);
    }

    public Locale(String language, String country) {
        this(language, country, "");
    }

    public Locale(String language) {
        this(language, "", "");
    }

    private static Locale createConstant(String lang, String country) {
        BaseLocale base = BaseLocale.createInstance(lang, country);
        return Locale.getInstance(base, null);
    }

    static Locale getInstance(String language, String country, String variant) {
        return Locale.getInstance(language, "", country, variant, null);
    }

    static Locale getInstance(String language, String script, String country, String variant, LocaleExtensions extensions) {
        if (language == null || script == null || country == null || variant == null) {
            throw new NullPointerException();
        }
        if (extensions == null) {
            extensions = Locale.getCompatibilityExtensions(language, script, country, variant);
        }
        BaseLocale baseloc = BaseLocale.getInstance(language, script, country, variant);
        return Locale.getInstance(baseloc, extensions);
    }

    static Locale getInstance(BaseLocale baseloc, LocaleExtensions extensions) {
        LocaleKey key = new LocaleKey(baseloc, extensions);
        return (Locale)LOCALECACHE.get(key);
    }

    public static Locale getDefault() {
        if (defaultLocale == null) {
            Locale.initDefault();
        }
        return defaultLocale;
    }

    public static Locale getDefault(Category category) {
        switch (category) {
            case DISPLAY: {
                if (defaultDisplayLocale == null) {
                    Locale.initDefault(category);
                }
                return defaultDisplayLocale;
            }
            case FORMAT: {
                if (defaultFormatLocale == null) {
                    Locale.initDefault(category);
                }
                return defaultFormatLocale;
            }
        }
        assert (false) : "Unknown Category";
        return Locale.getDefault();
    }

    private static void initDefault() {
        String script;
        String variant;
        String country;
        String language = AccessController.doPrivileged(new GetPropertyAction("user.language", "en"));
        String region = AccessController.doPrivileged(new GetPropertyAction("user.region"));
        if (region != null) {
            int i = region.indexOf(95);
            if (i >= 0) {
                country = region.substring(0, i);
                variant = region.substring(i + 1);
            } else {
                country = region;
                variant = "";
            }
            script = "";
        } else {
            script = AccessController.doPrivileged(new GetPropertyAction("user.script", ""));
            country = AccessController.doPrivileged(new GetPropertyAction("user.country", ""));
            variant = AccessController.doPrivileged(new GetPropertyAction("user.variant", ""));
        }
        defaultLocale = Locale.getInstance(language, script, country, variant, null);
    }

    private static void initDefault(Category category) {
        if (defaultLocale == null) {
            Locale.initDefault();
        }
        Locale defaultCategoryLocale = Locale.getInstance(AccessController.doPrivileged(new GetPropertyAction(category.languageKey, defaultLocale.getLanguage())), AccessController.doPrivileged(new GetPropertyAction(category.scriptKey, defaultLocale.getScript())), AccessController.doPrivileged(new GetPropertyAction(category.countryKey, defaultLocale.getCountry())), AccessController.doPrivileged(new GetPropertyAction(category.variantKey, defaultLocale.getVariant())), null);
        switch (category) {
            case DISPLAY: {
                defaultDisplayLocale = defaultCategoryLocale;
                break;
            }
            case FORMAT: {
                defaultFormatLocale = defaultCategoryLocale;
            }
        }
    }

    public static synchronized void setDefault(Locale newLocale) {
        Locale.setDefault(Category.DISPLAY, newLocale);
        Locale.setDefault(Category.FORMAT, newLocale);
        defaultLocale = newLocale;
    }

    public static synchronized void setDefault(Category category, Locale newLocale) {
        if (category == null) {
            throw new NullPointerException("Category cannot be NULL");
        }
        if (newLocale == null) {
            throw new NullPointerException("Can't set default locale to NULL");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission("user.language", "write"));
        }
        switch (category) {
            case DISPLAY: {
                defaultDisplayLocale = newLocale;
                break;
            }
            case FORMAT: {
                defaultFormatLocale = newLocale;
                break;
            }
            default: {
                assert (false) : "Unknown Category";
                break;
            }
        }
    }

    public static Locale[] getAvailableLocales() {
        return LocaleServiceProviderPool.getAllAvailableLocales();
    }

    public static String[] getISOCountries() {
        if (isoCountries == null) {
            isoCountries = Locale.getISO2Table("ADANDAEAREAFAFGAGATGAIAIAALALBAMARMANANTAOAGOAQATAARARGASASMATAUTAUAUSAWABWAXALAAZAZEBABIHBBBRBBDBGDBEBELBFBFABGBGRBHBHRBIBDIBJBENBLBLMBMBMUBNBRNBOBOLBQBESBRBRABSBHSBTBTNBVBVTBWBWABYBLRBZBLZCACANCCCCKCDCODCFCAFCGCOGCHCHECICIVCKCOKCLCHLCMCMRCNCHNCOCOLCRCRICUCUBCVCPVCWCUWCXCXRCYCYPCZCZEDEDEUDJDJIDKDNKDMDMADODOMDZDZAECECUEEESTEGEGYEHESHERERIESESPETETHFIFINFJFJIFKFLKFMFSMFOFROFRFRAGAGABGBGBRGDGRDGEGEOGFGUFGGGGYGHGHAGIGIBGLGRLGMGMBGNGINGPGLPGQGNQGRGRCGSSGSGTGTMGUGUMGWGNBGYGUYHKHKGHMHMDHNHNDHRHRVHTHTIHUHUNIDIDNIEIRLILISRIMIMNININDIOIOTIQIRQIRIRNISISLITITAJEJEYJMJAMJOJORJPJPNKEKENKGKGZKHKHMKIKIRKMCOMKNKNAKPPRKKRKORKWKWTKYCYMKZKAZLALAOLBLBNLCLCALILIELKLKALRLBRLSLSOLTLTULULUXLVLVALYLBYMAMARMCMCOMDMDAMEMNEMFMAFMGMDGMHMHLMKMKDMLMLIMMMMRMNMNGMOMACMPMNPMQMTQMRMRTMSMSRMTMLTMUMUSMVMDVMWMWIMXMEXMYMYSMZMOZNANAMNCNCLNENERNFNFKNGNGANINICNLNLDNONORNPNPLNRNRUNUNIUNZNZLOMOMNPAPANPEPERPFPYFPGPNGPHPHLPKPAKPLPOLPMSPMPNPCNPRPRIPSPSEPTPRTPWPLWPYPRYQAQATREREUROROURSSRBRURUSRWRWASASAUSBSLBSCSYCSDSDNSESWESGSGPSHSHNSISVNSJSJMSKSVKSLSLESMSMRSNSENSOSOMSRSURSTSTPSVSLVSXSXMSYSYRSZSWZTCTCATDTCDTFATFTGTGOTHTHATJTJKTKTKLTLTLSTMTKMTNTUNTOTONTRTURTTTTOTVTUVTWTWNTZTZAUAUKRUGUGAUMUMIUSUSAUYURYUZUZBVAVATVCVCTVEVENVGVGBVIVIRVNVNMVUVUTWFWLFWSWSMYEYEMYTMYTZAZAFZMZMBZWZWE");
        }
        String[] result = new String[isoCountries.length];
        System.arraycopy(isoCountries, 0, result, 0, isoCountries.length);
        return result;
    }

    public static String[] getISOLanguages() {
        if (isoLanguages == null) {
            isoLanguages = Locale.getISO2Table("aaaarababkaeaveafafrakakaamamhanargararaasasmavavaayaymazazebabakbebelbgbulbhbihbibisbmbambnbenbobodbrbrebsboscacatcechechchacocoscrcrecscescuchucvchvcycymdadandedeudvdivdzdzoeeeweelellenengeoepoesspaetesteueusfafasfffulfifinfjfijfofaofrfrafyfrygaglegdglaglglggngrngugujgvglvhahauhehebhihinhohmohrhrvhthathuhunhyhyehzheriainaidindieileigiboiiiiiikipkinindioidoisislititaiuikuiwhebjajpnjiyidjvjavkakatkgkonkikikkjkuakkkazklkalkmkhmknkankokorkrkaukskaskukurkvkomkwcorkykirlalatlbltzlgluglilimlnlinlolaoltlitlulublvlavmgmlgmhmahmimrimkmkdmlmalmnmonmomolmrmarmsmsamtmltmymyananaunbnobndndenenepngndonlnldnnnnononornrnblnvnavnynyaocociojojiomormororiososspapanpipliplpolpspusptporququermrohrnrunroronrurusrwkinsasanscsrdsdsndsesmesgsagsisinskslkslslvsmsmosnsnasosomsqsqisrsrpsssswstsotsusunsvsweswswatatamteteltgtgkththatitirtktuktltgltntsntotontrturtstsotttattwtwitytahuguigukukrururduzuzbvevenvivievovolwawlnwowolxhxhoyiyidyoyorzazhazhzhozuzul");
        }
        String[] result = new String[isoLanguages.length];
        System.arraycopy(isoLanguages, 0, result, 0, isoLanguages.length);
        return result;
    }

    private static final String[] getISO2Table(String table) {
        int len = table.length() / 5;
        String[] isoTable = new String[len];
        int i = 0;
        int j = 0;
        while (i < len) {
            isoTable[i] = table.substring(j, j + 2);
            ++i;
            j += 5;
        }
        return isoTable;
    }

    public String getLanguage() {
        return this.baseLocale.getLanguage();
    }

    public String getScript() {
        return this.baseLocale.getScript();
    }

    public String getCountry() {
        return this.baseLocale.getRegion();
    }

    public String getVariant() {
        return this.baseLocale.getVariant();
    }

    public String getExtension(char key) {
        if (!LocaleExtensions.isValidKey(key)) {
            throw new IllegalArgumentException("Ill-formed extension key: " + key);
        }
        return this.localeExtensions == null ? null : this.localeExtensions.getExtensionValue(Character.valueOf(key));
    }

    public Set<Character> getExtensionKeys() {
        if (this.localeExtensions == null) {
            return Collections.emptySet();
        }
        return this.localeExtensions.getKeys();
    }

    public Set<String> getUnicodeLocaleAttributes() {
        if (this.localeExtensions == null) {
            return Collections.emptySet();
        }
        return this.localeExtensions.getUnicodeLocaleAttributes();
    }

    public String getUnicodeLocaleType(String key) {
        if (!UnicodeLocaleExtension.isKey(key)) {
            throw new IllegalArgumentException("Ill-formed Unicode locale key: " + key);
        }
        return this.localeExtensions == null ? null : this.localeExtensions.getUnicodeLocaleType(key);
    }

    public Set<String> getUnicodeLocaleKeys() {
        if (this.localeExtensions == null) {
            return Collections.emptySet();
        }
        return this.localeExtensions.getUnicodeLocaleKeys();
    }

    BaseLocale getBaseLocale() {
        return this.baseLocale;
    }

    LocaleExtensions getLocaleExtensions() {
        return this.localeExtensions;
    }

    public final String toString() {
        boolean l = this.baseLocale.getLanguage().length() != 0;
        boolean s = this.baseLocale.getScript().length() != 0;
        boolean r = this.baseLocale.getRegion().length() != 0;
        boolean v = this.baseLocale.getVariant().length() != 0;
        boolean e = this.localeExtensions != null && this.localeExtensions.getID().length() != 0;
        StringBuilder result = new StringBuilder(this.baseLocale.getLanguage());
        if (r || l && (v || s || e)) {
            result.append('_').append(this.baseLocale.getRegion());
        }
        if (v && (l || r)) {
            result.append('_').append(this.baseLocale.getVariant());
        }
        if (s && (l || r)) {
            result.append("_#").append(this.baseLocale.getScript());
        }
        if (e && (l || r)) {
            result.append('_');
            if (!s) {
                result.append('#');
            }
            result.append(this.localeExtensions.getID());
        }
        return result.toString();
    }

    public String toLanguageTag() {
        LanguageTag tag = LanguageTag.parseLocale(this.baseLocale, this.localeExtensions);
        StringBuilder buf = new StringBuilder();
        String subtag = tag.getLanguage();
        if (subtag.length() > 0) {
            buf.append(LanguageTag.canonicalizeLanguage(subtag));
        }
        if ((subtag = tag.getScript()).length() > 0) {
            buf.append("-");
            buf.append(LanguageTag.canonicalizeScript(subtag));
        }
        if ((subtag = tag.getRegion()).length() > 0) {
            buf.append("-");
            buf.append(LanguageTag.canonicalizeRegion(subtag));
        }
        List<String> subtags = tag.getVariants();
        for (String s : subtags) {
            buf.append("-");
            buf.append(s);
        }
        subtags = tag.getExtensions();
        for (String s : subtags) {
            buf.append("-");
            buf.append(LanguageTag.canonicalizeExtension(s));
        }
        subtag = tag.getPrivateuse();
        if (subtag.length() > 0) {
            if (buf.length() > 0) {
                buf.append("-");
            }
            buf.append("x").append("-");
            buf.append(subtag);
        }
        return buf.toString();
    }

    public static Locale forLanguageTag(String languageTag) {
        LanguageTag tag = LanguageTag.parse(languageTag, null);
        InternalLocaleBuilder bldr = new InternalLocaleBuilder();
        bldr.setLanguageTag(tag);
        BaseLocale base = bldr.getBaseLocale();
        LocaleExtensions exts = bldr.getLocaleExtensions();
        if (exts == null && base.getVariant().length() > 0) {
            exts = Locale.getCompatibilityExtensions(base.getLanguage(), base.getScript(), base.getRegion(), base.getVariant());
        }
        return Locale.getInstance(base, exts);
    }

    public String getISO3Language() throws MissingResourceException {
        String lang = this.baseLocale.getLanguage();
        if (lang.length() == 3) {
            return lang;
        }
        String language3 = Locale.getISO3Code(lang, "aaaarababkaeaveafafrakakaamamhanargararaasasmavavaayaymazazebabakbebelbgbulbhbihbibisbmbambnbenbobodbrbrebsboscacatcechechchacocoscrcrecscescuchucvchvcycymdadandedeudvdivdzdzoeeeweelellenengeoepoesspaetesteueusfafasfffulfifinfjfijfofaofrfrafyfrygaglegdglaglglggngrngugujgvglvhahauhehebhihinhohmohrhrvhthathuhunhyhyehzheriainaidindieileigiboiiiiiikipkinindioidoisislititaiuikuiwhebjajpnjiyidjvjavkakatkgkonkikikkjkuakkkazklkalkmkhmknkankokorkrkaukskaskukurkvkomkwcorkykirlalatlbltzlgluglilimlnlinlolaoltlitlulublvlavmgmlgmhmahmimrimkmkdmlmalmnmonmomolmrmarmsmsamtmltmymyananaunbnobndndenenepngndonlnldnnnnononornrnblnvnavnynyaocociojojiomormororiososspapanpipliplpolpspusptporququermrohrnrunroronrurusrwkinsasanscsrdsdsndsesmesgsagsisinskslkslslvsmsmosnsnasosomsqsqisrsrpsssswstsotsusunsvsweswswatatamteteltgtgkththatitirtktuktltgltntsntotontrturtstsotttattwtwitytahuguigukukrururduzuzbvevenvivievovolwawlnwowolxhxhoyiyidyoyorzazhazhzhozuzul");
        if (language3 == null) {
            throw new MissingResourceException("Couldn't find 3-letter language code for " + lang, "FormatData_" + this.toString(), "ShortLanguage");
        }
        return language3;
    }

    public String getISO3Country() throws MissingResourceException {
        String country3 = Locale.getISO3Code(this.baseLocale.getRegion(), "ADANDAEAREAFAFGAGATGAIAIAALALBAMARMANANTAOAGOAQATAARARGASASMATAUTAUAUSAWABWAXALAAZAZEBABIHBBBRBBDBGDBEBELBFBFABGBGRBHBHRBIBDIBJBENBLBLMBMBMUBNBRNBOBOLBQBESBRBRABSBHSBTBTNBVBVTBWBWABYBLRBZBLZCACANCCCCKCDCODCFCAFCGCOGCHCHECICIVCKCOKCLCHLCMCMRCNCHNCOCOLCRCRICUCUBCVCPVCWCUWCXCXRCYCYPCZCZEDEDEUDJDJIDKDNKDMDMADODOMDZDZAECECUEEESTEGEGYEHESHERERIESESPETETHFIFINFJFJIFKFLKFMFSMFOFROFRFRAGAGABGBGBRGDGRDGEGEOGFGUFGGGGYGHGHAGIGIBGLGRLGMGMBGNGINGPGLPGQGNQGRGRCGSSGSGTGTMGUGUMGWGNBGYGUYHKHKGHMHMDHNHNDHRHRVHTHTIHUHUNIDIDNIEIRLILISRIMIMNININDIOIOTIQIRQIRIRNISISLITITAJEJEYJMJAMJOJORJPJPNKEKENKGKGZKHKHMKIKIRKMCOMKNKNAKPPRKKRKORKWKWTKYCYMKZKAZLALAOLBLBNLCLCALILIELKLKALRLBRLSLSOLTLTULULUXLVLVALYLBYMAMARMCMCOMDMDAMEMNEMFMAFMGMDGMHMHLMKMKDMLMLIMMMMRMNMNGMOMACMPMNPMQMTQMRMRTMSMSRMTMLTMUMUSMVMDVMWMWIMXMEXMYMYSMZMOZNANAMNCNCLNENERNFNFKNGNGANINICNLNLDNONORNPNPLNRNRUNUNIUNZNZLOMOMNPAPANPEPERPFPYFPGPNGPHPHLPKPAKPLPOLPMSPMPNPCNPRPRIPSPSEPTPRTPWPLWPYPRYQAQATREREUROROURSSRBRURUSRWRWASASAUSBSLBSCSYCSDSDNSESWESGSGPSHSHNSISVNSJSJMSKSVKSLSLESMSMRSNSENSOSOMSRSURSTSTPSVSLVSXSXMSYSYRSZSWZTCTCATDTCDTFATFTGTGOTHTHATJTJKTKTKLTLTLSTMTKMTNTUNTOTONTRTURTTTTOTVTUVTWTWNTZTZAUAUKRUGUGAUMUMIUSUSAUYURYUZUZBVAVATVCVCTVEVENVGVGBVIVIRVNVNMVUVUTWFWLFWSWSMYEYEMYTMYTZAZAFZMZMBZWZWE");
        if (country3 == null) {
            throw new MissingResourceException("Couldn't find 3-letter country code for " + this.baseLocale.getRegion(), "FormatData_" + this.toString(), "ShortCountry");
        }
        return country3;
    }

    private static final String getISO3Code(String iso2Code, String table) {
        int tableLength;
        int codeLength = iso2Code.length();
        if (codeLength == 0) {
            return "";
        }
        int index = tableLength = table.length();
        if (codeLength == 2) {
            char c1 = iso2Code.charAt(0);
            char c2 = iso2Code.charAt(1);
            for (index = 0; index < tableLength && (table.charAt(index) != c1 || table.charAt(index + 1) != c2); index += 5) {
            }
        }
        return index < tableLength ? table.substring(index + 2, index + 5) : null;
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(Locale.getDefault(Category.DISPLAY));
    }

    public String getDisplayLanguage(Locale inLocale) {
        return this.getDisplayString(this.baseLocale.getLanguage(), inLocale, 0);
    }

    public String getDisplayScript() {
        return this.getDisplayScript(Locale.getDefault());
    }

    public String getDisplayScript(Locale inLocale) {
        return this.getDisplayString(this.baseLocale.getScript(), inLocale, 3);
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(Locale.getDefault(Category.DISPLAY));
    }

    public String getDisplayCountry(Locale inLocale) {
        return this.getDisplayString(this.baseLocale.getRegion(), inLocale, 1);
    }

    private String getDisplayString(String code, Locale inLocale, int type) {
        if (code.length() == 0) {
            return "";
        }
        if (inLocale == null) {
            throw new NullPointerException();
        }
        try {
            OpenListResourceBundle bundle = LocaleData.getLocaleNames(inLocale);
            String key = type == 2 ? "%%" + code : code;
            String result = null;
            LocaleServiceProviderPool pool = LocaleServiceProviderPool.getPool(LocaleNameProvider.class);
            if (pool.hasProviders()) {
                result = pool.getLocalizedObject(LocaleNameGetter.INSTANCE, inLocale, bundle, key, type, code);
            }
            if (result == null) {
                result = bundle.getString(key);
            }
            if (result != null) {
                return result;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return code;
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(Locale.getDefault(Category.DISPLAY));
    }

    public String getDisplayVariant(Locale inLocale) {
        if (this.baseLocale.getVariant().length() == 0) {
            return "";
        }
        OpenListResourceBundle bundle = LocaleData.getLocaleNames(inLocale);
        String[] names = this.getDisplayVariantArray(bundle, inLocale);
        String listPattern = null;
        String listCompositionPattern = null;
        try {
            listPattern = bundle.getString("ListPattern");
            listCompositionPattern = bundle.getString("ListCompositionPattern");
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return Locale.formatList(names, listPattern, listCompositionPattern);
    }

    public final String getDisplayName() {
        return this.getDisplayName(Locale.getDefault(Category.DISPLAY));
    }

    public String getDisplayName(Locale inLocale) {
        OpenListResourceBundle bundle = LocaleData.getLocaleNames(inLocale);
        String languageName = this.getDisplayLanguage(inLocale);
        String scriptName = this.getDisplayScript(inLocale);
        String countryName = this.getDisplayCountry(inLocale);
        String[] variantNames = this.getDisplayVariantArray(bundle, inLocale);
        String displayNamePattern = null;
        String listPattern = null;
        String listCompositionPattern = null;
        try {
            displayNamePattern = bundle.getString("DisplayNamePattern");
            listPattern = bundle.getString("ListPattern");
            listCompositionPattern = bundle.getString("ListCompositionPattern");
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        String mainName = null;
        String[] qualifierNames = null;
        if (languageName.length() == 0 && scriptName.length() == 0 && countryName.length() == 0) {
            if (variantNames.length == 0) {
                return "";
            }
            return Locale.formatList(variantNames, listPattern, listCompositionPattern);
        }
        ArrayList<String> names = new ArrayList<String>(4);
        if (languageName.length() != 0) {
            names.add(languageName);
        }
        if (scriptName.length() != 0) {
            names.add(scriptName);
        }
        if (countryName.length() != 0) {
            names.add(countryName);
        }
        if (variantNames.length != 0) {
            for (String var : variantNames) {
                names.add(var);
            }
        }
        mainName = (String)names.get(0);
        int numNames = names.size();
        qualifierNames = numNames > 1 ? names.subList(1, numNames).toArray(new String[numNames - 1]) : new String[]{};
        Object[] displayNames = new Object[]{new Integer(qualifierNames.length != 0 ? 2 : 1), mainName, qualifierNames.length != 0 ? Locale.formatList(qualifierNames, listPattern, listCompositionPattern) : null};
        if (displayNamePattern != null) {
            return new MessageFormat(displayNamePattern).format(displayNames);
        }
        StringBuilder result = new StringBuilder();
        result.append((String)displayNames[1]);
        if (displayNames.length > 2) {
            result.append(" (");
            result.append((String)displayNames[2]);
            result.append(')');
        }
        return result.toString();
    }

    public Object clone() {
        try {
            Locale that = (Locale)super.clone();
            return that;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int hc = this.hashCodeValue;
        if (hc == 0) {
            hc = this.baseLocale.hashCode();
            if (this.localeExtensions != null) {
                hc ^= this.localeExtensions.hashCode();
            }
            this.hashCodeValue = hc;
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Locale)) {
            return false;
        }
        BaseLocale otherBase = ((Locale)obj).baseLocale;
        if (!this.baseLocale.equals(otherBase)) {
            return false;
        }
        if (this.localeExtensions == null) {
            return ((Locale)obj).localeExtensions == null;
        }
        return this.localeExtensions.equals(((Locale)obj).localeExtensions);
    }

    private String[] getDisplayVariantArray(OpenListResourceBundle bundle, Locale inLocale) {
        StringTokenizer tokenizer = new StringTokenizer(this.baseLocale.getVariant(), "_");
        String[] names = new String[tokenizer.countTokens()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.getDisplayString(tokenizer.nextToken(), inLocale, 2);
        }
        return names;
    }

    private static String formatList(String[] stringList, String listPattern, String listCompositionPattern) {
        if (listPattern == null || listCompositionPattern == null) {
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < stringList.length; ++i) {
                if (i > 0) {
                    result.append(',');
                }
                result.append(stringList[i]);
            }
            return result.toString();
        }
        if (stringList.length > 3) {
            MessageFormat format = new MessageFormat(listCompositionPattern);
            stringList = Locale.composeList(format, stringList);
        }
        Object[] args = new Object[stringList.length + 1];
        System.arraycopy(stringList, 0, args, 1, stringList.length);
        args[0] = new Integer(stringList.length);
        MessageFormat format = new MessageFormat(listPattern);
        return format.format(args);
    }

    private static String[] composeList(MessageFormat format, String[] list) {
        if (list.length <= 3) {
            return list;
        }
        String[] listItems = new String[]{list[0], list[1]};
        String newItem = format.format(listItems);
        String[] newList = new String[list.length - 1];
        System.arraycopy(list, 2, newList, 1, newList.length - 1);
        newList[0] = newItem;
        return Locale.composeList(format, newList);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("language", this.baseLocale.getLanguage());
        fields.put("script", this.baseLocale.getScript());
        fields.put("country", this.baseLocale.getRegion());
        fields.put("variant", this.baseLocale.getVariant());
        fields.put("extensions", this.localeExtensions == null ? "" : this.localeExtensions.getID());
        fields.put("hashcode", -1);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        String language = (String)fields.get("language", "");
        String script = (String)fields.get("script", "");
        String country = (String)fields.get("country", "");
        String variant = (String)fields.get("variant", "");
        String extStr = (String)fields.get("extensions", "");
        this.baseLocale = BaseLocale.getInstance(Locale.convertOldISOCodes(language), script, country, variant);
        if (extStr.length() > 0) {
            try {
                InternalLocaleBuilder bldr = new InternalLocaleBuilder();
                bldr.setExtensions(extStr);
                this.localeExtensions = bldr.getLocaleExtensions();
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage());
            }
        } else {
            this.localeExtensions = null;
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return Locale.getInstance(this.baseLocale.getLanguage(), this.baseLocale.getScript(), this.baseLocale.getRegion(), this.baseLocale.getVariant(), this.localeExtensions);
    }

    private static String convertOldISOCodes(String language) {
        if ((language = LocaleUtils.toLowerString(language).intern()) == "he") {
            return "iw";
        }
        if (language == "yi") {
            return "ji";
        }
        if (language == "id") {
            return "in";
        }
        return language;
    }

    private static LocaleExtensions getCompatibilityExtensions(String language, String script, String country, String variant) {
        LocaleExtensions extensions = null;
        if (LocaleUtils.caseIgnoreMatch(language, "ja") && script.length() == 0 && LocaleUtils.caseIgnoreMatch(country, "jp") && "JP".equals(variant)) {
            extensions = LocaleExtensions.CALENDAR_JAPANESE;
        } else if (LocaleUtils.caseIgnoreMatch(language, "th") && script.length() == 0 && LocaleUtils.caseIgnoreMatch(country, "th") && "TH".equals(variant)) {
            extensions = LocaleExtensions.NUMBER_THAI;
        }
        return extensions;
    }

    public static final class Builder {
        private final InternalLocaleBuilder localeBuilder = new InternalLocaleBuilder();

        public Builder setLocale(Locale locale) {
            try {
                this.localeBuilder.setLocale(locale.baseLocale, locale.localeExtensions);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder setLanguageTag(String languageTag) {
            ParseStatus sts = new ParseStatus();
            LanguageTag tag = LanguageTag.parse(languageTag, sts);
            if (sts.isError()) {
                throw new IllformedLocaleException(sts.getErrorMessage(), sts.getErrorIndex());
            }
            this.localeBuilder.setLanguageTag(tag);
            return this;
        }

        public Builder setLanguage(String language) {
            try {
                this.localeBuilder.setLanguage(language);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder setScript(String script) {
            try {
                this.localeBuilder.setScript(script);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder setRegion(String region) {
            try {
                this.localeBuilder.setRegion(region);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder setVariant(String variant) {
            try {
                this.localeBuilder.setVariant(variant);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder setExtension(char key, String value) {
            try {
                this.localeBuilder.setExtension(key, value);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder setUnicodeLocaleKeyword(String key, String type) {
            try {
                this.localeBuilder.setUnicodeLocaleKeyword(key, type);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder addUnicodeLocaleAttribute(String attribute) {
            try {
                this.localeBuilder.addUnicodeLocaleAttribute(attribute);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder removeUnicodeLocaleAttribute(String attribute) {
            try {
                this.localeBuilder.removeUnicodeLocaleAttribute(attribute);
            }
            catch (LocaleSyntaxException e) {
                throw new IllformedLocaleException(e.getMessage(), e.getErrorIndex());
            }
            return this;
        }

        public Builder clear() {
            this.localeBuilder.clear();
            return this;
        }

        public Builder clearExtensions() {
            this.localeBuilder.clearExtensions();
            return this;
        }

        public Locale build() {
            BaseLocale baseloc = this.localeBuilder.getBaseLocale();
            LocaleExtensions extensions = this.localeBuilder.getLocaleExtensions();
            if (extensions == null && baseloc.getVariant().length() > 0) {
                extensions = Locale.getCompatibilityExtensions(baseloc.getLanguage(), baseloc.getScript(), baseloc.getRegion(), baseloc.getVariant());
            }
            return Locale.getInstance(baseloc, extensions);
        }
    }

    public static enum Category {
        DISPLAY("user.language.display", "user.script.display", "user.country.display", "user.variant.display"),
        FORMAT("user.language.format", "user.script.format", "user.country.format", "user.variant.format");

        final String languageKey;
        final String scriptKey;
        final String countryKey;
        final String variantKey;

        private Category(String languageKey, String scriptKey, String countryKey, String variantKey) {
            this.languageKey = languageKey;
            this.scriptKey = scriptKey;
            this.countryKey = countryKey;
            this.variantKey = variantKey;
        }
    }

    private static class LocaleNameGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<LocaleNameProvider, String> {
        private static final LocaleNameGetter INSTANCE = new LocaleNameGetter();

        private LocaleNameGetter() {
        }

        @Override
        public String getObject(LocaleNameProvider localeNameProvider, Locale locale, String key, Object ... params) {
            assert (params.length == 2);
            int type = (Integer)params[0];
            String code = (String)params[1];
            switch (type) {
                case 0: {
                    return localeNameProvider.getDisplayLanguage(code, locale);
                }
                case 1: {
                    return localeNameProvider.getDisplayCountry(code, locale);
                }
                case 2: {
                    return localeNameProvider.getDisplayVariant(code, locale);
                }
                case 3: {
                    return localeNameProvider.getDisplayScript(code, locale);
                }
            }
            assert (false);
            return null;
        }
    }

    private static final class LocaleKey {
        private final BaseLocale base;
        private final LocaleExtensions exts;
        private final int hash;

        private LocaleKey(BaseLocale baseLocale, LocaleExtensions extensions) {
            this.base = baseLocale;
            this.exts = extensions;
            int h = this.base.hashCode();
            if (this.exts != null) {
                h ^= this.exts.hashCode();
            }
            this.hash = h;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LocaleKey)) {
                return false;
            }
            LocaleKey other = (LocaleKey)obj;
            if (this.hash != other.hash || !this.base.equals(other.base)) {
                return false;
            }
            if (this.exts == null) {
                return other.exts == null;
            }
            return this.exts.equals(other.exts);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class Cache
    extends LocaleObjectCache<LocaleKey, Locale> {
        private Cache() {
        }

        @Override
        protected Locale createObject(LocaleKey key) {
            return new Locale(key.base, key.exts);
        }
    }
}

