/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketPermissionCollection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import sun.net.PortConfig;
import sun.net.RegisteredDomain;
import sun.net.util.IPAddressUtil;
import sun.net.www.URLConnection;
import sun.security.action.GetBooleanAction;
import sun.security.util.Debug;

public final class SocketPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = -7204263841984476862L;
    private static final int CONNECT = 1;
    private static final int LISTEN = 2;
    private static final int ACCEPT = 4;
    private static final int RESOLVE = 8;
    private static final int NONE = 0;
    private static final int ALL = 15;
    private static final int PORT_MIN = 0;
    private static final int PORT_MAX = 65535;
    private static final int PRIV_PORT_MAX = 1023;
    private static final int DEF_EPH_LOW = 49152;
    private transient int mask;
    private String actions;
    private transient String hostname;
    private transient String cname;
    private transient InetAddress[] addresses;
    private transient boolean wildcard;
    private transient boolean init_with_ip;
    private transient boolean invalid;
    private transient int[] portrange;
    private transient boolean defaultDeny = false;
    private transient boolean untrusted;
    private transient boolean trusted;
    private static boolean trustNameService;
    private static Debug debug;
    private static boolean debugInit;
    private static final int ephemeralLow;
    private static final int ephemeralHigh;
    private transient String cdomain;
    private transient String hdomain;

    private static synchronized Debug getDebug() {
        if (!debugInit) {
            debug = Debug.getInstance("access");
            debugInit = true;
        }
        return debug;
    }

    public SocketPermission(String host, String action) {
        super(SocketPermission.getHost(host));
        this.init(this.getName(), SocketPermission.getMask(action));
    }

    SocketPermission(String host, int mask) {
        super(SocketPermission.getHost(host));
        this.init(this.getName(), mask);
    }

    private void setDeny() {
        this.defaultDeny = true;
    }

    private static String getHost(String host) {
        int ind;
        if (host.equals("")) {
            return "localhost";
        }
        if (host.charAt(0) != '[' && (ind = host.indexOf(58)) != host.lastIndexOf(58)) {
            StringTokenizer st = new StringTokenizer(host, ":");
            int tokens = st.countTokens();
            if (tokens == 9) {
                ind = host.lastIndexOf(58);
                host = "[" + host.substring(0, ind) + "]" + host.substring(ind);
            } else if (tokens == 8 && host.indexOf("::") == -1) {
                host = "[" + host + "]";
            } else {
                throw new IllegalArgumentException("Ambiguous hostport part");
            }
        }
        return host;
    }

    private int[] parsePort(String port) throws Exception {
        if (port == null || port.equals("") || port.equals("*")) {
            return new int[]{0, 65535};
        }
        int dash = port.indexOf(45);
        if (dash == -1) {
            int p = Integer.parseInt(port);
            return new int[]{p, p};
        }
        String low = port.substring(0, dash);
        String high = port.substring(dash + 1);
        int l = low.equals("") ? 0 : Integer.parseInt(low);
        int h = high.equals("") ? 65535 : Integer.parseInt(high);
        if (l < 0 || h < 0 || h < l) {
            throw new IllegalArgumentException("invalid port range");
        }
        return new int[]{l, h};
    }

    private boolean includesEphemerals() {
        return this.portrange[0] == 0;
    }

    private void init(String host, int mask) {
        char ch;
        if ((mask & 0xF) != mask) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        this.mask = mask | 8;
        int rb = 0;
        int start = 0;
        int end = 0;
        int sep = -1;
        String hostport = host;
        if (host.charAt(0) == '[') {
            start = 1;
            rb = host.indexOf(93);
            if (rb == -1) {
                throw new IllegalArgumentException("invalid host/port: " + host);
            }
            host = host.substring(start, rb);
            sep = hostport.indexOf(58, rb + 1);
        } else {
            start = 0;
            end = sep = host.indexOf(58, rb);
            if (sep != -1) {
                host = host.substring(start, end);
            }
        }
        if (sep != -1) {
            String port = hostport.substring(sep + 1);
            try {
                this.portrange = this.parsePort(port);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid port range: " + port);
            }
        } else {
            this.portrange = new int[]{0, 65535};
        }
        this.hostname = host;
        if (host.lastIndexOf(42) > 0) {
            throw new IllegalArgumentException("invalid host wildcard specification");
        }
        if (host.startsWith("*")) {
            this.wildcard = true;
            if (host.equals("*")) {
                this.cname = "";
            } else if (host.startsWith("*.")) {
                this.cname = host.substring(1).toLowerCase();
            } else {
                throw new IllegalArgumentException("invalid host wildcard specification");
            }
            return;
        }
        if (host.length() > 0 && ((ch = host.charAt(0)) == ':' || Character.digit(ch, 16) != -1)) {
            byte[] ip = IPAddressUtil.textToNumericFormatV4(host);
            if (ip == null) {
                ip = IPAddressUtil.textToNumericFormatV6(host);
            }
            if (ip != null) {
                try {
                    this.addresses = new InetAddress[]{InetAddress.getByAddress(ip)};
                    this.init_with_ip = true;
                }
                catch (UnknownHostException uhe) {
                    this.invalid = true;
                }
            }
        }
    }

    private static int getMask(String action) {
        if (action == null) {
            throw new NullPointerException("action can't be null");
        }
        if (action.equals("")) {
            throw new IllegalArgumentException("action can't be empty");
        }
        int mask = 0;
        if (action == "resolve") {
            return 8;
        }
        if (action == "connect") {
            return 1;
        }
        if (action == "listen") {
            return 2;
        }
        if (action == "accept") {
            return 4;
        }
        if (action == "connect,accept") {
            return 5;
        }
        char[] a = action.toCharArray();
        int i = a.length - 1;
        if (i < 0) {
            return mask;
        }
        while (i != -1) {
            int matchlen;
            char c;
            while (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --i;
            }
            if (!(i < 6 || a[i - 6] != 'c' && a[i - 6] != 'C' || a[i - 5] != 'o' && a[i - 5] != 'O' || a[i - 4] != 'n' && a[i - 4] != 'N' || a[i - 3] != 'n' && a[i - 3] != 'N' || a[i - 2] != 'e' && a[i - 2] != 'E' || a[i - 1] != 'c' && a[i - 1] != 'C' || a[i] != 't' && a[i] != 'T')) {
                matchlen = 7;
                mask |= 1;
            } else if (!(i < 6 || a[i - 6] != 'r' && a[i - 6] != 'R' || a[i - 5] != 'e' && a[i - 5] != 'E' || a[i - 4] != 's' && a[i - 4] != 'S' || a[i - 3] != 'o' && a[i - 3] != 'O' || a[i - 2] != 'l' && a[i - 2] != 'L' || a[i - 1] != 'v' && a[i - 1] != 'V' || a[i] != 'e' && a[i] != 'E')) {
                matchlen = 7;
                mask |= 8;
            } else if (!(i < 5 || a[i - 5] != 'l' && a[i - 5] != 'L' || a[i - 4] != 'i' && a[i - 4] != 'I' || a[i - 3] != 's' && a[i - 3] != 'S' || a[i - 2] != 't' && a[i - 2] != 'T' || a[i - 1] != 'e' && a[i - 1] != 'E' || a[i] != 'n' && a[i] != 'N')) {
                matchlen = 6;
                mask |= 2;
            } else if (!(i < 5 || a[i - 5] != 'a' && a[i - 5] != 'A' || a[i - 4] != 'c' && a[i - 4] != 'C' || a[i - 3] != 'c' && a[i - 3] != 'C' || a[i - 2] != 'e' && a[i - 2] != 'E' || a[i - 1] != 'p' && a[i - 1] != 'P' || a[i] != 't' && a[i] != 'T')) {
                matchlen = 6;
                mask |= 4;
            } else {
                throw new IllegalArgumentException("invalid permission: " + action);
            }
            boolean seencomma = false;
            while (i >= matchlen && !seencomma) {
                switch (a[i - matchlen]) {
                    case ',': {
                        seencomma = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + action);
                    }
                }
                --i;
            }
            i -= matchlen;
        }
        return mask;
    }

    private boolean isUntrusted() throws UnknownHostException {
        if (this.trusted) {
            return false;
        }
        if (this.invalid || this.untrusted) {
            return true;
        }
        try {
            if (!trustNameService && (this.defaultDeny || URLConnection.isProxiedHost(this.hostname))) {
                if (this.cname == null) {
                    this.getCanonName();
                }
                if (!this.match(this.cname, this.hostname) && !this.authorized(this.hostname, this.addresses[0].getAddress())) {
                    this.untrusted = true;
                    Debug debug = SocketPermission.getDebug();
                    if (debug != null && Debug.isOn("failure")) {
                        debug.println("socket access restriction: proxied host (" + this.addresses[0] + ")" + " does not match " + this.cname + " from reverse lookup");
                    }
                    return true;
                }
                this.trusted = true;
            }
        }
        catch (UnknownHostException uhe) {
            this.invalid = true;
            throw uhe;
        }
        return false;
    }

    void getCanonName() throws UnknownHostException {
        if (this.cname != null || this.invalid || this.untrusted) {
            return;
        }
        try {
            if (this.addresses == null) {
                this.getIP();
            }
            this.cname = this.init_with_ip ? this.addresses[0].getHostName(false).toLowerCase() : InetAddress.getByName(this.addresses[0].getHostAddress()).getHostName(false).toLowerCase();
        }
        catch (UnknownHostException uhe) {
            this.invalid = true;
            throw uhe;
        }
    }

    private boolean match(String cname, String hname) {
        String b;
        String a = cname.toLowerCase();
        if (a.startsWith(b = hname.toLowerCase()) && (a.length() == b.length() || a.charAt(b.length()) == '.')) {
            return true;
        }
        if (this.cdomain == null) {
            this.cdomain = RegisteredDomain.getRegisteredDomain((String)a);
        }
        if (this.hdomain == null) {
            this.hdomain = RegisteredDomain.getRegisteredDomain((String)b);
        }
        return this.cdomain.length() != 0 && this.hdomain.length() != 0 && this.cdomain.equals(this.hdomain);
    }

    private boolean authorized(String cname, byte[] addr) {
        if (addr.length == 4) {
            return this.authorizedIPv4(cname, addr);
        }
        if (addr.length == 16) {
            return this.authorizedIPv6(cname, addr);
        }
        return false;
    }

    private boolean authorizedIPv4(String cname, byte[] addr) {
        block4: {
            String authHost = "";
            try {
                authHost = "auth." + (addr[3] & 0xFF) + "." + (addr[2] & 0xFF) + "." + (addr[1] & 0xFF) + "." + (addr[0] & 0xFF) + ".in-addr.arpa";
                authHost = this.hostname + '.' + authHost;
                InetAddress auth = InetAddress.getAllByName0(authHost, false)[0];
                if (auth.equals(InetAddress.getByAddress(addr))) {
                    return true;
                }
                Debug debug = SocketPermission.getDebug();
                if (debug != null && Debug.isOn("failure")) {
                    debug.println("socket access restriction: IP address of " + auth + " != " + InetAddress.getByAddress(addr));
                }
            }
            catch (UnknownHostException uhe) {
                Debug debug = SocketPermission.getDebug();
                if (debug == null || !Debug.isOn("failure")) break block4;
                debug.println("socket access restriction: forward lookup failed for " + authHost);
            }
        }
        return false;
    }

    private boolean authorizedIPv6(String cname, byte[] addr) {
        block5: {
            String authHost = "";
            try {
                StringBuffer sb = new StringBuffer(39);
                for (int i = 15; i >= 0; --i) {
                    sb.append(Integer.toHexString(addr[i] & 0xF));
                    sb.append('.');
                    sb.append(Integer.toHexString(addr[i] >> 4 & 0xF));
                    sb.append('.');
                }
                authHost = "auth." + sb.toString() + "IP6.ARPA";
                authHost = this.hostname + '.' + authHost;
                InetAddress auth = InetAddress.getAllByName0(authHost, false)[0];
                if (auth.equals(InetAddress.getByAddress(addr))) {
                    return true;
                }
                Debug debug = SocketPermission.getDebug();
                if (debug != null && Debug.isOn("failure")) {
                    debug.println("socket access restriction: IP address of " + auth + " != " + InetAddress.getByAddress(addr));
                }
            }
            catch (UnknownHostException uhe) {
                Debug debug = SocketPermission.getDebug();
                if (debug == null || !Debug.isOn("failure")) break block5;
                debug.println("socket access restriction: forward lookup failed for " + authHost);
            }
        }
        return false;
    }

    void getIP() throws UnknownHostException {
        if (this.addresses != null || this.wildcard || this.invalid) {
            return;
        }
        try {
            int i;
            String host = this.getName().charAt(0) == '[' ? this.getName().substring(1, this.getName().indexOf(93)) : ((i = this.getName().indexOf(":")) == -1 ? this.getName() : this.getName().substring(0, i));
            this.addresses = new InetAddress[]{InetAddress.getAllByName0(host, false)[0]};
        }
        catch (UnknownHostException uhe) {
            this.invalid = true;
            throw uhe;
        }
        catch (IndexOutOfBoundsException iobe) {
            this.invalid = true;
            throw new UnknownHostException(this.getName());
        }
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof SocketPermission)) {
            return false;
        }
        if (p == this) {
            return true;
        }
        SocketPermission that = (SocketPermission)p;
        return (this.mask & that.mask) == that.mask && this.impliesIgnoreMask(that);
    }

    boolean impliesIgnoreMask(SocketPermission that) {
        if ((that.mask & 8) != that.mask && (that.portrange[0] < this.portrange[0] || that.portrange[1] > this.portrange[1])) {
            if (this.includesEphemerals() || that.includesEphemerals()) {
                if (!SocketPermission.inRange(this.portrange[0], this.portrange[1], that.portrange[0], that.portrange[1])) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.wildcard && "".equals(this.cname)) {
            return true;
        }
        if (this.invalid || that.invalid) {
            return this.compareHostnames(that);
        }
        try {
            if (this.init_with_ip) {
                if (that.wildcard) {
                    return false;
                }
                if (that.init_with_ip) {
                    return this.addresses[0].equals(that.addresses[0]);
                }
                if (that.addresses == null) {
                    that.getIP();
                }
                for (int i = 0; i < that.addresses.length; ++i) {
                    if (!this.addresses[0].equals(that.addresses[i])) continue;
                    return true;
                }
                return false;
            }
            if (this.wildcard || that.wildcard) {
                if (this.wildcard && that.wildcard) {
                    return that.cname.endsWith(this.cname);
                }
                if (that.wildcard) {
                    return false;
                }
                if (that.cname == null) {
                    that.getCanonName();
                }
                return that.cname.endsWith(this.cname);
            }
            if (this.addresses == null) {
                this.getIP();
            }
            if (that.addresses == null) {
                that.getIP();
            }
            if (!that.init_with_ip || !this.isUntrusted()) {
                for (int j = 0; j < this.addresses.length; ++j) {
                    for (int i = 0; i < that.addresses.length; ++i) {
                        if (!this.addresses[j].equals(that.addresses[i])) continue;
                        return true;
                    }
                }
                if (this.cname == null) {
                    this.getCanonName();
                }
                if (that.cname == null) {
                    that.getCanonName();
                }
                return this.cname.equalsIgnoreCase(that.cname);
            }
        }
        catch (UnknownHostException uhe) {
            return this.compareHostnames(that);
        }
        return false;
    }

    private boolean compareHostnames(SocketPermission that) {
        String thisHost = this.hostname;
        String thatHost = that.hostname;
        if (thisHost == null) {
            return false;
        }
        return thisHost.equalsIgnoreCase(thatHost);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SocketPermission)) {
            return false;
        }
        SocketPermission that = (SocketPermission)obj;
        if (this.mask != that.mask) {
            return false;
        }
        if ((that.mask & 8) != that.mask && (this.portrange[0] != that.portrange[0] || this.portrange[1] != that.portrange[1])) {
            return false;
        }
        if (this.getName().equalsIgnoreCase(that.getName())) {
            return true;
        }
        try {
            this.getCanonName();
            that.getCanonName();
        }
        catch (UnknownHostException uhe) {
            return false;
        }
        if (this.invalid || that.invalid) {
            return false;
        }
        if (this.cname != null) {
            return this.cname.equalsIgnoreCase(that.cname);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.init_with_ip || this.wildcard) {
            return this.getName().hashCode();
        }
        try {
            this.getCanonName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (this.invalid || this.cname == null) {
            return this.getName().hashCode();
        }
        return this.cname.hashCode();
    }

    int getMask() {
        return this.mask;
    }

    private static String getActions(int mask) {
        StringBuilder sb = new StringBuilder();
        boolean comma = false;
        if ((mask & 1) == 1) {
            comma = true;
            sb.append("connect");
        }
        if ((mask & 2) == 2) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("listen");
        }
        if ((mask & 4) == 4) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("accept");
        }
        if ((mask & 8) == 8) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("resolve");
        }
        return sb.toString();
    }

    @Override
    public String getActions() {
        if (this.actions == null) {
            this.actions = SocketPermission.getActions(this.mask);
        }
        return this.actions;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new SocketPermissionCollection();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        s.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(this.getName(), SocketPermission.getMask(this.actions));
    }

    private static int initEphemeralPorts(final String suffix, int defval) {
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                int val = Integer.getInteger("jdk.net.ephemeralPortRange." + suffix, -1);
                if (val != -1) {
                    return val;
                }
                return suffix.equals("low") ? PortConfig.getLower() : PortConfig.getUpper();
            }
        });
    }

    private static boolean inRange(int policyLow, int policyHigh, int targetLow, int targetHigh) {
        if (targetLow == 0) {
            if (!SocketPermission.inRange(policyLow, policyHigh, ephemeralLow, ephemeralHigh)) {
                return false;
            }
            if (targetHigh == 0) {
                return true;
            }
            targetLow = 1;
        }
        if (policyLow == 0 && policyHigh == 0) {
            return targetLow >= ephemeralLow && targetHigh <= ephemeralHigh;
        }
        if (policyLow != 0) {
            return targetLow >= policyLow && targetHigh <= policyHigh;
        }
        if (policyHigh >= ephemeralLow - 1) {
            return targetHigh <= ephemeralHigh;
        }
        return targetLow <= policyHigh && targetHigh <= policyHigh || targetLow >= ephemeralLow && targetHigh <= ephemeralHigh;
    }

    static {
        debug = null;
        debugInit = false;
        ephemeralLow = SocketPermission.initEphemeralPorts("low", 49152);
        ephemeralHigh = SocketPermission.initEphemeralPorts("high", 65535);
        Boolean tmp = AccessController.doPrivileged(new GetBooleanAction("sun.net.trustNameService"));
        trustNameService = tmp;
    }
}

