/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsMenuItemUI;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import sun.swing.StringUIClientPropertyKey;
import sun.swing.SwingUtilities2;

public class WindowsPopupMenuUI
extends BasicPopupMenuUI {
    static MnemonicListener mnemonicListener = null;
    static final Object GUTTER_OFFSET_KEY = new StringUIClientPropertyKey("GUTTER_OFFSET_KEY");

    public static ComponentUI createUI(JComponent c) {
        return new WindowsPopupMenuUI();
    }

    @Override
    public void installListeners() {
        super.installListeners();
        if (!UIManager.getBoolean("Button.showMnemonics") && mnemonicListener == null) {
            mnemonicListener = new MnemonicListener();
            MenuSelectionManager.defaultManager().addChangeListener(mnemonicListener);
        }
    }

    @Override
    public Popup getPopup(JPopupMenu popupMenu, int x, int y) {
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        return popupFactory.getPopup(popupMenu.getInvoker(), popupMenu, x, y);
    }

    static int getTextOffset(JComponent c) {
        int rv = -1;
        Object maxTextOffset = c.getClientProperty(SwingUtilities2.BASICMENUITEMUI_MAX_TEXT_OFFSET);
        if (maxTextOffset instanceof Integer) {
            rv = (Integer)maxTextOffset;
            int menuItemOffset = 0;
            Component component = c.getComponent(0);
            if (component != null) {
                menuItemOffset = component.getX();
            }
            rv += menuItemOffset;
        }
        return rv;
    }

    static int getSpanBeforeGutter() {
        return 3;
    }

    static int getSpanAfterGutter() {
        return 3;
    }

    static int getGutterWidth() {
        int rv = 2;
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            XPStyle.Skin skin = xp.getSkin(null, TMSchema.Part.MP_POPUPGUTTER);
            rv = skin.getWidth();
        }
        return rv;
    }

    private static boolean isLeftToRight(JComponent c) {
        boolean leftToRight = true;
        for (int i = c.getComponentCount() - 1; i >= 0 && leftToRight; --i) {
            leftToRight = c.getComponent(i).getComponentOrientation().isLeftToRight();
        }
        return leftToRight;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            XPStyle xp = XPStyle.getXP();
            XPStyle.Skin skin = xp.getSkin(c, TMSchema.Part.MP_POPUPBACKGROUND);
            skin.paintSkin(g, 0, 0, c.getWidth(), c.getHeight(), TMSchema.State.NORMAL);
            int textOffset = WindowsPopupMenuUI.getTextOffset(c);
            if (textOffset >= 0 && WindowsPopupMenuUI.isLeftToRight(c)) {
                skin = xp.getSkin(c, TMSchema.Part.MP_POPUPGUTTER);
                int gutterWidth = WindowsPopupMenuUI.getGutterWidth();
                int gutterOffset = textOffset - WindowsPopupMenuUI.getSpanAfterGutter() - gutterWidth;
                c.putClientProperty(GUTTER_OFFSET_KEY, gutterOffset);
                Insets insets = c.getInsets();
                skin.paintSkin(g, gutterOffset, insets.top, gutterWidth, c.getHeight() - insets.bottom - insets.top, TMSchema.State.NORMAL);
            } else if (c.getClientProperty(GUTTER_OFFSET_KEY) != null) {
                c.putClientProperty(GUTTER_OFFSET_KEY, null);
            }
        } else {
            super.paint(g, c);
        }
    }

    static class MnemonicListener
    implements ChangeListener {
        JRootPane repaintRoot = null;

        MnemonicListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            MenuSelectionManager msm = (MenuSelectionManager)ev.getSource();
            MenuElement[] path = msm.getSelectedPath();
            if (path.length == 0) {
                if (!WindowsLookAndFeel.isMnemonicHidden()) {
                    WindowsLookAndFeel.setMnemonicHidden(true);
                    if (this.repaintRoot != null) {
                        Window win = SwingUtilities.getWindowAncestor(this.repaintRoot);
                        WindowsGraphicsUtils.repaintMnemonicsInWindow(win);
                    }
                }
            } else {
                Component c = (Component)((Object)path[0]);
                if (c instanceof JPopupMenu) {
                    c = ((JPopupMenu)c).getInvoker();
                }
                this.repaintRoot = SwingUtilities.getRootPane(c);
            }
        }
    }
}

