/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.Date;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MemoryMonitor
extends JPanel {
    private static final long serialVersionUID = -3463003810776195761L;
    static JCheckBox dateStampCB = new JCheckBox("Output Date Stamp");
    public Surface surf;
    JPanel controls;
    boolean doControls;
    JTextField tf;
    static List<MemoryPoolMXBean> mpools = ManagementFactory.getMemoryPoolMXBeans();
    static int numPools = mpools.size();

    public MemoryMonitor() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(), "Memory Monitor"));
        this.surf = new Surface();
        this.add(this.surf);
        this.controls = new JPanel();
        this.controls.setPreferredSize(new Dimension(135, 80));
        Font font = new Font("serif", 0, 10);
        JLabel label = new JLabel("Sample Rate");
        label.setFont(font);
        label.setForeground(Color.red);
        this.controls.add(label);
        this.tf = new JTextField("1000");
        this.tf.setPreferredSize(new Dimension(45, 20));
        this.controls.add(this.tf);
        label = new JLabel("ms");
        this.controls.add(label);
        label.setFont(font);
        label.setForeground(Color.red);
        this.controls.add(dateStampCB);
        dateStampCB.setFont(font);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MemoryMonitor.this.removeAll();
                MemoryMonitor.this.doControls = !MemoryMonitor.this.doControls;
                if (MemoryMonitor.this.doControls) {
                    MemoryMonitor.this.surf.stop();
                    MemoryMonitor.this.add(MemoryMonitor.this.controls);
                } else {
                    try {
                        MemoryMonitor.this.surf.sleepAmount = Long.parseLong(MemoryMonitor.this.tf.getText().trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    MemoryMonitor.this.surf.start();
                    MemoryMonitor.this.add(MemoryMonitor.this.surf);
                }
                MemoryMonitor.this.validate();
                MemoryMonitor.this.repaint();
            }
        });
    }

    public static void main(String[] s) {
        final MemoryMonitor demo = new MemoryMonitor();
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                demo.surf.start();
            }

            @Override
            public void windowIconified(WindowEvent e) {
                demo.surf.stop();
            }
        };
        JFrame f = new JFrame("MemoryMonitor");
        f.addWindowListener(l);
        f.getContentPane().add("Center", demo);
        f.pack();
        f.setSize(new Dimension(400, 500));
        f.setVisible(true);
        demo.surf.start();
        Thread thr = new Thread(new Memeater());
        thr.start();
    }

    static class Memeater
    extends ClassLoader
    implements Runnable {
        Object[] y;
        static int count = 100000;

        @Override
        public void run() {
            this.y = new Object[10000000];
            int k = 0;
            block4: while (true) {
                if (k == 5000000) {
                    k = 0;
                }
                this.y[k++] = new Object();
                try {
                    Thread.sleep(20L);
                }
                catch (Exception x) {
                    // empty catch block
                }
                try {
                    int i = 0;
                    while (true) {
                        if (i >= 10) continue block4;
                        this.loadNext();
                        ++i;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
                break;
            }
        }

        Class<?> loadNext() throws ClassNotFoundException {
            byte[] value;
            int[] begin = new int[]{202, 254, 186, 190, 0, 0, 0, 48, 0, 10, 10, 0, 3, 0, 7, 7, 0, 8, 7, 0, 9, 1, 0, 6, 60, 105, 110, 105, 116, 62, 1, 0, 3, 40, 41, 86, 1, 0, 4, 67, 111, 100, 101, 12, 0, 4, 0, 5, 1, 0, 10, 84, 101, 115, 116};
            int[] end = new int[]{1, 0, 16, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 79, 98, 106, 101, 99, 116, 0, 33, 0, 2, 0, 3, 0, 0, 0, 0, 0, 1, 0, 1, 0, 4, 0, 5, 0, 1, 0, 6, 0, 0, 0, 17, 0, 1, 0, 1, 0, 0, 0, 5, 42, 183, 0, 1, 177, 0, 0, 0, 0, 0, 0};
            String name = "Test" + Integer.toString(count++);
            try {
                value = name.substring(4).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException x) {
                throw new Error();
            }
            int len = begin.length + value.length + end.length;
            byte[] b = new byte[len];
            int pos = 0;
            for (int i : begin) {
                b[pos++] = (byte)i;
            }
            for (byte v : value) {
                b[pos++] = v;
            }
            for (int e : end) {
                b[pos++] = (byte)e;
            }
            return this.defineClass(name, b, 0, b.length);
        }
    }

    public class Surface
    extends JPanel
    implements Runnable {
        public Thread thread;
        public long sleepAmount = 1000L;
        public int usageHistCount = 20000;
        private int w;
        private int h;
        private BufferedImage bimg;
        private Graphics2D big;
        private Font font = new Font("Times New Roman", 0, 11);
        private int columnInc;
        private float[][] usedMem;
        private float[] usedMemMax;
        private int[] ptNum;
        private int ascent;
        private int descent;
        private Rectangle graphOutlineRect = new Rectangle();
        private Rectangle2D mfRect = new Rectangle2D.Float();
        private Rectangle2D muRect = new Rectangle2D.Float();
        private Line2D graphLine = new Line2D.Float();
        private Color graphColor = new Color(46, 139, 87);
        private Color mfColor = new Color(0, 100, 0);
        private String usedStr;

        public Surface() {
            this.setBackground(Color.black);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Surface.this.thread == null) {
                        Surface.this.start();
                    } else {
                        Surface.this.stop();
                    }
                }
            });
            this.usedMem = new float[numPools][];
            this.usedMemMax = new float[numPools];
            for (int i = 0; i < numPools; ++i) {
                this.usedMemMax[i] = 1048576.0f;
            }
            this.ptNum = new int[numPools];
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(135, 80);
        }

        @Override
        public void paint(Graphics g) {
            if (this.big == null) {
                return;
            }
            this.big.setBackground(this.getBackground());
            this.big.clearRect(0, 0, this.w, this.h);
            this.h /= (numPools + numPools % 2) / 2;
            this.w /= 2;
            int k = 0;
            block0: for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < (numPools + numPools % 2) / 2; ++j) {
                    this.plotMemoryUsage(this.w * i, this.h * j, this.w, this.h, k);
                    if (++k < numPools) continue;
                    i = 3;
                    j = (numPools + numPools % 2) / 2;
                    continue block0;
                }
            }
            g.drawImage(this.bimg, 0, 0, this);
        }

        public void plotMemoryUsage(int x1, int y1, int x2, int y2, int npool) {
            int i;
            MemoryPoolMXBean mp = mpools.get(npool);
            float usedMemory = mp.getUsage().getUsed();
            float totalMemory = mp.getUsage().getMax();
            if (totalMemory < 0.0f) {
                if (usedMemory > this.usedMemMax[npool]) {
                    this.usedMemMax[npool] = usedMemory;
                }
                totalMemory = this.usedMemMax[npool];
            }
            this.big.setColor(Color.green);
            this.big.drawString(String.valueOf((int)totalMemory / 1024) + "K Max ", (float)x1 + 4.0f, (float)y1 + (float)this.ascent + 0.5f);
            this.big.setColor(Color.yellow);
            this.big.drawString(mp.getName(), (float)(x1 + x2 / 2), (float)y1 + (float)this.ascent + 0.5f);
            this.usedStr = String.valueOf((int)usedMemory / 1024) + "K used";
            this.big.setColor(Color.green);
            this.big.drawString(this.usedStr, x1 + 4, y1 + y2 - this.descent);
            float ssH = this.ascent + this.descent;
            float remainingHeight = (float)y2 - ssH * 2.0f - 0.5f;
            float blockHeight = remainingHeight / 10.0f;
            float blockWidth = 20.0f;
            float remainingWidth = (float)x2 - blockWidth - 10.0f;
            this.big.setColor(this.mfColor);
            int MemUsage = (int)((totalMemory - usedMemory) / totalMemory * 10.0f);
            for (i = 0; i < MemUsage; ++i) {
                this.mfRect.setRect(x1 + 5, (float)y1 + ssH + (float)i * blockHeight, blockWidth, blockHeight - 1.0f);
                this.big.fill(this.mfRect);
            }
            this.big.setColor(Color.green);
            while (i < 10) {
                this.muRect.setRect(x1 + 5, (float)y1 + ssH + (float)i * blockHeight, blockWidth, blockHeight - 1.0f);
                this.big.fill(this.muRect);
                ++i;
            }
            if (remainingWidth <= 30.0f) {
                remainingWidth = 30.0f;
            }
            if (remainingHeight <= ssH) {
                remainingHeight = ssH;
            }
            this.big.setColor(this.graphColor);
            int graphX = x1 + 30;
            int graphY = y1 + (int)ssH;
            int graphW = (int)remainingWidth;
            int graphH = (int)remainingHeight;
            this.graphOutlineRect.setRect(graphX, graphY, graphW, graphH);
            this.big.draw(this.graphOutlineRect);
            int graphRow = graphH / 10;
            for (int j = graphY; j <= graphH + graphY; j += graphRow) {
                this.graphLine.setLine(graphX, j, graphX + graphW, j);
                this.big.draw(this.graphLine);
            }
            int graphColumn = graphW / 15;
            if (this.columnInc == 0) {
                this.columnInc = graphColumn;
            }
            for (int j = graphX + this.columnInc; j < graphW + graphX; j += graphColumn) {
                this.graphLine.setLine(j, graphY, j, graphY + graphH);
                this.big.draw(this.graphLine);
            }
            --this.columnInc;
            if (this.usedMem[npool] == null) {
                this.usedMem[npool] = new float[this.usageHistCount];
                this.ptNum[npool] = 0;
            }
            this.usedMem[npool][this.ptNum[npool]] = usedMemory;
            this.big.setColor(Color.yellow);
            int w1 = this.ptNum[npool] > graphW ? graphW : this.ptNum[npool];
            int j = graphX + graphW - w1;
            int k = this.ptNum[npool] - w1;
            while (k < this.ptNum[npool]) {
                if (k != 0) {
                    int h1;
                    if (this.usedMem[npool][k] != this.usedMem[npool][k - 1]) {
                        h1 = (int)((float)graphY + (float)graphH * ((totalMemory - this.usedMem[npool][k - 1]) / totalMemory));
                        int h2 = (int)((float)graphY + (float)graphH * ((totalMemory - this.usedMem[npool][k]) / totalMemory));
                        this.big.drawLine(j - 1, h1, j, h2);
                    } else {
                        h1 = (int)((float)graphY + (float)graphH * ((totalMemory - this.usedMem[npool][k]) / totalMemory));
                        this.big.fillRect(j, h1, 1, 1);
                    }
                }
                ++k;
                ++j;
            }
            if (this.ptNum[npool] + 2 == this.usedMem[npool].length) {
                for (j = 1; j < this.ptNum[npool]; ++j) {
                    this.usedMem[npool][j - 1] = this.usedMem[npool][j];
                }
                int n = npool;
                this.ptNum[n] = this.ptNum[n] - 1;
            } else {
                int n = npool;
                this.ptNum[n] = this.ptNum[n] + 1;
            }
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("MemoryMonitor");
            this.thread.start();
        }

        public synchronized void stop() {
            this.thread = null;
            this.notify();
        }

        @Override
        public void run() {
            Thread me = Thread.currentThread();
            while (this.thread == me && !this.isShowing() || this.getSize().width == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            while (this.thread == me && this.isShowing()) {
                Dimension d = this.getSize();
                if (d.width != this.w || d.height != this.h) {
                    this.w = d.width;
                    this.h = d.height;
                    this.bimg = (BufferedImage)this.createImage(this.w, this.h);
                    this.big = this.bimg.createGraphics();
                    this.big.setFont(this.font);
                    FontMetrics fm = this.big.getFontMetrics(this.font);
                    this.ascent = fm.getAscent();
                    this.descent = fm.getDescent();
                }
                this.repaint();
                try {
                    Thread.sleep(this.sleepAmount);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (!dateStampCB.isSelected()) continue;
                System.out.println(new Date().toString() + " " + this.usedStr);
            }
            this.thread = null;
        }
    }
}

