/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Vector;
import javax.print.CancelablePrintJob;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashPrintJobAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobOriginatingUserName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import sun.print.ImagePrinter;
import sun.print.PSPrinterJob;
import sun.print.PSStreamPrintService;
import sun.print.PrintJobAttributeException;
import sun.print.PrintJobFlavorException;

public class PSStreamPrintJob
implements CancelablePrintJob {
    private transient Vector jobListeners;
    private transient Vector attrListeners;
    private transient Vector listenedAttributeSets;
    private PSStreamPrintService service;
    private boolean fidelity;
    private boolean printing = false;
    private boolean printReturned = false;
    private PrintRequestAttributeSet reqAttrSet = null;
    private PrintJobAttributeSet jobAttrSet = null;
    private PrinterJob job;
    private Doc doc;
    private InputStream instream = null;
    private Reader reader = null;
    private String jobName = "Java Printing";
    private int copies = 1;
    private MediaSize mediaSize = MediaSize.NA.LETTER;
    private OrientationRequested orient = OrientationRequested.PORTRAIT;

    PSStreamPrintJob(PSStreamPrintService service) {
        this.service = service;
    }

    @Override
    public PrintService getPrintService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintJobAttributeSet getAttributes() {
        PSStreamPrintJob pSStreamPrintJob = this;
        synchronized (pSStreamPrintJob) {
            if (this.jobAttrSet == null) {
                HashPrintJobAttributeSet jobSet = new HashPrintJobAttributeSet();
                return AttributeSetUtilities.unmodifiableView(jobSet);
            }
            return this.jobAttrSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrintJobListener(PrintJobListener listener) {
        PSStreamPrintJob pSStreamPrintJob = this;
        synchronized (pSStreamPrintJob) {
            if (listener == null) {
                return;
            }
            if (this.jobListeners == null) {
                this.jobListeners = new Vector();
            }
            this.jobListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrintJobListener(PrintJobListener listener) {
        PSStreamPrintJob pSStreamPrintJob = this;
        synchronized (pSStreamPrintJob) {
            if (listener == null || this.jobListeners == null) {
                return;
            }
            this.jobListeners.remove(listener);
            if (this.jobListeners.isEmpty()) {
                this.jobListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDataStreams() {
        if (this.doc == null) {
            return;
        }
        Object data = null;
        try {
            data = this.doc.getPrintData();
        }
        catch (IOException e) {
            return;
        }
        if (this.instream != null) {
            try {
                this.instream.close();
            }
            catch (IOException e) {
            }
            finally {
                this.instream = null;
            }
        } else if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
            }
            finally {
                this.reader = null;
            }
        } else if (data instanceof InputStream) {
            try {
                ((InputStream)data).close();
            }
            catch (IOException e) {}
        } else if (data instanceof Reader) {
            try {
                ((Reader)data).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEvent(int reason) {
        PSStreamPrintJob pSStreamPrintJob = this;
        synchronized (pSStreamPrintJob) {
            if (this.jobListeners != null) {
                PrintJobEvent event = new PrintJobEvent(this, reason);
                block10: for (int i = 0; i < this.jobListeners.size(); ++i) {
                    PrintJobListener listener = (PrintJobListener)this.jobListeners.elementAt(i);
                    switch (reason) {
                        case 101: {
                            listener.printJobCanceled(event);
                            continue block10;
                        }
                        case 103: {
                            listener.printJobFailed(event);
                            continue block10;
                        }
                        case 106: {
                            listener.printDataTransferCompleted(event);
                            continue block10;
                        }
                        case 105: {
                            listener.printJobNoMoreEvents(event);
                            continue block10;
                        }
                        case 102: {
                            listener.printJobCompleted(event);
                            continue block10;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPrintJobAttributeListener(PrintJobAttributeListener listener, PrintJobAttributeSet attributes) {
        PSStreamPrintJob pSStreamPrintJob = this;
        synchronized (pSStreamPrintJob) {
            if (listener == null) {
                return;
            }
            if (this.attrListeners == null) {
                this.attrListeners = new Vector();
                this.listenedAttributeSets = new Vector();
            }
            this.attrListeners.add(listener);
            if (attributes == null) {
                attributes = new HashPrintJobAttributeSet();
            }
            this.listenedAttributeSets.add(attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePrintJobAttributeListener(PrintJobAttributeListener listener) {
        PSStreamPrintJob pSStreamPrintJob = this;
        synchronized (pSStreamPrintJob) {
            if (listener == null || this.attrListeners == null) {
                return;
            }
            int index = this.attrListeners.indexOf(listener);
            if (index == -1) {
                return;
            }
            this.attrListeners.remove(index);
            this.listenedAttributeSets.remove(index);
            if (this.attrListeners.isEmpty()) {
                this.attrListeners = null;
                this.listenedAttributeSets = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Doc doc, PrintRequestAttributeSet attributes) throws PrintException {
        Object data;
        PSStreamPrintJob pSStreamPrintJob = this;
        synchronized (pSStreamPrintJob) {
            if (this.printing) {
                throw new PrintException("already printing");
            }
            this.printing = true;
        }
        this.doc = doc;
        DocFlavor flavor = doc.getDocFlavor();
        try {
            data = doc.getPrintData();
        }
        catch (IOException e) {
            this.notifyEvent(103);
            throw new PrintException("can't get print data: " + e.toString());
        }
        if (flavor == null || !this.service.isDocFlavorSupported(flavor)) {
            this.notifyEvent(103);
            throw new PrintJobFlavorException("invalid flavor", flavor);
        }
        this.initializeAttributeSets(doc, attributes);
        this.getAttributeValues(flavor);
        String repClassName = flavor.getRepresentationClassName();
        if (flavor.equals(DocFlavor.INPUT_STREAM.GIF) || flavor.equals(DocFlavor.INPUT_STREAM.JPEG) || flavor.equals(DocFlavor.INPUT_STREAM.PNG) || flavor.equals(DocFlavor.BYTE_ARRAY.GIF) || flavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || flavor.equals(DocFlavor.BYTE_ARRAY.PNG)) {
            try {
                this.instream = doc.getStreamForBytes();
                this.printableJob(new ImagePrinter(this.instream), this.reqAttrSet);
                return;
            }
            catch (ClassCastException cce) {
                this.notifyEvent(103);
                throw new PrintException(cce);
            }
            catch (IOException ioe) {
                this.notifyEvent(103);
                throw new PrintException(ioe);
            }
        }
        if (flavor.equals(DocFlavor.URL.GIF) || flavor.equals(DocFlavor.URL.JPEG) || flavor.equals(DocFlavor.URL.PNG)) {
            try {
                this.printableJob(new ImagePrinter((URL)data), this.reqAttrSet);
                return;
            }
            catch (ClassCastException cce) {
                this.notifyEvent(103);
                throw new PrintException(cce);
            }
        }
        if (repClassName.equals("java.awt.print.Pageable")) {
            try {
                this.pageableJob((Pageable)doc.getPrintData(), this.reqAttrSet);
                return;
            }
            catch (ClassCastException cce) {
                this.notifyEvent(103);
                throw new PrintException(cce);
            }
            catch (IOException ioe) {
                this.notifyEvent(103);
                throw new PrintException(ioe);
            }
        }
        if (repClassName.equals("java.awt.print.Printable")) {
            try {
                this.printableJob((Printable)doc.getPrintData(), this.reqAttrSet);
                return;
            }
            catch (ClassCastException cce) {
                this.notifyEvent(103);
                throw new PrintException(cce);
            }
            catch (IOException ioe) {
                this.notifyEvent(103);
                throw new PrintException(ioe);
            }
        }
        this.notifyEvent(103);
        throw new PrintException("unrecognized class: " + repClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printableJob(Printable printable, PrintRequestAttributeSet attributes) throws PrintException {
        try {
            PSStreamPrintJob pSStreamPrintJob = this;
            synchronized (pSStreamPrintJob) {
                if (this.job != null) {
                    throw new PrintException("already printing");
                }
                this.job = new PSPrinterJob();
            }
            this.job.setPrintService(this.getPrintService());
            PageFormat pf = new PageFormat();
            if (this.mediaSize != null) {
                Paper p = new Paper();
                p.setSize((double)this.mediaSize.getX(25400) * 72.0, (double)this.mediaSize.getY(25400) * 72.0);
                p.setImageableArea(72.0, 72.0, p.getWidth() - 144.0, p.getHeight() - 144.0);
                pf.setPaper(p);
            }
            if (this.orient == OrientationRequested.REVERSE_LANDSCAPE) {
                pf.setOrientation(2);
            } else if (this.orient == OrientationRequested.LANDSCAPE) {
                pf.setOrientation(0);
            }
            this.job.setPrintable(printable, pf);
            this.job.print(attributes);
            this.notifyEvent(102);
            return;
        }
        catch (PrinterException pe) {
            this.notifyEvent(103);
            throw new PrintException(pe);
        }
        finally {
            this.printReturned = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageableJob(Pageable pageable, PrintRequestAttributeSet attributes) throws PrintException {
        try {
            PSStreamPrintJob pSStreamPrintJob = this;
            synchronized (pSStreamPrintJob) {
                if (this.job != null) {
                    throw new PrintException("already printing");
                }
                this.job = new PSPrinterJob();
            }
            this.job.setPrintService(this.getPrintService());
            this.job.setPageable(pageable);
            this.job.print(attributes);
            this.notifyEvent(102);
            return;
        }
        catch (PrinterException pe) {
            this.notifyEvent(103);
            throw new PrintException(pe);
        }
        finally {
            this.printReturned = true;
        }
    }

    private synchronized void initializeAttributeSets(Doc doc, PrintRequestAttributeSet reqSet) {
        DocAttributeSet docSet;
        Attribute[] attrs;
        this.reqAttrSet = new HashPrintRequestAttributeSet();
        this.jobAttrSet = new HashPrintJobAttributeSet();
        if (reqSet != null) {
            this.reqAttrSet.addAll(reqSet);
            attrs = reqSet.toArray();
            for (int i = 0; i < attrs.length; ++i) {
                if (!(attrs[i] instanceof PrintJobAttribute)) continue;
                this.jobAttrSet.add(attrs[i]);
            }
        }
        if ((docSet = doc.getAttributes()) != null) {
            attrs = docSet.toArray();
            for (int i = 0; i < attrs.length; ++i) {
                if (attrs[i] instanceof PrintRequestAttribute) {
                    this.reqAttrSet.add(attrs[i]);
                }
                if (!(attrs[i] instanceof PrintJobAttribute)) continue;
                this.jobAttrSet.add(attrs[i]);
            }
        }
        String userName = "";
        try {
            userName = System.getProperty("user.name");
        }
        catch (SecurityException se) {
            // empty catch block
        }
        if (userName == null || userName.equals("")) {
            RequestingUserName ruName = (RequestingUserName)reqSet.get(RequestingUserName.class);
            if (ruName != null) {
                this.jobAttrSet.add(new JobOriginatingUserName(ruName.getValue(), ruName.getLocale()));
            } else {
                this.jobAttrSet.add(new JobOriginatingUserName("", null));
            }
        } else {
            this.jobAttrSet.add(new JobOriginatingUserName(userName, null));
        }
        if (this.jobAttrSet.get(JobName.class) == null) {
            JobName jobName;
            if (docSet != null && docSet.get(DocumentName.class) != null) {
                DocumentName docName = (DocumentName)docSet.get(DocumentName.class);
                jobName = new JobName(docName.getValue(), docName.getLocale());
                this.jobAttrSet.add(jobName);
            } else {
                String str = "JPS Job:" + doc;
                try {
                    Object printData = doc.getPrintData();
                    if (printData instanceof URL) {
                        str = ((URL)doc.getPrintData()).toString();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                jobName = new JobName(str, null);
                this.jobAttrSet.add(jobName);
            }
        }
        this.jobAttrSet = AttributeSetUtilities.unmodifiableView(this.jobAttrSet);
    }

    private void getAttributeValues(DocFlavor flavor) throws PrintException {
        this.fidelity = this.reqAttrSet.get(Fidelity.class) == Fidelity.FIDELITY_TRUE;
        Attribute[] attrs = this.reqAttrSet.toArray();
        for (int i = 0; i < attrs.length; ++i) {
            Attribute attr = attrs[i];
            Class<? extends Attribute> category = attr.getCategory();
            if (this.fidelity) {
                if (!this.service.isAttributeCategorySupported(category)) {
                    this.notifyEvent(103);
                    throw new PrintJobAttributeException("unsupported category: " + category, category, null);
                }
                if (!this.service.isAttributeValueSupported(attr, flavor, null)) {
                    this.notifyEvent(103);
                    throw new PrintJobAttributeException("unsupported attribute: " + attr, null, attr);
                }
            }
            if (category == JobName.class) {
                this.jobName = ((JobName)attr).getValue();
                continue;
            }
            if (category == Copies.class) {
                this.copies = ((Copies)attr).getValue();
                continue;
            }
            if (category == Media.class) {
                if (!(attr instanceof MediaSizeName) || !this.service.isAttributeValueSupported(attr, null, null)) continue;
                this.mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)attr);
                continue;
            }
            if (category != OrientationRequested.class) continue;
            this.orient = (OrientationRequested)attr;
        }
    }

    @Override
    public void cancel() throws PrintException {
        PSStreamPrintJob pSStreamPrintJob = this;
        synchronized (pSStreamPrintJob) {
            if (!this.printing) {
                throw new PrintException("Job is not yet submitted.");
            }
            if (this.job != null && !this.printReturned) {
                this.job.cancel();
                this.notifyEvent(101);
                return;
            }
            throw new PrintException("Job could not be cancelled.");
        }
    }
}

