/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.security.action.GetPropertyAction;

public class DefaultFileSystemProvider {
    private DefaultFileSystemProvider() {
    }

    private static FileSystemProvider createProvider(final String cn) {
        return AccessController.doPrivileged(new PrivilegedAction<FileSystemProvider>(){

            @Override
            public FileSystemProvider run() {
                Class<?> c;
                try {
                    c = Class.forName(cn, true, null);
                }
                catch (ClassNotFoundException x) {
                    throw new AssertionError((Object)x);
                }
                try {
                    return (FileSystemProvider)c.newInstance();
                }
                catch (IllegalAccessException x) {
                    throw new AssertionError((Object)x);
                }
                catch (InstantiationException x) {
                    throw new AssertionError((Object)x);
                }
            }
        });
    }

    public static FileSystemProvider create() {
        String osname = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (osname.equals("SunOS")) {
            return DefaultFileSystemProvider.createProvider("sun.nio.fs.SolarisFileSystemProvider");
        }
        if (osname.equals("Linux")) {
            return DefaultFileSystemProvider.createProvider("sun.nio.fs.LinuxFileSystemProvider");
        }
        if (osname.equals("Darwin") || osname.contains("OS X")) {
            return DefaultFileSystemProvider.createProvider("sun.nio.fs.MacOSXFileSystemProvider");
        }
        throw new AssertionError((Object)"Platform not recognized");
    }
}

